/*
 * Decompiled with CFR 0.152.
 */
package server;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import server.ChannelManager;
import server.EEGLABChatServer;

public class ConfigParser
extends DefaultHandler {
    private EEGLABChatServer server;
    private boolean inMessage;
    private String messageBuffer;

    ConfigParser(EEGLABChatServer s) {
        this.server = s;
        this.inMessage = false;
        this.messageBuffer = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String s = new String(ch, start, length);
        if (s != null && this.inMessage) {
            s = s.replaceAll("[\\t\\n]", " ");
            s = s.replaceAll("[ ]{2,}", " ");
            s = s.trim();
            this.messageBuffer = String.valueOf(this.messageBuffer) + s;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String name = localName;
        if ("".equals(name)) {
            name = qName;
        }
        if ("WelcomeMessage".equals(name)) {
            this.inMessage = false;
            EEGLABChatServer.welcomeMessage = this.messageBuffer;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String name = localName;
        if ("".equals(name)) {
            name = qName;
        }
        if ("Port".equals(name)) {
            String val = attributes.getValue("value");
            try {
                if (val != null) {
                    EEGLABChatServer.PORT = Integer.parseInt(val);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("SysLogFile".equals(name)) {
            String val = attributes.getValue("value");
            if (val != null) {
                EEGLABChatServer.sysLogFile = val;
            }
        } else if ("ChatLogPath".equals(name)) {
            String val = attributes.getValue("value");
            if (val != null) {
                if ("".equals(val)) {
                    val = ".";
                }
                EEGLABChatServer.chatLogPath = val;
            }
        } else if ("AllowAdmin".equals(name)) {
            String val = attributes.getValue("value");
            if (val != null) {
                if (val.equals("yes")) {
                    EEGLABChatServer.allowAdmin = true;
                } else if (val.equals("no")) {
                    EEGLABChatServer.allowAdmin = false;
                }
            }
        } else if ("PassPhrase".equals(name)) {
            String val = attributes.getValue("value");
            if (val != null) {
                EEGLABChatServer.adminPass = val;
            }
        } else if ("UserExportFile".equals(name)) {
            String val = attributes.getValue("value");
            if (val != null) {
                EEGLABChatServer.userExportFile = val;
            }
        } else if ("AllowUserChannels".equals(name)) {
            String val = attributes.getValue("value");
            if (val != null) {
                if (val.equals("yes")) {
                    ChannelManager.allowUserChannels = (char)121;
                } else if (val.equals("admin")) {
                    ChannelManager.allowUserChannels = (char)97;
                }
                if (val.equals("no")) {
                    ChannelManager.allowUserChannels = (char)110;
                }
            }
        } else if ("DefaultChannel".equals(name)) {
            String val = attributes.getValue("value");
            if (val != null) {
                EEGLABChatServer.channels.setDefaultChannel(val);
            }
        } else if ("Channel".equals(name)) {
            String val = attributes.getValue("value");
            String pass = null;
            if (attributes.getLength() > 1) {
                pass = attributes.getValue("pass");
            }
            if (val != null) {
                EEGLABChatServer.channels.addSystemChannel(val, pass);
            }
        } else if ("WelcomeMessage".equals(name)) {
            this.inMessage = true;
        } else if ("br".equals(name)) {
            this.messageBuffer = String.valueOf(this.messageBuffer) + "\n";
        }
    }
}

