/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.EEGLABChat;
import common.MessageQueue;
import common.SocketConnection;
import common.sd.SD_UserAdd;
import common.sd.SocketData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.JOptionPane;

public class ServerConnection
implements Runnable,
SocketConnection {
    private EEGLABChat client;
    private SSLSocket socket;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    public boolean connected = false;
    public boolean finalized = false;
    public String channel;
    private MessageQueue queue;

    ServerConnection(EEGLABChat c) {
        this.client = c;
        this.channel = "Lobby";
        this.queue = new MessageQueue(this);
        try {
            SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.socket = (SSLSocket)sslFact.createSocket(c.site, c.PORT);
            this.socket.setReuseAddress(true);
            String[] enabledCipher = this.socket.getSupportedCipherSuites();
            this.socket.setEnabledCipherSuites(enabledCipher);
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            this.in = new ObjectInputStream(this.socket.getInputStream());
            this.connected = true;
            c.setConnected(true);
            new Thread(this).start();
        }
        catch (IOException e) {
            c.error("Server not available");
            System.out.println("Chat server not available.");
            c.setConnected(false);
            this.connected = false;
        }
    }

    private SocketData readObject() {
        try {
            return (SocketData)this.in.readObject();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void writeObject(Object obj) {
        this.queue.enqueue(obj);
    }

    @Override
    public void _writeObject(Object obj) throws IOException {
        if (this.connected) {
            try {
                this.out.writeObject(obj);
                this.out.flush();
            }
            catch (IOException e) {
                this.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            System.out.println("Closing server...");
            this.connected = false;
            this.client.setConnected(false);
            if (this.connected) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void updateUserNumber(int nUsers) {
        this.client.updateUserNumber(nUsers);
    }

    @Override
    public void serverCap(char type, Object obj) {
        try {
            block1 : switch (type) {
                case '\u0000': {
                    char tmp = ((Character)obj).charValue();
                    switch (tmp) {
                        case 'y': {
                            this.client.chanAdmin = false;
                            break block1;
                        }
                        case 'a': {
                            this.client.chanAdmin = true;
                            break block1;
                        }
                    }
                    this.client.chanAdmin = false;
                    break;
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void userAdd(String username, boolean isParsed) {
        if (username == null) {
            this.client.showUserStatus = true;
        } else {
            this.client.userAdd(username, isParsed);
        }
    }

    @Override
    public void adminAdd(String username) {
        if (username.equals(this.client.username)) {
            this.client.setAdmin();
        }
        if (!this.client.admins.contains(username)) {
            this.client.admins.add(username);
            this.client.serverMessage(String.valueOf(username) + " is now an admin");
            this.client.updateList();
        }
    }

    @Override
    public void userDel(String username) {
        this.client.userDel(username);
    }

    @Override
    public void rename(String on, String nn) {
        if (!nn.equals(this.client.username)) {
            this.client.username = nn;
        }
        this.client.rename(on, nn);
        this.client.writeUsernameLog(nn);
    }

    @Override
    public void kick(String un) {
        this.client.username = null;
    }

    @Override
    public void channel(boolean nc, String n, String p) {
        if (nc) {
            this.client.newChannel(n, p != null);
        } else if (n == null) {
            this.client.showUserStatus = true;
        } else {
            this.client.users.clear();
            this.client.afks.clear();
            this.client.ignores.clear();
            this.client.admins.clear();
            if (this.client.admin) {
                this.client.admins.add(this.client.username);
            }
            this.client.updateList();
            this.client.userAdd(this.client.username, false);
            this.channel = n;
        }
    }

    @Override
    public void chat(String username, String message) {
        this.client.recieveChat(username, message);
    }

    @Override
    public void private_msg(String username, String message) {
        this.client.recievePrivate(username, message);
    }

    @Override
    public void whisper(String username, String message) {
        this.client.recieveWhisper(username, message);
    }

    @Override
    public void chatLog(boolean start) {
        if (start) {
            this.client.serverMessage("now logging in " + this.channel);
        } else {
            this.client.serverMessage("no longer logging in " + this.channel);
        }
    }

    @Override
    public void error(String s) {
        this.client.error(s);
    }

    public void closeSocket() throws IOException {
        this.socket.close();
    }

    @Override
    public void run() {
        SocketData sd;
        String username = null;
        username = this.client.readUsernameLog();
        if (username != null) {
            this.writeObject(new SD_UserAdd(username, true));
        } else {
            username = this.client.username;
            boolean stillSearching = true;
            while (stillSearching) {
                try {
                    if (username == null) {
                        throw new Exception("Username cannot be null");
                    }
                    this.writeObject(new SD_UserAdd(username, true));
                    if (this.client.users.contains(username)) {
                        System.out.println("Chat already contains user " + username);
                    }
                    stillSearching = false;
                }
                catch (Exception e) {
                    username = JOptionPane.showInputDialog(this.client, "Username already being used.  Please enter a new username and restart eeglab.", "Login", 3);
                    System.out.println("Username set to " + username);
                    this.client.username = username;
                    try {
                        this.client.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        while (this.connected && (sd = this.readObject()) != null) {
            try {
                sd.performAction(this);
            }
            catch (Exception e) {
                System.out.println("Server connection error.");
            }
        }
        try {
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

