/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.web;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VersionCheck
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent.indexOf("VersionChecker") == -1) {
            response.setStatus(403);
            response.getWriter().close();
            return;
        }
        response.setContentType("text/xml;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String webInfPath = String.valueOf(this.getServletContext().getRealPath("/")) + File.separator + "WEB-INF" + File.separator;
        StringBuilder usageStats = new StringBuilder();
        String id = null;
        String os = null;
        String version = null;
        boolean isKU = request.getRemoteAddr().startsWith("129.237.");
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (paramName == null) continue;
            if (paramName.length() > 64) {
                paramName = paramName.substring(0, 64);
            }
            String[] valueArray = request.getParameterValues(paramName);
            String value = null;
            if (valueArray.length > 0 && (value = valueArray[0]) != null && value.length() > 64) {
                value = value.substring(0, 64);
            }
            if (paramName.equalsIgnoreCase("id")) {
                id = value;
                continue;
            }
            if (paramName.equalsIgnoreCase("os")) {
                os = value;
                continue;
            }
            if (paramName.equalsIgnoreCase("version")) {
                version = value;
                continue;
            }
            usageStats.append("\t" + paramName + ":" + value + "\n");
        }
        InputStream in = null;
        try {
            int ch;
            in = new BufferedInputStream(new FileInputStream(String.valueOf(webInfPath) + "install_info.xml"));
            while ((ch = in.read()) != -1) {
                out.print((char)ch);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        out.close();
        StringBuilder logEntry = new StringBuilder();
        String timestamp = new Date().toString();
        logEntry.append(timestamp);
        logEntry.append("\n");
        String idString = "ID = " + id + ", " + "OS = " + os + ", " + version;
        logEntry.append(idString);
        logEntry.append("\t" + request.getRemoteAddr());
        if (isKU) {
            logEntry.append(" (KU)");
        }
        logEntry.append("\n");
        logEntry.append(usageStats.toString());
        logEntry.append("\n");
        VersionCheck versionCheck = this;
        synchronized (versionCheck) {
            block25: {
                File logFile = new File(String.valueOf(webInfPath) + "usage_log.txt");
                OutputStreamWriter fileWriter = null;
                try {
                    try {
                        fileWriter = new FileWriter(logFile, true);
                        fileWriter.write(logEntry.toString());
                        fileWriter.flush();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                    throw throwable;
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "A simple application version checker / usage tracker";
    }
}

