/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.web;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogView
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Usage Stats Log Viewer</title>");
        out.println("</head>");
        out.println("<body>");
        String webInfPath = String.valueOf(this.getServletContext().getRealPath("/")) + File.separator + "WEB-INF" + File.separator;
        File usageLog = new File(String.valueOf(webInfPath) + "usage_log.txt");
        Hashtable<String, List<String>> usageData = this.summarizeUsageData(usageLog);
        this.performReverseDNS(usageData);
        out.println("<h3>Records found: " + usageData.keySet().size() + "</h3><br/>");
        out.println("<pre>");
        for (String id : usageData.keySet()) {
            for (String entry : usageData.get(id)) {
                out.println("\t" + entry);
            }
            out.println();
        }
        out.println("</pre>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    protected Hashtable<String, List<String>> summarizeUsageData(File usageLogContents) throws FileNotFoundException, IOException {
        BufferedReader input = new BufferedReader(new FileReader(usageLogContents));
        Hashtable<String, List<String>> compiledData = new Hashtable<String, List<String>>();
        String line = null;
        while ((line = input.readLine()) != null) {
            if (!line.startsWith("ID") || line.endsWith("(KU)")) continue;
            Vector<String> data = new Vector<String>();
            data.add(line);
            String idString = line.substring(5, 54);
            while ((line = input.readLine()) != null && line.trim().length() > 0) {
                data.add(line);
            }
            compiledData.put(idString, data);
        }
        return compiledData;
    }

    protected String doSingleReverseDNS(String ipAddr) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LogView.class, ex);
            return "";
        }
        return addr.getHostName();
    }

    protected void performReverseDNS(Hashtable<String, List<String>> usageData) {
        ExecutorService glExecServ = Executors.newFixedThreadPool(25);
        int cnt = 0;
        for (String id : usageData.keySet()) {
            final List<String> record = usageData.get(id);
            final String idLine = record.get(0);
            StringTokenizer st = new StringTokenizer(idLine, "\t");
            st.nextToken();
            final String ipAddr = st.nextToken().trim();
            System.out.println(String.valueOf(++cnt) + " / " + usageData.keySet().size());
            Runnable hostnameLookup = new Runnable(){

                @Override
                public void run() {
                    String hostname = LogView.this.doSingleReverseDNS(ipAddr);
                    record.set(0, String.valueOf(idLine) + "\t(" + hostname + ")");
                }
            };
            glExecServ.submit(hostnameLookup);
        }
        glExecServ.shutdown();
        try {
            glExecServ.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LogView.class, ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void processStats() {
        try {
            PrintWriter out = new PrintWriter(new File("stats.html"));
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Usage Stats Log Viewer</title>");
            out.println("</head>");
            out.println("<body>");
            File usageLog = new File("/Users/rod/usage_log.txt");
            Hashtable<String, List<String>> usageData = this.summarizeUsageData(usageLog);
            this.performReverseDNS(usageData);
            out.println("<h3>Records found: " + usageData.keySet().size() + "</h3><br/>");
            out.println("<pre>");
            for (String id : usageData.keySet()) {
                for (String entry : usageData.get(id)) {
                    out.println("\t" + entry);
                }
                out.println();
            }
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LogView.class, ex);
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        LogView lv = new LogView();
        lv.processStats();
    }
}

