/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util.thumbnails;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.IconEntry;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.thumbnails.ThumbnailGeneratorIFace;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Thumbnailer {
    private static HashMap<String, String> availableIcons;
    protected Hashtable<String, ThumbnailGeneratorIFace> mimeTypeToGeneratorMap = new Hashtable();
    protected float quality = 1.0f;
    protected int maxWidth = 32;
    protected int maxHeight = 32;

    static {
        Thumbnailer.readIconMap();
    }

    public void registerThumbnailers(File generatorRegistryFile) throws SAXException, IOException, ParserConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Document registry = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(generatorRegistryFile);
        NodeList generatorNodes = registry.getElementsByTagName("generator");
        int i = 0;
        while (i < generatorNodes.getLength()) {
            Node generatorNode = generatorNodes.item(i);
            Node classNameNode = generatorNode.getAttributes().getNamedItem("class");
            String generatorClassName = classNameNode.getNodeValue();
            ThumbnailGeneratorIFace gen = Class.forName(generatorClassName).asSubclass(ThumbnailGeneratorIFace.class).newInstance();
            String[] stringArray = gen.getSupportedMimeTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String supportedMimeType = stringArray[n2];
                this.registerThumbnailGenerator(supportedMimeType, gen);
                ++n2;
            }
            ++i;
        }
    }

    private static void readIconMap() {
        availableIcons = new HashMap();
        File mimeTypeFile = XMLHelper.getConfigDir("mime_icons.xml");
        if (mimeTypeFile.exists()) {
            try {
                Document registry = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(mimeTypeFile);
                NodeList mimeNodes = registry.getElementsByTagName("mimetype");
                int i = 0;
                while (i < mimeNodes.getLength()) {
                    Node mimeNode = mimeNodes.item(i);
                    Node iconNameNode = mimeNode.getAttributes().getNamedItem("icon");
                    String iconName = iconNameNode.getNodeValue();
                    NodeList extNodes = mimeNode.getChildNodes();
                    int j = 0;
                    while (j < extNodes.getLength()) {
                        Node extNode = extNodes.item(j);
                        String ext = extNode.getTextContent().trim();
                        if (StringUtils.isNotEmpty((String)ext)) {
                            availableIcons.put(ext, iconName);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public ThumbnailGeneratorIFace registerThumbnailGenerator(String mimeType, ThumbnailGeneratorIFace generator) {
        generator.setQuality(this.quality);
        generator.setMaxHeight(this.maxHeight);
        generator.setMaxWidth(this.maxWidth);
        return this.mimeTypeToGeneratorMap.put(mimeType, generator);
    }

    public ThumbnailGeneratorIFace removeGenerator(String mimeType) {
        return this.mimeTypeToGeneratorMap.remove(mimeType);
    }

    public void generateThumbnail(String originalFile, String outputFile, boolean doHighQuality) throws IOException {
        IconEntry entry;
        MimetypesFileTypeMap mimeMap = (MimetypesFileTypeMap)FileTypeMap.getDefaultFileTypeMap();
        mimeMap.addMimeTypes("image/png    png");
        mimeMap.addMimeTypes("application/vnd.google-earth.kml+xml kml");
        String mimeType = mimeMap.getContentType(originalFile);
        ThumbnailGeneratorIFace generator = this.mimeTypeToGeneratorMap.get(mimeType);
        if (generator != null) {
            if (!generator.generateThumbnail(originalFile, outputFile, doHighQuality)) {
                UIRegistry.getStatusBar().setLocalizedText("Thumbnailer.THMB_NO_CREATE", originalFile);
            }
            return;
        }
        String iconName = null;
        String ext = FilenameUtils.getExtension((String)originalFile);
        if (StringUtils.isNotEmpty((String)ext)) {
            iconName = availableIcons.get(ext);
        }
        if (StringUtils.isEmpty(iconName)) {
            iconName = "unknown";
        }
        if ((entry = IconManager.getIconEntryByName(iconName)) != null) {
            BufferedImage bi = ImageIO.read(entry.getUrl());
            ImageIO.write((RenderedImage)bi, "PNG", new FileOutputStream(outputFile));
        }
    }

    public void setMaxWidth(int maxWidth) {
        Enumeration<ThumbnailGeneratorIFace> tgs = this.mimeTypeToGeneratorMap.elements();
        while (tgs.hasMoreElements()) {
            tgs.nextElement().setMaxWidth(maxWidth);
        }
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        Enumeration<ThumbnailGeneratorIFace> tgs = this.mimeTypeToGeneratorMap.elements();
        while (tgs.hasMoreElements()) {
            tgs.nextElement().setMaxHeight(maxHeight);
        }
        this.maxHeight = maxHeight;
    }

    public void setQuality(float percent) {
        Enumeration<ThumbnailGeneratorIFace> tgs = this.mimeTypeToGeneratorMap.elements();
        while (tgs.hasMoreElements()) {
            tgs.nextElement().setQuality(percent);
        }
        this.quality = percent;
    }

    public static String getIconNameFromExtension(String ext) {
        return availableIcons.get(ext);
    }
}

