/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util.thumbnails;

import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.util.thumbnails.ThumbnailGeneratorIFace;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class ImageThumbnailGenerator
implements ThumbnailGeneratorIFace {
    protected int maxWidth = 32;
    protected int maxHeight = 32;
    protected float quality;

    @Override
    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public void setQuality(float percent) {
        this.quality = percent;
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return ImageIO.getReaderMIMETypes();
    }

    public byte[] generateThumbnail(byte[] originalImageData, boolean doHighQuality) throws IOException {
        BufferedImage orig;
        ByteArrayInputStream inputStr = new ByteArrayInputStream(originalImageData);
        if (inputStr != null && (orig = ImageIO.read(inputStr)) != null) {
            if (orig.getHeight() < this.maxHeight && orig.getWidth() < this.maxWidth) {
                return originalImageData;
            }
            byte[] scaledImgData = GraphicsUtils.scaleImage(orig, this.maxHeight, this.maxWidth, true, doHighQuality);
            return scaledImgData;
        }
        return null;
    }

    public byte[] generateTiffThumbnail(File tiffImageFile) {
        return null;
    }

    @Override
    public boolean generateThumbnail(String originalFile, String thumbnailFile, boolean doHighQuality) throws IOException {
        byte[] thumb;
        byte[] origData = GraphicsUtils.readImage(originalFile);
        if (origData != null && (thumb = this.generateThumbnail(origData, doHighQuality)) != null) {
            FileUtils.writeByteArrayToFile((File)new File(thumbnailFile), (byte[])thumb);
            return true;
        }
        return false;
    }

    @Override
    public void setMaxDuration(int seconds) {
    }
}

