/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util.services;

import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.FileCache;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class MapGrabber {
    private static final Logger log = Logger.getLogger(MapGrabber.class);
    protected HttpClient httpClient = new HttpClient();
    protected String host = "mapus.jpl.nasa.gov";
    protected String defaultPathAndParams = "/browse.cgi?request=GetMap&srs=EPSG:4326&format=image/png&styles=visual";
    protected String layers = "global_mosaic";
    protected double minLat = -90.0;
    protected double minLong = -180.0;
    protected double maxLat = 90.0;
    protected double maxLong = 180.0;
    protected Integer height = null;
    protected Integer width = null;
    protected int defaultHeight = 2048;
    protected int defaultWidth = 2048;
    protected static FileCache imageCache = UIRegistry.getLongTermFileCache();

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getLayers() {
        return this.layers;
    }

    public void setLayers(String layers) {
        this.layers = layers;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        Integer ht = height;
        if (ht != null && ht > 2048) {
            ht = 2048;
        }
        this.height = ht;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        Integer wt = width;
        if (wt != null && wt > 2048) {
            wt = 2048;
        }
        this.width = wt;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public void setMaxLat(double maxLat) {
        this.maxLat = maxLat;
    }

    public double getMaxLong() {
        return this.maxLong;
    }

    public void setMaxLong(double maxLong) {
        this.maxLong = maxLong;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public void setMinLat(double minLat) {
        this.minLat = minLat;
    }

    public double getMinLong() {
        return this.minLong;
    }

    public void setMinLong(double minLong) {
        this.minLong = minLong;
    }

    public void setDefaultPathAndParams(String defaultPathAndParams) {
        this.defaultPathAndParams = defaultPathAndParams;
    }

    public Image getMap(Integer w, Integer h, int minLatitude, int minLongitude, int maxLatitude, int maxLongitude) throws HttpException, IOException {
        this.setMinLat(minLatitude);
        this.setMinLong(minLongitude);
        this.setMaxLat(maxLatitude);
        this.setMaxLong(maxLongitude);
        this.setWidth(w);
        this.setHeight(h);
        return this.getMap();
    }

    protected double getLatLongRatio() {
        double longRange = this.maxLong - this.minLong;
        double latRange = this.maxLat - this.minLat;
        return latRange / longRange;
    }

    public Image getMap() throws HttpException, IOException {
        Image image;
        log.debug((Object)"Entering MapGrabber.getMap()");
        log.debug((Object)("width=" + this.width + "\theight=" + this.height));
        double longSpread = this.maxLong - this.minLong;
        double latSpread = this.maxLat - this.minLat;
        log.debug((Object)("lat spread:  min=" + this.minLat + "\tmax=" + this.maxLat + "\trange=" + latSpread));
        log.debug((Object)("long spread: min=" + this.minLong + "\tmax=" + this.maxLong + "\trange=" + longSpread));
        if (this.width == null && this.height == null) {
            this.width = this.defaultWidth;
            this.height = this.defaultHeight;
        }
        StringBuilder url = new StringBuilder("http://");
        url.append(this.host);
        url.append(this.defaultPathAndParams);
        url.append("&layers=");
        url.append(this.layers);
        url.append("&bbox=");
        url.append(this.minLong);
        url.append(",");
        url.append(this.minLat);
        url.append(",");
        url.append(this.maxLong);
        url.append(",");
        url.append(this.maxLat);
        url.append("&height=");
        url.append(this.height);
        url.append("&width=");
        url.append(this.width);
        String urlStr = url.toString();
        if (imageCache != null) {
            ImageIcon mapIcon;
            log.info((Object)("Asking cache to grab map image: " + urlStr));
            File imageFile = imageCache.getCacheFile(urlStr);
            if (imageFile == null) {
                urlStr = imageCache.cacheWebResource(urlStr);
                imageFile = imageCache.getCacheFile(urlStr);
            }
            if ((image = ImageIO.read(imageFile)) == null) {
                imageCache.refreshCachedWebResource(urlStr);
            }
            if ((mapIcon = new ImageIcon(image)).getIconHeight() < 0 || mapIcon.getIconWidth() < 0) {
                imageCache.clearItem(urlStr);
                throw new IOException("Mapping service failed to return a valid image.  Map request URL: " + urlStr);
            }
        } else {
            log.info((Object)"No image cache available.  Grabbing map internally.");
            GetMethod get = new GetMethod(urlStr);
            get.setFollowRedirects(true);
            int resultCode = this.httpClient.executeMethod((HttpMethod)get);
            log.info((Object)("GET " + urlStr + " returned " + resultCode));
            log.info((Object)"Exiting MapGrabber.getMap()");
            byte[] data = get.getResponseBody();
            image = Toolkit.getDefaultToolkit().createImage(data);
            ImageIcon mapIcon = new ImageIcon(image);
            if (mapIcon.getIconHeight() < 0 || mapIcon.getIconWidth() < 0) {
                throw new IOException("Mapping service failed to return a valid image.  Map request URL: " + urlStr);
            }
        }
        return image;
    }
}

