/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util.services;

import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class GenericKMLGenerator {
    protected static String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static String KML_NAMESPACE_DECL = "<kml xmlns=\"http://earth.google.com/kml/2.1\">\n";
    protected List<Pair<Double, Double>> points = new Vector<Pair<Double, Double>>();
    protected Map<Pair<Double, Double>, String> pointNameMap = new Hashtable<Pair<Double, Double>, String>();
    protected Map<Pair<Double, Double>, String> pointDescMap = new Hashtable<Pair<Double, Double>, String>();
    protected String placemarkIconURL;
    protected String balloonStyleBgColor;
    protected String balloonStyleTextColor;
    protected String balloonStyleText;
    protected String description;

    public void setDescription(String description) {
        this.description = description;
    }

    public void addPlacemark(Pair<Double, Double> point, String name, String htmlDescription) {
        if (point == null) {
            return;
        }
        this.points.add(point);
        this.pointNameMap.put(point, name == null ? "" : name);
        this.pointDescMap.put(point, htmlDescription);
    }

    public void setDescritpion(String descritpion) {
        this.description = descritpion;
    }

    public String getPlacemarkIconURL() {
        return this.placemarkIconURL;
    }

    public void setPlacemarkIconURL(String placemarkIconURL) {
        this.placemarkIconURL = placemarkIconURL;
    }

    public String getBalloonStyleBgColor() {
        return this.balloonStyleBgColor;
    }

    public void setBalloonStyleBgColor(String balloonStyleBgColor) {
        this.balloonStyleBgColor = balloonStyleBgColor;
    }

    public String getBalloonStyleText() {
        return this.balloonStyleText;
    }

    public void setBalloonStyleText(String balloonStyleText) {
        this.balloonStyleText = balloonStyleText;
    }

    public String getBalloonStyleTextColor() {
        return this.balloonStyleTextColor;
    }

    public void setBalloonStyleTextColor(String balloonStyleTextColor) {
        this.balloonStyleTextColor = balloonStyleTextColor;
    }

    public static String generateIconCode(String iconURL) {
        if (StringUtils.isNotEmpty((String)iconURL)) {
            StringBuilder sb = new StringBuilder();
            sb.append("<IconStyle>\n");
            sb.append("<Icon>\n");
            sb.append("<href>");
            sb.append(iconURL);
            sb.append("</href>\n");
            sb.append("</Icon>\n");
            sb.append("</IconStyle>\n");
            return sb.toString();
        }
        return "";
    }

    public static String generateBalloon(String balloonStyleBgColor, String balloonStyleTextColor, String balloonStyleText) {
        if (balloonStyleBgColor != null || balloonStyleTextColor != null || balloonStyleText != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<BalloonStyle>\n");
            if (balloonStyleBgColor != null) {
                sb.append("<bgColor>" + balloonStyleBgColor + "</bgColor>\n");
            }
            if (balloonStyleText != null) {
                sb.append("<text><![CDATA[" + balloonStyleText + "]]></text>\n");
            }
            sb.append("</BalloonStyle>\n");
            return sb.toString();
        }
        return "";
    }

    public static String generateStyle(String iconURL, String balloonStyleBgColor, String balloonStyleTextColor, String balloonStyleText) {
        if (iconURL != null || balloonStyleBgColor != null || balloonStyleTextColor != null || balloonStyleText != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<Style id=\"custom\">\n");
            sb.append(GenericKMLGenerator.generateIconCode(iconURL));
            sb.append(GenericKMLGenerator.generateBalloon(balloonStyleBgColor, balloonStyleTextColor, balloonStyleText));
            sb.append("</Style>\n");
            return sb.toString();
        }
        return "";
    }

    public String generateKML() {
        StringBuilder kmlBuilder = new StringBuilder();
        kmlBuilder.append(XML_DECLARATION);
        kmlBuilder.append(KML_NAMESPACE_DECL);
        kmlBuilder.append("<Document>\n");
        if (StringUtils.isNotEmpty((String)this.description)) {
            kmlBuilder.append("<description><![CDATA[");
            kmlBuilder.append(this.description);
            kmlBuilder.append("]]></description>");
        }
        kmlBuilder.append(GenericKMLGenerator.generateStyle(this.placemarkIconURL, this.balloonStyleBgColor, this.balloonStyleTextColor, this.balloonStyleText));
        for (Pair<Double, Double> point : this.points) {
            String name = this.pointNameMap.get(point);
            String htmlDesc = this.pointDescMap.get(point);
            kmlBuilder.append(GenericKMLGenerator.buildPlacemark(point, name, this.balloonStyleTextColor, htmlDesc, this.placemarkIconURL));
        }
        kmlBuilder.append("</Document>\n");
        kmlBuilder.append("</kml>\n");
        return kmlBuilder.toString();
    }

    public static String buildPlacemark(Pair<Double, Double> point, String name, String textColor, String htmlDesc, String iconURL) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenericKMLGenerator.generateXmlStartTag("Placemark"));
        sb.append(GenericKMLGenerator.generateXmlElement("name", name));
        sb.append(GenericKMLGenerator.generateXmlElement("styleUrl", "#custom"));
        sb.append("\n");
        sb.append(GenericKMLGenerator.generateXmlElement("description", "<![CDATA[" + htmlDesc + "]]>"));
        sb.append("\n");
        sb.append(GenericKMLGenerator.buildPointAndLookAt(point));
        sb.append("\n");
        sb.append(GenericKMLGenerator.generateXmlEndTag("Placemark"));
        return sb.toString();
    }

    public static String buildPointAndLookAt(Pair<Double, Double> point) {
        StringBuilder sb = new StringBuilder();
        sb.append("<LookAt>\n");
        sb.append("<latitude>");
        sb.append(point.first);
        sb.append("</latitude>\n");
        sb.append("<longitude>");
        sb.append(point.second);
        sb.append("</longitude>\n");
        sb.append("<range>300000.00</range>\n");
        sb.append("</LookAt>\n");
        sb.append("<Point>\n");
        sb.append("<coordinates>");
        sb.append(point.second);
        sb.append(",");
        sb.append(point.first);
        sb.append("</coordinates>\n");
        sb.append("</Point>\n");
        return sb.toString();
    }

    public void generateKML(OutputStream out) throws IOException {
        String kml = this.generateKML();
        out.write(kml.getBytes("UTF-8"));
    }

    public void generateKML(File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        this.generateKML(fos);
    }

    public static String generateXmlStartTag(String name) {
        return "<" + name + ">";
    }

    public static String generateXmlEndTag(String name) {
        return "</" + name + ">";
    }

    public static String generateXmlElement(String name, String content) {
        if (content == null || content.equals("")) {
            return "<" + name + "/>";
        }
        return "<" + name + ">" + content + "</" + name + ">";
    }
}

