/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class XMLChecksumUtil {
    protected static final String checksumFileName = "checksum.ini";

    protected static String getRelativeName(File file) {
        String absName = file.getAbsolutePath();
        int inx = absName.indexOf("config");
        if (inx != -1) {
            return absName.substring(inx, absName.length());
        }
        return null;
    }

    public static boolean checkSignature(File file) {
        Properties checksumProps = new Properties();
        File checksumFile = XMLHelper.getConfigDir(checksumFileName);
        if (checksumFile.exists()) {
            try {
                checksumProps.load(new FileInputStream(checksumFile));
                return XMLChecksumUtil.checkSignature(checksumProps, file);
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(XMLChecksumUtil.class, ex);
                throw new RuntimeException("Couldn't locate Checksum file [" + checksumFile.getAbsolutePath() + "]");
            }
        }
        JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("CHECKSUM_MSG"), UIRegistry.getResourceString("CHECKSUM_TITLE"), 0);
        System.exit(0);
        return false;
    }

    protected static boolean checkSignature(Properties checksumProps, File file) throws IOException {
        String relativeName = XMLChecksumUtil.getRelativeName(file);
        if (StringUtils.isNotEmpty((String)relativeName)) {
            String checksumStr = checksumProps.getProperty(relativeName);
            if (StringUtils.isNotEmpty((String)checksumStr)) {
                long newCheckSum;
                long checkSum = FileUtils.checksumCRC32((File)file);
                return checkSum == (newCheckSum = Long.parseLong(checksumStr));
            }
        } else {
            throw new RuntimeException("The file isn't in the config directory [" + file.getAbsolutePath() + "]");
        }
        return false;
    }

    public static void createChecksumProps(File[] files) {
        Properties checksumProps = new Properties();
        File checksumFile = XMLHelper.getConfigDir(checksumFileName);
        try {
            XMLChecksumUtil.createChecksumProps(checksumProps, files);
            checksumProps.store(new FileOutputStream(checksumFile), "Checksum Properties");
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(XMLChecksumUtil.class, ex);
            throw new RuntimeException("Couldn't locate Checksum file [" + checksumFile.getAbsolutePath() + "]");
        }
    }

    protected static void createChecksumProps(Properties checksumProps, File[] files) throws IOException {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String relativeName = XMLChecksumUtil.getRelativeName(file);
            if (StringUtils.isNotEmpty((String)relativeName)) {
                String checksumStr = checksumProps.getProperty(relativeName);
                if (!StringUtils.isEmpty((String)checksumStr)) {
                    throw new RuntimeException("Duplicate checksum name [" + relativeName + "]");
                }
            } else {
                throw new RuntimeException("The file isn't in the config directory [" + file.getAbsolutePath() + "]");
            }
            checksumProps.put(relativeName, Long.toString(FileUtils.checksumCRC32((File)file)));
            ++n2;
        }
    }

    public static void createChecksum() {
        File[] files = FileUtils.convertFileCollectionToFileArray((Collection)FileUtils.listFiles((File)XMLHelper.getConfigDir(null), (String[])new String[]{"xml"}, (boolean)true));
        XMLChecksumUtil.createChecksumProps(files);
    }
}

