/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentManagerIface;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileCache;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public final class WebStoreAttachmentMgr
implements AttachmentManagerIface {
    private static final Logger log = Logger.getLogger(WebStoreAttachmentMgr.class);
    private static MessageDigest sha1 = null;
    private Boolean isInitialized = null;
    private byte[] bytes = new byte[102400];
    private File cacheDir;
    private FileCache shortTermCache;
    private HashMap<String, String> attachNameThumbMap = new HashMap();
    private HashMap<String, String> attachNameOrigMap = new HashMap();
    private String readURLStr = null;
    private String writeURLStr = null;
    private String delURLStr = null;
    private String[] symbols = new String[]{"<coll>", "<disp>", "<div>", "<inst>"};
    private String[] values = new String[this.symbols.length];

    static {
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isInitialized(String urlStr) {
        if (this.isInitialized == null) {
            this.isInitialized = false;
            this.cacheDir = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "attach_cache");
            if (!this.cacheDir.exists() && !this.cacheDir.mkdir()) {
                this.cacheDir = null;
                return this.isInitialized;
            }
            try {
                this.shortTermCache = new FileCache(this.cacheDir.getAbsolutePath(), "cache.map");
                this.shortTermCache.setSuffix("");
                this.shortTermCache.setUsingExtensions(true);
                this.isInitialized = this.getURLSetupXML(urlStr);
                return this.isInitialized;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.isInitialized;
    }

    private boolean getURLSetupXML(String urlStr) {
        block3: {
            File tmpFile;
            block4: {
                if (!StringUtils.isNotEmpty((String)urlStr) || !this.fillFileFromWeb(urlStr, tmpFile = File.createTempFile("sp6", ".xml", this.cacheDir.getAbsoluteFile()))) break block3;
                if (!this.getURLSFromFile(tmpFile)) break block4;
                tmpFile.delete();
                return true;
            }
            try {
                tmpFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getURLSFromFile(File webAssetFile) {
        try {
            Element root = XMLHelper.readFileToDOM4J(webAssetFile);
            if (root != null) {
                Iterator i = root.elementIterator("url");
                while (i.hasNext()) {
                    Element urlNode = (Element)i.next();
                    String type = urlNode.attributeValue("type");
                    String urlStr = urlNode.getTextTrim();
                    if (type.equals("read")) {
                        this.readURLStr = urlStr;
                        continue;
                    }
                    if (type.equals("write")) {
                        this.writeURLStr = urlStr;
                        continue;
                    }
                    if (!type.equals("delete")) {
                        return false;
                    }
                    this.delURLStr = urlStr;
                }
            }
            return StringUtils.isNotEmpty((String)this.readURLStr) && StringUtils.isNotEmpty((String)this.writeURLStr) && StringUtils.isNotEmpty((String)this.delURLStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setStorageLocationIntoAttachment(Attachment attachment, boolean doDisplayErrors) {
        String errMsg;
        block7: {
            File storageFile;
            String storageFilename;
            block6: {
                String attName = attachment.getOrigFilename();
                int lastPeriod = attName.lastIndexOf(46);
                String suffix = ".att";
                if (lastPeriod != -1) {
                    suffix = ".att" + attName.substring(lastPeriod);
                }
                errMsg = null;
                storageFilename = "";
                storageFile = File.createTempFile("sp6", suffix, this.cacheDir.getAbsoluteFile());
                System.err.println("[" + storageFile.getAbsolutePath() + "] " + storageFile.canWrite());
                if (!storageFile.exists()) break block6;
                attachment.setAttachmentLocation(storageFile.getName());
                storageFile.deleteOnExit();
                return true;
            }
            try {
                errMsg = UIRegistry.getLocalizedMessage("ATTCH_NOT_SAVED_REPOS", storageFile.getAbsolutePath());
                log.error((Object)("storageFile doesn't exist[" + storageFile.getAbsolutePath() + "]"));
            }
            catch (IOException e) {
                e.printStackTrace();
                if (doDisplayErrors) {
                    errMsg = UIRegistry.getLocalizedMessage("ATTCH_NOT_SAVED_REPOS", storageFilename);
                    break block7;
                }
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FileStoreAttachmentManager.class, e);
            }
        }
        if (doDisplayErrors && errMsg != null) {
            UIRegistry.showError(errMsg);
        }
        return false;
    }

    @Override
    public synchronized File getOriginal(Attachment attachment) {
        return this.getFile(attachment, this.attachNameOrigMap, false);
    }

    @Override
    public synchronized File getThumbnail(Attachment attachment) {
        return this.getFile(attachment, this.attachNameThumbMap, true);
    }

    private File createTempFile(String fileName, boolean doDelOnExit) throws IOException {
        String fileExt = FilenameUtils.getExtension((String)fileName);
        File file = File.createTempFile("sp6", String.valueOf('.') + fileExt, this.cacheDir.getAbsoluteFile());
        if (doDelOnExit) {
            file.deleteOnExit();
        }
        return file;
    }

    private synchronized File getFile(Attachment attachment, HashMap<String, String> nameHash, boolean isThumb) {
        File thumbFile;
        String origFilePath;
        String nmExt;
        block11: {
            File cachedFile;
            String localThumbName;
            nmExt = isThumb ? ".THB" : "";
            boolean isSaved = StringUtils.isNotEmpty((String)attachment.getAttachmentLocation());
            if (!isSaved && StringUtils.isNotEmpty((String)(localThumbName = nameHash.get(String.valueOf(attachment.getOrigFilename()) + nmExt))) && (cachedFile = this.shortTermCache.getCacheFile(localThumbName)) != null && cachedFile.exists()) {
                return cachedFile;
            }
            origFilePath = attachment.getAttachmentLocation();
            if (isSaved) {
                File cachedFile2;
                String fileName = nameHash.get(String.valueOf(origFilePath) + nmExt);
                if (StringUtils.isNotEmpty((String)fileName) && (cachedFile2 = this.shortTermCache.getCacheFile(fileName)) != null && cachedFile2.exists()) {
                    return cachedFile2;
                }
                cachedFile2 = this.shortTermCache.getCacheFile(origFilePath);
                if (cachedFile2 != null && cachedFile2.exists()) {
                    return cachedFile2;
                }
                File thmbFile = this.getFileFromWeb(attachment.getAttachmentLocation(), attachment.getMimeType(), isThumb);
                if (thmbFile != null && thmbFile.exists()) {
                    try {
                        String nm = thmbFile.getName();
                        this.shortTermCache.cacheFile(thmbFile);
                        nameHash.put(String.valueOf(attachment.getAttachmentLocation()) + nmExt, nm);
                        thmbFile.delete();
                        thmbFile = this.shortTermCache.getCacheFile(nm);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return thmbFile;
            }
            origFilePath = attachment.getOrigFilename();
            if (StringUtils.isEmpty((String)origFilePath)) {
                return null;
            }
            File origFile = new File(origFilePath);
            thumbFile = null;
            try {
                String fileExt = FilenameUtils.getExtension((String)origFilePath);
                thumbFile = this.createTempFile(fileExt, false);
                Thumbnailer thumbnailGen = AttachmentUtils.getThumbnailer();
                thumbnailGen.generateThumbnail(origFile.getAbsolutePath(), thumbFile.getAbsolutePath(), false);
                if (thumbFile.exists()) break block11;
                return null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        nameHash.put(String.valueOf(origFilePath) + nmExt, thumbFile.getName());
        this.shortTermCache.cacheFile(thumbFile);
        thumbFile.delete();
        return thumbFile;
    }

    private boolean fillFileFromWeb(String urlStr, File tmpFile) {
        try {
            URL url = new URL(urlStr);
            InputStream inpStream = url.openStream();
            if (inpStream != null) {
                int numBytes;
                BufferedInputStream in = new BufferedInputStream(inpStream);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
                while ((numBytes = in.read(this.bytes)) != -1) {
                    bos.write(this.bytes, 0, numBytes);
                }
                in.close();
                bos.close();
                return true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private synchronized File getFileFromWeb(String fileName, String mimeType, boolean isThumb) {
        try {
            File tmpFile = this.createTempFile(fileName, false);
            String urlStr = this.subAllExtraData(this.readURLStr, fileName, isThumb);
            log.debug((Object)("[" + urlStr + "]"));
            return this.fillFileFromWeb(urlStr, tmpFile) ? tmpFile : null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void storeAttachmentFile(Attachment attachment, File attachmentFile, File thumbnail) throws IOException {
        this.sendFile(attachmentFile, attachment.getAttachmentLocation(), false);
        this.sendFile(thumbnail, attachment.getAttachmentLocation(), true);
    }

    private String doSub(String urlStr, String symbol, String value) {
        return StringUtils.replace((String)urlStr, (String)symbol, (String)value);
    }

    private void fillValuesArray() {
        Collection coll = AppContextMgr.getInstance().getClassObject(Collection.class);
        Discipline disp = AppContextMgr.getInstance().getClassObject(Discipline.class);
        Division div = AppContextMgr.getInstance().getClassObject(Division.class);
        Institution inst = AppContextMgr.getInstance().getClassObject(Institution.class);
        this.values[0] = coll.getCollectionName();
        this.values[1] = disp.getName();
        this.values[2] = div.getName();
        this.values[3] = inst.getName();
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = StringUtils.replace((String)this.values[i], (String)" ", (String)"%20");
            ++i;
        }
    }

    private String subAllExtraData(String urlStr, String fileName, boolean isThumb) {
        this.fillValuesArray();
        String newURLStr = urlStr;
        int i = 0;
        while (i < this.values.length) {
            newURLStr = this.doSub(newURLStr, this.symbols[i], this.values[i]);
            ++i;
        }
        newURLStr = this.doSub(newURLStr, "<type>", isThumb ? "T" : "O");
        newURLStr = this.doSub(newURLStr, "<fname>", fileName);
        return newURLStr;
    }

    private synchronized boolean sendFile(File targetFile, String fileName, boolean isThumb) {
        String targetURL = this.writeURLStr;
        PostMethod filePost = new PostMethod(targetURL);
        this.fillValuesArray();
        try {
            System.out.println("Uploading " + targetFile.getName() + " to " + targetURL);
            String sha1Hash = this.calculateHash(targetFile);
            Part[] parts = new Part[]{new FilePart(targetFile.getName(), targetFile), new StringPart("type", isThumb ? "T" : "O"), new StringPart("store", fileName), new StringPart("coll", this.values[0]), new StringPart("hash", sha1Hash == null ? "" : sha1Hash)};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            int status = client.executeMethod((HttpMethod)filePost);
            System.out.println(filePost.getResponseBodyAsString());
            if (status == 200) {
                return true;
            }
        }
        catch (Exception ex) {
            System.out.println("Error:  " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            filePost.releaseConnection();
        }
        return false;
    }

    @Override
    public void replaceOriginal(Attachment attachment, File newOriginal, File newThumbnail) throws IOException {
    }

    @Override
    public void deleteAttachmentFiles(Attachment attachment) throws IOException {
        String targetFileName = attachment.getAttachmentLocation();
        if (this.deleteFileFromWeb(targetFileName, false)) {
            this.deleteFileFromWeb(targetFileName, true);
        } else {
            UIRegistry.showLocalizedError("ATTCH_NOT_DEL_REPOS", targetFileName);
        }
    }

    private boolean deleteFileFromWeb(String fileName, boolean isThumb) {
        try {
            String targetURL = this.subAllExtraData(this.delURLStr, fileName, isThumb);
            GetMethod getMethod = new GetMethod(targetURL);
            System.out.println("Deleting " + fileName + " from " + targetURL);
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            int status = client.executeMethod((HttpMethod)getMethod);
            System.out.println(getMethod.getResponseBodyAsString());
            return status == 200;
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public File regenerateThumbnail(Attachment attachment) throws IOException {
        File origFile;
        File thumbFile = null;
        boolean doLocalFile = false;
        String origFilePath = attachment.getAttachmentLocation();
        if (StringUtils.isEmpty((String)origFilePath)) {
            doLocalFile = true;
            origFilePath = attachment.getOrigFilename();
            if (StringUtils.isEmpty((String)origFilePath)) {
                return null;
            }
        }
        if ((origFile = doLocalFile ? new File(origFilePath) : this.getOriginal(attachment)) != null) {
            thumbFile = this.createTempFile(origFile.getName(), true);
            Thumbnailer thumbnailGen = AttachmentUtils.getThumbnailer();
            thumbnailGen.generateThumbnail(origFile.getAbsolutePath(), thumbFile.getAbsolutePath(), false);
            if (thumbFile.exists()) {
                if (!doLocalFile) {
                    this.sendFile(thumbFile, thumbFile.getName(), true);
                }
                try {
                    this.shortTermCache.cacheFile(thumbFile.getName(), thumbFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return thumbFile;
    }

    private String calculateHash(File file) throws Exception {
        if (sha1 != null) {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            DigestInputStream dis = new DigestInputStream(bis, sha1);
            while (dis.read() != -1) {
            }
            byte[] hash = sha1.digest();
            return this.byteArray2Hex(hash);
        }
        return null;
    }

    private String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    @Override
    public void setDirectory(File baseDir) throws IOException {
    }

    @Override
    public File getDirectory() {
        return null;
    }

    @Override
    public void cleanup() {
    }
}

