/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryWarningSystem {
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private static double thresholdPercentage = 0.6;
    private static double thresholdStep = 0.1;
    private static long maxMemory = 0L;
    private static long usedMemory = 0L;
    private static final MemoryPoolMXBean tenuredGenPool = MemoryWarningSystem.findTenuredGenPool();

    public MemoryWarningSystem() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object hb) {
                maxMemory = tenuredGenPool.getUsage().getMax();
                usedMemory = tenuredGenPool.getUsage().getUsed();
                double percentageUsed = (double)usedMemory / (double)maxMemory;
                if (thresholdStep < 0.9 && percentageUsed > thresholdStep) {
                    thresholdStep = Math.max(1.0, MemoryWarningSystem.getThresholdPercentage() + 0.2);
                    for (Listener listener : MemoryWarningSystem.this.listeners) {
                        listener.memoryUsageLow(usedMemory, maxMemory);
                    }
                }
                if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                    for (Listener listener : MemoryWarningSystem.this.listeners) {
                        listener.memoryUsageLow(usedMemory, maxMemory);
                    }
                }
            }
        }, null, null);
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public static void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        thresholdPercentage = percentage;
        long maxMem = tenuredGenPool.getUsage().getMax();
        long warningThreshold = (long)((double)maxMem * percentage);
        tenuredGenPool.setUsageThreshold(warningThreshold);
    }

    public static double getThresholdPercentage() {
        return thresholdPercentage;
    }

    public static void setThresholdPercentage(double thresholdPercentage) {
        MemoryWarningSystem.thresholdPercentage = thresholdPercentage;
    }

    public static long getMaxMemory() {
        return maxMemory;
    }

    public static long getUsedMemory() {
        return usedMemory;
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);

        public void memoryUsage(long var1, long var3);
    }
}

