/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.util.LatLonConverter;
import java.util.ArrayList;

public class LatLonValueInfo {
    protected String strVal = null;
    protected String dirStr = null;
    protected String fmtStrVal = null;
    protected LatLonConverter.FORMAT format = null;
    protected boolean hasDegreesTxt;
    protected ArrayList<String> parts = new ArrayList(4);

    public LatLonValueInfo(boolean hasDegreesTxt) {
        this.hasDegreesTxt = hasDegreesTxt;
    }

    public void addPart(String str) {
        this.parts.add(str);
    }

    public String getPart(int inx) {
        return this.parts.get(inx);
    }

    public String getStrVal(boolean inclDir) {
        if (this.strVal == null) {
            this.strVal = this.createValStrFromParts(false, inclDir);
        }
        return this.strVal;
    }

    public String getFormattedStrVal() {
        if (this.fmtStrVal == null) {
            this.fmtStrVal = this.createValStrFromParts(true, true);
        }
        return this.fmtStrVal;
    }

    public void setStrVal(String strVal) {
        this.strVal = strVal;
    }

    public String getDirStr() {
        return this.dirStr;
    }

    public void setDirStr(String dirStr) {
        this.dirStr = dirStr;
    }

    public LatLonConverter.FORMAT getFormat() {
        return this.format;
    }

    public void setFormat(LatLonConverter.FORMAT format) {
        this.format = format;
    }

    public String getBaseStrVal() {
        return this.strVal.substring(0, this.strVal.length() - 2);
    }

    public boolean isHasDegreesTxt() {
        return this.hasDegreesTxt;
    }

    public void setHasDegreesTxt(boolean hasDegreesTxt) {
        this.hasDegreesTxt = hasDegreesTxt;
    }

    public boolean isDirPositive() {
        return this.dirStr != null && (this.dirStr.equals(LatLonConverter.northSouth[0]) || this.dirStr.equals(LatLonConverter.eastWest[0]));
    }

    public String createValStrFromParts(boolean doAddSymbols, boolean inclDir) {
        if (this.parts.size() > 0) {
            StringBuilder sb = new StringBuilder(this.parts.get(0));
            if (doAddSymbols) {
                sb.append("\u00b0");
            }
            switch (this.format) {
                case DDDDDD: {
                    if (!inclDir) break;
                    sb.append(' ');
                    sb.append(this.parts.get(1));
                    break;
                }
                case DDMMMM: {
                    sb.append(' ');
                    sb.append(this.parts.get(1));
                    if (doAddSymbols) {
                        sb.append("'");
                    }
                    if (!inclDir) break;
                    sb.append(' ');
                    sb.append(this.parts.get(2));
                    break;
                }
                case DDMMSS: {
                    sb.append(' ');
                    sb.append(this.parts.get(1));
                    if (doAddSymbols) {
                        sb.append("'");
                    }
                    sb.append(' ');
                    sb.append(this.parts.get(2));
                    if (doAddSymbols) {
                        sb.append("\"");
                    }
                    if (!inclDir) break;
                    sb.append(' ');
                    sb.append(this.parts.get(3));
                    break;
                }
            }
            return sb.toString();
        }
        return null;
    }
}

