/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.LatLonValueInfo;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class LatLonConverter {
    protected static DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.getDefault());
    protected static String decimalSep;
    public static final char UNICODE_DEGREE = '\u00b0';
    public static final String DEGREES_SYMBOL = "\u00b0";
    public static final String SEPS = "\u00b0:'\" ";
    protected static final int DDDDDD_LEN = 7;
    protected static final int DDMMMM_LEN = 5;
    protected static final int DDMMSS_LEN = 3;
    public static int[] DECIMAL_SIZES;
    private static boolean useDB;
    public static DecimalFormat decFormatter;
    protected static StringBuffer zeroes;
    protected static BigDecimal minusOne;
    protected static DecimalFormat decFormatter2;
    protected static BigDecimal one;
    protected static BigDecimal sixty;
    public static String[] NORTH_SOUTH;
    public static String[] EAST_WEST;
    public static String[] northSouth;
    public static String[] eastWest;

    static {
        int[] nArray = new int[4];
        nArray[0] = 7;
        nArray[1] = 3;
        nArray[2] = 5;
        DECIMAL_SIZES = nArray;
        useDB = false;
        decFormatter = new DecimalFormat("#0.0000000#");
        zeroes = new StringBuffer(64);
        minusOne = new BigDecimal("-1.0");
        decFormatter2 = new DecimalFormat("#0");
        one = new BigDecimal("1.0");
        sixty = new BigDecimal("60.0");
        northSouth = null;
        eastWest = null;
        NORTH_SOUTH = new String[]{"N", "S"};
        EAST_WEST = new String[]{"E", "W"};
        northSouth = new String[]{UIRegistry.getResourceString(NORTH_SOUTH[0]), UIRegistry.getResourceString(NORTH_SOUTH[1])};
        eastWest = new String[]{UIRegistry.getResourceString(EAST_WEST[0]), UIRegistry.getResourceString(EAST_WEST[1])};
        int i = 0;
        while (i < 8) {
            zeroes.append("00000000");
            ++i;
        }
        decimalSep = Character.toString(formatSymbols.getDecimalSeparator());
    }

    private LatLonConverter() {
    }

    public static FORMAT convertIntToFORMAT(int formatInt) {
        switch (formatInt) {
            case 0: {
                return FORMAT.DDDDDD;
            }
            case 1: {
                return FORMAT.DDMMSS;
            }
            case 2: {
                return FORMAT.DDMMMM;
            }
        }
        return FORMAT.DDDDDD;
    }

    public static String ensureFormattedString(BigDecimal bd, String latLonStr, FORMAT type, LATLON latOrLon) {
        return LatLonConverter.ensureFormattedString(bd, latLonStr, type, latOrLon, DECIMAL_SIZES[type.ordinal()]);
    }

    public static String ensureFormattedString(BigDecimal bd, String latLonStr, FORMAT type, LATLON latOrLon, int decimalSize) {
        if (StringUtils.isEmpty((String)latLonStr)) {
            if (bd == null) {
                return null;
            }
            String outStr = LatLonConverter.format(bd, latOrLon, type, DEGREES_FORMAT.Symbol, decimalSize);
            outStr = latOrLon == LATLON.Latitude ? String.valueOf(outStr) + " " + northSouth[bd.doubleValue() < 0.0 ? 1 : 0] : String.valueOf(outStr) + " " + eastWest[bd.doubleValue() < 0.0 ? 1 : 0];
            return outStr;
        }
        return latLonStr;
    }

    public static LatLonValueInfo adjustLatLonStr(String strArg, FORMAT actualFmt, boolean addSymbols, boolean inclZeroes, LATLON latOrLon) {
        if (StringUtils.isNotEmpty((String)strArg)) {
            String str = strArg;
            boolean redoSplit = false;
            String[] tokens = LatLonConverter.breakStringAPart(str);
            boolean startsWithMinus = str.startsWith("-");
            if (startsWithMinus) {
                str = str.substring(1);
                redoSplit = true;
            }
            if (tokens.length == 1) {
                str = latOrLon == LATLON.Latitude ? String.valueOf(str) + " " + northSouth[startsWithMinus ? 1 : 0] : String.valueOf(str) + " " + eastWest[startsWithMinus ? 1 : 0];
                redoSplit = true;
            }
            if (redoSplit) {
                tokens = LatLonConverter.breakStringAPart(str);
            }
            String zero = inclZeroes ? "0" : "";
            boolean hasDegreesTxt = tokens[1].length() == 3 && tokens[1].equals("deg");
            LatLonValueInfo latLonInfo = new LatLonValueInfo(hasDegreesTxt);
            latLonInfo.addPart(tokens[0]);
            int toksLen = tokens.length;
            String dirStr = null;
            FORMAT fmt = null;
            if (actualFmt != null && actualFmt != FORMAT.None) {
                switch (actualFmt) {
                    case DDDDDD: {
                        dirStr = tokens[toksLen - 1];
                        break;
                    }
                    case DDMMMM: {
                        if (toksLen == 3) {
                            latLonInfo.addPart(tokens[1]);
                            dirStr = tokens[2];
                            break;
                        }
                        latLonInfo.addPart(zero);
                        dirStr = tokens[1];
                        break;
                    }
                    case DDMMSS: {
                        if (toksLen == 4) {
                            latLonInfo.addPart(tokens[1]);
                            latLonInfo.addPart(tokens[2]);
                            dirStr = tokens[3];
                            break;
                        }
                        if (toksLen == 3) {
                            String tok1 = tokens[1];
                            if (StringUtils.contains((String)tok1, (char)formatSymbols.getDecimalSeparator())) {
                                String[] tks = StringUtils.split((String)tok1, (char)formatSymbols.getDecimalSeparator());
                                latLonInfo.addPart(tks[0]);
                                latLonInfo.addPart(tks[1]);
                            } else {
                                latLonInfo.addPart(tok1);
                                latLonInfo.addPart(zero);
                            }
                            dirStr = tokens[2];
                            break;
                        }
                        if (toksLen != 2) break;
                        latLonInfo.addPart(zero);
                        latLonInfo.addPart(zero);
                        dirStr = tokens[1];
                        break;
                    }
                }
                fmt = actualFmt;
            } else {
                switch (toksLen) {
                    case 2: {
                        dirStr = tokens[1];
                        fmt = FORMAT.DDDDDD;
                        break;
                    }
                    case 3: {
                        if (hasDegreesTxt) {
                            fmt = FORMAT.DDDDDD;
                        } else {
                            latLonInfo.addPart(tokens[1]);
                            fmt = FORMAT.DDMMMM;
                        }
                        dirStr = tokens[2];
                        break;
                    }
                    case 4: {
                        if (hasDegreesTxt) {
                            fmt = FORMAT.DDMMMM;
                        } else {
                            latLonInfo.addPart(tokens[1]);
                            fmt = FORMAT.DDMMSS;
                        }
                        latLonInfo.addPart(tokens[2]);
                        dirStr = tokens[3];
                        break;
                    }
                    case 5: {
                        latLonInfo.addPart(tokens[2]);
                        latLonInfo.addPart(tokens[3]);
                        dirStr = tokens[4];
                        fmt = FORMAT.DDMMSS;
                        break;
                    }
                }
            }
            latLonInfo.addPart(dirStr);
            latLonInfo.setFormat(fmt);
            latLonInfo.setDirStr(dirStr);
            return latLonInfo;
        }
        return null;
    }

    public static String convert(String strArg, FORMAT fromFmt, FORMAT toFmt, LATLON latOrLon) {
        if (fromFmt == toFmt) {
            return strArg;
        }
        LatLonValueInfo latLonVal = LatLonConverter.adjustLatLonStr(strArg, fromFmt, false, true, latOrLon);
        String str = latLonVal.getStrVal(false);
        if (StringUtils.isNotEmpty((String)str)) {
            BigDecimal bd = null;
            switch (fromFmt) {
                case DDDDDD: {
                    bd = LatLonConverter.convertDDDDStrToDDDDBD(str);
                    break;
                }
                case DDMMMM: {
                    bd = LatLonConverter.convertDDMMMMStrToDDDDBD(str);
                    break;
                }
                case DDMMSS: {
                    bd = LatLonConverter.convertDDMMSSStrToDDDDBD(str);
                    break;
                }
            }
            String outStr = "";
            if (bd != null) {
                outStr = LatLonConverter.format(bd, latOrLon, toFmt, DEGREES_FORMAT.Symbol, DECIMAL_SIZES[toFmt.ordinal()]);
                if (StringUtils.isNotEmpty((String)latLonVal.getDirStr())) {
                    outStr = String.valueOf(outStr) + " " + latLonVal.getDirStr();
                }
            }
            return outStr;
        }
        return null;
    }

    public static String convertToDDMMSS(BigDecimal bd, int decimalLen) {
        return LatLonConverter.convertToDDMMSS(bd, DEGREES_FORMAT.None, DIRECTION.None, decimalLen);
    }

    public static String convertToSignedDDMMSS(BigDecimal bd, int decimalLen) {
        return LatLonConverter.convertToSignedDDMMSS(bd, decimalLen, DEGREES_FORMAT.None);
    }

    public static String convertToSignedDDMMSS(BigDecimal bd, int decimalLen, DEGREES_FORMAT degFmt) {
        String sign = "";
        if (bd.compareTo(bd.abs()) < 0) {
            sign = "-";
        }
        String convertedAbs = LatLonConverter.convertToDDMMSS(bd, degFmt, DIRECTION.None, decimalLen);
        return String.valueOf(sign) + convertedAbs;
    }

    public static int getDecimalLength(String latLonStr) {
        int decIndex;
        int decimalFmtLen = 0;
        if (StringUtils.isNotEmpty((String)latLonStr) && (decIndex = latLonStr.lastIndexOf(46)) > -1 && latLonStr.length() > decIndex) {
            decimalFmtLen = latLonStr.length() - decIndex;
        }
        return decimalFmtLen;
    }

    public static String convertToDDMMSS(BigDecimal bd, DEGREES_FORMAT degreesFMT, DIRECTION direction, int decimalLen) {
        return LatLonConverter.convertToDDMMSS(bd, degreesFMT, direction, decimalLen, false);
    }

    public static String convertToDDMMSS(BigDecimal bd, DEGREES_FORMAT degreesFMT, DIRECTION direction, int decimalLen, boolean alwaysIncludeDir) {
        int secondsWhole;
        boolean addMinSecsSyms;
        if (bd.doubleValue() == 0.0) {
            return "0." + zeroes.substring(0, decimalLen);
        }
        if (useDB) {
            BigDecimal remainder = bd.remainder(one);
            BigDecimal num = bd.subtract(remainder);
            BigDecimal minutes = new BigDecimal(remainder.multiply(sixty).abs().intValue());
            BigDecimal secondsFraction = remainder.abs().multiply(sixty).subtract(minutes);
            BigDecimal seconds = secondsFraction.multiply(sixty);
            return String.valueOf(decFormatter2.format(num)) + " " + decFormatter2.format(minutes) + " " + decFormatter.format(seconds);
        }
        double num = Math.abs(bd.doubleValue());
        int whole = (int)Math.floor(num);
        double remainder = num - (double)whole;
        double minutes = remainder * 60.0;
        int minutesWhole = (int)Math.floor(minutes);
        double secondsFraction = minutes - (double)minutesWhole;
        double seconds = secondsFraction * 60.0;
        boolean bl = addMinSecsSyms = degreesFMT != DEGREES_FORMAT.None;
        if (minutesWhole == 60) {
            ++whole;
            minutesWhole = 0;
        }
        if ((secondsWhole = (int)Math.floor(seconds = (double)Math.round(seconds * 1000.0) / 1000.0)) == 60) {
            ++minutesWhole;
            seconds = 0.0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(whole);
        if (degreesFMT == DEGREES_FORMAT.Symbol) {
            sb.append(DEGREES_SYMBOL);
        }
        sb.append(' ');
        sb.append(minutesWhole);
        if (addMinSecsSyms) {
            sb.append("'");
        }
        sb.append(' ');
        sb.append(String.format("%2." + decimalLen + "f", seconds));
        if (addMinSecsSyms) {
            sb.append("\"");
        }
        if (degreesFMT == DEGREES_FORMAT.String || alwaysIncludeDir) {
            int inx;
            int n = inx = bd.doubleValue() < 0.0 ? 1 : 0;
            if (direction != DIRECTION.None) {
                sb.append(' ');
                sb.append(direction == DIRECTION.NorthSouth ? northSouth[inx] : eastWest[inx]);
            }
        }
        return sb.toString();
    }

    public static String convertToDDMMMM(BigDecimal bd, int decimalLen) {
        return LatLonConverter.convertToDDMMMM(bd, DEGREES_FORMAT.None, DIRECTION.None, decimalLen);
    }

    public static String convertToSignedDDMMMM(BigDecimal dd, int decimalLen) {
        return LatLonConverter.convertToSignedDDMMMM(dd, decimalLen, DEGREES_FORMAT.None);
    }

    public static String convertToSignedDDMMMM(BigDecimal dd, int decimalLen, DEGREES_FORMAT degFmt) {
        String sign = "";
        if (dd.compareTo(dd.abs()) < 0) {
            sign = "-";
        }
        String convertedAbs = LatLonConverter.convertToDDMMMM(dd, degFmt, DIRECTION.None, decimalLen);
        return String.valueOf(sign) + convertedAbs;
    }

    public static String convertToDDMMMM(BigDecimal bd, DEGREES_FORMAT degreesFMT, DIRECTION direction, int decimalLen) {
        return LatLonConverter.convertToDDMMMM(bd, degreesFMT, direction, decimalLen, false);
    }

    public static String convertToDDMMMM(BigDecimal bd, DEGREES_FORMAT degreesFMT, DIRECTION direction, int decimalLen, boolean alwaysIncludeDir) {
        if (bd.doubleValue() == 0.0) {
            return "0.0";
        }
        if (useDB) {
            BigDecimal remainder = bd.remainder(one);
            BigDecimal num = bd.subtract(remainder);
            BigDecimal minutes = remainder.multiply(sixty).abs();
            return String.valueOf(decFormatter2.format(num)) + " " + decFormatter2.format(minutes);
        }
        boolean addMinSecsSyms = degreesFMT != DEGREES_FORMAT.None;
        double num = Math.abs(bd.doubleValue());
        int whole = (int)Math.floor(num);
        double remainder = num - (double)whole;
        double minutes = remainder * 60.0;
        StringBuilder sb = new StringBuilder();
        sb.append(whole);
        if (degreesFMT == DEGREES_FORMAT.Symbol) {
            sb.append(DEGREES_SYMBOL);
        }
        sb.append(' ');
        sb.append(String.format("%2." + decimalLen + "f", minutes));
        if (addMinSecsSyms) {
            sb.append("'");
        }
        if (degreesFMT == DEGREES_FORMAT.String || alwaysIncludeDir) {
            int inx;
            int n = inx = bd.doubleValue() < 0.0 ? 1 : 0;
            if (direction != DIRECTION.None) {
                sb.append(' ');
                sb.append(direction == DIRECTION.NorthSouth ? northSouth[inx] : eastWest[inx]);
            }
        }
        return sb.toString();
    }

    public static String convertToDDDDDD(BigDecimal bd, int decimalLen) {
        return LatLonConverter.convertToDDDDDD(bd, DEGREES_FORMAT.String, DIRECTION.None, decimalLen);
    }

    public static String convertToSignedDDDDDD(BigDecimal dd, int decimalLen) {
        return LatLonConverter.convertToSignedDDDDDD(dd, decimalLen, DEGREES_FORMAT.None);
    }

    public static String convertToSignedDDDDDD(BigDecimal dd, int decimalLen, DEGREES_FORMAT degFmt) {
        String sign = "";
        if (dd.compareTo(dd.abs()) < 0) {
            sign = "-";
        }
        String convertedAbs = LatLonConverter.convertToDDDDDD(dd, degFmt, DIRECTION.None, decimalLen);
        return String.valueOf(sign) + convertedAbs;
    }

    public static String convertToDDDDDD(BigDecimal bd, DEGREES_FORMAT degreesFMT, DIRECTION direction, int decimalLen) {
        return LatLonConverter.convertToDDDDDD(bd, degreesFMT, direction, decimalLen, false);
    }

    public static String convertToDDDDDD(BigDecimal bd, DEGREES_FORMAT degreesFMT, DIRECTION direction, int decimalLen, boolean alwaysIncludeDir) {
        if (bd == null || bd.doubleValue() == 0.0) {
            return "0.0";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%" + decimalLen + "." + decimalLen + "f", bd.abs()));
        if (degreesFMT == DEGREES_FORMAT.Symbol) {
            sb.append(DEGREES_SYMBOL);
        }
        if (degreesFMT == DEGREES_FORMAT.String || alwaysIncludeDir) {
            int inx;
            int n = inx = bd.doubleValue() < 0.0 ? 1 : 0;
            if (direction != DIRECTION.None) {
                sb.append(' ');
                sb.append(direction == DIRECTION.NorthSouth ? northSouth[inx] : eastWest[inx]);
            }
        }
        return sb.toString();
    }

    protected static boolean isNegative(String direction) {
        return direction.equals("S") || direction.equals("W");
    }

    public static BigDecimal convertDDDDStrToDDDDBD(String str) {
        String withoutDegSign = StringUtils.chomp((String)str, (String)DEGREES_SYMBOL);
        withoutDegSign = StringUtils.chomp((String)withoutDegSign, (String)"\ufffd");
        String val = StringUtils.replace((String)StringUtils.replace((String)(withoutDegSign = StringUtils.remove((String)withoutDegSign, (char)'\u00b0')), (String)decimalSep, (String)""), (String)"-", (String)"");
        return StringUtils.isNumeric((String)val) ? UIHelper.parseDoubleToBigDecimal(withoutDegSign) : null;
    }

    public static BigDecimal convertDDDDStrToDDDDBD(String str, String direction) {
        String val = StringUtils.replace((String)StringUtils.replace((String)str, (String)decimalSep, (String)""), (String)"-", (String)"");
        if (!StringUtils.isNumeric((String)val)) {
            return null;
        }
        BigDecimal bd = UIHelper.parseDoubleToBigDecimal(str);
        if (LatLonConverter.isNegative(direction)) {
            return bd.multiply(minusOne);
        }
        return bd;
    }

    public static String[] breakStringAPart(String str) {
        return StringUtils.split((String)str, (String)SEPS);
    }

    public static BigDecimal convertDDMMSSStrToDDDDBD(String str) {
        String[] parts = StringUtils.split((String)str, (String)" d\u00b0'\"\u00b0");
        if (parts.length != 3) {
            return null;
        }
        double p0 = UIHelper.parseDouble(parts[0]);
        boolean neg = false;
        if (p0 < 0.0) {
            p0 *= -1.0;
            neg = true;
        }
        double p1 = UIHelper.parseDouble(parts[1]);
        double p2 = UIHelper.parseDouble(parts[2]);
        BigDecimal val = new BigDecimal(p0 + (p1 + p2 / 60.0) / 60.0);
        if (neg) {
            val = val.multiply(minusOne);
        }
        return val;
    }

    public static BigDecimal convertDDMMSSStrToDDDDBD(String str, String direction) {
        BigDecimal bd = LatLonConverter.convertDDMMSSStrToDDDDBD(str);
        if (LatLonConverter.isNegative(direction)) {
            return bd.multiply(minusOne);
        }
        return bd;
    }

    public static BigDecimal convertDDMMMMStrToDDDDBD(String str) {
        String[] parts = StringUtils.split((String)str, (String)" d\u00b0'\"\u00b0");
        double p0 = UIHelper.parseDouble(parts[0]);
        boolean neg = false;
        if (p0 < 0.0) {
            p0 *= -1.0;
            neg = true;
        }
        double p1 = UIHelper.parseDouble(parts[1]);
        BigDecimal val = new BigDecimal(p0 + p1 / 60.0);
        if (neg) {
            val = val.multiply(minusOne);
        }
        return val;
    }

    public static BigDecimal convertDDMMMMStrToDDDDBD(String str, String direction) {
        BigDecimal bd = LatLonConverter.convertDDMMMMStrToDDDDBD(str);
        if (LatLonConverter.isNegative(direction)) {
            return bd.multiply(minusOne);
        }
        return bd;
    }

    public static String stripZeroes(String str) {
        if (str.indexOf(46) == -1) {
            return str;
        }
        String newStr = StringUtils.stripEnd((String)str, (String)"0");
        if (newStr.endsWith(decimalSep)) {
            return String.valueOf(newStr) + "0";
        }
        return newStr;
    }

    public static String format(BigDecimal bd) {
        String formatted = decFormatter.format(bd);
        return LatLonConverter.stripZeroes(formatted);
    }

    public static String format(BigDecimal value, LATLON latOrLon, FORMAT format, DEGREES_FORMAT degreesFMT, int decimalLen) {
        DIRECTION dir = latOrLon == LATLON.Latitude ? DIRECTION.NorthSouth : DIRECTION.EastWest;
        switch (format) {
            case DDDDDD: {
                return LatLonConverter.convertToDDDDDD(value, degreesFMT, dir, decimalLen);
            }
            case DDMMMM: {
                return LatLonConverter.convertToDDMMMM(value, degreesFMT, dir, decimalLen);
            }
            case DDMMSS: {
                return LatLonConverter.convertToDDMMSS(value, degreesFMT, dir, decimalLen);
            }
        }
        return "";
    }

    public static BigDecimal convertDirectionalDDMMSSToDDDD(String str) {
        String[] parts = StringUtils.split((String)str, (String)" d\u00b0'\"\u00b0");
        String dir = null;
        if (parts.length < 4) {
            parts[2] = parts[2].replaceAll("[NSEW]", "");
            int beginIndex = str.indexOf(parts[2]) + parts[2].length();
            dir = str.substring(beginIndex, beginIndex + 1);
        } else {
            dir = parts[3].substring(0, 1);
        }
        double p0 = UIHelper.parseDouble(parts[0]);
        double p1 = UIHelper.parseDouble(parts[1]);
        double p2 = UIHelper.parseDouble(parts[2]);
        BigDecimal val = new BigDecimal(p0 + (p1 + p2 / 60.0) / 60.0);
        if (LatLonConverter.isNegative(dir)) {
            val = val.multiply(minusOne);
        }
        return val;
    }

    public static BigDecimal convertDirectionalDDMMMMToDDDD(String dm) {
        String[] parts = StringUtils.split((String)dm, (String)" d\u00b0'\"\u00b0");
        String dir = null;
        if (parts.length < 3) {
            parts[1] = parts[1].replaceAll("[NSEW]", "");
            int beginIndex = dm.indexOf(parts[1]) + parts[1].length();
            dir = dm.substring(beginIndex, beginIndex + 1);
        } else {
            dir = parts[2].substring(0, 1);
        }
        double p0 = UIHelper.parseDouble(parts[0]);
        double p1 = UIHelper.parseDouble(parts[1]);
        BigDecimal val = new BigDecimal(p0 + p1 / 60.0);
        if (LatLonConverter.isNegative(dir)) {
            val = val.multiply(minusOne);
        }
        return val;
    }

    public static BigDecimal convertDirectionalDDDDToDDDD(String str) {
        String[] parts = StringUtils.split((String)str, (String)" d\u00b0'\"\u00b0");
        String dir = null;
        if (parts.length < 2) {
            parts[0] = parts[0].replaceAll("[NSEW]", "");
            int beginIndex = str.indexOf(parts[0]) + parts[0].length();
            dir = str.substring(beginIndex, beginIndex + 1);
        } else {
            dir = parts[1].substring(0, 1);
        }
        double p0 = UIHelper.parseDouble(parts[0]);
        BigDecimal val = new BigDecimal(p0);
        if (LatLonConverter.isNegative(dir)) {
            val = val.multiply(minusOne);
        }
        return val;
    }

    public static enum DEGREES_FORMAT {
        None,
        Symbol,
        String;

    }

    public static enum DIRECTION {
        None,
        NorthSouth,
        EastWest;

    }

    public static enum FORMAT {
        DDDDDD,
        DDMMSS,
        DDMMMM,
        None;

    }

    public static enum LATLON {
        Latitude,
        Longitude;

    }
}

