/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class HelpIndexer {
    File jhm;
    File topDir;
    String outFileName;
    List<String> mapLines;

    public HelpIndexer(String jhmFile, String dir, String outFileName) {
        this.jhm = new File(jhmFile);
        this.topDir = new File(dir);
        this.outFileName = outFileName;
    }

    public void indexIt() {
        if (!this.jhm.exists()) {
            System.out.println("jhm file not found.");
            return;
        }
        if (!this.topDir.isDirectory()) {
            System.out.println("directory does not exist.");
            return;
        }
        try {
            this.mapLines = FileUtils.readLines((File)this.jhm);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HelpIndexer.class, ex);
            System.out.println("Error reading map file: " + ex.getMessage());
            return;
        }
        Vector<String> lines = new Vector<String>();
        String[] ext = new String[]{"html"};
        Iterator helpFiles = FileUtils.iterateFiles((File)this.topDir, (String[])ext, (boolean)true);
        while (helpFiles.hasNext()) {
            File file = (File)helpFiles.next();
            System.out.println("Processing " + file.getName());
            this.processFile(file, lines);
        }
        System.out.println();
        System.out.println("all done.");
        File outFile = new File(this.outFileName);
        try {
            lines.insertElementAt("<?xml version='1.0' encoding='ISO-8859-1'  ?>", 0);
            lines.insertElementAt("<!DOCTYPE index", 1);
            lines.insertElementAt("  PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Index Version 1.0//EN\"", 2);
            lines.insertElementAt("         \"http://java.sun.com/products/javahelp/index_1_0.dtd\">", 3);
            lines.insertElementAt("<index version=\"1.0\">", 4);
            lines.insertElementAt(" ", 5);
            lines.add(" ");
            lines.add("</index>");
            FileUtils.writeLines((File)outFile, lines);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HelpIndexer.class, ex);
            System.out.println("error writing output file: " + ex.getMessage());
        }
    }

    protected String getFileTitle(File file) {
        String text;
        try {
            text = FileUtils.readFileToString((File)file);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HelpIndexer.class, ex);
            System.out.println("error processing file: " + file.getName());
            return null;
        }
        int titlePos = text.toLowerCase().indexOf("<title>", 0);
        if (titlePos < 0) {
            return null;
        }
        int endTitlePos = text.toLowerCase().indexOf("</title>", titlePos);
        if (endTitlePos < 0) {
            return null;
        }
        return text.substring(titlePos + 7, endTitlePos).trim();
    }

    protected String processIndexLine(String line, String target) {
        String workLine = line.trim();
        int sinx = workLine.indexOf("<span");
        int startIdxTitle = workLine.indexOf(">", sinx) + 1;
        int endIdxTitle = workLine.indexOf("</span>", sinx);
        String idxTitle = workLine.substring(startIdxTitle, endIdxTitle);
        return "<indexitem text=\"" + idxTitle + "\"   target=\"" + target + "\"/>";
    }

    protected String getTarget(File file) {
        int lineNo = 0;
        while (lineNo < this.mapLines.size() && this.mapLines.get(lineNo).indexOf(file.getName()) < 0) {
            ++lineNo;
        }
        if (lineNo == this.mapLines.size()) {
            System.out.println("target for " + file.getName() + " could not be determined.");
            return null;
        }
        String mapLine = this.mapLines.get(lineNo);
        int targetIdx = mapLine.toLowerCase().indexOf("target=");
        if (targetIdx < 0) {
            System.out.println("target for " + file.getName() + " could not be determined.");
            return null;
        }
        int endTargetIdx = mapLine.indexOf("\"", targetIdx + 9);
        if (endTargetIdx < 0) {
            System.out.println("target for " + file.getName() + " could not be determined.");
            return null;
        }
        String result = mapLine.substring(targetIdx + 7, endTargetIdx + 1).trim();
        return result.substring(1, result.length() - 1);
    }

    protected void processFile(File file, Vector<String> lines) {
        LineIterator it;
        try {
            it = FileUtils.lineIterator((File)file, (String)"UTF-8");
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HelpIndexer.class, ex);
            System.out.println("error processing file: " + file.getName());
            return;
        }
        String target = this.getTarget(file);
        String title = this.getFileTitle(file);
        boolean removeTitleEntry = false;
        if (title != null) {
            String tline = "<indexitem text=\"" + title;
            if (target != null) {
                tline = String.valueOf(tline) + "\"  target=\"" + target;
            }
            tline = String.valueOf(tline) + "\">";
            lines.add(tline);
            removeTitleEntry = true;
        }
        if (target != null) {
            try {
                while (it.hasNext()) {
                    String line = it.nextLine();
                    if (!this.isIndexLine(line)) continue;
                    System.out.println("indexing " + file.getName() + ": " + line);
                    String indexEntry = this.processIndexLine(line, target);
                    if (indexEntry == null) continue;
                    lines.add("     " + indexEntry);
                    removeTitleEntry = false;
                }
            }
            finally {
                LineIterator.closeQuietly((LineIterator)it);
            }
        }
        if (title != null && !removeTitleEntry) {
            lines.add("</indexitem>");
        }
        if (removeTitleEntry) {
            lines.remove(lines.size() - 1);
        }
    }

    protected boolean isIndexLine(String line) {
        String token = "<span class=\"index\">";
        String stripped = line.trim();
        if (stripped.length() < "<span class=\"index\">".length()) {
            return false;
        }
        return stripped.indexOf("<span class=\"index\">") > -1;
    }

    public static void main(String[] args) {
        String output;
        String helpFile;
        String mapFile;
        if (args.length == 0) {
            mapFile = "help/SpecifyHelp.jhm";
            helpFile = "help/SpecifyHelp/Workbench";
            output = "SpecifyHelpIndex.xml";
        } else {
            mapFile = args[0];
            helpFile = args[1];
            output = args[2];
        }
        HelpIndexer hi = new HelpIndexer(mapFile, helpFile, output);
        hi.indexIt();
    }
}

