/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.StringConverter;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class GeoRefConverter
implements StringConverter {
    protected final String decimalSep = Character.toString(new DecimalFormatSymbols(Locale.getDefault()).getDecimalSeparator());

    public int getDecimalSize(String llText) {
        if (StringUtils.isBlank((String)llText)) {
            return 0;
        }
        int decimalFmtLen = 0;
        int decIndex = llText.lastIndexOf(this.decimalSep);
        if (decIndex > -1 && llText.length() > decIndex) {
            int end = llText.length();
            while (!StringUtils.isNumeric((String)llText.substring(decIndex + 1, end)) && end >= 0) {
                --end;
            }
            decimalFmtLen = end - decIndex - 1;
        }
        return decimalFmtLen;
    }

    @Override
    public String convert(String original, String destFormat) throws Exception {
        return this.convert(original, destFormat, LatLonConverter.LATLON.Latitude, LatLonConverter.DEGREES_FORMAT.None);
    }

    public String convert(String original, String destFormat, LatLonConverter.LATLON llType, LatLonConverter.DEGREES_FORMAT degFmt) throws Exception {
        if (original == null) {
            return null;
        }
        String deLocalized = original.replace(this.decimalSep, ".");
        BigDecimal degreesPlusMinus = null;
        Enum originalFormat = null;
        GeoRefFormat[] geoRefFormatArray = GeoRefFormat.values();
        int n = geoRefFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoRefFormat format = geoRefFormatArray[n2];
            if (deLocalized.matches(format.regex)) {
                degreesPlusMinus = format.convertToDecimalDegrees(original);
                originalFormat = format;
                break;
            }
            ++n2;
        }
        int decimalFmtLen = this.getDecimalSize(original);
        if (degreesPlusMinus == null) {
            throw new Exception("Cannot find matching input format");
        }
        if (destFormat.equals(GeoRefFormat.DMS_PLUS_MINUS.name()) || destFormat.equals(GeoRefFormat.DMS_NSEW.name())) {
            if (originalFormat.equals((Object)GeoRefFormat.D_NSEW) || originalFormat.equals((Object)GeoRefFormat.D_PLUS_MINUS)) {
                decimalFmtLen = Math.max(0, decimalFmtLen - 4);
            } else if (originalFormat.equals((Object)GeoRefFormat.DM_NSEW) || originalFormat.equals((Object)GeoRefFormat.DM_PLUS_MINUS)) {
                decimalFmtLen = Math.max(0, decimalFmtLen - 2);
            }
            if (destFormat.equals(GeoRefFormat.DMS_PLUS_MINUS.name())) {
                return LatLonConverter.convertToSignedDDMMSS(degreesPlusMinus, decimalFmtLen, degFmt);
            }
            if (destFormat.equals(GeoRefFormat.DMS_NSEW.name())) {
                return LatLonConverter.convertToDDMMSS(degreesPlusMinus, degFmt, this.getDir(llType), decimalFmtLen, true);
            }
        } else if (destFormat.equals(GeoRefFormat.DM_PLUS_MINUS.name()) || destFormat.equals(GeoRefFormat.DM_NSEW.name())) {
            if (originalFormat.equals((Object)GeoRefFormat.D_NSEW) || originalFormat.equals((Object)GeoRefFormat.D_PLUS_MINUS)) {
                decimalFmtLen = Math.max(0, decimalFmtLen - 2);
            } else if (originalFormat.equals((Object)GeoRefFormat.DMS_NSEW) || originalFormat.equals((Object)GeoRefFormat.DMS_PLUS_MINUS)) {
                decimalFmtLen += 2;
            }
            if (destFormat.equals(GeoRefFormat.DM_PLUS_MINUS.name())) {
                return LatLonConverter.convertToSignedDDMMMM(degreesPlusMinus, Math.max(decimalFmtLen, 2), degFmt);
            }
            if (destFormat.equals(GeoRefFormat.DM_NSEW.name())) {
                return LatLonConverter.convertToDDMMMM(degreesPlusMinus, degFmt, this.getDir(llType), Math.max(decimalFmtLen, 2), true);
            }
        } else if (destFormat.equals(GeoRefFormat.D_PLUS_MINUS.name()) || destFormat.equals(GeoRefFormat.D_NSEW.name())) {
            if (originalFormat.equals((Object)GeoRefFormat.DMS_NSEW) || originalFormat.equals((Object)GeoRefFormat.DMS_PLUS_MINUS)) {
                decimalFmtLen += 7;
            } else if (originalFormat.equals((Object)GeoRefFormat.DM_NSEW) || originalFormat.equals((Object)GeoRefFormat.DM_PLUS_MINUS)) {
                decimalFmtLen += 5;
            }
            if (destFormat.equals(GeoRefFormat.D_PLUS_MINUS.name())) {
                return LatLonConverter.convertToSignedDDDDDD(degreesPlusMinus, Math.max(decimalFmtLen, 2), degFmt);
            }
            if (destFormat.equals(GeoRefFormat.D_NSEW.name())) {
                return LatLonConverter.convertToDDDDDD(degreesPlusMinus, degFmt, this.getDir(llType), Math.max(decimalFmtLen, 2), true);
            }
        }
        return null;
    }

    protected LatLonConverter.DIRECTION getDir(LatLonConverter.LATLON llType) {
        if (llType.equals((Object)LatLonConverter.LATLON.Latitude)) {
            return LatLonConverter.DIRECTION.NorthSouth;
        }
        if (llType.equals((Object)LatLonConverter.LATLON.Longitude)) {
            return LatLonConverter.DIRECTION.EastWest;
        }
        return LatLonConverter.DIRECTION.None;
    }

    public LatLonConverter.FORMAT getLatLonFormat(String entry) {
        if (entry != null) {
            String delocalized = entry.replace(this.decimalSep, ".");
            GeoRefFormat[] geoRefFormatArray = GeoRefFormat.values();
            int n = geoRefFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                GeoRefFormat format = geoRefFormatArray[n2];
                if (format.matches(delocalized)) {
                    if (format.equals((Object)GeoRefFormat.D_NSEW) || format.equals((Object)GeoRefFormat.D_PLUS_MINUS)) {
                        return LatLonConverter.FORMAT.DDDDDD;
                    }
                    if (format.equals((Object)GeoRefFormat.DM_NSEW) || format.equals((Object)GeoRefFormat.DM_PLUS_MINUS)) {
                        return LatLonConverter.FORMAT.DDMMMM;
                    }
                    if (format.equals((Object)GeoRefFormat.DMS_NSEW) || format.equals((Object)GeoRefFormat.DMS_PLUS_MINUS)) {
                        return LatLonConverter.FORMAT.DDMMSS;
                    }
                }
                ++n2;
            }
        }
        return LatLonConverter.FORMAT.None;
    }

    public static void main(String[] args) throws Exception {
        Object degreesPlusMinus;
        String[] inputStrings;
        String destFormat = GeoRefFormat.DMS_PLUS_MINUS.name();
        String[] stringArray = inputStrings = new String[]{"//+/- Deg Min Sec", "0 0 0", "0 0 0.", "-32 45 16.8232", "-32d 45' 16.8232\"", "-32d45'16.8232\"", "-32\u00b045'16.8232\"", "-32\u00b0 45' 16.82\"", "-32 45 16.82", "-32 45 6.8232", "-32 45 6.82", "-32 45 0.82", "-132 45 16.82151", "-132 45 6.82", "32 45 16.8232", "32 45 16.82", "32 45 6.8232", "32 45 6.82", "32 45 0.82", "132 45 16.82151", "132 45 6.82", "//Deg Min Sec N/S/E/W", "32 45 16.8232 N", "32 45 16.82 N", "32d45'16.82\" N", "32d45'16.82\"N", "32d 45' 16.82\" N", "32\u00b0 45' 16.82\" N", "32 45 16.82 N", "32 45 6.8232 N", "32 45 6.82 N", "32 45 0.82 N", "132 45 16.82151 N", "132 45 6.82 N", "32 45 16.8232 S", "32 45 16.82 S", "32 45 6.8232 S", "32 45 6.82 S", "32 45 0.82 S", "132 45 16.82151 S", "132 45 6.82 S", "32 45 16.8232 E", "32 45 16.82 E", "32 45 6.8232 E", "32 45 6.82 E", "32 45 0.82 E", "132 45 16.82151 E", "132 45 6.82 E", "32 45 16.8232 W", "32 45 16.82 W", "32 45 6.8232 W", "32 45 6.82 W", "32 45 0.82 W", "132 45 16.82151 W", "132 45 6.82 W", "//+/- Deg Min", "0 0", "0 0.", "-32 16.8232", "-32 16.82", "-32\u00b0 16.82'", "-32\u00b016.82", "-32d 16", "-32 16.82", "-32 6.8232", "-32 6.82", "-32 0.82", "-132 16.82151", "-132 6.82", "32 16.8232", "32 16.82", "32 6.8232", "32 6.82", "32 0.82", "132 16.82151", "132 6.82", "//Deg Min N/S/E/W", "32 16.8232 N", "32 16.82 N", "32 6.8232 N", "32 6.82 N", "32 0.82 N", "132 16.82151 N", "132 6.82 N", "32 16.8232 S", "32 16.82 S", "32 6.8232 S", "32 6.82 S", "32 0.82 S", "132 16.82151 S", "132 6.82 S", "32 16.8232 E", "32 16.82 E", "32 6.8232 E", "32 6.82 E", "32 0.82 E", "132 16.82151 E", "132 6.82 E", "32 16.8232 W", "32 16.82 W", "32 6.8232 W", "32 6.82 W", "32 0.82 W", "132 16.82151 W", "132 6.82 W", "//+/- Decimal Degrees", "0", "0.", "-16.8232", "-16.8232\u00b0", "-16.82", "-6.8232", "-6.82", "-0.82", "-116.82151", "-116.82", "-1.82", "16.8232", "16.82", "6.8232", "6.82", "0.82", "116.82151", "116.82", "1.82", "//Decimal Degrees N/S/E/W", "16.8232 N", "16.82 N", "16.8232\u00b0 N", "16.82\u00b0 N", "16.8232\u00b0N", "16.82\u00b0N", "6.8232 N", "6.82 N", "0.82 N", "116.82151 N", "116.82 N", "1.82 N", "16.8232 S", "16.82 S", "6.8232 S", "6.82 S", "0.82 S", "116.82151 S", "116.82 S", "1.82 S", "16.8232 E", "16.82 E", "6.8232 E", "6.82 E", "0.82 E", "116.82151 E", "116.82 E", "1.82 E", "16.8232 W", "16.82 W", "6.8232 W", "6.82 W", "0.82 W", "116.82151 W", "116.82 W", "1.82 W", "41 43."};
        int n = inputStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String input = stringArray[n2];
            if (input.length() != 0) {
                if (input.startsWith("//")) {
                    System.out.println();
                    System.out.println("----------------------------------");
                    System.out.println("----------------------------------");
                    System.out.println(input.substring(2));
                    System.out.println("----------------------------------");
                    System.out.println("----------------------------------");
                } else {
                    System.out.println("Input:             " + input);
                    degreesPlusMinus = null;
                    GeoRefFormat[] geoRefFormatArray = GeoRefFormat.values();
                    int n3 = geoRefFormatArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GeoRefFormat format = geoRefFormatArray[n4];
                        if (input.matches(format.regex)) {
                            System.out.println("Format match:      " + format.name());
                            degreesPlusMinus = format.convertToDecimalDegrees(input);
                            break;
                        }
                        ++n4;
                    }
                    if (degreesPlusMinus == null) {
                        System.out.println("No matching format found");
                        System.out.println("----------------------------------");
                    } else {
                        int decimalFmtLen = 0;
                        int decIndex = input.lastIndexOf(46);
                        if (decIndex > -1 && input.length() > decIndex) {
                            decimalFmtLen = input.length() - decIndex;
                        }
                        String convertedVal = null;
                        if (destFormat == GeoRefFormat.DMS_PLUS_MINUS.name()) {
                            convertedVal = LatLonConverter.convertToSignedDDMMSS((BigDecimal)degreesPlusMinus, decimalFmtLen);
                        } else if (destFormat == GeoRefFormat.DM_PLUS_MINUS.name()) {
                            convertedVal = LatLonConverter.convertToSignedDDMMMM((BigDecimal)degreesPlusMinus, decimalFmtLen);
                        } else if (destFormat == GeoRefFormat.D_PLUS_MINUS.name()) {
                            convertedVal = LatLonConverter.convertToSignedDDDDDD((BigDecimal)degreesPlusMinus, decimalFmtLen);
                        }
                        System.out.println("Converted value:   " + convertedVal);
                        System.out.println("----------------------------------");
                    }
                }
            }
            ++n2;
        }
        GeoRefConverter converter = new GeoRefConverter();
        degreesPlusMinus = inputStrings;
        int n5 = inputStrings.length;
        n = 0;
        while (n < n5) {
            String input = degreesPlusMinus[n];
            if (input.length() != 0) {
                if (input.startsWith("//")) {
                    System.out.println();
                    System.out.println("----------------------------------");
                    System.out.println("----------------------------------");
                    System.out.println(input.substring(2));
                    System.out.println("----------------------------------");
                    System.out.println("----------------------------------");
                } else {
                    System.out.println("Input:             " + input);
                    String decimalDegrees = converter.convert(input, GeoRefFormat.D_PLUS_MINUS.name());
                    System.out.println("Decimal degrees:   " + decimalDegrees);
                }
            }
            ++n;
        }
        System.out.println("----------------------------------");
        System.out.println("----------------------------------");
        System.out.println("----------------------------------");
        System.out.println("----------------------------------");
        System.out.println("----------------------------------");
        System.out.println("----------------------------------");
        System.out.println("----------------------------------");
        System.out.println("----------------------------------");
        String problemString = "41 43 18.";
        System.out.println("input: " + problemString);
        String d = converter.convert(problemString, GeoRefFormat.D_PLUS_MINUS.name());
        String dm = converter.convert(problemString, GeoRefFormat.DM_PLUS_MINUS.name());
        String dms = converter.convert(problemString, GeoRefFormat.DMS_PLUS_MINUS.name());
        System.out.println(String.valueOf(d) + "   :   " + dm + "   :   " + dms);
        problemString = d;
        System.out.println("input: " + problemString);
        String d2 = converter.convert(problemString, GeoRefFormat.D_PLUS_MINUS.name());
        String dm2 = converter.convert(problemString, GeoRefFormat.DM_PLUS_MINUS.name());
        String dms2 = converter.convert(problemString, GeoRefFormat.DMS_PLUS_MINUS.name());
        System.out.println(String.valueOf(d2) + "   :   " + dm2 + "   :   " + dms2);
        problemString = dm;
        System.out.println("input: " + problemString);
        String d3 = converter.convert(problemString, GeoRefFormat.D_PLUS_MINUS.name());
        String dm3 = converter.convert(problemString, GeoRefFormat.DM_PLUS_MINUS.name());
        String dms3 = converter.convert(problemString, GeoRefFormat.DMS_PLUS_MINUS.name());
        System.out.println(String.valueOf(d3) + "   :   " + dm3 + "   :   " + dms3);
    }

    public static enum GeoRefFormat {
        D_PLUS_MINUS("[\\+\\-]?\\d{1,3}(\\.\\d{0,}\\s*)?[d\u00b0|d\ufffd|d\ufffd|d\u00b0]?"){

            @Override
            public BigDecimal convertToDecimalDegrees(String orig) {
                return LatLonConverter.convertDDDDStrToDDDDBD(orig);
            }
        }
        ,
        DM_PLUS_MINUS("[\\+\\-]?\\d{1,3}[\\sd\u00b0|\\sd\ufffd|\\sd\ufffd|\\sd|\u00b0]\\s?\\d{1,2}(\\.\\d{0,}\\s*)?'?"){

            @Override
            public BigDecimal convertToDecimalDegrees(String orig) {
                return LatLonConverter.convertDDMMMMStrToDDDDBD(orig);
            }
        }
        ,
        DMS_PLUS_MINUS("[\\+\\-]?\\d{1,3}[\\sd\u00b0|\\sd\ufffd|\\sd\ufffd|\\sd\u00b0]?\\s?\\d{1,2}[\\s']\\s?\\d{1,2}(\\.\\d{0,}\\s*)?\"?"){

            @Override
            public BigDecimal convertToDecimalDegrees(String orig) {
                return LatLonConverter.convertDDMMSSStrToDDDDBD(orig);
            }
        }
        ,
        DMS_NSEW("\\d{1,3}[\\sd\u00b0|\\sd\ufffd|\\sd\ufffd|\\sd\u00b0]\\s?\\d{1,2}[\\s']\\s?\\d{1,2}(\\.\\d{0,})?\"?\\s?[NSEW]{1}.*"){

            @Override
            public BigDecimal convertToDecimalDegrees(String orig) {
                return LatLonConverter.convertDirectionalDDMMSSToDDDD(orig);
            }
        }
        ,
        DM_NSEW("\\d{1,3}[\\sd\u00b0|\\sd\ufffd|\\sd\ufffd|\\sd\u00b0]\\s?\\d{1,2}(\\.\\d{0,})?'?\\s?[NSEW]{1}.*"){

            @Override
            public BigDecimal convertToDecimalDegrees(String orig) {
                return LatLonConverter.convertDirectionalDDMMMMToDDDD(orig);
            }
        }
        ,
        D_NSEW("\\d{1,3}(\\.\\d{0,})?[d\u00b0|d\ufffd|d\ufffd|\u00b0]?\\s?[NSEW]{1}.*"){

            @Override
            public BigDecimal convertToDecimalDegrees(String orig) {
                return LatLonConverter.convertDirectionalDDDDToDDDD(orig);
            }
        };

        public final String regex;

        private GeoRefFormat(String regex) {
            this.regex = regex;
        }

        public boolean matches(String input) {
            return input.matches(this.regex);
        }

        public abstract BigDecimal convertToDecimalDegrees(String var1);
    }
}

