/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentManagerIface;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileStoreAttachmentManager
implements AttachmentManagerIface {
    private static final Logger log = Logger.getLogger(FileStoreAttachmentManager.class);
    private static final String ORIGINAL = "originals";
    private static final String THUMBNAILS = "thumbnails";
    protected String baseDirectory;
    protected File originalsDir;
    protected File thumbsDir;
    protected Vector<String> unfilledFiles;

    public FileStoreAttachmentManager(File baseDirectory) throws IOException {
        this.setDirectory(baseDirectory);
    }

    @Override
    public boolean isInitialized(String urlStr) {
        return false;
    }

    @Override
    public void setDirectory(File baseDir) throws IOException {
        this.baseDirectory = baseDir.getAbsolutePath();
        this.originalsDir = new File(String.valueOf(this.baseDirectory) + File.separator + ORIGINAL);
        this.thumbsDir = new File(String.valueOf(this.baseDirectory) + File.separator + THUMBNAILS);
        if (!this.originalsDir.exists() && !this.originalsDir.mkdirs()) {
            log.error((Object)("setDirectory - failed to create originals[" + this.originalsDir.getAbsolutePath() + "]"));
        }
        if (!this.thumbsDir.exists() && !this.thumbsDir.mkdirs()) {
            log.error((Object)("setDirectory - failed to create thumbsDir[" + this.thumbsDir.getAbsolutePath() + "]"));
        }
        if (!this.originalsDir.canWrite()) {
            throw new IOException("Storage directory not writable: " + this.originalsDir.getAbsolutePath());
        }
        if (!this.thumbsDir.canWrite()) {
            throw new IOException("Storage directory not writable: " + this.originalsDir.getAbsolutePath());
        }
        this.unfilledFiles = new Vector();
    }

    @Override
    public File getDirectory() {
        return new File(this.baseDirectory);
    }

    @Override
    public boolean setStorageLocationIntoAttachment(Attachment attachment, boolean doDisplayErrors) {
        String errMsg;
        block8: {
            File storageFile;
            String storageFilename;
            block7: {
                String attName = attachment.getOrigFilename();
                int lastPeriod = attName.lastIndexOf(46);
                String suffix = ".att";
                if (lastPeriod != -1) {
                    suffix = ".att" + attName.substring(lastPeriod);
                }
                errMsg = null;
                storageFilename = "";
                if (this.originalsDir == null || !this.originalsDir.exists() || !this.originalsDir.canWrite()) {
                    errMsg = UIRegistry.getLocalizedMessage("ATTCH_STRG_DIR_ERR", this.originalsDir != null ? this.originalsDir.getAbsolutePath() : "(missing dir name)");
                    log.error((Object)("originalsDir doesn't exist[" + (this.originalsDir != null ? this.originalsDir.getAbsolutePath() : "null ") + "]"));
                }
                storageFile = File.createTempFile("sp6-", suffix, this.originalsDir);
                System.err.println("[" + storageFile.getAbsolutePath() + "] " + storageFile.canWrite());
                FileOutputStream fos = new FileOutputStream(storageFile);
                fos.write(1);
                fos.flush();
                fos.close();
                if (!storageFile.exists()) break block7;
                attachment.setAttachmentLocation(storageFile.getName());
                this.unfilledFiles.add(attachment.getAttachmentLocation());
                return true;
            }
            try {
                errMsg = UIRegistry.getLocalizedMessage("ATTCH_NOT_SAVED_REPOS", storageFile != null ? storageFile.getAbsolutePath() : "(missing file name)");
                log.error((Object)("storageFile doesn't exist[" + (storageFile != null ? storageFile.getAbsolutePath() : "null") + "]"));
            }
            catch (IOException e) {
                e.printStackTrace();
                if (doDisplayErrors) {
                    errMsg = UIRegistry.getLocalizedMessage("ATTCH_NOT_SAVED_REPOS", storageFilename);
                    break block8;
                }
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FileStoreAttachmentManager.class, e);
            }
        }
        if (doDisplayErrors && errMsg != null) {
            UIRegistry.showError(errMsg);
        }
        return false;
    }

    @Override
    public File getOriginal(Attachment attachment) {
        String fileLoc = attachment.getAttachmentLocation();
        if (StringUtils.isNotEmpty((String)fileLoc)) {
            File storedFile = new File(String.valueOf(this.baseDirectory) + File.separator + ORIGINAL + File.separator + fileLoc);
            if (storedFile.exists()) {
                return storedFile;
            }
        } else {
            log.error((Object)("AttachmentLocation is null for id[" + attachment.getId() + "]"));
        }
        return null;
    }

    @Override
    public File getThumbnail(Attachment attachment) {
        String fileLoc = attachment.getAttachmentLocation();
        if (StringUtils.isNotEmpty((String)fileLoc)) {
            File storedFile = new File(String.valueOf(this.baseDirectory) + File.separator + THUMBNAILS + File.separator + fileLoc);
            if (storedFile.exists()) {
                return storedFile;
            }
            try {
                return this.regenerateThumbnail(attachment);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            log.error((Object)("AttachmentLocation is null for id[" + attachment.getId() + "]"));
        }
        return null;
    }

    @Override
    public void storeAttachmentFile(Attachment attachment, File attachmentFile, File thumbnail) throws IOException {
        String attachLoc = attachment.getAttachmentLocation();
        File repositoryFile = new File(String.valueOf(this.baseDirectory) + File.separator + ORIGINAL + File.separator + attachLoc);
        FileUtils.copyFile((File)attachmentFile, (File)repositoryFile);
        if (thumbnail != null) {
            File thumbFile = new File(String.valueOf(this.baseDirectory) + File.separator + THUMBNAILS + File.separator + attachLoc);
            FileUtils.copyFile((File)thumbnail, (File)thumbFile);
        }
        this.unfilledFiles.remove(attachment.getAttachmentLocation());
    }

    @Override
    public File regenerateThumbnail(Attachment attachment) throws IOException {
        String attachLoc = attachment.getAttachmentLocation();
        File repositoryFile = null;
        File thumbFile = null;
        if (StringUtils.isNotEmpty((String)attachLoc)) {
            repositoryFile = new File(String.valueOf(this.baseDirectory) + File.separator + ORIGINAL + File.separator + attachLoc);
            thumbFile = new File(String.valueOf(this.baseDirectory) + File.separator + THUMBNAILS + File.separator + attachLoc);
        } else if (StringUtils.isNotEmpty((String)attachment.getOrigFilename())) {
            repositoryFile = new File(attachment.getOrigFilename());
            thumbFile = File.createTempFile("sp6-", ".tmp");
            thumbFile.deleteOnExit();
        } else {
            return null;
        }
        Thumbnailer thumbnailGen = AttachmentUtils.getThumbnailer();
        thumbnailGen.generateThumbnail(repositoryFile.getAbsolutePath(), thumbFile.getAbsolutePath(), false);
        return thumbFile;
    }

    @Override
    public void replaceOriginal(Attachment attachment, File newOriginal, File newThumbnail) throws IOException {
        String attachLoc = attachment.getAttachmentLocation();
        File origFile = new File(String.valueOf(this.baseDirectory) + File.separator + ORIGINAL + File.separator + attachLoc);
        File thumbFile = new File(String.valueOf(this.baseDirectory) + File.separator + THUMBNAILS + File.separator + attachLoc);
        this.replaceFile(origFile, newOriginal);
        this.replaceFile(thumbFile, newThumbnail);
    }

    protected void replaceFile(File origFile, File newFile) throws IOException {
        block2: {
            File tmpOrig = File.createTempFile("sp6-", ".tmp");
            FileUtils.copyFile((File)origFile, (File)tmpOrig);
            try {
                FileUtils.copyFile((File)newFile, (File)origFile);
            }
            catch (IOException e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FileStoreAttachmentManager.class, e);
                if (FileUtils.contentEquals((File)origFile, (File)tmpOrig)) break block2;
                FileUtils.copyFile((File)tmpOrig, (File)origFile);
            }
        }
    }

    @Override
    public void deleteAttachmentFiles(Attachment attachment) throws IOException {
        String attachLoc = attachment.getAttachmentLocation();
        if (StringUtils.isNotEmpty((String)attachLoc)) {
            File origFile = new File(String.valueOf(this.baseDirectory) + File.separator + ORIGINAL + File.separator + attachLoc);
            File thumbFile = new File(String.valueOf(this.baseDirectory) + File.separator + THUMBNAILS + File.separator + attachLoc);
            if (origFile.exists()) {
                origFile.delete();
            }
            if (thumbFile.exists()) {
                thumbFile.delete();
            }
        } else {
            log.error((Object)("The AttachmentLocation was null/empty for attachment id: " + attachment.getId()));
        }
    }

    @Override
    public void cleanup() {
        for (String unusedFile : this.unfilledFiles) {
            File f = new File(String.valueOf(this.originalsDir.getAbsolutePath()) + File.separator + unusedFile);
            f.delete();
        }
    }
}

