/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DateConverter {
    protected static final Logger log = Logger.getLogger(DateConverter.class);
    protected boolean preferMonthDay;

    public DateConverter() {
        String currentFormat = AppPreferences.getRemote().get("ui.formatting.scrdateformat", null);
        if (currentFormat.startsWith("MM") || currentFormat.startsWith("mm")) {
            this.preferMonthDay = true;
        } else if (currentFormat.startsWith("DD") || currentFormat.startsWith("dd")) {
            this.preferMonthDay = false;
        } else {
            DateFormat df = DateFormat.getDateInstance(3);
            GregorianCalendar result = new GregorianCalendar();
            result.set(2000, 3, 1);
            String dtstr = df.format(result.getTime());
            int moIdx = dtstr.indexOf("4");
            int dayIdx = dtstr.indexOf("1");
            this.preferMonthDay = moIdx < dayIdx;
        }
    }

    protected DateFormats match(String dateStr) {
        LinkedList<DateFormats> matches = new LinkedList<DateFormats>();
        DateFormats[] dateFormatsArray = DateFormats.values();
        int n = dateFormatsArray.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormats format = dateFormatsArray[n2];
            if (format.matches(dateStr)) {
                matches.add(format);
            }
            ++n2;
        }
        if (matches.size() == 0) {
            return null;
        }
        if (matches.size() == 1) {
            return (DateFormats)((Object)matches.get(0));
        }
        for (DateFormats format : matches) {
            if (this.preferMonthDay && format.equals((Object)DateFormats.MON_DAY_LYEAR) || format.equals((Object)DateFormats.MON_DAY_SYEAR)) {
                return format;
            }
            if ((this.preferMonthDay || !format.equals((Object)DateFormats.DAY_MON_LYEAR)) && !format.equals((Object)DateFormats.DAY_MON_SYEAR)) continue;
            return format;
        }
        if (matches.size() > 0) {
            log.error((Object)("Unable to resolve multiple date-format matches for '" + dateStr + "'"));
        }
        return null;
    }

    public Calendar convert(String dateStr) throws ParseException {
        if (StringUtils.isBlank((String)dateStr)) {
            return null;
        }
        DateFormats format = this.match(dateStr);
        if (format != null) {
            return format.convertToCalendar(dateStr);
        }
        throw new ParseException("unrecognized date format", 0);
    }

    public UIFieldFormatterIFace.PartialDateEnum getDatePrecision(String dateStr) throws ParseException {
        if (StringUtils.isBlank((String)dateStr)) {
            return UIFieldFormatterIFace.PartialDateEnum.None;
        }
        DateFormats format = this.match(dateStr);
        if (format != null) {
            return format.getPrecision(dateStr);
        }
        throw new ParseException("unrecognized date format", 0);
    }

    public String adjustForPrecision(String dateStr) throws ParseException {
        if (StringUtils.isBlank((String)dateStr)) {
            return dateStr;
        }
        DateFormats format = this.match(dateStr);
        if (format != null) {
            UIFieldFormatterIFace.PartialDateEnum prec = format.getPrecision(dateStr);
            return format.adjustForPrecision(dateStr, prec);
        }
        throw new ParseException("unrecognized date format", 0);
    }

    public boolean isPreferMonthDay() {
        return this.preferMonthDay;
    }

    public void setPreferMonthDay(boolean preferMonthDay) {
        this.preferMonthDay = preferMonthDay;
    }

    public static void main(String[] args) {
        DateConverter dc = new DateConverter();
        try {
            System.out.println(dc.convert("12/07/2007").getTime().toString());
            System.out.println(dc.convert("3/21/2006").getTime().toString());
            System.out.println(dc.convert("12 07 2007").getTime().toString());
            System.out.println(dc.convert("3/22/2004").getTime().toString());
            System.out.println(dc.convert("12-07-2007").getTime().toString());
            System.out.println(dc.convert("5.21.1999").getTime().toString());
            System.out.println(dc.convert("9/15/04").getTime().toString());
            System.out.println(dc.convert("11-1-07").getTime().toString());
            System.out.println(dc.convert("5.21.00").getTime().toString());
            System.out.println(dc.convert("3/12/2004").getTime().toString());
            System.out.println(dc.convert("12-07-2007").getTime().toString());
            System.out.println(dc.convert("5.42.1999").getTime().toString());
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
        }
    }

    public static enum DateFormats {
        MON_DAY_LYEAR("[0123456789]?[0123456789]([ /\\.-])[0123456789]?[0123456789]\\1[0-9][0-9][0-9][0-9]"){

            @Override
            public Calendar convertToCalendar(String dateStr) throws ParseException {
                SimpleDateFormat df;
                if (dateStr.contains("/")) {
                    df = new SimpleDateFormat("MM/dd/yyyy");
                } else if (dateStr.contains(".")) {
                    df = new SimpleDateFormat("MM.dd.yyyy");
                } else if (dateStr.contains("-")) {
                    df = new SimpleDateFormat("MM-dd-yyyy");
                } else if (dateStr.contains(" ")) {
                    df = new SimpleDateFormat("MM dd yyyy");
                } else {
                    return null;
                }
                GregorianCalendar result = new GregorianCalendar();
                result.setLenient(false);
                df.setLenient(false);
                result.setTime(df.parse(dateStr));
                return result;
            }

            @Override
            public UIFieldFormatterIFace.PartialDateEnum getPrecision(String dateStr) throws ParseException {
                boolean noDay;
                String month = dateStr.substring(0, 2);
                String day = dateStr.substring(3, 5);
                boolean noMonth = month.equals("00") || month.equals("  ");
                boolean bl = noDay = day.equals("00") || day.equals("  ");
                if (noMonth && !noDay) {
                    throw new ParseException("invalid date", 0);
                }
                if (noMonth && noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Year;
                }
                if (noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Month;
                }
                return UIFieldFormatterIFace.PartialDateEnum.Full;
            }

            @Override
            public String adjustForPrecision(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "01" + dateStr.substring(2, 3) + "01" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return String.valueOf(dateStr.substring(0, 3)) + "01" + dateStr.substring(5);
                }
                return dateStr;
            }

            @Override
            public String adjustForPrecisionOut(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "00" + dateStr.substring(2, 3) + "00" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return String.valueOf(dateStr.substring(0, 3)) + "00" + dateStr.substring(5);
                }
                return dateStr;
            }

            @Override
            public String getFormatString(String separator) {
                return "MM" + separator + "dd" + separator + "yyyy";
            }
        }
        ,
        MON_DAY_SYEAR("[0123456789]?[0123456789]([ /\\.-])[0123456789]?[0123456789]\\1[0-9][0-9]"){

            @Override
            public Calendar convertToCalendar(String dateStr) throws ParseException {
                SimpleDateFormat df;
                if (dateStr.contains("/")) {
                    df = new SimpleDateFormat("MM/dd/yy");
                } else if (dateStr.contains(".")) {
                    df = new SimpleDateFormat("MM.dd.yy");
                } else if (dateStr.contains("-")) {
                    df = new SimpleDateFormat("MM-dd-yy");
                } else if (dateStr.contains(" ")) {
                    df = new SimpleDateFormat("MM dd yy");
                } else {
                    return null;
                }
                GregorianCalendar result = new GregorianCalendar();
                result.setLenient(false);
                df.setLenient(false);
                result.setTime(df.parse(dateStr));
                return result;
            }

            @Override
            public UIFieldFormatterIFace.PartialDateEnum getPrecision(String dateStr) throws ParseException {
                boolean noDay;
                String month = dateStr.substring(0, 2);
                String day = dateStr.substring(3, 5);
                boolean noMonth = month.equals("00") || month.equals("  ");
                boolean bl = noDay = day.equals("00") || day.equals("  ");
                if (noMonth && !noDay) {
                    throw new ParseException("invalid date", 0);
                }
                if (noMonth && noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Year;
                }
                if (noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Month;
                }
                return UIFieldFormatterIFace.PartialDateEnum.Full;
            }

            @Override
            public String adjustForPrecision(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "01" + dateStr.substring(2, 3) + "01" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return String.valueOf(dateStr.substring(0, 3)) + "01" + dateStr.substring(5);
                }
                return dateStr;
            }

            @Override
            public String adjustForPrecisionOut(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "00" + dateStr.substring(2, 3) + "00" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return String.valueOf(dateStr.substring(0, 3)) + "00" + dateStr.substring(5);
                }
                return dateStr;
            }

            @Override
            public String getFormatString(String separator) {
                return "MM" + separator + "dd" + separator + "yy";
            }
        }
        ,
        DAY_MON_LYEAR("[0123456789]?[0123456789]([ /\\.-])[0123456789]?[0123456789]\\1[0-9][0-9][0-9][0-9]"){

            @Override
            public Calendar convertToCalendar(String dateStr) throws ParseException {
                SimpleDateFormat df;
                if (dateStr.contains("/")) {
                    df = new SimpleDateFormat("dd/MM/yyyy");
                } else if (dateStr.contains(".")) {
                    df = new SimpleDateFormat("dd.MM.yyyy");
                } else if (dateStr.contains("-")) {
                    df = new SimpleDateFormat("dd-MM-yyyy");
                } else if (dateStr.contains(" ")) {
                    df = new SimpleDateFormat("dd MM yyyy");
                } else {
                    return null;
                }
                GregorianCalendar result = new GregorianCalendar();
                result.setLenient(false);
                df.setLenient(false);
                result.setTime(df.parse(dateStr));
                return result;
            }

            @Override
            public UIFieldFormatterIFace.PartialDateEnum getPrecision(String dateStr) throws ParseException {
                boolean noDay;
                String month = dateStr.substring(3, 5);
                String day = dateStr.substring(0, 2);
                boolean noMonth = month.equals("00") || month.equals("  ");
                boolean bl = noDay = day.equals("00") || day.equals("  ");
                if (noMonth && !noDay) {
                    throw new ParseException("invalid date", 0);
                }
                if (noMonth && noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Year;
                }
                if (noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Month;
                }
                return UIFieldFormatterIFace.PartialDateEnum.Full;
            }

            @Override
            public String adjustForPrecision(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "01" + dateStr.substring(2, 3) + "01" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return "01" + dateStr.substring(2);
                }
                return dateStr;
            }

            @Override
            public String adjustForPrecisionOut(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "00" + dateStr.substring(2, 3) + "00" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return "00" + dateStr.substring(2);
                }
                return dateStr;
            }

            @Override
            public String getFormatString(String separator) {
                return "dd" + separator + "MM" + separator + "yyyy";
            }
        }
        ,
        DAY_MON_SYEAR("[0-9]?[0-9]([ /\\.-])[0-9]?[0-9]\\1[0-9][0-9]"){

            @Override
            public Calendar convertToCalendar(String dateStr) throws ParseException {
                SimpleDateFormat df;
                if (dateStr.contains("/")) {
                    df = new SimpleDateFormat("dd/MM/yy");
                } else if (dateStr.contains(".")) {
                    df = new SimpleDateFormat("dd.MM.yy");
                } else if (dateStr.contains("-")) {
                    df = new SimpleDateFormat("dd-MM-yy");
                } else if (dateStr.contains(" ")) {
                    df = new SimpleDateFormat("dd MM yy");
                } else {
                    return null;
                }
                GregorianCalendar result = new GregorianCalendar();
                result.setLenient(false);
                df.setLenient(false);
                result.setTime(df.parse(dateStr));
                return result;
            }

            @Override
            public UIFieldFormatterIFace.PartialDateEnum getPrecision(String dateStr) throws ParseException {
                boolean noDay;
                String month = dateStr.substring(3, 5);
                String day = dateStr.substring(0, 2);
                boolean noMonth = month.equals("00") || month.equals("  ");
                boolean bl = noDay = day.equals("00") || day.equals("  ");
                if (noMonth && !noDay) {
                    throw new ParseException("invalid date", 0);
                }
                if (noMonth && noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Year;
                }
                if (noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Month;
                }
                return UIFieldFormatterIFace.PartialDateEnum.Full;
            }

            @Override
            public String adjustForPrecision(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "01" + dateStr.substring(2, 3) + "01" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return "01" + dateStr.substring(2);
                }
                return dateStr;
            }

            @Override
            public String adjustForPrecisionOut(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "00" + dateStr.substring(2, 3) + "00" + dateStr.substring(5);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return "00" + dateStr.substring(2);
                }
                return dateStr;
            }

            @Override
            public String getFormatString(String separator) {
                return "MM" + separator + "dd" + separator + "yy";
            }
        }
        ,
        LYEAR_MON_DAY("[0-9][0-9][0-9][0-9]([ /\\.-])[0-9]?[0-9]\\1[0-9]?[0-9]"){

            @Override
            public Calendar convertToCalendar(String dateStr) throws ParseException {
                SimpleDateFormat df;
                if (dateStr.contains("/")) {
                    df = new SimpleDateFormat("yyyy/MM/dd");
                } else if (dateStr.contains(".")) {
                    df = new SimpleDateFormat("yyyy.MM.dd");
                } else if (dateStr.contains("-")) {
                    df = new SimpleDateFormat("yyyy-MM-dd");
                } else if (dateStr.contains(" ")) {
                    df = new SimpleDateFormat("yyyy MM dd");
                } else {
                    return null;
                }
                GregorianCalendar result = new GregorianCalendar();
                result.setLenient(false);
                df.setLenient(false);
                result.setTime(df.parse(dateStr));
                return result;
            }

            @Override
            public UIFieldFormatterIFace.PartialDateEnum getPrecision(String dateStr) throws ParseException {
                boolean noDay;
                String month = dateStr.substring(5, 7);
                String day = dateStr.substring(8, 10);
                boolean noMonth = month.equals("00") || month.equals("  ");
                boolean bl = noDay = day.equals("00") || day.equals("  ");
                if (noMonth && !noDay) {
                    throw new ParseException("invalid date", 0);
                }
                if (noMonth && noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Year;
                }
                if (noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Month;
                }
                return UIFieldFormatterIFace.PartialDateEnum.Full;
            }

            @Override
            public String adjustForPrecision(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return String.valueOf(dateStr.substring(0, 5)) + "01" + dateStr.substring(7, 8) + "01";
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return String.valueOf(dateStr.substring(0, 8)) + "01";
                }
                return dateStr;
            }

            @Override
            public String adjustForPrecisionOut(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return String.valueOf(dateStr.substring(0, 5)) + "00" + dateStr.substring(7, 8) + "00";
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return String.valueOf(dateStr.substring(0, 8)) + "00";
                }
                return dateStr;
            }

            @Override
            public String getFormatString(String separator) {
                return "yyyy" + separator + "MM" + separator + "dd";
            }
        }
        ,
        DAY_CMON_LYEAR("[0-9][0-9]([ /\\.-])[A-z|-][A-z|-][A-z|-]\\1[0-9][0-9][0-9][0-9]"){

            @Override
            public Calendar convertToCalendar(String dateStr) throws ParseException {
                SimpleDateFormat df;
                if (dateStr.contains("/")) {
                    df = new SimpleDateFormat("dd/MMM/yyy");
                } else if (dateStr.contains(".")) {
                    df = new SimpleDateFormat("dd.MMM.yyyy");
                } else if (dateStr.contains("-")) {
                    df = new SimpleDateFormat("dd-MMM-yyyy");
                } else if (dateStr.contains(" ")) {
                    df = new SimpleDateFormat("dd MMM yyyy");
                } else {
                    return null;
                }
                GregorianCalendar result = new GregorianCalendar();
                result.setLenient(false);
                result.setTime(df.parse(dateStr));
                return result;
            }

            @Override
            public UIFieldFormatterIFace.PartialDateEnum getPrecision(String dateStr) throws ParseException {
                boolean noDay;
                String month = dateStr.substring(3, 6);
                String day = dateStr.substring(0, 2);
                boolean noMonth = month.equals("00") || month.equals("  ") || month.equals("---");
                boolean bl = noDay = day.equals("00") || day.equals("  ");
                if (noMonth && !noDay) {
                    throw new ParseException("invalid date", 0);
                }
                if (noMonth && noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Year;
                }
                if (noDay) {
                    return UIFieldFormatterIFace.PartialDateEnum.Month;
                }
                return UIFieldFormatterIFace.PartialDateEnum.Full;
            }

            @Override
            public String adjustForPrecision(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "01" + dateStr.substring(2, 3) + "01" + dateStr.substring(6);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return "01" + dateStr.substring(2);
                }
                return dateStr;
            }

            @Override
            public String adjustForPrecisionOut(String dateStr, UIFieldFormatterIFace.PartialDateEnum prec) throws ParseException {
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                    return "00" + dateStr.substring(2, 3) + "00" + dateStr.substring(6);
                }
                if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month)) {
                    return "00" + dateStr.substring(2);
                }
                return dateStr;
            }

            @Override
            public String getFormatString(String separator) {
                return "dd" + separator + "MMM" + separator + "yyyy";
            }
        };

        public final String regex;

        private DateFormats(String regex) {
            this.regex = regex;
        }

        public boolean matches(String input) {
            return input.matches(this.regex);
        }

        public abstract Calendar convertToCalendar(String var1) throws ParseException;

        public abstract UIFieldFormatterIFace.PartialDateEnum getPrecision(String var1) throws ParseException;

        public abstract String adjustForPrecision(String var1, UIFieldFormatterIFace.PartialDateEnum var2) throws ParseException;

        public abstract String adjustForPrecisionOut(String var1, UIFieldFormatterIFace.PartialDateEnum var2) throws ParseException;

        public abstract String getFormatString(String var1);
    }
}

