/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.util.DataCacheIFace;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CacheManager {
    private static final Logger log = Logger.getLogger(CacheManager.class);
    protected Vector<DataCacheIFace> registeredCaches = new Vector();

    public void registerCache(DataCacheIFace cache) {
        this.registeredCaches.add(cache);
    }

    public void unregisterCache(DataCacheIFace cache) {
        this.registeredCaches.remove(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Vector<DataCacheIFace> vector = this.registeredCaches;
        synchronized (vector) {
            for (DataCacheIFace cache : this.registeredCaches) {
                try {
                    cache.shutdown();
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(CacheManager.class, e);
                    log.error((Object)"Error shutting down registered cache", (Throwable)e);
                }
            }
        }
        this.registeredCaches.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Vector<DataCacheIFace> vector = this.registeredCaches;
        synchronized (vector) {
            for (DataCacheIFace cache : this.registeredCaches) {
                cache.clear();
            }
        }
    }
}

