/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.util;

import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentManagerIface;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class AttachmentUtils {
    private static final Logger log = Logger.getLogger(AttachmentUtils.class);
    private static AttachmentManagerIface attachMgr;
    private static Thumbnailer thumbnailer;
    private static boolean isConfigForPath;

    static {
        isConfigForPath = true;
    }

    public static AttachmentManagerIface getAttachmentManager() {
        return attachMgr;
    }

    public static void setAttachmentManager(AttachmentManagerIface mgr) {
        attachMgr = mgr;
    }

    public static void setThumbnailer(Thumbnailer thumber) {
        thumbnailer = thumber;
    }

    public static boolean isAvailable() {
        return attachMgr != null;
    }

    public static Thumbnailer getThumbnailer() {
        return thumbnailer;
    }

    public static boolean isConfigForPath() {
        return isConfigForPath;
    }

    public static void setConfigForPath(boolean isConfigForPath) {
        AttachmentUtils.isConfigForPath = isConfigForPath;
    }

    protected static boolean isAttachLocOK() {
        if (attachMgr != null) {
            return true;
        }
        UIRegistry.showLocalizedError("AttachmentUtils.NOT_AVAIL");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAttachmentDirMounted(File attachmentLocation) {
        String statsMsg;
        String fullPath;
        block6: {
            fullPath = "";
            statsMsg = "The test to write to the AttachmentLocation [%s] %s.";
            try {
                fullPath = attachmentLocation.getCanonicalPath();
                if (attachmentLocation.exists()) {
                    if (attachmentLocation.isDirectory()) {
                        File tmpFile = new File(attachmentLocation.getAbsoluteFile() + File.separator + System.currentTimeMillis() + System.getProperty("user.name"));
                        if (tmpFile.createNewFile()) {
                            FileOutputStream fos = FileUtils.openOutputStream((File)tmpFile);
                            fos.write(1);
                            fos.close();
                            tmpFile.delete();
                            return true;
                        }
                        log.error((Object)String.format("The Attachment Location [%s] atachment file couldn't be created", fullPath));
                        break block6;
                    } else {
                        log.error((Object)String.format("The Attachment Location [%s] is not a directory.", fullPath));
                    }
                    break block6;
                }
                log.error((Object)String.format("The Attachment Location [%s] doesn't exist.", fullPath));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        log.debug((Object)String.format(statsMsg, fullPath, "failed"));
        return false;
    }

    public static ActionListener getAttachmentDisplayer() {
        ActionListener displayer = new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (!(source instanceof Attachment) && !(source instanceof ObjectAttachmentIFace)) {
                    throw new IllegalArgumentException("Passed object must be an Attachment or ObjectAttachmentIFace");
                }
                Attachment attachment = source instanceof Attachment ? (Attachment)source : ((ObjectAttachmentIFace)source).getAttachment();
                File original = null;
                if (attachment.getId() != null) {
                    if (!AttachmentUtils.isAttachLocOK()) return;
                    original = attachMgr.getOriginal(attachment);
                } else {
                    String origFile = attachment.getOrigFilename();
                    original = new File(origFile);
                }
                String errMsg = null;
                if (original != null && original.exists()) {
                    try {
                        Desktop.getDesktop().open(original);
                    }
                    catch (IOException ex) {
                        errMsg = ex.getMessage();
                        ex.printStackTrace();
                    }
                } else {
                    String string = errMsg = attachMgr.getDirectory() != null ? attachMgr.getDirectory().getAbsolutePath() : "N/A";
                }
                if (errMsg == null) return;
                UIRegistry.showLocalizedMsg("AttachmentUtils.ANF_TITLE", "AttachmentUtils.ANF", errMsg);
            }
        };
        return displayer;
    }

    public static String getMimeType(String filename) {
        if (filename == null) {
            return null;
        }
        MimetypesFileTypeMap mimeMap = (MimetypesFileTypeMap)FileTypeMap.getDefaultFileTypeMap();
        mimeMap.addMimeTypes("image/tif    tif");
        mimeMap.addMimeTypes("image/tif    TIF");
        mimeMap.addMimeTypes("image/png    png");
        mimeMap.addMimeTypes("image/png    PNG");
        mimeMap.addMimeTypes("application/vnd.google-earth.kml+xml kml");
        return mimeMap.getContentType(filename);
    }

    public static void openFile(File f) throws Exception {
        Desktop.getDesktop().open(f);
    }

    public static void openURI(URI uri) throws Exception {
        Desktop.getDesktop().browse(uri);
    }

    public static void main(String[] args) {
        String[] filenames;
        String[] stringArray = new String[8];
        stringArray[0] = "hello.txt";
        stringArray[1] = "a.bmp";
        stringArray[2] = "b.pdf";
        stringArray[3] = "hello.gif";
        stringArray[4] = "blha.tiff";
        stringArray[5] = "c.jpg";
        stringArray[7] = "blah.kml";
        String[] stringArray2 = filenames = stringArray;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray2[n2];
            System.out.println(AttachmentUtils.getMimeType(name));
            ++n2;
        }
    }
}

