/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.tmanfe;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.SearchableJXTable;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.tmanfe.SearchReplacePanel;
import edu.ku.brc.ui.tmanfe.SpreadSheetModel;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpreadSheet
extends SearchableJXTable
implements ActionListener {
    protected static final Logger log = Logger.getLogger(SpreadSheet.class);
    public static final boolean DEBUG = true;
    protected SpreadSheetModel model;
    protected JScrollPane scrollPane;
    protected JPopupMenu popupMenu;
    protected Action deleteAction = null;
    protected boolean useRowScrolling = false;
    protected int rowLabelWidth = 0;
    protected JPanel rowHeaderPanel;
    protected RHCellMouseAdapter rhCellMouseAdapter;
    protected Border cellBorder = null;
    protected Font cellFont;
    protected boolean mouseDown = false;
    private boolean rowSelectionStarted = false;
    private Pair<Integer, Integer> emphasizedCell = null;
    protected SearchReplacePanel findPanel = null;
    protected CellRenderer customCellRenderer = new CellRenderer();
    protected int[] pastedRows = new int[]{-1, -1};
    protected int prevRowSelInx = -1;
    protected int prevColSelInx = -1;
    protected boolean isReadOnly = false;

    public SpreadSheet(SpreadSheetModel model) {
        super(model);
        this.model = model;
        this.buildSpreadsheet();
    }

    public SearchReplacePanel getFindReplacePanel() {
        log.debug((Object)"Getting mySearchPanel");
        if (this.findPanel == null) {
            this.findPanel = this.createSearchReplacePanel();
        }
        return this.findPanel;
    }

    protected SearchReplacePanel createSearchReplacePanel() {
        return new SearchReplacePanel(this);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.clearEmphasis();
    }

    public void clearSelection() {
        super.clearSelection();
        this.clearEmphasis();
    }

    protected void clearEmphasis() {
        Pair<Integer, Integer> ec = this.emphasizedCell;
        this.setEmphasizedCell(null);
        if (ec != null) {
            this.getModel().fireTableCellUpdated(ec.getFirst(), ec.getSecond());
        }
    }

    protected void buildSpreadsheet() {
        this.setShowGrid(true);
        int numRows = this.model.getRowCount();
        this.scrollPane = new JScrollPane((Component)((Object)this), 20, 30);
        this.setAutoResizeMode(0);
        final SpreadSheet ss = this;
        JButton cornerBtn = UIHelper.createIconBtn("Blank", IconManager.IconSize.Std16, "SelectAll", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ss.selectAll();
            }
        });
        cornerBtn.setEnabled(true);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", cornerBtn);
        this.setCellSelectionEnabled(true);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SpreadSheet.this.prevRowSelInx = SpreadSheet.this.getSelectedRow();
                SpreadSheet.this.prevColSelInx = SpreadSheet.this.getSelectedColumn();
                if (e.getClickCount() == 2) {
                    int rowIndexStart = SpreadSheet.this.getSelectedRow();
                    int colIndexStart = SpreadSheet.this.getSelectedColumn();
                    ss.editCellAt(rowIndexStart, colIndexStart);
                    if (ss.getEditorComponent() != null && ss.getEditorComponent() instanceof JTextComponent) {
                        ss.getEditorComponent().requestFocus();
                        final JTextComponent txtComp = (JTextComponent)ss.getEditorComponent();
                        String txt = txtComp.getText();
                        FontMetrics fm = txtComp.getFontMetrics(txtComp.getFont());
                        int x = e.getPoint().x - ss.getEditorComponent().getBounds().x - 1;
                        int prevWidth = 0;
                        int i = 0;
                        while (i < txt.length()) {
                            int width = fm.stringWidth(txt.substring(0, i));
                            int basePlusHalf = prevWidth + (int)((double)((width - prevWidth) / 2) + 0.5);
                            if (x < width) {
                                final int inx = i + (x <= basePlusHalf ? -1 : 0);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        txtComp.setSelectionStart(0);
                                        txtComp.setSelectionEnd(0);
                                        txtComp.setCaretPosition(inx > 0 ? inx : 0);
                                    }
                                });
                                break;
                            }
                            prevWidth = width;
                            ++i;
                        }
                    }
                }
            }
        });
        this.getModel().fireTableStructureChanged();
        this.rowHeaderPanel = new JPanel(null);
        if (this.getColumnModel().getColumnCount() > 0) {
            TableColumn column = this.getColumnModel().getColumn(0);
            TableCellRenderer renderer = this.getTableHeader().getDefaultRenderer();
            if (renderer == null) {
                renderer = column.getHeaderRenderer();
            }
            Component cellRenderComp = renderer.getTableCellRendererComponent((JTable)((Object)this), column.getHeaderValue(), false, false, -1, 0);
            this.cellFont = cellRenderComp.getFont();
        } else {
            this.cellFont = new JLabel().getFont();
        }
        this.cellBorder = (Border)UIManager.getDefaults().get("TableHeader.cellBorder");
        Insets insets = this.cellBorder.getBorderInsets(this.tableHeader);
        FontMetrics metrics = this.getFontMetrics(this.cellFont);
        this.rowHeight = insets.bottom + metrics.getHeight() + insets.top;
        this.rowLabelWidth = metrics.stringWidth("9999") + insets.right + insets.left;
        Dimension dim = new Dimension(this.rowLabelWidth, this.rowHeight * numRows);
        this.rowHeaderPanel.setPreferredSize(dim);
        this.rhCellMouseAdapter = new RHCellMouseAdapter((JTable)((Object)this));
        int ii = 0;
        while (ii < numRows) {
            this.addRow(ii, ii + 1, false);
            ++ii;
        }
        JViewport viewPort = new JViewport();
        dim.height = this.rowHeight * numRows;
        viewPort.setViewSize(dim);
        viewPort.setView(this.rowHeaderPanel);
        this.scrollPane.setRowHeader(viewPort);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(ss.isEditing() || e.isActionKey() || e.isControlDown() || e.isMetaDown() || e.isAltDown() || e.getKeyCode() == 16 || e.getKeyCode() == 9 || e.getKeyCode() == 10)) {
                    log.error((Object)"Grabbed the event as input");
                    int rowIndexStart = SpreadSheet.this.getSelectedRow();
                    int colIndexStart = SpreadSheet.this.getSelectedColumn();
                    if (rowIndexStart == -1 || colIndexStart == -1) {
                        return;
                    }
                    ss.editCellAt(rowIndexStart, colIndexStart);
                    Component c = ss.getEditorComponent();
                    if (c instanceof JTextComponent) {
                        ((JTextComponent)c).setText("");
                    }
                }
            }
        });
        this.resizeAndRepaint();
        KeyStroke cut = KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        KeyStroke copy = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        AbstractAction ssAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet.this.actionPerformed(e);
            }
        };
        this.getInputMap().put(cut, "Cut");
        this.getActionMap().put("Cut", ssAction);
        this.getInputMap().put(copy, "Copy");
        this.getActionMap().put("Copy", ssAction);
        this.getInputMap().put(paste, "Paste");
        this.getActionMap().put("Paste", ssAction);
        ((JMenuItem)UIRegistry.get("Copy")).addActionListener(this);
        ((JMenuItem)UIRegistry.get("Cut")).addActionListener(this);
        ((JMenuItem)UIRegistry.get("Paste")).addActionListener(this);
        this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
    }

    protected void addRow(int rowInx, int rowNum, boolean adjustPanelSize) {
        RowHeaderLabel lbl = new RowHeaderLabel(rowNum, this.cellFont);
        lbl.setBounds(0, rowInx * this.rowHeight, this.rowLabelWidth, this.rowHeight);
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            lbl.setBorder(this.cellBorder);
        }
        lbl.addMouseListener(this.rhCellMouseAdapter);
        this.rowHeaderPanel.add(lbl);
        if (adjustPanelSize) {
            Dimension dim = new Dimension(this.rowLabelWidth, this.rowHeight * (rowInx + 1));
            this.rowHeaderPanel.setPreferredSize(dim);
            this.rowHeaderPanel.setSize(dim);
            this.resizeAndRepaint();
        }
    }

    public void addRow() {
        this.addRow(this.getModel().getRowCount() - 1, this.getModel().getRowCount(), true);
    }

    public void setDeleteAction(Action deleteAction) {
        this.deleteAction = deleteAction;
    }

    public void removeRow(int rowInx, boolean doSelection) {
        int rowCount = this.getModel().getRowCount();
        Component comp = this.rowHeaderPanel.getComponent(rowCount);
        this.rowHeaderPanel.remove(comp);
        Dimension dim = new Dimension(this.rowLabelWidth, this.rowHeight * rowCount);
        this.rowHeaderPanel.setPreferredSize(dim);
        this.rowHeaderPanel.setSize(dim);
        this.rowHeaderPanel.validate();
        this.resizeAndRepaint();
        if (doSelection && rowCount > 0) {
            if (rowInx >= rowCount) {
                this.setRowSelectionInterval(rowCount - 1, rowCount - 1);
            } else {
                this.setRowSelectionInterval(rowInx, rowInx);
            }
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
    }

    public void scrollToRow(int row) {
        Rectangle r = this.getCellRect(row, 0, true);
        this.scrollRectToVisible(r);
    }

    public int[] getSelectedRowModelIndexes() {
        int[] selected = this.getSelectedRows();
        int j = 0;
        while (j < selected.length) {
            int modelIndex;
            selected[j] = modelIndex = this.convertRowIndexToModel(selected[j]);
            ++j;
        }
        return selected;
    }

    public int[] getSelectedColumnModelIndexes() {
        int[] selected = this.getSelectedColumns();
        int j = 0;
        while (j < selected.length) {
            int modelIndex;
            selected[j] = modelIndex = this.convertColumnIndexToModel(selected[j]);
            ++j;
        }
        return selected;
    }

    public boolean editCellAt(int row, int column, EventObject ev) {
        return this.mouseDown ? false : (this.isReadOnly ? false : super.editCellAt(row, column, ev));
    }

    public void editingStopped(ChangeEvent ev) {
        super.editingStopped(ev);
    }

    public void editingCanceled(ChangeEvent ev) {
        super.editingCanceled(ev);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    protected JPopupMenu createMenuForSelection(Point pnt) {
        JMenuItem mi;
        JMenuItem mi2;
        int[] rows;
        Class<?> cellClass = this.getModel().getColumnClass(this.convertColumnIndexToModel(this.columnAtPoint(pnt)));
        boolean isImage = cellClass == ImageIcon.class || cellClass == Image.class;
        JPopupMenu pMenu = new JPopupMenu();
        UsageTracker.incrUsageCount("WB.SpreadsheetContextMenu");
        if (this.getSelectedColumnCount() == 1 && (rows = this.getSelectedRowModelIndexes()).length > 1) {
            if (!isImage) {
                mi2 = pMenu.add(new JMenuItem(UIRegistry.getResourceString("SpreadSheet.FillDown")));
                mi2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int selectedUICol = SpreadSheet.this.getSelectedColumn();
                        int selectedModelCol = SpreadSheet.this.convertColumnIndexToModel(selectedUICol);
                        SpreadSheet.this.model.fill(selectedModelCol, rows[0], rows);
                        SpreadSheet.this.popupMenu.setVisible(false);
                    }
                });
            }
            if (!isImage) {
                mi2 = pMenu.add(new JMenuItem(UIRegistry.getResourceString("Spreadsheet.FillUp")));
                mi2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int selectedUICol = SpreadSheet.this.getSelectedColumn();
                        int selectedModelCol = SpreadSheet.this.convertColumnIndexToModel(selectedUICol);
                        SpreadSheet.this.model.fill(selectedModelCol, rows[rows.length - 1], rows);
                        SpreadSheet.this.popupMenu.setVisible(false);
                    }
                });
            }
        }
        if (!isImage) {
            mi = pMenu.add(new JMenuItem(UIRegistry.getResourceString("SpreadSheet.ClearCells")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int[] rows = SpreadSheet.this.getSelectedRowModelIndexes();
                    int[] cols = SpreadSheet.this.getSelectedColumnModelIndexes();
                    SpreadSheet.this.model.clearCells(rows, cols);
                    SpreadSheet.this.popupMenu.setVisible(false);
                }
            });
        }
        if (this.deleteAction != null) {
            mi = pMenu.add(new JMenuItem(UIRegistry.getResourceString("SpreadSheet.DeleteRows")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SpreadSheet.this.deleteAction.actionPerformed(ae);
                    SpreadSheet.this.popupMenu.setVisible(false);
                }
            });
        }
        if (!isImage) {
            boolean isSelection;
            boolean bl = isSelection = this.getSelectedColumnCount() > 0 && this.getSelectedRowCount() > 0;
            if (pMenu.getComponentCount() > 0) {
                pMenu.add(new JPopupMenu.Separator());
            }
            mi2 = pMenu.add(new JMenuItem(UIRegistry.getResourceString("CutMenu")));
            mi2.setEnabled(isSelection && !isImage);
            mi2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpreadSheet.this.cutOrCopy(true);
                        }
                    });
                }
            });
            mi2 = pMenu.add(new JMenuItem(UIRegistry.getResourceString("CopyMenu")));
            mi2.setEnabled(isSelection && !isImage);
            mi2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpreadSheet.this.cutOrCopy(false);
                        }
                    });
                }
            });
            mi2 = pMenu.add(new JMenuItem(UIRegistry.getResourceString("PasteMenu")));
            mi2.setEnabled(isSelection && !isImage && this.canPasteFromClipboard());
            mi2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpreadSheet.this.paste();
                        }
                    });
                }
            });
        }
        pMenu.setInvoker((Component)((Object)this));
        return pMenu;
    }

    public void processMouseEvent(MouseEvent ev) {
        int type = ev.getID();
        boolean bl = this.mouseDown = type == 501;
        if (this.mouseDown && UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX) {
            int rowIndexStart = this.rowAtPoint(ev.getPoint());
            int colIndexStart = this.columnAtPoint(ev.getPoint());
            if (this.isEditing() && (this.prevRowSelInx != rowIndexStart || this.prevColSelInx != colIndexStart)) {
                this.getCellEditor().stopCellEditing();
            }
        }
        if (ev.isPopupTrigger()) {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            boolean isOnSelectedCell = false;
            int rowIndexStart = this.rowAtPoint(ev.getPoint());
            int colIndexStart = this.columnAtPoint(ev.getPoint());
            if (this.getSelectedRowCount() > 0) {
                int[] cols = this.getSelectedColumns();
                int[] nArray = this.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int r = nArray[n2];
                    if (r == rowIndexStart) {
                        int[] nArray2 = cols;
                        int n3 = cols.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int c = nArray2[n4];
                            if (c == colIndexStart) {
                                isOnSelectedCell = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            if (!isOnSelectedCell) {
                this.setRowSelectionInterval(rowIndexStart, rowIndexStart);
                this.setColumnSelectionInterval(colIndexStart, colIndexStart);
            }
            if (this.popupMenu != null) {
                this.popupMenu.setVisible(false);
            }
            this.popupMenu = this.createMenuForSelection(ev.getPoint());
            if (this.popupMenu.isVisible()) {
                this.popupMenu.setVisible(false);
            } else {
                Point p = this.getLocationOnScreen();
                this.popupMenu.setLocation(p.x + ev.getX() + 1, p.y + ev.getY() + 1);
                this.popupMenu.setVisible(true);
            }
        }
        super.processMouseEvent(ev);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 157) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected boolean canCutOrCopy() {
        int numcols = this.getSelectedColumnCount();
        int numrows = this.getSelectedRowCount();
        int[] rowsselected = this.getSelectedRows();
        int[] colsselected = this.getSelectedColumns();
        return numcols != 0 && numrows != 0 && numrows - 1 == rowsselected[rowsselected.length - 1] - rowsselected[0] && numrows == rowsselected.length && numcols - 1 == colsselected[colsselected.length - 1] - colsselected[0] && numcols == colsselected.length;
    }

    public void cutOrCopy(boolean isCut) {
        if (!this.canCutOrCopy()) {
            return;
        }
        StringBuffer sbf = new StringBuffer();
        int numcols = this.getSelectedColumnCount();
        int numrows = this.getSelectedRowCount();
        int[] rowsselected = this.getSelectedRows();
        int[] colsselected = this.getSelectedColumns();
        int i = 0;
        while (i < numrows) {
            int j = 0;
            while (j < numcols) {
                sbf.append(this.getValueAt(rowsselected[i], colsselected[j]));
                if (j < numcols - 1) {
                    sbf.append("\t");
                }
                if (isCut) {
                    this.setValueAt("", rowsselected[i], colsselected[j]);
                }
                ++j;
            }
            if (numrows > 1) {
                sbf.append("\n");
            }
            ++i;
        }
        UIHelper.setTextToClipboard(sbf.toString());
    }

    protected boolean canPasteFromClipboard() {
        Clipboard sysClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        return sysClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
    }

    public void paste() {
        int[] rows = this.getSelectedRows();
        int[] cols = this.getSelectedColumns();
        this.pastedRows[0] = -1;
        this.pastedRows[1] = -1;
        if (rows != null && cols != null && rows.length > 0 && cols.length > 0) {
            int startRow;
            this.pastedRows[0] = startRow = rows[0];
            int startCol = cols[0];
            try {
                Clipboard sysClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (sysClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    String trstring = (String)sysClipboard.getData(DataFlavor.stringFlavor);
                    StringTokenizer st1 = new StringTokenizer(trstring, "\n\r");
                    int i = 0;
                    while (st1.hasMoreTokens()) {
                        String rowstring = st1.nextToken();
                        String[] tokens = StringUtils.splitPreserveAllTokens((String)rowstring, (char)'\t');
                        int j = 0;
                        while (j < tokens.length) {
                            if (startRow + i < this.getRowCount() && startCol + j < this.getColumnCount()) {
                                int colInx = startCol + j;
                                if (tokens[j].length() <= this.model.getColDataLen(colInx)) {
                                    this.setValueAt(tokens[j], startRow + i, colInx);
                                } else {
                                    String msg = String.format(UIRegistry.getResourceString("UI_NEWDATA_TOO_LONG"), this.model.getColumnName(startCol + j), this.model.getColDataLen(colInx));
                                    UIRegistry.getStatusBar().setErrorMessage(msg);
                                    Toolkit.getDefaultToolkit().beep();
                                }
                            }
                            ++j;
                        }
                        this.pastedRows[1] = this.pastedRows[1] + 1;
                        ++i;
                    }
                }
            }
            catch (IllegalStateException ex) {
                UIRegistry.displayStatusBarErrMsg(UIRegistry.getResourceString("Spreadsheet.ClipboardUnavailable"));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpreadSheet.class, ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isCut;
        if (UIRegistry.getPermanentFocusOwner() != this) {
            return;
        }
        boolean bl = isCut = e.getActionCommand().compareTo("Cut") == 0 || e.getActionCommand().equals("x");
        if (e.getActionCommand().compareTo("Copy") == 0 || e.getActionCommand().equals("c") || isCut) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpreadSheet.this.cutOrCopy(isCut);
                }
            });
        } else if (e.getActionCommand().compareTo("Paste") == 0 || e.getActionCommand().equals("v")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpreadSheet.this.paste();
                }
            });
        }
    }

    public void setVisible(boolean flag) {
        this.scrollPane.setVisible(flag);
    }

    public int getMaxUnitIncrement() {
        if (this.getModel() == null) {
            return 0;
        }
        int cols = this.getModel().getColumnCount();
        if (cols > 0) {
            --cols;
        }
        double unit = this.getPreferredSize().width / cols;
        return (int)unit;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.useRowScrolling) {
            if (orientation == 0) {
                return visibleRect.width - this.getMaxUnitIncrement();
            }
            return visibleRect.height - this.getMaxUnitIncrement();
        }
        return super.getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.useRowScrolling ? false : super.getScrollableTracksViewportHeight();
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.useRowScrolling ? false : super.getScrollableTracksViewportWidth();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.useRowScrolling) {
            int currentPosition = 0;
            currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
            if (direction < 0) {
                int newPosition = currentPosition - currentPosition / this.getMaxUnitIncrement() * this.getMaxUnitIncrement();
                return newPosition == 0 ? this.getMaxUnitIncrement() : newPosition;
            }
            return (currentPosition / this.getMaxUnitIncrement() + 1) * this.getMaxUnitIncrement() - currentPosition;
        }
        return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public void setEmphasizedCell(int row, int column) {
        if (this.emphasizedCell == null) {
            this.emphasizedCell = new Pair<Integer, Integer>(row, column);
        } else {
            this.emphasizedCell.setFirst(row);
            this.emphasizedCell.setSecond(column);
        }
    }

    public void setEmphasizedCell(Pair<Integer, Integer> cell) {
        this.emphasizedCell = cell;
    }

    public boolean isEmphasizedCell(int row, int column) {
        return this.emphasizedCell == null ? false : this.emphasizedCell.getFirst().equals(row) && this.emphasizedCell.getSecond().equals(column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.isEmphasizedCell(row, column)) {
            return this.customCellRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public SpreadSheetModel getModel() {
        return (SpreadSheetModel)super.getModel();
    }

    public void cleanUp() {
        UIHelper.removeMouseListeners((Component)((Object)this));
        ((JMenuItem)UIRegistry.get("Copy")).removeActionListener(this);
        ((JMenuItem)UIRegistry.get("Cut")).removeActionListener(this);
        ((JMenuItem)UIRegistry.get("Paste")).removeActionListener(this);
        if (this.findPanel != null) {
            this.findPanel.cleanUp();
            this.findPanel = null;
        }
        if (this.scrollPane != null) {
            this.scrollPane.removeAll();
            this.scrollPane.setRowHeader(null);
        }
        if (this.rowHeaderPanel != null) {
            this.rowHeaderPanel.removeAll();
            this.rowHeaderPanel = null;
        }
        if (this.model != null) {
            this.model.cleanUp();
        }
        this.scrollPane = null;
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
            this.popupMenu = null;
        }
        if (this.rhCellMouseAdapter != null) {
            this.rhCellMouseAdapter.cleanUp();
            this.rhCellMouseAdapter = null;
        }
    }

    public class CellRenderer
    extends JLabel
    implements TableCellRenderer {
        private Border _selectBorder;
        private EmptyBorder _emptyBorder = new EmptyBorder(2, 2, 2, 2);
        private Border _emphasizedBorder;

        public CellRenderer() {
            this._selectBorder = new LineBorder(Color.BLUE);
            this._emphasizedBorder = new LineBorder(Color.BLUE);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean isEmphasized = SpreadSheet.this.emphasizedCell == null ? false : ((Integer)SpreadSheet.this.emphasizedCell.getFirst()).equals(row) && ((Integer)SpreadSheet.this.emphasizedCell.getSecond()).equals(column);
            Border border = null;
            if (isEmphasized) {
                border = this._emphasizedBorder;
                log.info((Object)("Emphasized Cell: " + SpreadSheet.this.emphasizedCell.getFirst() + ", " + SpreadSheet.this.emphasizedCell.getSecond()));
            } else {
                border = isSelected ? this._selectBorder : this._emptyBorder;
            }
            this.setBorder(border);
            this.setText(value.toString());
            return this;
        }
    }

    class RHCellMouseAdapter
    extends MouseAdapter {
        protected JTable table;
        protected Hashtable<Integer, Boolean> selectionHash = new Hashtable();
        protected Hashtable<Integer, Boolean> doubleSelected = new Hashtable();
        protected int selAnchor = -1;
        protected int selLead = -1;
        protected boolean ctrlWasDown = false;
        protected boolean dragIsDeselecting = false;

        public RHCellMouseAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            log.debug((Object)"mousePressed entered");
            log.debug((Object)("anchor: " + this.selAnchor));
            log.debug((Object)("lead   :" + this.selLead));
            if (SpreadSheet.this.isEditing()) {
                SpreadSheet.this.getCellEditor().stopCellEditing();
            }
            RowHeaderLabel lbl = (RowHeaderLabel)e.getSource();
            int row = lbl.getRowNum() - 1;
            boolean ctrlDown = false;
            ctrlDown = UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX ? e.isMetaDown() : e.isControlDown();
            if (ctrlDown) {
                ListSelectionModel selModel = this.table.getSelectionModel();
                boolean wasSelected = this.table.getSelectionModel().isSelectedIndex(row);
                if (wasSelected) {
                    selModel.removeSelectionInterval(row, row);
                    this.dragIsDeselecting = true;
                } else {
                    selModel.addSelectionInterval(row, row);
                    this.dragIsDeselecting = false;
                }
                this.selAnchor = row;
                this.selLead = row;
                this.ctrlWasDown = true;
            } else if (e.isShiftDown()) {
                ListSelectionModel selModel = this.table.getSelectionModel();
                selModel.removeSelectionInterval(this.selAnchor, this.selLead);
                selModel.addSelectionInterval(this.selAnchor, row);
                this.selLead = row;
            } else {
                this.table.setRowSelectionInterval(row, row);
                this.table.setColumnSelectionInterval(0, this.table.getColumnCount() - 1);
                this.selAnchor = this.selLead = row;
                SpreadSheet.this.prevRowSelInx = SpreadSheet.this.getSelectedRow();
                SpreadSheet.this.prevColSelInx = 0;
            }
            SpreadSheet.this.rowSelectionStarted = true;
            this.table.getSelectionModel().setValueIsAdjusting(true);
            log.debug((Object)("anchor: " + this.selAnchor));
            log.debug((Object)("lead   :" + this.selLead));
            log.debug((Object)"mousePressed exited");
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            log.debug((Object)"mouseReleased entered");
            log.debug((Object)("anchor: " + this.selAnchor));
            log.debug((Object)("lead   :" + this.selLead));
            SpreadSheet.this.rowSelectionStarted = false;
            this.table.getSelectionModel().setValueIsAdjusting(false);
            this.ctrlWasDown = false;
            this.dragIsDeselecting = false;
            log.debug((Object)("anchor: " + this.selAnchor));
            log.debug((Object)("lead   :" + this.selLead));
            log.debug((Object)"mouseReleased exited");
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SpreadSheet.this.rowSelectionStarted) {
                int row;
                log.debug((Object)"mouseEntered entered");
                log.debug((Object)("anchor: " + this.selAnchor));
                log.debug((Object)("lead   :" + this.selLead));
                RowHeaderLabel lbl = (RowHeaderLabel)e.getSource();
                this.selLead = row = lbl.getRowNum() - 1;
                if (this.ctrlWasDown) {
                    if (this.dragIsDeselecting) {
                        this.table.removeRowSelectionInterval(this.selAnchor, row);
                    } else {
                        this.table.addRowSelectionInterval(this.selAnchor, row);
                    }
                } else {
                    this.table.setRowSelectionInterval(this.selAnchor, row);
                }
                this.table.setColumnSelectionInterval(0, this.table.getColumnCount() - 1);
                log.debug((Object)("anchor: " + this.selAnchor));
                log.debug((Object)("lead   :" + this.selLead));
                log.debug((Object)"mouseEntered exited");
            }
        }

        public void cleanUp() {
            this.table = null;
        }
    }

    class RowHeaderLabel
    extends JComponent {
        protected String rowNumStr;
        protected int rowNum;
        protected Font font;
        protected int labelWidth = Integer.MAX_VALUE;
        protected int labelheight = Integer.MAX_VALUE;

        public RowHeaderLabel(int rowNum, Font font) {
            this.rowNum = rowNum;
            this.rowNumStr = Integer.toString(rowNum);
            this.font = font;
        }

        public int getRowNum() {
            return this.rowNum;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setFont(this.font);
            if (this.labelWidth == Integer.MAX_VALUE) {
                FontMetrics fm = this.getFontMetrics(this.font);
                this.labelheight = fm.getAscent();
                this.labelWidth = fm.stringWidth(this.rowNumStr);
            }
            Insets ins = this.getInsets();
            Dimension size = this.getSize();
            int y = size.height - (size.height - this.labelheight) / 2 - ins.bottom;
            g.drawString(this.rowNumStr, (size.width - this.labelWidth) / 2, y);
        }
    }
}

