/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.tmanfe;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.TableSearcher;
import edu.ku.brc.ui.TableSearcherCell;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.tmanfe.SpreadSheet;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SearchReplacePanel
extends JPanel {
    private final String FIND = "Find";
    protected SpreadSheet table;
    protected boolean isSearchDown = true;
    private boolean isFinishedSearchingDown = false;
    private boolean isFinishedSearchingUp = true;
    private boolean searchSelection = false;
    private TableSearcherCell foundCell = null;
    private JLabel findLabel;
    private JButton cancelButton;
    protected JButton nextButton;
    protected JButton previousButton;
    protected JButton replaceButton;
    protected JButton replaceAllButton;
    private int textFieldLength = 10;
    protected JTextField findField = UIHelper.createTextField();
    private JTextField replaceField = UIHelper.createTextField();
    private JCheckBox matchCaseButton;
    private JCheckBox wrapSearchButton;
    private JCheckBox searchSelectionChkBx;
    private JLabel statusInfo;
    private HideFindPanelAction hideFindPanelAction = new HideFindPanelAction();
    private SearchAction searchAction = new SearchAction();
    private ReplaceAction replaceAction = new ReplaceAction();
    private LaunchFindAction launchFindAction = null;
    private ListSelectionListener listSelectionListener = null;
    private CellConstraints cc = new CellConstraints();
    private FormLayout formLayout = new FormLayout("p,8px,p,1px,p,1px,p,1px,p,4px,p,1px,p,1px,p,1px,p,1px,p,1px,p", "p,1px,p,1px");
    private PanelBuilder builder = new PanelBuilder(this.formLayout, (JPanel)this);
    protected static final Logger log = Logger.getLogger(SearchReplacePanel.class);

    public SearchReplacePanel(SpreadSheet mytable) {
        this.table = mytable;
        this.setVisible(false);
        this.createFindAndReplacePanel();
        this.handleTableSelections();
    }

    protected TableSearcher createTableSearcher() {
        return new TableSearcher(this.table, this);
    }

    public void handleTableSelections() {
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SearchReplacePanel.this.nextButton.setEnabled(true);
                    SearchReplacePanel.this.previousButton.setEnabled(true);
                    SearchReplacePanel.this.updateStatusLabel(-1, false);
                }
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    protected JPanel showFindAndReplacePanel(boolean shouldShow) {
        if (!shouldShow) {
            this.setVisible(false);
        } else {
            this.stopTableEditing();
            this.setVisible(true);
            this.findField.requestFocusInWindow();
            UsageTracker.incrUsageCount("WB.ShowFindReplace");
        }
        return this;
    }

    private void setupKeyStrokeMappings() {
        this.table.getInputMap().put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), UIRegistry.getResourceString("Find"));
        this.table.getInputMap().put(KeyStroke.getKeyStroke(70, 2), UIRegistry.getResourceString("Find"));
        this.launchFindAction = new LaunchFindAction();
        this.table.getActionMap().put("Find", this.launchFindAction);
        String CANCEL_KEY = "CANCELKEY";
        String ENTER_KEY = "ENTERKEY";
        String REPLACE_KEY = "REPLACEKEY";
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0, false);
        InputMap textFieldInputMap = this.findField.getInputMap(1);
        textFieldInputMap.put(enterKey, ENTER_KEY);
        textFieldInputMap.put(escapeKey, CANCEL_KEY);
        ActionMap textFieldActionMap = this.findField.getActionMap();
        textFieldActionMap.put(ENTER_KEY, this.searchAction);
        textFieldActionMap.put(CANCEL_KEY, this.hideFindPanelAction);
        if (!this.table.isReadOnly()) {
            InputMap replaceFieldInputMap = this.replaceField.getInputMap(1);
            replaceFieldInputMap.put(enterKey, REPLACE_KEY);
            replaceFieldInputMap.put(escapeKey, CANCEL_KEY);
            ActionMap replaceFieldActionMap = this.replaceField.getActionMap();
            replaceFieldActionMap.put(REPLACE_KEY, this.replaceAction);
            replaceFieldActionMap.put(CANCEL_KEY, this.hideFindPanelAction);
        }
    }

    private void createReplacePanel() {
        if (!this.table.isReadOnly()) {
            this.replaceField.setColumns(this.textFieldLength);
            this.replaceField.addKeyListener(new FindReplaceTextFieldKeyAdapter());
            this.replaceButton = UIHelper.createButton(UIRegistry.getResourceString("SS_SR_REPLACE"));
            this.replaceButton.addActionListener(this.replaceAction);
            this.replaceAllButton = UIHelper.createButton(UIRegistry.getResourceString("SS_SR_REPLACEALL"));
            this.replaceAllButton.addActionListener(this.replaceAction);
            this.builder.add((Component)this.replaceField, this.cc.xy(5, 3));
            this.builder.add((Component)this.replaceButton, this.cc.xy(7, 3));
            this.builder.add((Component)this.replaceAllButton, this.cc.xy(9, 3));
        }
    }

    private void createFindAndReplacePanel() {
        this.setupKeyStrokeMappings();
        this.createFindPanel();
        this.createReplacePanel();
        this.statusInfo = UIHelper.createLabel("");
        this.builder.add((Component)this.statusInfo, this.cc.xywh(11, 3, 4, 1));
    }

    private void createFindPanel() {
        this.cancelButton = UIHelper.createButton(this.hideFindPanelAction);
        this.cancelButton.setIcon(IconManager.getIcon("Close"));
        this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelButton.setBorder(null);
        this.findLabel = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("SS_SR_FIND")) + ": ", 4);
        this.nextButton = UIHelper.createButton(UIRegistry.getResourceString("SS_SR_NEXT"));
        this.nextButton.setEnabled(false);
        UIHelper.setLocalizedMnemonic(this.previousButton, "SS_SR_NEXT_MNEU");
        this.nextButton.addActionListener(this.searchAction);
        this.previousButton = UIHelper.createButton(UIRegistry.getResourceString("SS_SR_PREVIOUS"));
        this.previousButton.setEnabled(false);
        UIHelper.setLocalizedMnemonic(this.previousButton, "SS_SR_PREVIOUS_MNEU");
        this.previousButton.addActionListener(this.searchAction);
        this.findField.setColumns(this.textFieldLength);
        this.findField.setText("");
        this.findField.addKeyListener(new FindReplaceTextFieldKeyAdapter());
        this.matchCaseButton = UIHelper.createCheckBox(UIRegistry.getResourceString("SS_SR_MATCHCASE"));
        this.matchCaseButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.wrapSearchButton = UIHelper.createCheckBox(UIRegistry.getResourceString("SS_SR_WRAP"));
        this.wrapSearchButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchReplacePanel.this.setCheckAndSetWrapOption();
            }
        });
        this.searchSelectionChkBx = UIHelper.createCheckBox(UIRegistry.getResourceString("SS_SR_SELECTED"));
        this.searchSelectionChkBx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchReplacePanel.this.setSearchSelectionOption();
                SearchReplacePanel.this.foundCell = null;
            }
        });
        this.builder.add((Component)this.cancelButton, this.cc.xy(1, 1));
        this.builder.add((Component)this.findLabel, this.cc.xy(3, 1));
        this.builder.add((Component)this.findField, this.cc.xy(5, 1));
        this.builder.add((Component)this.nextButton, this.cc.xy(7, 1));
        this.builder.add((Component)this.previousButton, this.cc.xy(9, 1));
        this.builder.add((Component)this.matchCaseButton, this.cc.xy(11, 1));
        this.builder.add((Component)this.wrapSearchButton, this.cc.xy(13, 1));
        this.builder.add((Component)this.searchSelectionChkBx, this.cc.xy(15, 1));
    }

    protected boolean getMatchCaseFlag() {
        return this.matchCaseButton.isSelected();
    }

    protected boolean getWrapSearchFlag() {
        return this.wrapSearchButton.isSelected();
    }

    public void setStatusLabelWithFailedFind() {
        log.info((Object)("NOT FOUND - Findvalue[" + this.findField.getText() + "] displaying statusInfo to the user"));
        this.statusInfo.setHorizontalTextPosition(4);
        this.statusInfo.setIcon(IconManager.getIcon("Error", IconManager.IconSize.Std16));
        this.statusInfo.setText(UIRegistry.getResourceString("SS_SR_PHRASENOTFOUND"));
    }

    public void setStatusLabelEndReached() {
        log.info((Object)("NOT FOUND - Findvalue[" + this.findField.getText() + "] displaying statusInfo to the user"));
        this.statusInfo.setHorizontalTextPosition(4);
        this.statusInfo.setIcon(IconManager.getIcon("ValidationValid", IconManager.IconSize.Std16));
        this.statusInfo.setText(UIRegistry.getResourceString("SS_SR_ENDOFTABLE"));
    }

    public void updateStatusLabel(int count, boolean isReplace) {
        this.statusInfo.setHorizontalTextPosition(4);
        this.statusInfo.setIcon(null);
        String findFldVal = this.getFindFieldValue();
        this.replaceButton.setEnabled(this.foundCell != null && StringUtils.isNotBlank((String)findFldVal));
        if (count > 0) {
            if (!isReplace) {
                if (!this.table.isReadOnly() || count > 1) {
                    String key = count == 1 ? "SearchReplacePanel.FOUND_MATCH" : "SearchReplacePanel.FOUND_MATCHES";
                    this.statusInfo.setText(String.format(UIRegistry.getResourceString(key), count));
                }
            } else {
                String key = count == 1 ? "SearchReplacePanel.REPLACED_CELL" : "SearchReplacePanel.REPLACED_CELLS";
                this.statusInfo.setText(String.format(UIRegistry.getResourceString(key), count));
            }
        } else {
            this.statusInfo.setText("");
        }
    }

    private void stopTableEditing() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    public void setCheckAndSetWrapOption() {
        if (this.wrapSearchButton.isSelected()) {
            this.isFinishedSearchingDown = false;
            this.isFinishedSearchingUp = false;
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(true);
            this.updateStatusLabel(-1, false);
        }
    }

    public void setSearchSelectionOption() {
        this.searchSelection = this.searchSelectionChkBx.isSelected();
    }

    public void updateTableUiForFoundValue(TableSearcherCell cell, int replacementCount, boolean isReplace) {
        int curRow = -1;
        int curCol = -1;
        if (replacementCount > 0) {
            curRow = cell.getRow();
            curCol = cell.getColumn();
            if (curRow != -1 && curCol != -1) {
                ListSelectionModel rsm = this.table.getSelectionModel();
                ListSelectionModel csm = this.table.getColumnModel().getSelectionModel();
                Rectangle rect = this.table.getCellRect(curRow, curCol, false);
                if (!this.isSearchSelection()) {
                    rsm.setSelectionInterval(curRow, curRow);
                    csm.setSelectionInterval(curCol, curCol);
                } else {
                    this.table.setEmphasizedCell(curRow, curCol);
                    if (rect != null) {
                        this.table.repaint(rect);
                    } else {
                        this.table.repaint();
                    }
                }
                if (rect != null && this.table.getAutoscrolls()) {
                    this.table.scrollRectToVisible(rect);
                }
            }
            if (this.isSearchDown()) {
                this.enablePreviousButton();
            } else {
                this.enableNextButton();
            }
            this.updateStatusLabel(replacementCount, isReplace);
        } else if (this.isSearchDown()) {
            this.setFinishedSearchingDown(true);
            if (!this.getWrapSearchFlag()) {
                this.disableNextButton();
                this.enablePreviousButton();
            }
            this.setStatusLabelWithFailedFind();
        } else {
            this.setFinishedSearchingUp(true);
            if (!this.getWrapSearchFlag()) {
                this.disablePreviousButton();
                this.enableNextButton();
            }
            this.setStatusLabelWithFailedFind();
        }
    }

    public Action getLaunchFindAction() {
        return this.launchFindAction;
    }

    public void cleanUp() {
        this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        this.table.getActionMap().remove("Find");
        this.table = null;
    }

    public SearchReplacePanel getPanel() {
        return this;
    }

    protected boolean canReplace() {
        TableColumn sortedColumn = this.table.getSortedColumn();
        if (sortedColumn != null) {
            if (this.isSearchSelection()) {
                int[] selCols = this.table.getSelectedColumns();
                int sortCol = this.table.getColumnModel().getColumnIndex(sortedColumn.getIdentifier());
                int c = 0;
                while (c < selCols.length) {
                    if (selCols[c] == sortCol) {
                        return false;
                    }
                    ++c;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public HideFindPanelAction getHideFindPanelAction() {
        return this.hideFindPanelAction;
    }

    public void setHideFindPanelAction(HideFindPanelAction hideFindPanelAction) {
        this.hideFindPanelAction = hideFindPanelAction;
    }

    public String getFindFieldValue() {
        if (this.findField != null) {
            return this.findField.getText();
        }
        return null;
    }

    public String getRepalceFieldValue() {
        if (this.replaceField != null) {
            return this.replaceField.getText();
        }
        return null;
    }

    public void enablePreviousButton() {
        if (this.previousButton != null) {
            this.previousButton.setEnabled(true);
        }
    }

    public void enableNextButton() {
        if (this.nextButton != null) {
            this.nextButton.setEnabled(true);
        }
    }

    public void disablePreviousButton() {
        if (this.previousButton != null) {
            this.previousButton.setEnabled(false);
        }
    }

    public void disableNextButton() {
        if (this.nextButton != null) {
            this.nextButton.setEnabled(false);
        }
    }

    protected boolean isSearchDown() {
        return this.isSearchDown;
    }

    public boolean isFinishedSearchingDown() {
        return this.isFinishedSearchingDown;
    }

    public void setFinishedSearchingDown(boolean isFinishedSearchingDown) {
        this.isFinishedSearchingDown = isFinishedSearchingDown;
    }

    public boolean isFinishedSearchingUp() {
        return this.isFinishedSearchingUp;
    }

    public void setFinishedSearchingUp(boolean isFinishedSearchingUp) {
        this.isFinishedSearchingUp = isFinishedSearchingUp;
    }

    public void setSearchDown(boolean isSearchDown) {
        this.isSearchDown = isSearchDown;
    }

    public JButton getReplaceButton() {
        return this.replaceButton;
    }

    public void setReplaceButton(JButton replaceButton) {
        this.replaceButton = replaceButton;
    }

    public JButton getReplaceAllButton() {
        return this.replaceAllButton;
    }

    public void setReplaceAllButton(JButton replaceAllButton) {
        this.replaceAllButton = replaceAllButton;
    }

    public boolean isSearchSelection() {
        return this.searchSelection;
    }

    private class FindReplaceTextFieldKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent ke) {
            int key;
            boolean findTextState = SearchReplacePanel.this.findField.getText().length() > 0;
            SearchReplacePanel.this.nextButton.setEnabled(findTextState);
            if (SearchReplacePanel.this.table.getSelectedRow() > 0 || SearchReplacePanel.this.table.getSelectedColumn() > 0) {
                SearchReplacePanel.this.previousButton.setEnabled(findTextState);
            }
            if (SearchReplacePanel.this.replaceButton != null) {
                SearchReplacePanel.this.replaceButton.setEnabled(findTextState);
            }
            if (SearchReplacePanel.this.replaceAllButton != null) {
                SearchReplacePanel.this.replaceAllButton.setEnabled(findTextState);
            }
            if ((key = ke.getKeyCode()) != 10) {
                SearchReplacePanel.this.updateStatusLabel(-1, false);
                SearchReplacePanel.this.foundCell = null;
            }
        }
    }

    public class HideFindPanelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            SearchReplacePanel.this.showFindAndReplacePanel(false);
        }

        public void hide() {
            SearchReplacePanel.this.showFindAndReplacePanel(false);
        }
    }

    public class LaunchFindAction
    extends AbstractAction {
        public LaunchFindAction() {
            super("Find");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchReplacePanel.this.showFindAndReplacePanel(true);
        }
    }

    private class ReplaceAction
    extends AbstractAction {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            SearchReplacePanel.this.setCheckAndSetWrapOption();
            String replaceValue = SearchReplacePanel.this.getRepalceFieldValue();
            String findValue = SearchReplacePanel.this.getFindFieldValue();
            TableSearcherCell cell = null;
            if (source == SearchReplacePanel.this.replaceAllButton) {
                log.debug((Object)"replaceAllButton --------------------------------------------------------");
                TableSearcher tableSearcher = SearchReplacePanel.this.createTableSearcher();
                int selectedCol = 0;
                int selectedRow = 0;
                int rowCount = SearchReplacePanel.this.table.getModel().getRowCount();
                int colCount = SearchReplacePanel.this.table.getModel().getColumnCount();
                boolean found = false;
                boolean oldBatchMode = SearchReplacePanel.this.table.getModel().isBatchMode();
                cell = tableSearcher.checkCell(SearchReplacePanel.this.getFindFieldValue(), selectedRow, selectedCol, SearchReplacePanel.this.getMatchCaseFlag(), SearchReplacePanel.this.isSearchSelection());
                try {
                    SearchReplacePanel.this.table.getModel().setBatchMode(true);
                    while (selectedRow > -1 && selectedCol > -1 && selectedRow <= rowCount - 1 && selectedCol <= colCount - 1) {
                        found = cell.isFound();
                        if (found) {
                            tableSearcher.replace(cell, findValue, replaceValue, SearchReplacePanel.this.getMatchCaseFlag(), SearchReplacePanel.this.isSearchSelection());
                        }
                        cell = tableSearcher.findNext(findValue, selectedRow, selectedCol, true, false, SearchReplacePanel.this.getMatchCaseFlag(), SearchReplacePanel.this.isSearchSelection());
                        selectedCol = cell.getColumn();
                        selectedRow = cell.getRow();
                    }
                }
                finally {
                    SearchReplacePanel.this.table.getModel().setBatchMode(oldBatchMode);
                }
                tableSearcher.replacementCleanup();
                SearchReplacePanel.this.updateTableUiForFoundValue(cell, tableSearcher.getReplacementCount(), true);
                UsageTracker.incrUsageCount("WB.ReplaceAllButton");
                return;
            }
            if (source != SearchReplacePanel.this.replaceButton) return;
            if (!SearchReplacePanel.this.canReplace()) {
                if (SearchReplacePanel.this.isSearchSelection()) {
                    UIRegistry.displayInfoMsgDlgLocalized("SearchReplacePanel.UnableToReplaceSelection", new Object[0]);
                    return;
                }
                UIRegistry.displayInfoMsgDlgLocalized("SearchReplacePanel.UnableToReplace", new Object[0]);
                return;
            }
            log.debug((Object)"replaceButton --------------------------------------------------------");
            TableSearcher tableSearcher = SearchReplacePanel.this.createTableSearcher();
            int selectedCol = SearchReplacePanel.this.foundCell == null ? SearchReplacePanel.this.table.getSelectedColumn() - 1 : SearchReplacePanel.this.foundCell.getColumn();
            int selectedRow = SearchReplacePanel.this.foundCell == null ? SearchReplacePanel.this.table.getSelectedRow() : SearchReplacePanel.this.foundCell.getRow();
            cell = tableSearcher.checkCell(SearchReplacePanel.this.getFindFieldValue(), selectedRow, selectedCol, SearchReplacePanel.this.getMatchCaseFlag(), SearchReplacePanel.this.isSearchSelection());
            if (cell.isFound()) {
                tableSearcher.replace(cell, findValue, replaceValue, SearchReplacePanel.this.getMatchCaseFlag(), SearchReplacePanel.this.isSearchSelection());
                tableSearcher.replacementCleanup();
                selectedCol = cell.getColumn();
                selectedRow = cell.getRow();
                cell = tableSearcher.findNext(findValue, selectedRow, selectedCol, SearchReplacePanel.this.isSearchDown(), SearchReplacePanel.this.getWrapSearchFlag(), SearchReplacePanel.this.getMatchCaseFlag(), SearchReplacePanel.this.isSearchSelection());
                if (cell.isFound()) {
                    SearchReplacePanel.this.foundCell = cell;
                    SearchReplacePanel.this.updateTableUiForFoundValue(SearchReplacePanel.this.foundCell, tableSearcher.getReplacementCount(), true);
                } else {
                    SearchReplacePanel.this.foundCell = null;
                }
            } else {
                SearchReplacePanel.this.setStatusLabelWithFailedFind();
            }
            UsageTracker.incrUsageCount("WB.ReplaceButton");
        }
    }

    private class SearchAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            SearchReplacePanel.this.isSearchDown = true;
            Object source = evt.getSource();
            TableSearcher tableSearcher = SearchReplacePanel.this.createTableSearcher();
            if (source == SearchReplacePanel.this.nextButton) {
                log.debug((Object)"nextButton --------------------------------------------------------");
                SearchReplacePanel.this.isSearchDown = true;
            } else if (source == SearchReplacePanel.this.previousButton) {
                log.debug((Object)"previousButton --------------------------------------------------------");
                SearchReplacePanel.this.isSearchDown = false;
            }
            int replacementCount = 0;
            UsageTracker.incrUsageCount("WB.FindButton");
            SearchReplacePanel.this.setCheckAndSetWrapOption();
            log.debug((Object)"action performed");
            String findValue = SearchReplacePanel.this.getFindFieldValue();
            int curRow = SearchReplacePanel.this.foundCell == null ? SearchReplacePanel.this.table.getSelectedRow() : SearchReplacePanel.this.foundCell.getRow();
            int curCol = SearchReplacePanel.this.foundCell == null ? SearchReplacePanel.this.table.getSelectedColumn() - 1 : SearchReplacePanel.this.foundCell.getColumn();
            TableSearcherCell cell = tableSearcher.findNext(findValue, curRow, curCol, SearchReplacePanel.this.isSearchDown(), SearchReplacePanel.this.getWrapSearchFlag(), SearchReplacePanel.this.getMatchCaseFlag(), SearchReplacePanel.this.isSearchSelection());
            if (cell.isFound()) {
                ++replacementCount;
                SearchReplacePanel.this.foundCell = cell;
            }
            SearchReplacePanel.this.updateTableUiForFoundValue(cell, replacementCount, false);
        }
    }
}

