/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.skin;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.skin.Skin;
import edu.ku.brc.ui.skin.SkinItem;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SkinsMgr {
    protected static SkinsMgr instance = new SkinsMgr();
    protected static boolean hasSkins;
    protected Skin currentSkin = null;

    protected SkinsMgr() {
        SkinsMgr.load();
        File skinsFile = new File(XMLHelper.getConfigDirPath("skins.xml"));
        hasSkins = skinsFile.exists();
    }

    public static SkinsMgr getInstance() {
        return instance;
    }

    public static boolean hasSkins() {
        return hasSkins;
    }

    public static Skin getCurrentSkin() {
        return SkinsMgr.instance.currentSkin;
    }

    public static SkinItem getSkinItem(String itemName) {
        if (SkinsMgr.instance.currentSkin != null) {
            return SkinsMgr.instance.currentSkin.getItem(itemName);
        }
        return null;
    }

    public static boolean shouldBeOpaque(SkinItem item) {
        return !SkinsMgr.doesCurrentHaveBG() || item != null && item.isOpaque();
    }

    public static boolean doesCurrentHaveBG() {
        if (SkinsMgr.instance.currentSkin != null) {
            return SkinsMgr.instance.currentSkin.hasBG();
        }
        return false;
    }

    public Skin setSkin(String skinName) {
        if (hasSkins && (this.currentSkin == null || !this.currentSkin.getName().equals(skinName))) {
            if (this.currentSkin != null) {
                this.currentSkin.unregister();
            }
            this.currentSkin = null;
            Hashtable<String, Skin> skinsHash = SkinsMgr.load();
            if (skinsHash != null) {
                this.currentSkin = skinsHash.get(skinName);
                if (this.currentSkin != null) {
                    this.currentSkin.register();
                }
            }
        }
        return this.currentSkin;
    }

    public List<Skin> getSkinList() {
        Vector<Skin> skinsList = new Vector<Skin>();
        if (hasSkins) {
            Hashtable<String, Skin> skinHash = SkinsMgr.load();
            skinsList.addAll(skinHash.values());
            Collections.sort(skinsList);
        }
        return skinsList;
    }

    protected static Hashtable<String, Skin> load() {
        XStream xstream = new XStream();
        SkinsMgr.config(xstream);
        File skinsFile = new File(XMLHelper.getConfigDirPath("skins.xml"));
        if (skinsFile.exists()) {
            return (Hashtable)xstream.fromXML(XMLHelper.getContents(skinsFile));
        }
        return null;
    }

    protected static void config(XStream xstream) {
        xstream.alias("skins", SkinsMgr.class);
        Skin.config(xstream);
    }
}

