/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.skin;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.ui.JTiledPanel;
import edu.ku.brc.ui.skin.SkinsMgr;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.File;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.lang.StringUtils;

public class SkinItem {
    protected String name = null;
    protected String fontName = null;
    protected int fontSize = -1;
    protected String fontStyle = null;
    protected Color fgColor = null;
    protected Color bgColor = null;
    protected String imagePath = null;
    protected String desc = null;
    protected Image bgImage = null;
    protected Font font = null;
    protected Hashtable<String, Object> cacheHash = new Hashtable();

    public SkinItem() {
    }

    public SkinItem(String name, String fontName, int fontSize, String fontStyle, Color fgColor, Color bgColor, String imagePath, String desc) {
        this.name = name;
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.imagePath = imagePath;
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isOpaque() {
        return !SkinsMgr.doesCurrentHaveBG() && (this.bgColor != null || StringUtils.isNotEmpty((String)this.imagePath));
    }

    public void setupPanel(JComponent comp) {
        boolean isOpaque;
        boolean bl = isOpaque = this.bgColor != null || StringUtils.isNotEmpty((String)this.imagePath);
        if (isOpaque) {
            comp.setOpaque(isOpaque);
        }
        if (this.bgColor != null) {
            comp.setBackground(this.bgColor);
        }
        if (comp instanceof JTiledPanel && (this.bgImage != null || StringUtils.isNotEmpty((String)this.imagePath))) {
            ((JTiledPanel)comp).setTileImage(this.getBGImage());
        }
    }

    public Font getFont() {
        if (this.font == null && StringUtils.isNotEmpty((String)this.fontName) && this.fontSize > 0) {
            int style = 0;
            if (StringUtils.isNotEmpty((String)this.fontStyle)) {
                if (this.fontStyle.equalsIgnoreCase("plain")) {
                    style = 0;
                } else if (this.fontStyle.equalsIgnoreCase("bold")) {
                    style = 1;
                } else if (this.fontStyle.equalsIgnoreCase("italic")) {
                    style = 2;
                } else if (this.fontStyle.equalsIgnoreCase("bolditalic")) {
                    style = 3;
                }
            }
            this.font = new Font(this.fontName, style, this.fontSize);
        }
        return this.font;
    }

    public Image getBGImage() {
        if (this.bgImage == null && new File(this.imagePath).exists()) {
            ImageIcon imgIcon = new ImageIcon(this.imagePath);
            this.bgImage = imgIcon.getImage();
        }
        return this.bgImage;
    }

    public void pushFG(String nm) {
        if (this.fgColor != null) {
            if (this.cacheHash == null) {
                this.cacheHash = new Hashtable();
            }
            this.cacheHash.put(nm, UIManager.get(nm));
            UIManager.put(nm, new ColorUIResource(this.fgColor));
        }
    }

    public void popFG(String nm) {
        if (this.fgColor != null) {
            Object obj = this.cacheHash.get(nm);
            UIManager.put(nm, obj);
        }
    }

    public void register() {
        if (this.getFont() != null) {
            UIManager.put(String.valueOf(this.name) + '.' + "font", new FontUIResource(this.font));
        }
        if (this.bgColor != null) {
            UIManager.put(String.valueOf(this.name) + '.' + "bgcolor", new ColorUIResource(this.bgColor));
        }
        if (this.fgColor != null) {
            UIManager.put(String.valueOf(this.name) + '.' + "fgcolor", new ColorUIResource(this.fgColor));
        }
        if (this.getBGImage() != null) {
            UIManager.put(String.valueOf(this.name) + '.' + "bgimage", this.bgImage);
        }
    }

    public void unregister() {
        String[] propNames;
        String[] stringArray = propNames = new String[]{"font", "bgcolor", "fgcolor", "bgimage"};
        int n = propNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pn = stringArray[n2];
            UIManager.put(String.valueOf(this.name) + '.' + pn, null);
            ++n2;
        }
    }

    public static void config(XStream xstream) {
        xstream.alias("skinitem", SkinItem.class);
        xstream.useAttributeFor(SkinItem.class, "name");
        xstream.useAttributeFor(SkinItem.class, "fontName");
        xstream.useAttributeFor(SkinItem.class, "fontSize");
        xstream.useAttributeFor(SkinItem.class, "fontStyle");
        xstream.useAttributeFor(SkinItem.class, "fgColor");
        xstream.useAttributeFor(SkinItem.class, "bgColor");
        xstream.omitField(SkinItem.class, "bgImage");
        xstream.omitField(SkinItem.class, "cacheHash");
        xstream.aliasAttribute(SkinItem.class, "name", "name");
        xstream.aliasAttribute(SkinItem.class, "fontName", "fontname");
        xstream.aliasAttribute(SkinItem.class, "fontSize", "fontsize");
        xstream.aliasAttribute(SkinItem.class, "fontStyle", "fontstyle");
        xstream.aliasAttribute(SkinItem.class, "fgColor", "fg");
        xstream.aliasAttribute(SkinItem.class, "bgColor", "bg");
        xstream.aliasField("image", SkinItem.class, "imagePath");
    }
}

