/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.skin;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.ui.skin.SkinItem;
import java.util.Hashtable;

public class Skin
implements Comparable<Skin> {
    protected String name = null;
    protected String desc = null;
    protected Hashtable<String, SkinItem> items = null;
    protected Boolean hasBG = false;

    public Skin() {
    }

    public Skin(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Hashtable<String, SkinItem> getItems() {
        if (this.items == null) {
            this.items = new Hashtable();
        }
        return this.items;
    }

    public void setItems(Hashtable<String, SkinItem> items) {
        this.items = items;
    }

    public SkinItem getItem(String itemName) {
        SkinItem item = this.items.get(itemName);
        if (item == null && !itemName.equals("bg")) {
            return this.items.get("bg");
        }
        return item;
    }

    public boolean hasBG() {
        if (this.hasBG == null) {
            this.hasBG = this.getItem("bg") != null;
        }
        return this.hasBG;
    }

    public void register() {
        for (SkinItem item : this.items.values()) {
            item.register();
        }
    }

    public void unregister() {
        for (SkinItem item : this.items.values()) {
            item.unregister();
        }
    }

    @Override
    public int compareTo(Skin obj) {
        return this.name.compareTo(obj.name);
    }

    public static void config(XStream xstream) {
        xstream.alias("skin", Skin.class);
        xstream.useAttributeFor(Skin.class, "name");
        xstream.omitField(Skin.class, "hasBG");
        SkinItem.config(xstream);
    }
}

