/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.listeners;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;

public class ScrollBarLinkingListener
implements AdjustmentListener {
    private List<JScrollBar> scrollBars = new Vector<JScrollBar>();
    private boolean enabled = true;

    public synchronized void addScrollBar(JScrollBar scrollBar) {
        this.scrollBars.add(scrollBar);
        scrollBar.addAdjustmentListener(this);
    }

    public synchronized void removeScrollBar(JScrollBar scrollBar) {
        scrollBar.removeAdjustmentListener(this);
        this.scrollBars.remove(scrollBar);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.enabled) {
            return;
        }
        BoundedRangeModel model = ((JScrollBar)e.getSource()).getModel();
        int value = model.getValue();
        int extent = model.getExtent();
        int max = model.getMaximum();
        double percent = (double)value / (double)(max - extent);
        ScrollBarLinkingListener scrollBarLinkingListener = this;
        synchronized (scrollBarLinkingListener) {
            for (JScrollBar sb : this.scrollBars) {
                BoundedRangeModel model2 = sb.getModel();
                int extent2 = model2.getExtent();
                int max2 = model2.getMaximum();
                this.enabled = false;
                model2.setValue((int)(percent * (double)(max2 - extent2)));
                this.enabled = true;
            }
        }
    }
}

