/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.DndDeletableListCellRenderer;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DndDeletable;
import edu.ku.brc.ui.dnd.Trash;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class TrashCanDlg
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final Logger log = Logger.getLogger(TrashCanDlg.class);
    protected JButton restoreBtn;
    protected JButton okBtn;
    protected JList list;
    protected List<DndDeletable> items;
    protected Trash trash;

    public TrashCanDlg(Frame frame) throws HeadlessException {
        super(frame, true);
        this.createUI();
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(0);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    protected void createUI() {
        this.trash = Trash.getInstance();
        this.items = this.trash.getItems();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        JLabel label = UIHelper.createLabel(UIRegistry.getResourceString("DeletedItems"), 0);
        panel.add((Component)label, "North");
        try {
            AbstractListModel listModel = new AbstractListModel(){

                @Override
                public int getSize() {
                    return TrashCanDlg.this.items.size();
                }

                @Override
                public Object getElementAt(int index) {
                    return TrashCanDlg.this.items.get(index).getName();
                }
            };
            this.list = new JList(listModel);
            this.list.setCellRenderer(new DndDeletableListCellRenderer());
            this.list.setVisibleRowCount(10);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        TrashCanDlg.this.okBtn.doClick();
                    }
                }
            });
            this.list.addListSelectionListener(this);
            panel.add((Component)UIHelper.createScrollPane(this.list), "Center");
            this.restoreBtn = UIHelper.createButton(UIRegistry.getResourceString("Restore"));
            this.okBtn = UIHelper.createButton(UIRegistry.getResourceString("CLOSE"));
            this.restoreBtn.setEnabled(false);
            this.okBtn.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okBtn);
            ButtonBarBuilder btnBuilder = new ButtonBarBuilder();
            btnBuilder.addGriddedButtons(new JButton[]{this.restoreBtn, this.okBtn});
            this.restoreBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TrashCanDlg.this.restoreItem();
                }
            });
            panel.add((Component)btnBuilder.getPanel(), "South");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TrashCanDlg.class, ex);
            log.error((Object)ex);
        }
        this.setContentPane(panel);
        this.pack();
    }

    protected void restoreItem() {
        JOptionPane.showMessageDialog(UIRegistry.get("frame"), "Sorry, not implemented yet.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public DndDeletable getDeletable() {
        int inx = this.list.getSelectedIndex();
        if (inx != -1) {
            return this.items.get(inx);
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.restoreBtn.setEnabled(this.list.getSelectedIndex() != -1);
    }
}

