/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DndDeletable;
import edu.ku.brc.ui.dnd.DragAndDropLock;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import edu.ku.brc.ui.dnd.TrashCanDlg;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Trash
extends JComponent
implements GhostActionable {
    public static final DataFlavor TRASH_FLAVOR = new DataFlavor(Trash.class, "Trash");
    private static final Trash instance = new Trash();
    protected static final int SHADOW_SIZE = 10;
    protected static final int TEXT_GAP = 2;
    protected ImageIcon imgIcon;
    protected ImageIcon trashIcon;
    protected ImageIcon trashFullIcon;
    protected ImageIcon paperIcon;
    protected Insets insets = new Insets(4, 4, 4, 4);
    protected GhostMouseInputAdapter mouseInputAdapter = null;
    protected RenderingHints hints = null;
    protected BufferedImage shadowBuffer = null;
    protected BufferedImage buffer = null;
    protected Dimension preferedRenderSize = new Dimension(0, 0);
    protected boolean verticalLayout = false;
    protected Vector<DndDeletable> items = new Vector();
    protected boolean isActive = false;
    protected boolean isOver = false;
    protected String title = UIRegistry.getResourceString("Trash");
    protected Dimension titleSize = null;
    protected Font titleFont;
    protected Color titleColor;
    protected Color textColor = new Color(0, 0, 0, 90);
    protected Font textFont = null;
    protected JPopupMenu popupMenu = null;
    protected JMenuItem emptyMenuItem = null;
    protected JMenuItem openMenuItem = null;
    protected Object data = null;
    protected List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();

    protected Trash() {
        this.dropFlavors.add(TRASH_FLAVOR);
        this.trashIcon = IconManager.getIcon("Trash");
        this.paperIcon = this.trashFullIcon = IconManager.getIcon("TrashFull");
        this.imgIcon = this.trashIcon;
        this.hints = UIHelper.createTextRenderingHints();
        this.titleFont = new Font(UIHelper.createLabel("").getFont().getFamily(), 0, 11);
        this.titleColor = new Color(0, 0, 0, 190);
        this.createMouseInputAdapter();
        MouseAdapter mouseListener = new MouseAdapter(){

            private void showIfPopupTrigger(MouseEvent mouseEvent) {
                if (Trash.this.items != null) {
                    if (Trash.this.emptyMenuItem != null) {
                        Trash.this.emptyMenuItem.setEnabled(Trash.this.items.size() > 0);
                    }
                    if (Trash.this.openMenuItem != null) {
                        Trash.this.openMenuItem.setEnabled(Trash.this.items.size() > 0);
                    }
                }
                if (Trash.this.popupMenu != null && mouseEvent.isPopupTrigger() && Trash.this.popupMenu.getComponentCount() > 0) {
                    Trash.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showIfPopupTrigger(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showIfPopupTrigger(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (Trash.this.isEnabled()) {
                    Trash.this.isOver = true;
                    Trash.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Trash.this.isOver = false;
                Trash.this.repaint();
            }
        };
        this.addMouseListener(mouseListener);
    }

    protected void openTrashCan() {
        TrashCanDlg dlg = new TrashCanDlg((Frame)UIRegistry.getTopWindow());
        dlg.setVisible(true);
    }

    public static Trash getInstance() {
        return instance;
    }

    public Vector<DndDeletable> getItems() {
        return this.items;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHints(this.hints);
        g.setColor(this.titleColor);
        g.setFont(this.titleFont);
        int txtY = g.getFontMetrics().getAscent();
        if (this.titleSize.width > this.imgIcon.getIconWidth()) {
            g.drawImage(this.imgIcon.getImage(), (this.titleSize.width - this.imgIcon.getIconWidth()) / 2 + this.insets.left, this.insets.top, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
            g.drawString(this.title, this.insets.left, this.imgIcon.getIconHeight() + 2 + txtY + this.insets.top);
        } else {
            g.drawImage(this.imgIcon.getImage(), this.insets.left, this.insets.top, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
            g.drawString(this.title, (this.imgIcon.getIconWidth() - this.titleSize.width) / 2 + this.insets.left, this.imgIcon.getIconHeight() + 2 + txtY + this.insets.top);
        }
        if (this.isActive && !this.hasFocus()) {
            Color color = this.isActive ? (DragAndDropLock.isDragAndDropStarted() && this.isOver ? RolloverCommand.getDropColor() : RolloverCommand.getActiveColor()) : RolloverCommand.getHoverColor();
            g.setColor(color);
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(0.0, 0.0, size.width - 1, size.height - 1, 10.0, 10.0);
            g2d.draw(rr);
            rr = new RoundRectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3, 10.0, 10.0);
            g2d.draw(rr);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.titleSize == null) {
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D g2d = img.createGraphics();
            g2d.setRenderingHints(this.hints);
            g2d.setFont(this.titleFont);
            FontMetrics fm = g2d.getFontMetrics();
            this.titleSize = new Dimension(fm.stringWidth(this.title), fm.getHeight());
            g2d.dispose();
        }
        return new Dimension(Math.max(this.imgIcon.getIconWidth(), this.titleSize.width) + this.insets.left + this.insets.right, this.imgIcon.getIconHeight() + this.insets.top + this.insets.bottom + 2 + this.titleSize.height);
    }

    protected BufferedImage getPaper() {
        BufferedImage buf = new BufferedImage(this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), 2);
        Graphics2D g2 = buf.createGraphics();
        g2.setRenderingHints(this.hints);
        g2.drawImage(this.paperIcon.getImage(), 0, 0, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
        return buf;
    }

    protected void emptyTrash() {
        GhostGlassPane glassPane = UIRegistry.getGlassPane();
        Container parent = this.getParent();
        Point p = (Point)this.getLocation().clone();
        Rectangle rr = SwingUtilities.convertRectangle(parent, parent.getBounds(), glassPane);
        p.x = (rr.width - this.imgIcon.getIconWidth()) / 2;
        p.y = rr.y + parent.getSize().height - this.imgIcon.getIconHeight() - 1;
        glassPane.setImage(this.getPaper());
        glassPane.setPoint(p);
        glassPane.setVisible(true);
        glassPane.startAnimation(rr);
        this.items.clear();
        this.imgIcon = this.trashIcon;
        this.repaint();
    }

    @Override
    public void doAction(GhostActionable src) {
        if (src != null) {
            Object dataObj = src.getData();
            ((GhostGlassPane)UIRegistry.get("glasspane")).remove(src);
            if (src instanceof DndDeletable && dataObj != null && ((DndDeletable)((Object)src)).deleteRequest()) {
                this.items.add((DndDeletable)((Object)src));
                this.imgIcon = this.trashFullIcon;
                this.repaint();
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }

                    @Override
                    public void finished() {
                        Trash.this.imgIcon = Trash.this.trashIcon;
                        Trash.this.repaint();
                    }
                };
                worker.start();
            }
        }
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return UIHelper.getDataForClass(this.data, classObj);
    }

    @Override
    public void createMouseInputAdapter() {
        this.mouseInputAdapter = new GhostMouseInputAdapter(UIRegistry.getGlassPane(), "action", this);
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return this.mouseInputAdapter;
    }

    private void renderOffscreen() {
        this.buffer = new BufferedImage(this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), 2);
        Graphics2D g2 = this.buffer.createGraphics();
        g2.setRenderingHints(this.hints);
        g2.fillRect(0, 0, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight());
        this.paint(g2);
        g2.dispose();
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.buffer == null) {
            this.renderOffscreen();
        }
        return this.buffer;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return null;
    }
}

