/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.ui.ProgressGlassPane;
import edu.ku.brc.ui.UIHelper;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class SimpleGlassPane
extends ProgressGlassPane
implements AWTEventListener {
    private String text;
    private int pointSize;
    private Color textColor = null;
    private Color fillColor = new Color(0, 0, 0, 50);
    private Insets margin = new Insets(0, 0, 0, 0);
    private Integer yPos = null;
    private boolean useBGImage = false;
    private boolean hideOnClick = false;
    private boolean dblClickProgBar = true;
    private BufferedImage img = null;
    private DelegateRenderer delegateRenderer = null;
    private JFrame frame = null;

    public SimpleGlassPane(String text, int pointSize) {
        this(text, pointSize, true, false);
    }

    public SimpleGlassPane(String text, int pointSize, boolean doBlockMouseEvents) {
        this(text, pointSize, doBlockMouseEvents, false);
    }

    public SimpleGlassPane(String text, int pointSize, boolean doBlockMouseEvents, boolean dblClickProgBar) {
        this.text = text;
        this.pointSize = pointSize;
        this.dblClickProgBar = dblClickProgBar;
        this.setBackground(this.fillColor);
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
                super.mouseClicked(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
                super.mouseDragged(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
                super.mouseExited(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
                super.mouseMoved(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
                super.mouseReleased(e);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                SimpleGlassPane.this.checkMouseEvent(e);
            }
        });
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        boolean srcIsComp = event.getSource() instanceof Component;
        if (event instanceof KeyEvent && srcIsComp) {
            if (this.frame == null) {
                Container p = this.getParent();
                while (this.frame == null && p != null) {
                    if (p instanceof JFrame) {
                        this.frame = (JFrame)p;
                    }
                    p = p.getParent();
                }
            }
            ((KeyEvent)event).consume();
        }
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    private Rectangle getInternalBounds() {
        Rectangle r = this.getBounds();
        r.x += this.margin.left;
        r.y += this.margin.top;
        r.width -= this.margin.left + this.margin.right;
        r.height -= this.margin.top + this.margin.bottom;
        return r;
    }

    protected void checkMouseEvent(MouseEvent e) {
        Point p;
        Rectangle r = this.getInternalBounds();
        if (!(!r.contains(p = e.getPoint()) || this.dblClickProgBar && this.getProgressBarRect().contains(p))) {
            e.consume();
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        this.setBackground(fillColor);
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setUseBGImage(boolean useBGImage) {
        this.useBGImage = useBGImage;
    }

    public void setDelegateRenderer(DelegateRenderer delegateRenderer) {
        this.delegateRenderer = delegateRenderer;
    }

    public void setHideOnClick(boolean hideOnClick) {
        this.hideOnClick = hideOnClick;
    }

    @Override
    public boolean contains(int x, int y) {
        return true;
    }

    public void setTextYPos(Integer yPos) {
        this.yPos = yPos;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Rectangle rect = this.getInternalBounds();
        int width = rect.width;
        int height = rect.height;
        if (this.useBGImage) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (this.img == null || this.img.getWidth() != width || this.img.getHeight() != height) {
                this.img = gc.createCompatibleImage(width, height, 3);
            }
            Graphics2D g2 = this.img.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, width, height);
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(0, 0, 0, 85));
            g2.fillRect(0, 0, width, height);
            if (this.delegateRenderer != null) {
                this.delegateRenderer.render(g, g2, this.img);
            }
            g2.dispose();
            g.drawImage((Image)this.img, rect.x, rect.y, null);
        }
        super.paintComponent(graphics);
        if (StringUtils.isNotEmpty((String)this.text)) {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.fillColor);
            g2.fillRect(this.margin.left, this.margin.top, rect.width, rect.height);
            g2.setFont(new Font(new JLabel().getFont().getName(), 1, this.pointSize));
            FontMetrics fm = g2.getFontMetrics();
            int tw = fm.stringWidth(this.text);
            int th = fm.getHeight();
            int tx = (rect.width - tw) / 2;
            int ty = (rect.height - th) / 2;
            if (this.yPos != null) {
                ty = this.yPos;
            }
            int expand = 20;
            int arc = expand * 2;
            g2.setColor(new Color(0, 0, 0, 50));
            int x = this.margin.left + tx - expand / 2;
            int y = this.margin.top + ty - fm.getAscent() - expand / 2;
            this.drawBGContainer(g2, true, x + 4, y + 6, tw + expand, th + expand, arc, arc);
            g2.setColor(new Color(255, 255, 255, 220));
            this.drawBGContainer(g2, true, x, y, tw + expand, th + expand, arc, arc);
            g2.setColor(Color.DARK_GRAY);
            this.drawBGContainer(g2, false, x, y, tw + expand, th + expand, arc, arc);
            g2.setColor(this.textColor == null ? Color.BLACK : this.textColor);
            g2.drawString(this.text, tx, ty);
        }
    }

    private void drawBGContainer(Graphics2D g2, boolean doFill, int x, int y, int w, int h, int arcW, int arcH) {
        Stroke cacheStroke = g2.getStroke();
        g2.setStroke(UIHelper.getStdLineStroke());
        if (UIHelper.isWindows()) {
            if (doFill) {
                g2.fillRoundRect(x, y, w, h, 4, 4);
            } else {
                g2.drawRoundRect(x, y, w, h, 4, 4);
            }
        } else if (doFill) {
            g2.fillRoundRect(x, y, w, h, arcW, arcH);
        } else {
            g2.drawRoundRect(x, y, w, h, arcW, arcH);
        }
        g2.setStroke(cacheStroke);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.hideOnClick && e.getClickCount() == 1) {
            this.hideOnClick = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleGlassPane.this.setVisible(false);
                }
            });
        } else if (!this.dblClickProgBar || !this.getProgressBarRect().contains(e.getPoint())) {
            e.consume();
        }
        super.processMouseEvent(e);
    }

    public static interface DelegateRenderer {
        public void render(Graphics2D var1, Graphics2D var2, BufferedImage var3);
    }
}

