/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DragAndDropLock;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostDropEvent;
import edu.ku.brc.ui.dnd.GhostDropListener;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;

public class GhostMouseInputAdapter
extends MouseInputAdapter {
    private static final Logger log = Logger.getLogger(GhostMouseInputAdapter.class);
    protected static final Cursor HAND_CURSOR = new Cursor(12);
    protected static final Cursor DEF_CURSOR = new Cursor(0);
    protected static final int dragButtonIndex = System.getProperty("os.name").equals("Mac OS X") ? 1 : 0;
    protected GhostGlassPane glassPane;
    protected Cursor currCursor = null;
    protected Point firstPosition = new Point();
    protected GhostGlassPane.ImagePaintMode paintPositionMode = GhostGlassPane.ImagePaintMode.DRAG;
    protected String action;
    protected List<GhostDropListener> listeners;
    protected GhostActionable ghostActionable;
    protected Point offsetFromStartPnt = new Point();
    protected boolean doAnimationOnDrop = true;
    protected Component dropCanvas = null;

    public GhostMouseInputAdapter(GhostGlassPane glassPane, String action, GhostActionable ghostActionable) {
        this.glassPane = glassPane;
        this.action = action;
        this.ghostActionable = ghostActionable;
        this.listeners = new ArrayList<GhostDropListener>();
    }

    public GhostGlassPane.ImagePaintMode getPaintPositionMode() {
        return this.paintPositionMode;
    }

    public void setPaintPositionMode(GhostGlassPane.ImagePaintMode paintPositionMode) {
        this.paintPositionMode = paintPositionMode;
    }

    public Point getOffsetFromStartPnt() {
        return this.offsetFromStartPnt;
    }

    public void setDoAnimationOnDrop(boolean doAnimationOnDrop) {
        this.doAnimationOnDrop = doAnimationOnDrop;
    }

    public void setDropCanvas(Component dropCanvas) {
        this.dropCanvas = dropCanvas;
    }

    protected void startDrag(Component c, int button, Point pnt) {
        Point pos = c.getLocation();
        pos.x = pnt.x - pos.x;
        pos.y = pnt.y - pos.y;
        if (DragAndDropLock.isLocked() || button != dragButtonIndex) {
            DragAndDropLock.setDragAndDropStarted(false);
            return;
        }
        DragAndDropLock.setLocked(true);
        DragAndDropLock.setDragAndDropStarted(true);
        this.glassPane.startDrag(this.ghostActionable);
        this.glassPane.setVisible(true);
        Point p = (Point)pnt.clone();
        SwingUtilities.convertPointToScreen(p, c);
        SwingUtilities.convertPointFromScreen(p, this.glassPane);
        BufferedImage bi = this.ghostActionable.getBufferedImage();
        if (bi != null) {
            this.glassPane.setPoint(p, this.paintPositionMode);
            this.glassPane.setOffset(pos);
            this.glassPane.setImage(bi, bi.getWidth());
            this.glassPane.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.firstPosition.setLocation(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Component dropComponent;
        Point pp;
        if (!DragAndDropLock.isDragAndDropStarted()) {
            return;
        }
        DragAndDropLock.setDragAndDropStarted(false);
        this.glassPane.stopDrag();
        Component srcOfDropComp = e.getComponent();
        if (!(srcOfDropComp instanceof GhostActionable)) {
            srcOfDropComp = srcOfDropComp.getParent();
        }
        Point p = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(p, srcOfDropComp);
        Point eventPoint = (Point)p.clone();
        SwingUtilities.convertPointFromScreen(p, this.glassPane);
        this.glassPane.setPoint(p, this.paintPositionMode);
        JComponent rootPane = (JComponent)UIRegistry.get("mainpane");
        if (this.dropCanvas != null) {
            pp = (Point)e.getPoint().clone();
            SwingUtilities.convertPointToScreen(pp, srcOfDropComp);
            SwingUtilities.convertPointFromScreen(pp, this.dropCanvas);
            dropComponent = SwingUtilities.getDeepestComponentAt(this.dropCanvas, pp.x, pp.y);
            if (dropComponent == null) {
                log.error((Object)"Drop Component is NULL!");
            }
            Component parent = dropComponent;
            while (parent != null && parent != this.dropCanvas) {
                parent = parent.getParent();
            }
            if (parent == this.dropCanvas) {
                dropComponent = this.dropCanvas;
            }
        } else {
            pp = (Point)e.getPoint().clone();
            SwingUtilities.convertPointToScreen(pp, srcOfDropComp);
            SwingUtilities.convertPointFromScreen(pp, rootPane);
            dropComponent = SwingUtilities.getDeepestComponentAt(rootPane, pp.x, pp.y);
        }
        this.offsetFromStartPnt.setLocation(e.getPoint());
        boolean clearIt = true;
        if (dropComponent == this.ghostActionable) {
            clearIt = true;
        } else if (dropComponent instanceof GhostActionable && dropComponent instanceof JComponent) {
            BufferedImage bi = this.ghostActionable.getBufferedImage();
            this.glassPane.setImage(bi, bi.getWidth());
            boolean isDropOK = this.glassPane.isDropOK(this.ghostActionable, (GhostActionable)((Object)dropComponent));
            if (this.doAnimationOnDrop && isDropOK) {
                this.glassPane.startAnimation(SwingUtilities.convertRectangle(dropComponent, ((JComponent)dropComponent).getVisibleRect(), this.glassPane));
            } else {
                this.glassPane.finishedWithDragAndDrop();
                this.glassPane.repaint();
            }
            if (srcOfDropComp instanceof GhostActionable) {
                if (isDropOK) {
                    this.doCommandAction((GhostActionable)((Object)dropComponent), (GhostActionable)((Object)srcOfDropComp));
                }
                clearIt = false;
            }
        } else if (this.hasListeners()) {
            GhostDropEvent gde = new GhostDropEvent(srcOfDropComp, this.action, eventPoint);
            this.fireGhostDropEvent(gde);
            if (gde.isConsumed()) {
                clearIt = false;
            }
        }
        if (clearIt) {
            this.glassPane.setImage(null);
            this.glassPane.setVisible(false);
            DragAndDropLock.setLocked(false);
        }
    }

    protected void doCommandAction(final GhostActionable drop, final GhostActionable src) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                drop.doAction(src);
            }
        });
    }

    protected boolean isFlavorOK(GhostActionable srcGA, GhostActionable dstGA) {
        for (DataFlavor srcDF : srcGA.getDragDataFlavors()) {
            for (DataFlavor dstDF : dstGA.getDropDataFlavors()) {
                if (!srcDF.equals(dstDF)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Component c;
        if (!this.ghostActionable.isEnabled()) {
            return;
        }
        Point pnt = e.getPoint();
        if (!DragAndDropLock.isDragAndDropStarted()) {
            if (Math.abs(this.firstPosition.x - pnt.x) > 3 || Math.abs(this.firstPosition.y - pnt.y) > 3) {
                this.startDrag(e.getComponent(), e.getButton(), this.firstPosition);
            } else {
                return;
            }
        }
        if (!((c = e.getComponent()) instanceof GhostActionable)) {
            c = c.getParent();
        }
        JComponent rootPane = (JComponent)UIRegistry.get("mainpane");
        Point pp = (Point)pnt.clone();
        SwingUtilities.convertPointToScreen(pp, c);
        SwingUtilities.convertPointFromScreen(pp, rootPane);
        Component dropComponent = SwingUtilities.getDeepestComponentAt(rootPane, pp.x, pp.y);
        boolean flavorOK = false;
        if (dropComponent instanceof GhostActionable && c != dropComponent && c instanceof GhostActionable) {
            flavorOK = this.isFlavorOK((GhostActionable)((Object)c), (GhostActionable)((Object)dropComponent));
        }
        if (flavorOK) {
            if (this.currCursor != HAND_CURSOR) {
                this.glassPane.setCursor(HAND_CURSOR);
                this.currCursor = HAND_CURSOR;
            }
        } else if (this.currCursor != DEF_CURSOR) {
            this.glassPane.setCursor(DEF_CURSOR);
            this.currCursor = DEF_CURSOR;
        }
        Point p = (Point)pnt.clone();
        SwingUtilities.convertPointToScreen(p, c);
        SwingUtilities.convertPointFromScreen(p, this.glassPane);
        this.glassPane.setPoint(p, this.paintPositionMode);
        this.glassPane.repaint(this.glassPane.getRepaintRect());
    }

    public void addGhostDropListener(GhostDropListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeGhostDropListener(GhostDropListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireGhostDropEvent(GhostDropEvent evt) {
        Iterator<GhostDropListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().ghostDropped(evt);
        }
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    public void cleanUp() {
        this.listeners.clear();
        this.glassPane = null;
        this.ghostActionable = null;
        this.dropCanvas = null;
    }
}

