/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DragAndDropLock;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostDropAdapter;
import edu.ku.brc.ui.dnd.GhostDropEvent;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GhostMouseDropAdapter
extends GhostDropAdapter {
    private static final Logger log = Logger.getLogger(GhostMouseDropAdapter.class);
    private GhostActionable ghostActionable;

    public GhostMouseDropAdapter(GhostGlassPane glassPane, String action, GhostActionable ghostActionable) {
        super(glassPane, action);
        this.ghostActionable = ghostActionable;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (DragAndDropLock.isLocked() || e.getButton() != 1) {
            DragAndDropLock.setDragAndDropStarted(false);
            return;
        }
        DragAndDropLock.setLocked(true);
        DragAndDropLock.setDragAndDropStarted(true);
        Component c = e.getComponent();
        this.glassPane.setVisible(true);
        Point p = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(p, c);
        SwingUtilities.convertPointFromScreen(p, this.glassPane);
        BufferedImage bi = this.ghostActionable.getBufferedImage();
        this.glassPane.setPoint(p);
        this.glassPane.setImage(bi, bi.getWidth());
        this.glassPane.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1 || !DragAndDropLock.isDragAndDropStarted()) {
            return;
        }
        DragAndDropLock.setDragAndDropStarted(false);
        Component c = e.getComponent();
        Point p = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(p, c);
        Point eventPoint = (Point)p.clone();
        SwingUtilities.convertPointFromScreen(p, this.glassPane);
        this.glassPane.setPoint(p);
        JComponent rootPane = (JComponent)UIRegistry.get("mainpane");
        Point pp = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(pp, c);
        SwingUtilities.convertPointFromScreen(pp, rootPane);
        Component dropComponent = SwingUtilities.getDeepestComponentAt(rootPane, pp.x, pp.y);
        if (dropComponent == null) {
            log.error((Object)"Drop Component is NULL!");
        }
        boolean clearIt = true;
        if (dropComponent instanceof GhostActionable && dropComponent instanceof JComponent) {
            BufferedImage bi = this.ghostActionable.getBufferedImage();
            this.glassPane.setImage(bi, bi.getWidth());
            this.glassPane.startAnimation(SwingUtilities.convertRectangle(dropComponent, ((JComponent)dropComponent).getVisibleRect(), this.glassPane));
            Component source = e.getComponent();
            if (source instanceof GhostActionable) {
                ((GhostActionable)((Object)dropComponent)).doAction((GhostActionable)((Object)source));
                clearIt = false;
            }
        } else if (this.hasListeners()) {
            GhostDropEvent gde = new GhostDropEvent(c, this.action, eventPoint);
            this.fireGhostDropEvent(gde);
            if (gde.isConsumed()) {
                clearIt = false;
            }
        }
        if (clearIt) {
            this.glassPane.setImage(null);
            this.glassPane.setVisible(false);
            DragAndDropLock.setLocked(false);
        }
    }
}

