/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DragAndDropLock;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GhostMotionAdapter
extends MouseMotionAdapter {
    private static final Cursor HAND_CURSOR = new Cursor(12);
    private static final Cursor DEF_CURSOR = new Cursor(0);
    private GhostGlassPane glassPane;
    private Cursor currCursor = null;

    public GhostMotionAdapter(GhostGlassPane glassPane) {
        this.glassPane = glassPane;
    }

    protected boolean isFlavorOK(GhostActionable srcGA, GhostActionable dstGA) {
        for (DataFlavor srcDF : srcGA.getDragDataFlavors()) {
            for (DataFlavor dstDF : dstGA.getDropDataFlavors()) {
                if (!srcDF.equals(dstDF)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!DragAndDropLock.isDragAndDropStarted()) {
            return;
        }
        Component c = e.getComponent();
        JComponent rootPane = (JComponent)UIRegistry.get("mainpane");
        Point pp = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(pp, c);
        SwingUtilities.convertPointFromScreen(pp, rootPane);
        boolean flavorOK = false;
        Component dropComponent = SwingUtilities.getDeepestComponentAt(rootPane, pp.x, pp.y);
        if (dropComponent instanceof GhostActionable && c != dropComponent) {
            flavorOK = this.isFlavorOK((GhostActionable)((Object)c), (GhostActionable)((Object)dropComponent));
        }
        if (flavorOK) {
            if (this.currCursor != HAND_CURSOR) {
                this.glassPane.setCursor(HAND_CURSOR);
                this.currCursor = HAND_CURSOR;
            }
        } else if (this.currCursor != DEF_CURSOR) {
            this.glassPane.setCursor(DEF_CURSOR);
            this.currCursor = DEF_CURSOR;
        }
        Point p = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(p, c);
        SwingUtilities.convertPointFromScreen(p, this.glassPane);
        this.glassPane.setPoint(p);
        this.glassPane.repaint(this.glassPane.getRepaintRect());
    }
}

