/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.ui.ProgressGlassPane;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.dnd.DragAndDropLock;
import edu.ku.brc.ui.dnd.GhostActionable;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public class GhostGlassPane
extends ProgressGlassPane {
    private static final boolean DEBUG = false;
    private static GhostGlassPane instance = new GhostGlassPane();
    private final int ANIMATION_DELAY = 500;
    private final float STD_ALPHA = 0.7f;
    protected FadeOutAnimation fadeOutAnimation = null;
    protected Timer fadeOutTimer = null;
    protected BufferedImage dragged = null;
    protected Point location = new Point(0, 0);
    protected Point oldLocation = new Point(0, 0);
    protected MouseAdapter mouseAdapter;
    protected int width;
    protected int height;
    protected Rectangle visibleRect = null;
    protected float zoom = 1.0f;
    protected float alpha = 0.7f;
    protected Point newPnt = new Point();
    protected Point oldPnt = new Point();
    protected Point offset = new Point();
    protected ImagePaintMode paintPositionMode = ImagePaintMode.DRAG;
    protected Vector<GhostActionable> actionables = new Vector();
    protected Vector<GhostActionable> enumList = new Vector();

    protected GhostGlassPane() {
        this.setOpaque(false);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                e.consume();
            }
        };
    }

    public static GhostGlassPane getInstance() {
        return instance;
    }

    public void setImage(BufferedImage dragged) {
        this.setImage(dragged, dragged == null ? 0 : dragged.getWidth());
    }

    public void setImage(BufferedImage dragged, int width) {
        if (dragged != null) {
            float ratio = (float)dragged.getWidth() / (float)dragged.getHeight();
            this.width = width;
            this.height = (int)((float)width / ratio);
        }
        this.dragged = dragged;
    }

    public void setOffset(Point offset) {
        this.offset.setLocation(offset);
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setPoint(Point location) {
        this.oldLocation = this.location;
        this.location = location;
        this.paintPositionMode = ImagePaintMode.DRAG;
    }

    public void setPoint(Point location, ImagePaintMode paintPositionMode) {
        this.oldLocation = this.location;
        this.location = location;
        this.paintPositionMode = paintPositionMode;
    }

    public Point getPoint() {
        return this.location;
    }

    protected Rectangle getRepaintRect() {
        this.calcPoints();
        int x = this.newPnt.x - 5;
        int y = this.newPnt.y - 5;
        int x2 = this.oldPnt.x - 5;
        int y2 = this.oldPnt.y - 5;
        int w = (int)((double)((float)this.width * this.zoom) + 10.0);
        int h = (int)((double)((float)this.height * this.zoom) + 10.0);
        return new Rectangle(x, y, w, h).union(new Rectangle(x2, y2, w, h));
    }

    protected void calcPoints() {
        double widthZoom = (float)this.width * this.zoom;
        double heightZoom = (float)this.height * this.zoom;
        this.newPnt.x = 0;
        this.newPnt.y = 0;
        if (this.paintPositionMode == ImagePaintMode.DRAG) {
            this.newPnt.x = (int)(this.location.getX() - widthZoom / 2.0);
            this.newPnt.y = (int)(this.location.getY() - heightZoom / 2.0);
            this.oldPnt.x = (int)(this.oldLocation.getX() - widthZoom / 2.0);
            this.oldPnt.y = (int)(this.oldLocation.getY() - heightZoom / 2.0);
        } else if (this.paintPositionMode == ImagePaintMode.CENTERED) {
            Dimension size = this.getSize();
            int w = size.width - this.dragged.getWidth();
            int h = size.height - this.dragged.getHeight();
            this.newPnt.x = w / 2 + (int)this.location.getX();
            this.newPnt.y = h / 2 + (int)this.location.getY();
            this.oldPnt.x = w / 2 + (int)this.oldLocation.getX();
            this.oldPnt.y = h / 2 + (int)this.oldLocation.getY();
        } else if (this.paintPositionMode == ImagePaintMode.ABSOLUTE) {
            this.newPnt.x = (int)this.location.getX() - this.offset.x;
            this.newPnt.y = (int)this.location.getY() - this.offset.y;
            this.oldPnt.x = (int)this.oldLocation.getX() - this.offset.x;
            this.oldPnt.y = (int)this.oldLocation.getY() - this.offset.y;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.dragged == null) {
            super.paintComponent(g);
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double widthZoom = (float)this.width * this.zoom;
        double heightZoom = (float)this.height * this.zoom;
        this.calcPoints();
        if (this.visibleRect != null) {
            g2.setClip(this.visibleRect);
        }
        RoundRectangle2D.Double rectangle = new RoundRectangle2D.Double((double)this.newPnt.x - 1.0, (double)this.newPnt.y - 1.0, widthZoom + 1.0, heightZoom + 1.0, 8.0, 8.0);
        if (this.visibleRect != null) {
            Area clip = new Area(this.visibleRect);
            g2.setClip(clip);
        } else {
            g2.setClip(rectangle);
        }
        g2.drawImage(this.dragged, this.newPnt.x, this.newPnt.y, (int)widthZoom, (int)heightZoom, null);
        super.paintComponent(g2);
        g2.dispose();
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void resetAlpha() {
        this.alpha = 0.7f;
    }

    public void startAnimation(Rectangle visibleRectArg) {
        this.visibleRect = visibleRectArg;
        this.fadeOutAnimation = new FadeOutAnimation();
        this.fadeOutTimer = new Timer(33, this.fadeOutAnimation);
        this.fadeOutTimer.start();
    }

    public void finishedWithDragAndDrop() {
        this.setVisible(false);
        this.zoom = 1.0f;
        this.alpha = 0.6f;
        this.visibleRect = null;
        this.dragged = null;
        DragAndDropLock.setLocked(false);
        this.fadeOutAnimation = null;
        this.fadeOutTimer = null;
    }

    protected boolean isDropOK(GhostActionable dragActionable, GhostActionable dropActionable) {
        List<DataFlavor> dragList = dragActionable.getDragDataFlavors();
        if (dragList != null) {
            for (DataFlavor dragFlavor : dragList) {
                for (DataFlavor dropFlavor : dropActionable.getDropDataFlavors()) {
                    if (!dragFlavor.equals(dropFlavor)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized void finishDnD() {
        if (this.fadeOutAnimation != null) {
            this.fadeOutTimer.stop();
            this.fadeOutAnimation.setStopNow(true);
            this.finishedWithDragAndDrop();
        }
    }

    public void startDrag(GhostActionable dragActionable) {
        for (GhostActionable dropActionable : this.actionables) {
            if (dragActionable == dropActionable) continue;
            boolean isActive = this.isDropOK(dragActionable, dropActionable);
            dropActionable.setActive(isActive);
            if (dropActionable instanceof RolloverCommand) {
                RolloverCommand rc = (RolloverCommand)dropActionable;
                rc.repaint();
                continue;
            }
            int x = 0;
            ++x;
        }
    }

    public void stopDrag() {
        for (GhostActionable dropActionable : this.actionables) {
            dropActionable.setActive(false);
        }
    }

    public void add(GhostActionable actionable) {
        this.actionables.add(actionable);
    }

    public void remove(GhostActionable actionable) {
        this.actionables.remove(actionable);
    }

    public void clearActionableList() {
        this.actionables.clear();
    }

    public void setMaskingEvents(boolean isMaskingEvents) {
        if (isMaskingEvents) {
            this.addMouseListener(this.mouseAdapter);
        } else {
            this.removeMouseListener(this.mouseAdapter);
        }
    }

    private class FadeOutAnimation
    implements ActionListener {
        private long start = System.currentTimeMillis();
        private boolean stopNow = false;

        FadeOutAnimation() {
            GhostGlassPane.this.oldLocation = GhostGlassPane.this.location;
        }

        public synchronized void setStopNow(boolean stopNow) {
            this.stopNow = stopNow;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long elapsed = System.currentTimeMillis() - this.start;
            if (this.stopNow || elapsed > 500L) {
                ((Timer)e.getSource()).stop();
                GhostGlassPane.this.finishedWithDragAndDrop();
            } else {
                GhostGlassPane.this.alpha = 0.6f - 0.6f * (float)elapsed / 500.0f;
                GhostGlassPane.this.zoom = 1.0f + 3.0f * ((float)elapsed / 500.0f);
            }
            GhostGlassPane.this.repaint(GhostGlassPane.this.getRepaintRect());
        }
    }

    public static enum ImagePaintMode {
        CENTERED,
        DRAG,
        ABSOLUTE;

    }
}

