/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.ui.dnd.GhostDropEvent;
import edu.ku.brc.ui.dnd.GhostDropListener;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GhostDropAdapter
extends MouseAdapter {
    protected GhostGlassPane glassPane;
    protected String action;
    private List<GhostDropListener> listeners;

    public GhostDropAdapter(GhostGlassPane glassPane, String action) {
        this.glassPane = glassPane;
        this.action = action;
        this.listeners = new ArrayList<GhostDropListener>();
    }

    public void addGhostDropListener(GhostDropListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeGhostDropListener(GhostDropListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireGhostDropEvent(GhostDropEvent evt) {
        Iterator<GhostDropListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().ghostDropped(evt);
        }
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }
}

