/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui.dnd;

import edu.ku.brc.ui.dnd.AbstractGhostDropManager;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostDropEvent;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GhostActionableDropManager
extends AbstractGhostDropManager {
    private GhostActionable ghostActionable;
    private GhostGlassPane glassPane;

    public GhostActionableDropManager(GhostGlassPane glassPane, JComponent target, GhostActionable ghostActionable) {
        super(target);
        this.glassPane = glassPane;
        this.ghostActionable = ghostActionable;
    }

    @Override
    public void ghostDropped(GhostDropEvent e) {
        Point p = this.getTranslatedPoint(e.getDropLocation());
        if (this.isInTarget(p)) {
            BufferedImage bi = this.ghostActionable.getBufferedImage();
            this.glassPane.setImage(bi, bi.getWidth());
            this.glassPane.startAnimation(SwingUtilities.convertRectangle(this.component, this.component.getVisibleRect(), this.glassPane));
            Component source = e.getComponent();
            if (this.component instanceof GhostActionable && source instanceof GhostActionable) {
                ((GhostActionable)((Object)this.component)).doAction((GhostActionable)((Object)source));
            }
            e.setConsumed(true);
        } else {
            this.component.isShowing();
        }
    }
}

