/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.UIHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class VerticalSeparator
extends JComponent {
    protected Color bgColor;
    protected Color fgColor;
    protected int preferredWidth = 10;
    protected static BasicStroke lineStroke = new BasicStroke(1.5f, 2, 2);

    public VerticalSeparator(Color fgColor, Color bgColor) {
        this.bgColor = bgColor;
        this.fgColor = fgColor;
    }

    public VerticalSeparator(Color fgColor, Color bgColor, int preferredWidth) {
        this.bgColor = bgColor;
        this.fgColor = fgColor;
        this.preferredWidth = preferredWidth;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(UIHelper.createTextRenderingHints());
        g2d.setStroke(lineStroke);
        Dimension size = this.getSize();
        int x = size.width / 2;
        g.setColor(this.bgColor);
        g.drawLine(x, 2, x, size.height - 1);
        g.setColor(this.fgColor);
        g.drawLine(x - 2, 0, x - 2, size.height - 3);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = Math.max(size.width, 4);
        size.width = this.preferredWidth;
        return size;
    }
}

