/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JLabel;

public class VectorLabel
extends JLabel {
    protected boolean isDrawHighlight = false;
    protected boolean isRoundedRect = false;
    protected boolean isDrawInnerBlock = false;
    protected boolean isBorderPainted = false;
    protected Color textColor = null;
    protected Color textColorShadow = null;

    public VectorLabel(String text) {
        super(text);
        this.setTextColor(Color.BLACK);
    }

    public VectorLabel(String text, boolean doLiquid) {
        super(text);
        this.setTextColor(Color.BLACK);
        this.isDrawHighlight = doLiquid;
        this.isRoundedRect = doLiquid;
        this.isDrawInnerBlock = doLiquid;
    }

    public VectorLabel(String text, int align) {
        super(text, align);
        this.setTextColor(Color.BLACK);
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        float scale = 1.6666666f * this.getFont().getSize2D();
        int w = fm.stringWidth(text);
        int h = fm.getHeight();
        return new Dimension(w += (int)(scale * 1.4f), h += (int)(scale * 0.3f));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        float scale = 1.6666666f * this.getFont().getSize2D();
        this.drawLiquidButton(this.getForeground(), this.getWidth(), this.getHeight(), this.getText(), scale, g2);
    }

    protected void drawLiquidButton(Color base, int width, int height, String text, float scale, Graphics2D g2) {
        int inset = (int)(scale * 0.04f);
        int w = width - inset * 2;
        int h = height - (int)(scale * 0.1f) - 1;
        g2.translate(inset, 0);
        this.drawDropShadow(w, h, scale, g2);
        this.drawButtonBody(w, h, scale, base, g2);
        this.drawText(w, h, scale, text, g2);
        if (this.isDrawHighlight) {
            this.drawHighlight(w, scale, g2);
        }
        if (this.isBorderPainted()) {
            this.drawBorder(w, h, scale, g2);
        }
        g2.translate(-inset, 0);
    }

    protected void drawDropShadow(int w, int h, float scale, Graphics2D g2) {
        g2.setColor(new Color(0, 0, 0, 50));
        this.fillRoundRect(g2, -0.04f * scale, 0.02f * scale, (float)w + 0.08f * scale, (float)h + 0.08f * scale, scale * 1.04f, scale * 1.04f);
        g2.setColor(new Color(0, 0, 0, 100));
        this.fillRoundRect(g2, 0.0f, 0.06f * scale, w, h, scale, scale);
    }

    protected void drawButtonBody(int w, int h, float scale, Color base, Graphics2D g2) {
        Color grad_top = base.brighter();
        Color grad_bot = base.darker();
        GradientPaint bg = new GradientPaint(new Point(0, 0), grad_top, new Point(0, h), grad_bot);
        g2.setPaint(bg);
        this.fillRoundRect(g2, 0.0f * scale, 0.0f * scale, w, h, 1.0f * scale, 1.0f * scale);
        if (this.isDrawInnerBlock) {
            Color inner = base.brighter();
            inner = VectorLabel.alphaColor(inner, 75);
            g2.setColor(inner);
            this.fillRoundRect(g2, scale * 0.4f, scale * 0.4f, (float)w - scale * 0.8f, (float)h - scale * 0.5f, scale * 0.6f, scale * 0.4f);
        }
    }

    protected void drawText(int w, int h, float scale, String text, Graphics2D g2) {
        int fw = g2.getFontMetrics().stringWidth(text);
        int fh = g2.getFontMetrics().getAscent() - g2.getFontMetrics().getDescent();
        int textx = this.getHorizontalAlignment() == 2 ? Math.max(this.getInsets().left, 2) : (w - fw) / 2;
        int texty = h / 2 + fh / 2;
        g2.setColor(this.textColorShadow);
        g2.drawString(text, (int)((float)textx + scale * 0.04f), (int)((float)texty + scale * 0.04f));
        g2.setColor(this.textColor);
        g2.drawString(text, textx, texty);
    }

    protected void drawHighlight(int w, float scale, Graphics2D g2) {
        GradientPaint highlight = new GradientPaint(new Point2D.Float(scale * 0.2f, scale * 0.2f), new Color(255, 255, 255, 175), new Point2D.Float(scale * 0.2f, scale * 0.55f), new Color(255, 255, 255, 0));
        g2.setPaint(highlight);
        this.fillRoundRect(g2, scale * 0.2f, scale * 0.1f, (float)w - scale * 0.4f, scale * 0.4f, scale * 0.8f, scale * 0.4f);
        this.drawRoundRect(g2, scale * 0.2f, scale * 0.1f, (float)w - scale * 0.4f, scale * 0.4f, scale * 0.8f, scale * 0.4f);
    }

    protected void drawBorder(int w, int h, float scale, Graphics2D g2) {
        g2.setColor(new Color(0, 0, 0, 150));
        this.drawRoundRect(g2, scale * 0.0f, scale * 0.0f, w, h, scale, scale);
    }

    protected void fillRoundRect(Graphics2D g2, float x, float y, float w, float h, float ax, float ay) {
        if (this.isRoundedRect) {
            g2.fillRoundRect((int)x, (int)y, (int)w, (int)h, (int)ax, (int)ay);
        } else {
            g2.fillRoundRect((int)x, (int)y, (int)w, (int)h, 0, 0);
        }
    }

    protected void drawRoundRect(Graphics2D g2, float x, float y, float w, float h, float ax, float ay) {
        if (this.isRoundedRect) {
            g2.drawRoundRect((int)x, (int)y, (int)w, (int)h, (int)ax, (int)ay);
        } else {
            g2.drawRoundRect((int)x, (int)y, (int)w, (int)h, 0, 0);
        }
    }

    protected static Color alphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public boolean isDrawHighlight() {
        return this.isDrawHighlight;
    }

    public void setDrawHighlight(boolean isDrawHighlight) {
        this.isDrawHighlight = isDrawHighlight;
    }

    public boolean isDrawInnerBlock() {
        return this.isDrawInnerBlock;
    }

    public void setDrawInnerBlock(boolean isdrawInnerBlock) {
        this.isDrawInnerBlock = isdrawInnerBlock;
    }

    public boolean isRoundedRect() {
        return this.isRoundedRect;
    }

    public void setRoundedRect(boolean isRoundedRect) {
        this.isRoundedRect = isRoundedRect;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.textColorShadow = new Color(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), 70);
    }

    public boolean isBorderPainted() {
        return this.isBorderPainted;
    }

    public void setBorderPainted(boolean isBorderPainted) {
        this.isBorderPainted = isBorderPainted;
    }
}

