/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UnhandledExceptionDialog
extends JDialog {
    public UnhandledExceptionDialog(String message, Exception exception) {
        this(message, (Throwable)exception);
    }

    public UnhandledExceptionDialog(String message, Throwable exception) {
        super(UIRegistry.getTopWindow() instanceof Frame ? (Frame)UIRegistry.getTopWindow() : null, UIRegistry.getResourceString("UnhandledExceptionTitle"), true);
        this.createUI(message, exception);
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(1);
        this.setAlwaysOnTop(true);
    }

    public UnhandledExceptionDialog(String message) {
        super(UIRegistry.getTopWindow() instanceof Frame ? (Frame)UIRegistry.getTopWindow() : null, UIRegistry.getResourceString("UnhandledExceptionTitle"), true);
        this.createUI(message, null);
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(1);
        this.setAlwaysOnTop(true);
    }

    public UnhandledExceptionDialog(Throwable throwable) {
        super(UIRegistry.getTopWindow() instanceof Frame ? (Frame)UIRegistry.getTopWindow() : null, UIRegistry.getResourceString("UnhandledExceptionTitle"), true);
        this.createUI(throwable.getMessage(), throwable);
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(1);
        this.setAlwaysOnTop(true);
    }

    protected void createUI(String message, Throwable throwable) {
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
        this.setDefaultCloseOperation(2);
        this.setModal(false);
        int height = 100;
        PanelBuilder builder = new PanelBuilder(new FormLayout("p:g,1dlu,r:p:g", "p," + (throwable != null ? "10px,p,2px,f:p:g," : "") + "5px,p"));
        CellConstraints cc = new CellConstraints();
        int rowIndex = 1;
        JTextArea messageTA = new JTextArea(message);
        messageTA.setEditable(false);
        builder.add((Component)new JScrollPane(messageTA, 20, 30), cc.xyw(1, 1, 3));
        rowIndex += 2;
        JTextArea stackTraceTA = null;
        JScrollPane stackTraceScrollPane = null;
        if (throwable != null) {
            StringWriter strWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(strWriter);
            throwable.printStackTrace(pw);
            if (throwable.getCause() != null) {
                throwable.getCause().printStackTrace(pw);
            }
            UIHelper.createLabel("");
            stackTraceTA = new JTextArea(strWriter.getBuffer().toString().replace("\t", "    "));
            stackTraceTA.setEditable(false);
            stackTraceScrollPane = new JScrollPane(stackTraceTA, 20, 30);
            stackTraceTA.setRows(15);
            builder.add((Component)UIHelper.createLabel("Stack Trace", 0), cc.xyw(1, rowIndex, 3));
            builder.add((Component)stackTraceScrollPane, cc.xyw(1, rowIndex += 2, 3));
            rowIndex += 2;
            height += 300;
        }
        JButton okBtn = UIHelper.createButton(UIRegistry.getResourceString("OK"));
        builder.add((Component)okBtn, cc.xyw(3, rowIndex, 1));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UnhandledExceptionDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(okBtn);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        panel.add((Component)builder.getPanel(), "Center");
        this.setContentPane(panel);
        this.setSize(new Dimension(500, height));
    }
}

