/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.ViewBasedDialogFactoryIFace;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.exceptions.UIException;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.ui.tmanfe.SearchReplacePanel;
import edu.ku.brc.util.FileCache;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UIRegistry {
    protected static final String MISSING_FACTORY_MSG = "The object has not been set for the ViewBasedDialogFactoryIFace. This class can be used without first setting a factory implementing this interface.";
    protected static final String EMBEDDED_DB_PATH = "embedded.dbpath";
    protected static final String MOBILE_EMBEDDED_DB_PATH = "mobile.embedded.dbpath";
    protected static final String EMBEDDED_DB_DIR = "SPECIFY_DATA";
    protected static final boolean debugPaths = false;
    public static final String FRAME = "frame";
    public static final String MENUBAR = "menubar";
    public static final String TOOLBAR = "toolbar";
    public static final String GLASSPANE = "glasspane";
    public static final String MAINPANE = "mainpane";
    public static final String RECENTFRAME = "recentframe";
    public static final String UNDO = "Undo";
    public static final String REDO = "Redo";
    public static final String CUT = "Cut";
    public static final String COPY = "Copy";
    public static final String PASTE = "Paste";
    public static final String FIND = "Find";
    public static final String INSERT = "Insert";
    public static final String ADD = "Add";
    public static final String DELETE = "Delete";
    public static final String Clear = "Clear";
    public static final String LONGTERM_CACHE_MAP = "longterm-cache-map.xml";
    private static final Logger log = Logger.getLogger(UIRegistry.class);
    protected static final UIRegistry instance = new UIRegistry();
    protected static Rectangle frameRect = null;
    protected static GhostGlassPane oldGlassPane = null;
    protected static boolean showingGlassPane = false;
    protected static boolean isRelease = false;
    protected static boolean isTesting = false;
    protected static int STD_WAIT_TIME = 2000;
    public static int STD_FONT_SIZE = 20;
    protected static Boolean isEmbedded = null;
    protected static Boolean isMobile = null;
    protected HashMap<String, Component> components = new HashMap();
    protected Window topWindow = null;
    protected Stack<Window> windowStack = new Stack();
    protected HashMap<String, HashMap<String, JComponent>> uiItems = new HashMap();
    protected Font baseFont = null;
    protected Font defaultFont = null;
    protected FileCache longTermCache = null;
    protected FileCache shortTermCache = null;
    protected FileCache formsCache = null;
    protected JStatusBar statusBar = null;
    protected String defaultWorkingPath = null;
    protected String userDataDir = null;
    protected String appDataDir = null;
    protected String appName = null;
    protected ResourceBundle resourceBundle = null;
    protected Stack<ResBundleInfo> resBundleStack = new Stack();
    protected String resourceName = "resources";
    protected Locale resourceLocale = Locale.getDefault();
    protected Locale platformLocale = Locale.getDefault();
    protected static boolean doShowAllResStrErors = false;
    protected ViewBasedDialogFactoryIFace viewbasedFactory = null;
    protected HashMap<String, Action> actionMap = new HashMap();
    protected static UndoAction undoAction;
    protected static RedoAction redoAction;
    protected static LaunchFindReplaceAction launchFindReplaceAction;
    protected HashMap<Object, Action> actions = null;
    protected static Component permanentFocusOwner;
    protected static SoftReference<BufferedImage> glassPaneBufferedImageSR;

    static {
        permanentFocusOwner = null;
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
        UIRegistry.instance.baseFont = new JLabel("").getFont();
        UIRegistry.instance.baseFont = UIRegistry.instance.baseFont.deriveFont(0);
        final KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propName = e.getPropertyName();
                if (propName.equals("permanentFocusOwner")) {
                    permanentFocusOwner = focusManager.getFocusOwner();
                }
                if ("focusOwner".equals(propName) && undoAction != null && redoAction != null) {
                    if (focusManager.getFocusOwner() instanceof UndoableTextIFace) {
                        UndoableTextIFace undoableText = (UndoableTextIFace)((Object)focusManager.getFocusOwner());
                        if (undoableText != null) {
                            undoAction.setUndoManager(undoableText.getUndoManager());
                            redoAction.setUndoManager(undoableText.getUndoManager());
                        }
                    } else if (focusManager.getFocusOwner() instanceof JTextComponent) {
                        undoAction.setUndoManager(null);
                        redoAction.setUndoManager(null);
                    }
                    undoAction.updateUndoState();
                    redoAction.updateRedoState();
                }
            }
        });
    }

    private UIRegistry() {
        if (this.resourceBundle == null) {
            this.resourceBundle = UIRegistry.getResourceBundle(this.resourceName);
        }
    }

    public static UIRegistry getInstance() {
        return instance;
    }

    public static String getAppVersion() {
        return UIRegistry.getResourceString("SPECIFY_VERSION");
    }

    public static boolean doesAppversionsMatch() {
        String install4J = UIHelper.getInstall4JInstallString();
        String resAppVersion = UIRegistry.getAppVersion();
        if (StringUtils.isEmpty((String)install4J) || StringUtils.isEmpty((String)resAppVersion) || !resAppVersion.equals(install4J)) {
            UIRegistry.showLocalizedError("APPVER_MISMATCH", install4J, resAppVersion);
            return false;
        }
        return true;
    }

    public static Locale getPlatformLocale() {
        return UIRegistry.instance.platformLocale;
    }

    public static ResourceBundle getResourceBundle(String name) {
        ResourceBundle resBundle = null;
        try {
            if (instance == null || UIRegistry.instance.resourceLocale == null) {
                resBundle = ResourceBundle.getBundle(name);
            } else {
                try {
                    resBundle = ResourceBundle.getBundle(name, UIRegistry.instance.resourceLocale);
                }
                catch (MissingResourceException ex) {
                    resBundle = ResourceBundle.getBundle(name, Locale.ENGLISH);
                }
            }
        }
        catch (MissingResourceException ex) {
            log.error((Object)("Couldn't find Resource Bundle Name[" + name + "]"), (Throwable)ex);
        }
        return resBundle;
    }

    public Locale getResourceLocale() {
        return this.resourceLocale;
    }

    public static void setResourceLocale(Locale resourceLocale) {
        if (!UIRegistry.instance.resourceLocale.equals(resourceLocale)) {
            UIRegistry.instance.resourceLocale = resourceLocale;
            UIRegistry.instance.resourceBundle = UIRegistry.getResourceBundle(UIRegistry.instance.resourceName);
        }
    }

    protected ResourceBundle pushInternal(String name, ResourceBundle rb) {
        this.resBundleStack.push(new ResBundleInfo(name, rb));
        return rb;
    }

    public static ResourceBundle push(String name, ResourceBundle rb) {
        instance.pushInternal(UIRegistry.instance.resourceName, UIRegistry.instance.resourceBundle);
        UIRegistry.instance.resourceBundle = rb;
        UIRegistry.instance.resourceName = name;
        return rb;
    }

    public static ResourceBundle loadAndPushResourceBundle(String resName) {
        ResourceBundle rb = UIRegistry.getResourceBundle(resName);
        if (rb != null) {
            UIRegistry.push(resName, rb);
        }
        return rb;
    }

    public static ResourceBundle popResourceBundle() {
        if (UIRegistry.instance.resBundleStack.size() > 0) {
            ResBundleInfo rbi = UIRegistry.instance.resBundleStack.pop();
            UIRegistry.instance.resourceBundle = rbi.getResBundle();
            UIRegistry.instance.resourceName = rbi.getName();
        } else {
            log.error((Object)"Tried to pop empty ResourceBundle Stack");
        }
        return UIRegistry.instance.resourceBundle;
    }

    protected static ResourceBundle getResourceBundleInternal() {
        return instance.getResourceBundle();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /*
     * Unable to fully structure code
     */
    protected String getResourceStringInternal(String key) {
        block8: {
            if (!StringUtils.isEmpty((String)key)) break block8;
            UIRegistry.log.warn((Object)("The key [" + key + "] was null/empty for localization"));
            return "";
        }
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            if (this.resBundleStack.size() == 0 || UIRegistry.doShowAllResStrErors) {
                UIRegistry.log.warn((Object)("Couldn't find key[" + key + "] in resource bundle [" + this.resourceName + "]"));
            }
            i = this.resBundleStack.size() - 1;
            ** while (i > -1)
        }
lbl-1000:
        // 1 sources

        {
            ri = (ResBundleInfo)this.resBundleStack.elementAt(i);
            try {
                return ri.getResBundle().getString(key);
            }
            catch (MissingResourceException mre) {
                if (i == 0 || UIRegistry.doShowAllResStrErors) {
                    UIRegistry.log.error((Object)("Couldn't find key[" + key + "] in resource bundle [" + ri.getName() + "]"));
                }
                --i;
            }
            continue;
        }
lbl21:
        // 1 sources

        return key;
    }

    public static void setDoShowAllResStrErors(boolean doShowAllResStrErors) {
        UIRegistry.doShowAllResStrErors = doShowAllResStrErors;
    }

    public static String getResourceString(String key) {
        return instance.getResourceStringInternal(key);
    }

    public static String getFormattedResStr(String key, Object ... params) {
        return String.format(instance.getResourceStringInternal(key), params);
    }

    public static Component getPermanentFocusOwner() {
        return permanentFocusOwner;
    }

    public static boolean isRelease() {
        return isRelease;
    }

    public static void setRelease(boolean isRelease) {
        UIRegistry.isRelease = isRelease;
    }

    public static boolean isTesting() {
        return isTesting;
    }

    public static void setTesting(boolean isTesting) {
        UIRegistry.isTesting = isTesting;
    }

    public static JStatusBar getStatusBar() {
        return UIRegistry.instance.statusBar;
    }

    public static void setStatusBar(JStatusBar statusBar) {
        UIRegistry.instance.statusBar = statusBar;
    }

    public static void setDefaultWorkingPath(String defaultWorkingPath) {
        File path = new File(defaultWorkingPath);
        String defPath = defaultWorkingPath;
        try {
            defPath = path.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        UIRegistry.dumpCanonicalPath("setDefaultWorkingPath", defPath);
        UIRegistry.instance.defaultWorkingPath = defPath;
    }

    public static String getDefaultWorkingPath() {
        if (UIRegistry.instance.defaultWorkingPath == null) {
            File file = new File(".");
            UIRegistry.instance.defaultWorkingPath = UIHelper.stripSubDirs(file.getAbsolutePath(), 1);
            log.debug((Object)("Working Path not set, setting it to[" + UIRegistry.instance.defaultWorkingPath + "]"));
        }
        return UIRegistry.instance.defaultWorkingPath;
    }

    public static File getAppDataSubDir(String dirName, boolean createIt) {
        File newDir = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + dirName);
        if (!newDir.exists() && createIt && !newDir.mkdirs()) {
            return null;
        }
        return newDir;
    }

    public static void setBaseAppDataDir(String appDataDir) {
        UIRegistry.dumpCanonicalPath("setBaseAppDataDir", appDataDir);
        UIRegistry.instance.appDataDir = appDataDir;
    }

    public static String getAppDataDir() {
        File dir = UIRegistry.instance.appDataDir == null ? new File(UIRegistry.getUserHomeAppDir()) : (UIRegistry.instance.appDataDir.equals(".") ? new File(String.valueOf(UIHelper.stripSubDirs(new File(".").getAbsolutePath(), 1)) + File.separator + UIRegistry.instance.appName) : new File(String.valueOf(UIRegistry.instance.appDataDir) + File.separator + UIRegistry.instance.appName));
        if (!dir.exists() && !dir.mkdir()) {
            throw new RuntimeException("Couldn't create data directory for " + UIRegistry.instance.appName + " [" + dir.getAbsolutePath() + "]");
        }
        try {
            return dir.getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return dir.getAbsolutePath();
        }
    }

    public static String getUserHomeAppDir() {
        assert (UIRegistry.instance.appName == null);
        return String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + UIRegistry.instance.appName;
    }

    public static String getUserHomeDir() {
        return UIRegistry.isMobile() ? UIRegistry.getDefaultWorkingPath() : UIRegistry.getDefaultUserHomeDir();
    }

    public static String getDefaultUserHomeDir() {
        String docPath;
        String homeDir = System.getProperty("user.home");
        UIHelper.OSTYPE osType = UIHelper.getOSType();
        if (osType == UIHelper.OSTYPE.Windows) {
            String appDataLoc = System.getenv("LOCALAPPDATA");
            return StringUtils.isNotEmpty((String)appDataLoc) ? appDataLoc : homeDir;
        }
        if (osType == UIHelper.OSTYPE.MacOSX && new File(docPath = String.valueOf(homeDir) + File.separator + "Documents").exists()) {
            return docPath;
        }
        return homeDir;
    }

    public static void dumpPaths() {
        String mobile = "";
        try {
            if (StringUtils.isNotEmpty((String)UIRegistry.getMobileEmbeddedDBPath())) {
                mobile = new File(UIRegistry.getMobileEmbeddedDBPath()).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getAppName() {
        return UIRegistry.instance.appName;
    }

    public static void setAppName(String appName) {
        if (!StringUtils.isNotEmpty((String)appName) || !StringUtils.isEmpty((String)UIRegistry.instance.appName)) {
            throw new RuntimeException("You cannot set the app name twice or with an empty string!");
        }
        UIRegistry.instance.appName = appName;
    }

    public static void registerUI(String category, String name, JComponent uiComp) throws UIException {
        HashMap<String, JComponent> compsHash = UIRegistry.instance.uiItems.get(category);
        if (compsHash == null) {
            compsHash = new HashMap();
            UIRegistry.instance.uiItems.put(category, compsHash);
        }
        if (compsHash.containsKey(name)) {
            throw new UIException("UI component with Name[" + name + "] has already been registered to [" + category + "].");
        }
        compsHash.put(name, uiComp);
    }

    public static void unregisterUI(String category, String name) throws UIException {
        HashMap<String, JComponent> compsHash = UIRegistry.instance.uiItems.get(category);
        if (compsHash == null) {
            throw new UIException("Couldn't find UI Category with Name[" + category + "].");
        }
        JComponent comp = compsHash.get(name);
        if (comp == null) {
            throw new UIException("Couldn't find UI component with Name[" + name + "].");
        }
        compsHash.remove(comp);
    }

    public static Component get(String name) {
        return UIRegistry.instance.components.get(name);
    }

    public static Window getTopWindow() {
        return UIRegistry.instance.topWindow;
    }

    public static void setTopWindow(Window window) {
        UIRegistry.instance.topWindow = window;
    }

    public static Window getMostRecentWindow() {
        Window recent = UIRegistry.instance.windowStack.size() > 0 ? UIRegistry.instance.windowStack.peek() : null;
        return recent == null || !recent.isVisible() ? UIRegistry.instance.topWindow : recent;
    }

    public static void pushWindow(Window window) {
        UIRegistry.instance.windowStack.push(window);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Window popWindow(Window requester) {
        if (UIRegistry.instance.windowStack.size() > 0) {
            int index = UIRegistry.instance.windowStack.indexOf(requester);
            if (index == -1) {
                log.error((Object)"Trying to pop Window not on the stack ");
                return null;
            } else {
                if (index >= UIRegistry.instance.windowStack.size() - 1) return UIRegistry.instance.windowStack.pop();
                log.error((Object)("Popping Window lower on Window stack than the Top [" + (UIRegistry.instance.windowStack.size() - 1) + "] poping index[" + index + "]"));
                while (UIRegistry.instance.windowStack.peek() != requester) {
                    UIRegistry.instance.windowStack.pop();
                }
            }
            return null;
        } else {
            log.error((Object)"Trying to pop Window off an empty stack.");
        }
        return null;
    }

    public static String getLocalizedMessage(String key, Object ... args) {
        return String.format(UIRegistry.getResourceString(key), args);
    }

    public static ViewBasedDialogFactoryIFace getViewbasedFactory() {
        if (UIRegistry.instance.viewbasedFactory == null) {
            String className = System.getProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", null);
            if (StringUtils.isNotEmpty((String)className)) {
                try {
                    UIRegistry.instance.viewbasedFactory = (ViewBasedDialogFactoryIFace)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    InternalError error = new InternalError("Can't instantiate ViewBasedDialogFactoryIFace factory " + className);
                    error.initCause(e);
                    throw error;
                }
            } else {
                throw new InternalError(MISSING_FACTORY_MSG);
            }
        }
        return UIRegistry.instance.viewbasedFactory;
    }

    public static void showLocalizedMsg(int iconType, String titleKey, String msgKey, Object ... args) {
        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), args.length == 0 ? UIRegistry.getResourceString(msgKey) : String.format(UIRegistry.getResourceString(msgKey), args), UIRegistry.getResourceString(StringUtils.isNotEmpty((String)titleKey) ? titleKey : "WARNING"), iconType);
    }

    public static void showLocalizedMsg(String msgKey) {
        UIRegistry.showLocalizedMsg(2, "WARNING", msgKey, new Object[0]);
    }

    public static void showLocalizedMsg(String titleKey, String msgKey, Object ... args) {
        UIRegistry.showLocalizedMsg(2, titleKey, msgKey, args);
    }

    public static int askYesNoLocalized(String yesKey, String noKey, String nonL10NMsg, String titleKey) {
        int userChoice = 1;
        Object[] options = new Object[]{UIRegistry.getResourceString(yesKey), UIRegistry.getResourceString(noKey)};
        userChoice = JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), nonL10NMsg, UIRegistry.getResourceString(titleKey), 0, 3, null, options, options[0]);
        return userChoice;
    }

    public static int askYesNoLocalized(String yesKey, String noKey, String cancelKey, String nonL10NMsg, String titleKey) {
        int userChoice = 2;
        Object[] options = new Object[]{UIRegistry.getResourceString(yesKey), UIRegistry.getResourceString(noKey), UIRegistry.getResourceString(cancelKey)};
        userChoice = JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), nonL10NMsg, UIRegistry.getResourceString(titleKey), 1, 3, null, options, options[0]);
        return userChoice;
    }

    public static String askForString(String lblKey, String titleKey, String msgKey, boolean doMustHaveValue) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p" + (StringUtils.isNotEmpty((String)msgKey) ? ",4px,p:g" : "")));
        final ValTextField vt = new ValTextField(32);
        vt.setRequired(doMustHaveValue);
        pb.add((Component)UIHelper.createI18NFormLabel(lblKey), cc.xy(1, 1));
        pb.add((Component)vt, cc.xy(3, 1));
        if (StringUtils.isNotEmpty((String)msgKey)) {
            pb.add((Component)UIHelper.createI18NLabel(msgKey), cc.xyw(1, 3, 3));
        }
        pb.setDefaultDialogBorder();
        final CustomDialog dlg = new CustomDialog(null, UIRegistry.getResourceString(titleKey), true, doMustHaveValue ? 1 : 3, (Component)pb.getPanel());
        dlg.createUI();
        dlg.getOkBtn().setEnabled(false);
        vt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                dlg.getOkBtn().setEnabled(StringUtils.isNotEmpty((String)vt.getText()));
            }
        });
        UIHelper.centerAndShow(dlg);
        return vt.getText();
    }

    public static void showError(String msg) {
        UIRegistry.showError(null, msg);
    }

    public static void showError(Integer dlgType, String msg) {
        log.error((Object)msg);
        String titleKey = dlgType != null && dlgType == 2 ? "WARNING" : "UIRegistry.UNRECOVERABLE_ERROR_TITLE";
        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), msg, UIRegistry.getResourceString(titleKey), dlgType == null ? 0 : dlgType);
    }

    public static void showErrorNonModal(String msg) {
        log.error((Object)msg);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        pb.add((Component)UIHelper.createLabel(msg), cc.xy(1, 1));
        pb.setDefaultDialogBorder();
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("UIRegistry.UNRECOVERABLE_ERROR_TITLE"), false, 1, (Component)pb.getPanel());
        dlg.setVisible(true);
    }

    public static void showLocalizedError(String key) {
        UIRegistry.showError(null, UIRegistry.getResourceString(key));
    }

    public static void showLocalizedError(Integer dlgType, String key) {
        UIRegistry.showError(dlgType, UIRegistry.getResourceString(key));
    }

    public static void showLocalizedError(String key, Object ... args) {
        UIRegistry.showError(String.format(UIRegistry.getResourceString(key), args));
    }

    public static void showLocalizedError(Integer dlgType, String key, Object ... args) {
        UIRegistry.showError(dlgType, String.format(UIRegistry.getResourceString(key), args));
    }

    public static void register(String name, Component uiComp) {
        if (uiComp != null) {
            if (UIRegistry.instance.components.get(name) != null) {
                throw new RuntimeException("Registering a uiComp with an existing name[" + name + "]");
            }
        } else {
            throw new NullPointerException("Trying to register a null UI Component!");
        }
        UIRegistry.instance.components.put(name, uiComp);
    }

    public static void unregister(String name) {
        if (name != null) {
            if (UIRegistry.instance.components.get(name) == null) {
                throw new RuntimeException("Unregistering a uiComp that has been registered [" + name + "]");
            }
        } else {
            throw new NullPointerException("Trying to unregister with a null name!");
        }
        UIRegistry.instance.components.remove(name);
    }

    public static void displayStatusBarText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UIRegistry.instance.statusBar != null) {
                    UIRegistry.instance.statusBar.setText(text == null ? "" : text);
                }
            }
        });
    }

    public static void displayStatusBarErrMsg(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UIRegistry.instance.statusBar != null && text != null) {
                    UIRegistry.instance.statusBar.setErrorMessage(text);
                }
            }
        });
    }

    public static void displayLocalizedStatusBarText(String key, Object ... args) {
        if (key == null) {
            throw new NullPointerException("Call to displayLocalizedStatusBarText cannot be null!");
        }
        String localizedStr = instance.getResourceStringInternal(key);
        assert (localizedStr != null) : "Localized String for key[" + key + "]";
        UIRegistry.displayStatusBarText(String.format(localizedStr, args));
    }

    public static void displayLocalizedStatusBarError(String key, Object ... args) {
        if (key == null) {
            throw new NullPointerException("Call to displayLocalizedStatusBarText cannot be null!");
        }
        String localizedStr = instance.getResourceStringInternal(key);
        assert (localizedStr != null) : "Localized String for key[" + key + "]";
        UIRegistry.displayStatusBarErrMsg(String.format(localizedStr, args));
    }

    public static void forceTopFrameRepaint() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = (JFrame)UIRegistry.instance.topWindow;
                if (!$assertionsDisabled && frame == null) {
                    throw new AssertionError((Object)"The top frame has not been registered");
                }
                frame.repaint();
            }
        });
    }

    public static GhostGlassPane getGlassPane() {
        return (GhostGlassPane)UIRegistry.instance.components.get(GLASSPANE);
    }

    public static void displayErrorDlg(String msg) {
        JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), msg, UIRegistry.getResourceString("Error"), 0);
    }

    public static void displayErrorDlgLocalized(String key, Object ... args) {
        JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString(key), args), UIRegistry.getResourceString("Error"), 0);
    }

    public static void displayInfoMsgDlgLocalized(String key, Object ... args) {
        JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString(key), args), UIRegistry.getResourceString("INFORMATION"), 1);
    }

    public static void displayInfoMsgDlg(String msg) {
        JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), msg, UIRegistry.getResourceString("INFORMATION"), 1);
    }

    public static boolean displayConfirm(String title, String msg, String keyBtn1, String keyBtn2, int iconOption) {
        Object[] options = new Object[]{keyBtn1, keyBtn2};
        return JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), msg, title, 0, iconOption, null, options, options[1]) == 0;
    }

    public static boolean displayConfirmLocalized(String titleKey, String msgKey, String keyBtn1, String keyBtn2, int iconOption) {
        return UIRegistry.displayConfirm(UIRegistry.getResourceString(titleKey), UIRegistry.getResourceString(msgKey), UIRegistry.getResourceString(keyBtn1), UIRegistry.getResourceString(keyBtn2), iconOption);
    }

    public static int displayConfirm(String title, String msg, String keyBtn1, String keyBtn2, String keyBtn3, int iconOption) {
        Object[] options = new Object[]{keyBtn1, keyBtn2, keyBtn3};
        return JOptionPane.showOptionDialog(UIRegistry.getMostRecentWindow(), msg, title, 1, iconOption, null, options, options[2]);
    }

    public static int displayConfirmLocalized(String titleKey, String msgKey, String keyBtn1, String keyBtn2, String keyBtn3, int iconOption) {
        return UIRegistry.displayConfirm(UIRegistry.getResourceString(titleKey), UIRegistry.getResourceString(msgKey), UIRegistry.getResourceString(keyBtn1), UIRegistry.getResourceString(keyBtn2), UIRegistry.getResourceString(keyBtn3), iconOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCache getLongTermFileCache() {
        UIRegistry uIRegistry = instance;
        synchronized (uIRegistry) {
            if (UIRegistry.instance.longTermCache == null) {
                try {
                    UIRegistry.instance.longTermCache = new FileCache("longTerm.Cache");
                    UIRegistry.instance.longTermCache.setMaxCacheSize(20000);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(UIRegistry.class, ex);
                    ex.printStackTrace();
                    log.error((Object)ex);
                }
            }
        }
        return UIRegistry.instance.longTermCache;
    }

    public static void setLongTermFileCache(FileCache longTermCache) {
        UIRegistry.instance.longTermCache = longTermCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCache getShortTermFileCache() {
        UIRegistry uIRegistry = instance;
        synchronized (uIRegistry) {
            if (UIRegistry.instance.shortTermCache == null) {
                try {
                    UIRegistry.instance.shortTermCache = new FileCache();
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(UIRegistry.class, ex);
                    ex.printStackTrace();
                    log.error((Object)ex);
                }
            }
        }
        return UIRegistry.instance.shortTermCache;
    }

    public static void setShortTermFileCache(FileCache shortTermCache) {
        UIRegistry.instance.shortTermCache = shortTermCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCache getFormsCache() {
        UIRegistry uIRegistry = instance;
        synchronized (uIRegistry) {
            if (UIRegistry.instance.formsCache == null) {
                try {
                    UIRegistry.instance.formsCache = new FileCache("forms.Cache");
                    UIRegistry.instance.formsCache.setEnforceMaxCacheSize(false);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(UIRegistry.class, ex);
                    ex.printStackTrace();
                    log.error((Object)ex);
                }
            }
        }
        return UIRegistry.instance.formsCache;
    }

    public static void setFormsCache(FileCache formsCache) {
        UIRegistry.instance.formsCache = formsCache;
    }

    protected static void adjustAllFonts(Font oldBaseFont, Font baseFontArg) {
        if (oldBaseFont != null && baseFontArg != null) {
            int fontSize = baseFontArg.getSize();
            int oldFontSize = oldBaseFont.getSize();
            String family = baseFontArg.getFamily();
            UIDefaults uiDefaults = UIManager.getDefaults();
            Enumeration e = uiDefaults.keys();
            while (e.hasMoreElements()) {
                FontUIResource fontUIRes;
                Object key = e.nextElement();
                if (!key.toString().endsWith(".font") || fontSize == (fontUIRes = (FontUIResource)uiDefaults.get(key)).getSize() && family.equals(fontUIRes.getFamily())) continue;
                UIManager.put(key, new FontUIResource(new Font(family, fontUIRes.getStyle(), fontSize + (fontUIRes.getSize() - oldFontSize))));
            }
        }
    }

    public static Font adjustPerDefaultFont(Font font) {
        return font.getFamily().equals(UIRegistry.instance.defaultFont.getFamily()) && UIRegistry.instance.defaultFont.getSize() == font.getSize() ? UIRegistry.instance.defaultFont : font;
    }

    public static Font getBaseFont() {
        return UIRegistry.instance.baseFont != null ? UIRegistry.instance.baseFont : UIHelper.createLabel("").getFont();
    }

    public static void setBaseFont(Font newBaseFont) {
        if (UIRegistry.instance.baseFont != newBaseFont && UIRegistry.instance.baseFont != null) {
            UIRegistry.adjustAllFonts(UIRegistry.instance.baseFont, newBaseFont);
        }
        UIRegistry.instance.baseFont = newBaseFont;
    }

    public static void setDefaultFont(Font defaultFont) {
        UIRegistry.instance.defaultFont = defaultFont;
    }

    public static Font getDefaultFont() {
        return UIRegistry.instance.defaultFont;
    }

    public static BufferedImage getGlassPaneBufferedImage(int width, int height) {
        BufferedImage bufImg = null;
        if (glassPaneBufferedImageSR != null) {
            bufImg = glassPaneBufferedImageSR.get();
        }
        if (bufImg != null && bufImg.getWidth() != width && bufImg.getHeight() != height) {
            bufImg = null;
        }
        if (bufImg == null) {
            glassPaneBufferedImageSR = new SoftReference<BufferedImage>(new BufferedImage(width, height, 2));
        }
        return glassPaneBufferedImageSR.get();
    }

    public static GhostGlassPane writeGlassPaneMsg(String msg, int pointSize) {
        GhostGlassPane glassPane = UIRegistry.getGlassPane();
        if (glassPane != null) {
            glassPane.finishDnD();
        }
        glassPane.setMaskingEvents(true);
        Component mainComp = UIRegistry.get(MAINPANE);
        if (mainComp != null && glassPane != null) {
            JFrame frame = (JFrame)UIRegistry.get(FRAME);
            frameRect = frame.getBounds();
            int y = 0;
            JMenuBar menuBar = null;
            Dimension size = mainComp.getSize();
            if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
                menuBar = frame.getJMenuBar();
                size.height += menuBar.getSize().height;
                y += menuBar.getSize().height;
            }
            BufferedImage buffer = UIRegistry.getGlassPaneBufferedImage(size.width, size.height);
            Graphics2D g2 = buffer.createGraphics();
            if (menuBar != null) {
                menuBar.paint(g2);
            }
            g2.translate(0, y);
            mainComp.paint(g2);
            g2.translate(0, -y);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(new Color(255, 255, 255, 128));
            g2.fillRect(0, 0, size.width, size.height);
            g2.setFont(new Font(new JLabel().getFont().getName(), 1, pointSize));
            FontMetrics fm = g2.getFontMetrics();
            int tw = fm.stringWidth(msg);
            int th = fm.getHeight();
            int tx = (size.width - tw) / 2;
            int ty = (size.height - th) / 2;
            int expand = 20;
            int arc = expand * 2;
            g2.setColor(Color.WHITE);
            g2.fillRoundRect(tx - expand / 2, ty - fm.getAscent() - expand / 2, tw + expand, th + expand, arc, arc);
            g2.setColor(Color.DARK_GRAY);
            g2.drawRoundRect(tx - expand / 2, ty - fm.getAscent() - expand / 2, tw + expand, th + expand, arc, arc);
            g2.setColor(Color.BLACK);
            g2.drawString(msg, tx, ty);
            g2.dispose();
            glassPane.setImage(buffer);
            glassPane.setPoint(new Point(0, 0), GhostGlassPane.ImagePaintMode.ABSOLUTE);
            glassPane.setOffset(new Point(0, 0));
            glassPane.setVisible(true);
            mainComp.setVisible(false);
            glassPane.paintImmediately(glassPane.getBounds());
            showingGlassPane = true;
        }
        return glassPane;
    }

    public static synchronized void clearGlassPaneMsg() {
        Component mainComp = UIRegistry.get(MAINPANE);
        if (mainComp != null && UIRegistry.getGlassPane() != null && UIRegistry.getGlassPane().isVisible()) {
            UIRegistry.getGlassPane().setMaskingEvents(false);
            UIRegistry.getGlassPane().setVisible(false);
            mainComp.setVisible(true);
            mainComp.repaint();
            JFrame frame = (JFrame)UIRegistry.get(FRAME);
            frame.setBounds(frameRect);
        }
        showingGlassPane = false;
    }

    public static boolean isShowingGlassPane() {
        return showingGlassPane;
    }

    public static SimpleGlassPane writeSimpleGlassPaneMsg(String msg, int pointSize) {
        return UIRegistry.writeSimpleGlassPaneMsg(msg, pointSize, false);
    }

    public static SimpleGlassPane writeSimpleGlassPaneMsg(String msg, int pointSize, boolean isDblClickProgBar) {
        SimpleGlassPane glassPane = new SimpleGlassPane(msg, pointSize, false, isDblClickProgBar);
        JStatusBar statusBar = UIRegistry.getStatusBar();
        if (statusBar != null) {
            glassPane.setMargin(new Insets(0, 0, statusBar.getSize().height, 0));
        }
        if ((oldGlassPane = UIRegistry.getGlassPane()) != null) {
            oldGlassPane.finishedWithDragAndDrop();
        }
        if (glassPane != null && UIRegistry.getTopWindow() != null) {
            ((JFrame)UIRegistry.getTopWindow()).setGlassPane(glassPane);
            glassPane.setVisible(true);
            showingGlassPane = true;
        } else {
            oldGlassPane = null;
            showingGlassPane = false;
        }
        return glassPane;
    }

    public static void writeTimedSimpleGlassPaneMsg(String localizedMsg) {
        UIRegistry.writeTimedSimpleGlassPaneMsg(localizedMsg, null, null, null, false);
    }

    public static void writeTimedSimpleGlassPaneMsg(String localizedMsg, Color textColor) {
        UIRegistry.writeTimedSimpleGlassPaneMsg(localizedMsg, null, textColor, null, false);
    }

    public static void writeTimedSimpleGlassPaneMsg(String localizedMsg, Integer milliseconds, Color textColor, Integer pointSize, boolean doHideOnClick) {
        UIRegistry.writeTimedSimpleGlassPaneMsg(localizedMsg, milliseconds, textColor, pointSize, doHideOnClick, null);
    }

    public static void writeTimedSimpleGlassPaneMsg(final String localizedMsg, final Integer milliseconds, final Color textColor, Integer pointSize, boolean doHideOnClick, Integer yTextPos) {
        final SimpleGlassPane sgp = UIRegistry.writeSimpleGlassPaneMsg(localizedMsg, pointSize == null ? STD_FONT_SIZE : pointSize);
        if (sgp != null) {
            sgp.setTextColor(textColor);
            sgp.setHideOnClick(doHideOnClick);
            sgp.setTextYPos(yTextPos);
        }
        SwingWorker<Integer, Integer> msgWorker = new SwingWorker<Integer, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                try {
                    Thread.sleep(milliseconds != null ? milliseconds : STD_WAIT_TIME);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                if (sgp != null) {
                    sgp.setTextColor(null);
                }
                UIRegistry.clearSimpleGlassPaneMsg();
                if (textColor == Color.RED) {
                    UIRegistry.getStatusBar().setErrorMessage(localizedMsg);
                } else {
                    UIRegistry.displayStatusBarText(localizedMsg);
                }
            }
        };
        msgWorker.execute();
    }

    public static synchronized void clearSimpleGlassPaneMsg() {
        if (oldGlassPane != null) {
            ((JFrame)UIRegistry.getTopWindow()).setGlassPane(oldGlassPane);
            oldGlassPane.setVisible(false);
        } else {
            Component glassPane = ((JFrame)UIRegistry.getTopWindow()).getGlassPane();
            if (glassPane != null) {
                glassPane.setVisible(false);
            }
        }
        oldGlassPane = null;
        showingGlassPane = false;
    }

    public static void setMobile(boolean isMobile) {
        UIRegistry.isMobile = isMobile;
    }

    public static boolean isMobile() {
        return isMobile != null && isMobile != false;
    }

    public static Boolean isEmbedded() {
        if (isEmbedded != null && isEmbedded.booleanValue()) {
            return true;
        }
        return false;
    }

    public static void setEmbedded(Boolean isEmbedded) {
        UIRegistry.isEmbedded = isEmbedded;
    }

    public static void setEmbeddedDBPath(String path) {
        UIRegistry.dumpCanonicalPath("setEmbeddedDBDir", path);
        if (StringUtils.isNotEmpty((String)path)) {
            System.setProperty(EMBEDDED_DB_PATH, path);
        }
    }

    public static String getEmbeddedDBPath() {
        return System.getProperty(EMBEDDED_DB_PATH);
    }

    private static void dumpCanonicalPath(String desc, String path) {
        UIRegistry.dumpCanonicalPath(desc, new File(path));
    }

    private static void dumpCanonicalPath(String desc, File path) {
    }

    public static String getDefaultEmbeddedDBPath() {
        UIRegistry.dumpCanonicalPath("getDefaultEmbeddedDBPath", String.valueOf(UIRegistry.getAppDataDir()) + File.separator + EMBEDDED_DB_DIR);
        return String.valueOf(UIRegistry.getAppDataDir()) + File.separator + EMBEDDED_DB_DIR;
    }

    public static String getDefaultMobileEmbeddedDBPath() {
        UIRegistry.dumpCanonicalPath("getDefaultMobileEmbeddedDBPath", String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + EMBEDDED_DB_DIR);
        return String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + EMBEDDED_DB_DIR;
    }

    public static String getDefaultMobileEmbeddedDBPath(String dbName) {
        UIRegistry.dumpCanonicalPath("getDefaultMobileEmbeddedDBPath", String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + dbName);
        String path = UIRegistry.getDefaultWorkingPath();
        String mobileRelativePath = System.getProperty("mobilesrcdir");
        if (StringUtils.isNotEmpty((String)mobileRelativePath)) {
            if (!path.endsWith(File.separator) && !mobileRelativePath.startsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
            path = String.valueOf(path) + mobileRelativePath;
        }
        return String.valueOf(path) + File.separator + dbName;
    }

    public static void setMobileEmbeddedDBPath(String path) {
        UIRegistry.dumpCanonicalPath("setMobileEmbeddedDBPath", path);
        if (StringUtils.isNotEmpty((String)path)) {
            System.setProperty(MOBILE_EMBEDDED_DB_PATH, path);
        }
    }

    public static String getMobileEmbeddedDBPath() {
        return System.getProperty(MOBILE_EMBEDDED_DB_PATH);
    }

    public static Action getAction(String name) {
        return UIRegistry.instance.actionMap.get(name);
    }

    public static Action registerAction(String name, Action action) {
        if (UIRegistry.instance.actionMap.get(name) == null) {
            UIRegistry.instance.actionMap.put(name, action);
        } else {
            log.error((Object)("Action with name[" + name + "] is already registered."));
        }
        return action;
    }

    public static void unregisterAction(String name) {
        if (UIRegistry.instance.actionMap.get(name) != null) {
            UIRegistry.instance.actionMap.remove(name);
        } else {
            log.error((Object)("Couldn't find Action with name[" + name + "]."));
        }
    }

    public void addNavBindings(JComponent comp) {
        InputMap inputMap = comp.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, "caret-backward");
        key = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, "caret-forward");
        key = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, "caret-up");
        key = KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, "caret-down");
    }

    public JMenu createEditMenu() {
        JMenu menu = new JMenu(UIRegistry.getResourceString("EDIT"));
        menu.setMnemonic(69);
        undoAction = (UndoAction)this.makeAction(UndoAction.class, this, UNDO, null, null, new Integer(90), KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        UIRegistry.register(UNDO, menu.add(undoAction));
        this.actionMap.put(UNDO, undoAction);
        redoAction = (RedoAction)this.makeAction(RedoAction.class, this, REDO, null, null, new Integer(89), KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        UIRegistry.register(REDO, menu.add(redoAction));
        this.actionMap.put(REDO, redoAction);
        menu.addSeparator();
        Action cutAction = this.makeAction(DefaultEditorKit.CutAction.class, null, CUT, null, "Cut selection to clipboard", new Integer(88), KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        UIRegistry.register(CUT, menu.add(cutAction));
        cutAction.setEnabled(false);
        this.actionMap.put(CUT, cutAction);
        Action copyAction = this.makeAction(DefaultEditorKit.CopyAction.class, null, COPY, null, "Copy selection to clipboard", new Integer(67), KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        UIRegistry.register(COPY, menu.add(copyAction));
        copyAction.setEnabled(false);
        this.actionMap.put(COPY, copyAction);
        Action pasteAction = this.makeAction(DefaultEditorKit.PasteAction.class, null, PASTE, null, "Paste contents of clipboard", new Integer(86), KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        pasteAction.setEnabled(false);
        UIRegistry.register(PASTE, menu.add(pasteAction));
        this.actionMap.put(PASTE, pasteAction);
        launchFindReplaceAction = (LaunchFindReplaceAction)this.makeAction(LaunchFindReplaceAction.class, this, FIND, null, null, new Integer(70), KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        launchFindReplaceAction.setEnabled(false);
        UIRegistry.register(FIND, menu.add(launchFindReplaceAction));
        this.actionMap.put(FIND, launchFindReplaceAction);
        return menu;
    }

    public static void enableCutCopyPaste(boolean enable) {
        UIRegistry.instance.actionMap.get(CUT).setEnabled(enable);
        UIRegistry.instance.actionMap.get(COPY).setEnabled(enable);
        UIRegistry.instance.actionMap.get(PASTE).setEnabled(enable);
    }

    public Action makeAction(Class<?> actionClass, Object owner, String name, ImageIcon icon, String toolTip, Integer mnemonicKeyCode, KeyStroke acceleratorKey) {
        Action a = null;
        try {
            if (owner != null) {
                Constructor<?> c = actionClass.getConstructor(owner.getClass());
                a = (Action)c.newInstance(owner);
            } else {
                Constructor<?> c = actionClass.getConstructor(null);
                a = (Action)c.newInstance(null);
            }
            return this.makeAction(a, name, icon, toolTip, mnemonicKeyCode, acceleratorKey);
        }
        catch (ClassCastException e) {
            System.err.println("actionClass argument " + actionClass + " does not implement Action");
        }
        catch (Exception e) {
            System.err.println(e + " -- while trying to make an instance of " + actionClass);
            try {
                Constructor<?>[] cc = actionClass.getConstructors();
                int i = 0;
                while (i < cc.length) {
                    System.err.println(cc[i].toString());
                    ++i;
                }
            }
            catch (Exception ee) {
                log.error((Object)ee);
            }
        }
        return a;
    }

    public Action makeAction(Action action, String name, ImageIcon icon, String toolTip, Integer mnemonicKeyCode, KeyStroke acceleratorKey) {
        if (name != null) {
            action.putValue("Name", name);
        }
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
        if (toolTip != null) {
            action.putValue("ShortDescription", toolTip);
        }
        if (mnemonicKeyCode != null) {
            action.putValue("MnemonicKey", mnemonicKeyCode);
        }
        if (acceleratorKey != null) {
            action.putValue("AcceleratorKey", acceleratorKey);
        }
        return action;
    }

    public static RedoAction getRedoAction() {
        return redoAction;
    }

    public static UndoAction getUndoAction() {
        return undoAction;
    }

    public static LaunchFindReplaceAction getLaunchFindReplaceAction() {
        return launchFindReplaceAction;
    }

    public static void disableFindFromEditMenu() {
        UIRegistry.getLaunchFindReplaceAction().setEnabled(false);
        UIRegistry.instance.actionMap.get(FIND).setEnabled(false);
    }

    public static void enableFind(SearchReplacePanel findPanel, boolean enable) {
        UIRegistry.getLaunchFindReplaceAction().setSearchReplacePanel(findPanel);
        UIRegistry.instance.actionMap.get(FIND).setEnabled(enable);
    }

    public void hookUpUndoableEditListener(UndoableTextIFace undoableText) {
        undoableText.getTextComponent().getDocument().addUndoableEditListener(new UICUndoableEditListener(undoableText.getUndoManager()));
    }

    public static void enableActionAndMenu(String nameStr, boolean enable, Boolean selected) {
        Component comp;
        Action action = UIRegistry.getAction(nameStr);
        if (action != null) {
            action.setEnabled(enable);
        }
        if ((comp = UIRegistry.get(nameStr)) instanceof JCheckBoxMenuItem) {
            ((JCheckBoxMenuItem)comp).setEnabled(enable);
            if (selected != null) {
                ((JCheckBoxMenuItem)comp).setSelected(selected);
            }
        } else if (comp instanceof JMenuItem) {
            ((JMenuItem)comp).setEnabled(enable);
        }
    }

    public class LaunchFindReplaceAction
    extends AbstractAction {
        protected SearchReplacePanel searchReplacePanel;

        public LaunchFindReplaceAction() {
            super(UIRegistry.FIND);
            this.searchReplacePanel = null;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug((Object)"Ctrl-f hit from with UIRegistry - passing action onto the SearchReplacePanel");
            if (this.isEnabled()) {
                if (this.searchReplacePanel != null) {
                    this.searchReplacePanel.getLaunchFindAction().actionPerformed(e);
                } else {
                    log.error((Object)"search panel is null");
                }
            }
        }

        public void removeSearchPanel() {
            this.searchReplacePanel = null;
            this.setEnabled(false);
        }

        public SearchReplacePanel getSearchReplacePanel() {
            return this.searchReplacePanel;
        }

        public void setSearchReplacePanel(SearchReplacePanel panel) {
            this.searchReplacePanel = panel;
            if (panel == null) {
                this.setEnabled(true);
            }
        }
    }

    public class RedoAction
    extends AbstractAction {
        protected UndoManager undoManager;

        public RedoAction() {
            super(UIRegistry.REDO);
            this.undoManager = null;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.undoManager.canRedo()) {
                    this.undoManager.redo();
                }
            }
            catch (CannotRedoException ex) {
                log.error((Object)("Unable to redo: " + ex));
                ex.printStackTrace();
            }
            this.updateRedoState();
            undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (this.undoManager != null && this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", UIRegistry.REDO);
            }
        }

        public UndoManager getUndoManager() {
            return this.undoManager;
        }

        public void setUndoManager(UndoManager undo) {
            this.undoManager = undo;
            this.setEnabled(undo != null);
        }
    }

    class ResBundleInfo {
        protected String name;
        protected ResourceBundle resBundle;

        public ResBundleInfo(String name, ResourceBundle resBundle) {
            this.name = name;
            this.resBundle = resBundle;
        }

        public String getName() {
            return this.name;
        }

        public ResourceBundle getResBundle() {
            return this.resBundle;
        }
    }

    public class UICUndoableEditListener
    implements UndoableEditListener {
        protected UndoManager undoManager;

        public UICUndoableEditListener(UndoManager undoManager) {
            this.undoManager = undoManager;
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
        }
    }

    public class UndoAction
    extends AbstractAction {
        protected UndoManager undoManager;

        public UndoAction() {
            super(UIRegistry.UNDO);
            this.undoManager = null;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.undoManager.canUndo()) {
                    this.undoManager.undo();
                }
            }
            catch (CannotUndoException ex) {
                ex.printStackTrace();
            }
            this.updateUndoState();
            undoAction.updateUndoState();
        }

        protected void updateUndoState() {
            if (this.undoManager != null && this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", UIRegistry.UNDO);
            }
        }

        public UndoManager getUndoManager() {
            return this.undoManager;
        }

        public void setUndoManager(UndoManager undo) {
            this.undoManager = undo;
            this.setEnabled(undo != null);
        }
    }

    public static interface UndoableTextIFace {
        public UndoManager getUndoManager();

        public JTextComponent getTextComponent();
    }
}

