/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.db.DatabaseLoginDlg;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.persist.FormCellIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.helpers.MenuItemPropertyChangeListener;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.CustomDBConverter;
import edu.ku.brc.specify.conversion.CustomDBConverterDlg;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.IconButton;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.MacBtnBorder;
import edu.ku.brc.ui.StringFormatHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.UnhandledExceptionDialog;
import edu.ku.brc.ui.dnd.GhostDataAggregatable;
import edu.ku.brc.util.Triple;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.MaskFormatter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.DoubleValidator;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public final class UIHelper {
    protected static final Logger log;
    protected static Calendar calendar;
    protected static OSTYPE oSType;
    protected static boolean isMacOS_10_5_X;
    protected static BasicStroke stdLineStroke;
    protected static DoubleValidator doubleValidator;
    protected static BigDecimalValidator bigDecValidator;
    protected static Hashtable<CommandType, KeyStroke> cmdTypeKSHash;
    protected static Object[][] valuesArray;
    protected static DateWrapper scrDateFormat;
    protected static Border emptyBorder;
    protected static Border focusBorder;
    protected static RenderingHints txtRenderingHints;
    protected static Hashtable<String, Boolean> baseClassHash;
    protected static CONTROLSIZE controlSize;
    protected static Color hoverColor;
    private static final Color clrGlowInnerHi;
    private static final Color clrGlowInnerLo;
    private static final Color clrGlowOuterHi;
    private static final Color clrGlowOuterLo;
    private static final Color altLineColor;

    static {
        Class[] baseClasses;
        log = Logger.getLogger(UIHelper.class);
        isMacOS_10_5_X = false;
        stdLineStroke = new BasicStroke(1.5f, 1, 1);
        doubleValidator = new DoubleValidator();
        bigDecValidator = new BigDecimalValidator();
        cmdTypeKSHash = new Hashtable();
        valuesArray = null;
        scrDateFormat = null;
        emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        focusBorder = new LineBorder(Color.GRAY, 1, true);
        baseClassHash = new Hashtable();
        controlSize = CONTROLSIZE.regular;
        hoverColor = new Color(0, 0, 150, 100);
        clrGlowInnerHi = new Color(253, 239, 175, 148);
        clrGlowInnerLo = new Color(255, 209, 0);
        clrGlowOuterHi = new Color(253, 239, 175, 124);
        clrGlowOuterLo = new Color(255, 179, 0);
        valuesArray = new Object[5][0];
        int i = 0;
        while (i < 5) {
            UIHelper.valuesArray[i] = new Object[i + 1];
            ++i;
        }
        try {
            calendar = GregorianCalendar.getInstance();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
        }
        String osStr = System.getProperty("os.name");
        oSType = osStr.startsWith("Mac OS X") ? OSTYPE.MacOSX : (osStr.indexOf("Windows") != -1 ? OSTYPE.Windows : (osStr.indexOf("Linux") != -1 ? OSTYPE.Linux : OSTYPE.Unknown));
        txtRenderingHints = UIHelper.createTextRenderingHints();
        Class[] classArray = baseClasses = new Class[]{Boolean.class, Integer.class, Double.class, String.class, Float.class, Character.class, Short.class, Byte.class, BigDecimal.class, Date.class, Calendar.class};
        int n = baseClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            baseClassHash.put(cls.getSimpleName(), true);
            ++n2;
        }
        if (UIHelper.isMacOS()) {
            UIHelper.buildKeyStrokeForCommandTypesMac();
        } else {
            UIHelper.buildKeyStrokeForCommandTypes();
        }
        altLineColor = UIHelper.isMacOS() ? new Color(236, 243, 254) : UIHelper.makeDarker(Color.WHITE, 0.1f);
    }

    public static boolean isMacOS() {
        return oSType == OSTYPE.MacOSX;
    }

    public static boolean isMacOS_10_5_X() {
        return isMacOS_10_5_X;
    }

    public static boolean isWindows() {
        return oSType == OSTYPE.Windows;
    }

    public static boolean isLinux() {
        return oSType == OSTYPE.Linux;
    }

    public static CONTROLSIZE getControlSize() {
        return controlSize;
    }

    public static Color getAltLineColor() {
        return altLineColor;
    }

    public static void setControlSize(CONTROLSIZE controlSize) {
        UIHelper.controlSize = controlSize;
    }

    public static void setControlSize(JComponent comp) {
        if (isMacOS_10_5_X && comp != null) {
            comp.putClientProperty("JComponent.sizeVariant", controlSize.toString());
        }
    }

    public static void setWindowModified(Component comp, boolean isModified) {
        if (comp != null && !(comp instanceof JDialog) && comp instanceof JFrame) {
            JFrame dlg = (JFrame)comp;
            if (isMacOS_10_5_X) {
                dlg.getRootPane().putClientProperty("JComponent.windowModified", isModified ? Boolean.TRUE : Boolean.FALSE);
            } else {
                String title;
                if (isModified) {
                    title = String.valueOf(dlg.getTitle()) + "*";
                } else {
                    title = dlg.getTitle();
                    if (title.endsWith("*")) {
                        title = StringUtils.chomp((String)title);
                    }
                }
                dlg.setTitle(title);
            }
        }
    }

    public static boolean isPrimitiveObjectType(Class<?> clazz) {
        return baseClassHash.get(clazz);
    }

    public static void adjustUIDefaults() {
        UIHelper.isWindows();
    }

    public static void centerAndShow(Window window, Integer width, Integer height) {
        UIHelper.centerWindow(window, width, height);
        window.setVisible(true);
    }

    public static void centerAndShow(Window window) {
        UIHelper.centerAndShow(window, null, null);
    }

    public static void centerWindow(Window window) {
        UIHelper.centerWindow(window, null, null);
    }

    public static void centerWindow(Window window, Integer width, Integer height) {
        JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
        Insets screenInsets = null;
        Rectangle screenRect = null;
        if (width != null || height != null) {
            Dimension s = window.getSize();
            if (width != null) {
                s.width = width;
            }
            if (height != null) {
                s.height = height;
            }
            window.setSize(s);
        }
        if (topFrame != null && topFrame != window) {
            screenRect = topFrame.getBounds();
            screenInsets = topFrame.getInsets();
        } else {
            screenRect = window.getGraphicsConfiguration().getBounds();
            screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(window.getGraphicsConfiguration());
        }
        int centerWidth = screenRect.width < window.getSize().width ? screenRect.x : screenRect.x + screenRect.width / 2 - window.getSize().width / 2;
        int centerHeight = screenRect.height < window.getSize().height ? screenRect.y : screenRect.y + screenRect.height / 2 - window.getSize().height / 2;
        centerHeight = centerHeight < screenInsets.top ? screenInsets.top : centerHeight;
        window.setLocation(centerWidth, centerHeight);
    }

    public static void positionAndFitToScreen(Window window, int x, int y, int w, int h) {
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(window.getGraphicsConfiguration());
        Rectangle winRect = window.getGraphicsConfiguration().getBounds();
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int xCoord = Math.max(0, x);
        int yCoord = Math.max(0, y);
        int width = w;
        int height = h;
        if (xCoord + width > size.width) {
            xCoord = size.width - width;
            xCoord = (winRect.width - width) / 2;
            width = Math.min(winRect.width - screenInsets.left - screenInsets.right, width);
        }
        if (yCoord + height > size.height) {
            yCoord = size.height - x;
            yCoord = (winRect.height - height) / 2;
            height = Math.min(winRect.height - screenInsets.top - screenInsets.bottom, height);
        }
        window.setBounds(xCoord, yCoord, width, height);
    }

    public static void positionAndShow(Window window) {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            window.setLocation(0, 0);
            window.setVisible(true);
        } else {
            UIHelper.centerAndShow(window);
        }
    }

    public static void positionFrameRelativeToTopFrame(JFrame frame) {
        JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
        if (topFrame != null) {
            int x = 0;
            int y = topFrame.getY();
            Rectangle screenRect = topFrame.getGraphicsConfiguration().getBounds();
            x = topFrame.getX() >= frame.getWidth() ? topFrame.getX() - frame.getWidth() : (screenRect.width - topFrame.getX() - topFrame.getWidth() >= frame.getWidth() ? topFrame.getWidth() : screenRect.width - frame.getWidth());
            frame.setBounds(x, y, frame.getWidth(), frame.getHeight());
            frame.setAlwaysOnTop(topFrame.getExtendedState() == 6 || topFrame.getExtendedState() == 4 || topFrame.getExtendedState() == 2);
        }
    }

    public static String createDuplicateJGoodiesDef(String def, String separator, int length) {
        StringBuilder strBuf = new StringBuilder(64);
        int i = 0;
        while (i < length) {
            if (strBuf.length() > 0) {
                strBuf.append(',');
            }
            strBuf.append(def);
            if (i < length - 1) {
                strBuf.append(',');
                strBuf.append(separator);
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static Date convertIntToDate(int iDate) {
        if (iDate == 0) {
            return null;
        }
        calendar.clear();
        int year = iDate / 10000;
        if (year > 1700) {
            int tmp = iDate - year * 10000;
            int month = tmp / 100;
            int day = tmp - month * 100;
            calendar.set(year, month == 0 ? 0 : month - 1, day == 0 ? 1 : day);
        } else {
            calendar.setTimeInMillis(0L);
        }
        return calendar.getTime();
    }

    public static int convertDateToInt(Date date) {
        calendar.setTimeInMillis(date.getTime());
        return calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
    }

    public static float getFloat(Object valObj) {
        float value = 0.0f;
        if (valObj != null) {
            if (valObj instanceof Integer) {
                value = ((Integer)valObj).floatValue();
            } else if (valObj instanceof Long) {
                value = ((Long)valObj).floatValue();
            } else if (valObj instanceof Float) {
                value = ((Float)valObj).floatValue();
            } else if (valObj instanceof Double) {
                value = ((Double)valObj).floatValue();
            } else {
                log.error((Object)("getFloat - Class type is " + valObj.getClass().getName()));
            }
        } else {
            log.error((Object)"getFloat - Result Object is null");
        }
        return value;
    }

    public static double getDouble(Object valObj) {
        double value = 0.0;
        if (valObj != null) {
            if (valObj instanceof Integer) {
                value = ((Integer)valObj).doubleValue();
            } else if (valObj instanceof Long) {
                value = ((Long)valObj).doubleValue();
            } else if (valObj instanceof Float) {
                value = ((Float)valObj).doubleValue();
            } else if (valObj instanceof Double) {
                value = (Double)valObj;
            } else {
                log.error((Object)("getDouble - Class type is " + valObj.getClass().getName()));
            }
        } else {
            log.error((Object)"getDouble - Result Object is null");
        }
        return value;
    }

    public static int getInt(Object valObj) {
        int value = 0;
        if (valObj != null) {
            if (valObj instanceof Integer) {
                value = (Integer)valObj;
            } else if (valObj instanceof Long) {
                value = ((Long)valObj).intValue();
            } else if (valObj instanceof Float) {
                value = ((Float)valObj).intValue();
            } else if (valObj instanceof Double) {
                value = ((Double)valObj).intValue();
            } else {
                log.error((Object)("getInt - Class type is " + valObj.getClass().getName()));
            }
        } else {
            log.error((Object)"getInt - Result Object is null");
        }
        return value;
    }

    public static String getString(Object valObj) {
        if (valObj != null) {
            if (valObj instanceof String) {
                return (String)valObj;
            }
            log.error((Object)("getString - Class type is " + valObj.getClass().getName() + " should be String"));
        } else {
            log.error((Object)"getString - Result Object is null for in getString");
        }
        return "";
    }

    public static <T> Object convertDataFromString(String dataStr, Class<T> cls) {
        try {
            if (cls == Integer.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? Integer.valueOf(Integer.parseInt(dataStr)) : null;
            }
            if (cls == Float.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? Float.valueOf(Float.parseFloat(dataStr)) : null;
            }
            if (cls == Double.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? Double.valueOf(Double.parseDouble(dataStr)) : null;
            }
            if (cls == BigDecimal.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? BigDecimal.valueOf(Double.parseDouble(dataStr)) : null;
            }
            if (cls == Long.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? Long.valueOf(Long.parseLong(dataStr)) : null;
            }
            if (cls == Short.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? Short.valueOf(Short.parseShort(dataStr)) : null;
            }
            if (cls == Byte.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? Byte.valueOf(Byte.parseByte(dataStr)) : null;
            }
            if (cls == Calendar.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? UIHelper.getCalendar(dataStr, scrDateFormat) : null;
            }
            if (cls == Date.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? UIHelper.getDate(dataStr, scrDateFormat) : null;
            }
            if (cls == Timestamp.class) {
                return StringUtils.isNotEmpty((String)dataStr) ? UIHelper.getDate(dataStr, scrDateFormat) : null;
            }
            log.error((Object)("Unsupported type for conversion[" + cls.getSimpleName() + "]"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isClassNumeric(Class<?> cls, boolean doScalarOnly) {
        if (cls == Integer.class) {
            return true;
        }
        if (cls == Long.class) {
            return true;
        }
        if (cls == Short.class) {
            return true;
        }
        if (cls == Byte.class) {
            return true;
        }
        if (doScalarOnly) {
            return false;
        }
        if (cls == Float.class) {
            return true;
        }
        if (cls == Double.class) {
            return true;
        }
        return cls == BigDecimal.class;
    }

    public static Date getDate(String dateStr, DateWrapper dateWrapper) {
        Calendar cal = UIHelper.getCalendar(dateStr, dateWrapper);
        if (cal != null) {
            return cal.getTime();
        }
        return null;
    }

    public static Calendar getCalendar(String dateStr, DateWrapper dateWrapper) {
        if (StringUtils.isNotEmpty((String)dateStr)) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(dateWrapper.getSimpleDateFormat().parse(dateStr));
                return cal;
            }
            catch (ParseException ex) {
                log.error((Object)("Date is in error for parsing[" + dateStr + "]"));
            }
        }
        return null;
    }

    public static boolean getBoolean(Object valObj) {
        if (valObj != null) {
            if (valObj instanceof String) {
                String valStr = ((String)valObj).toLowerCase();
                if (valStr.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valStr.equalsIgnoreCase("false")) {
                    return false;
                }
                log.error((Object)"getBoolean - value is not 'true' or 'false'");
            } else {
                log.error((Object)("getBoolean - Class type is " + valObj.getClass().getName() + " should be String"));
            }
        } else {
            log.error((Object)("getBoolean - Result Object is null for[" + valObj + "]"));
        }
        return false;
    }

    public static Object getDataForClass(Object data, Class<?> classObj) {
        Class<?>[] theInterfaces;
        Object newData;
        if (classObj == Object.class) {
            return data;
        }
        if (data instanceof GhostDataAggregatable && (newData = ((GhostDataAggregatable)data).getDataForClass(classObj)) != null) {
            return newData;
        }
        Vector classes = new Vector();
        Class<?>[] classArray = theInterfaces = data.getClass().getInterfaces();
        int n = theInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> co = classArray[n2];
            classes.add(co);
            ++n2;
        }
        if (classes.contains(classObj)) {
            return data;
        }
        classes.clear();
        Class<?> superclass = data.getClass().getSuperclass();
        while (superclass != null) {
            classes.addElement(superclass);
            superclass = superclass.getSuperclass();
        }
        return null;
    }

    public static OSTYPE getOSType() {
        return oSType;
    }

    public static String getOSTypeAsStr() {
        switch (UIHelper.getOSType()) {
            case Windows: {
                return "win";
            }
            case MacOSX: {
                return "mac";
            }
            case Linux: {
                return "lnx";
            }
        }
        return "exp";
    }

    protected static JMenuItem createMenu(String resKey, int virtualKeyCode, String mneu) {
        JMenuItem jmi = new JMenuItem(UIRegistry.getResourceString(resKey));
        if (oSType != OSTYPE.MacOSX) {
            jmi.setMnemonic(mneu.charAt(0));
        }
        jmi.setAccelerator(KeyStroke.getKeyStroke(virtualKeyCode, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return jmi;
    }

    public static JMenuBar getBasicMenuBar(boolean includeCutCopyPaste) {
        JMenuBar menuBar = new JMenuBar();
        String title = "FileMenu";
        String mneu = "FileMneu";
        JMenu fileMenu = UIHelper.createLocalizedMenu(menuBar, title, mneu);
        if (oSType != OSTYPE.MacOSX) {
            fileMenu.addSeparator();
            fileMenu.add(UIHelper.createMenu(UIRegistry.getResourceString("ExitMenu"), UIRegistry.getResourceString("ExitAccl").charAt(0), UIRegistry.getResourceString("ExitMneu")));
        }
        if (includeCutCopyPaste) {
            title = "EditMenu";
            mneu = "EditMneu";
            JMenu editMenu = UIHelper.createLocalizedMenu(menuBar, title, mneu);
            editMenu.add(UIHelper.createMenu(UIRegistry.getResourceString("CutMenu"), UIRegistry.getResourceString("CutAccl").charAt(0), UIRegistry.getResourceString("CutMneu")));
            editMenu.add(UIHelper.createMenu(UIRegistry.getResourceString("CopyMenu"), 67, UIRegistry.getResourceString("CopyMneu")));
            editMenu.add(UIHelper.createMenu(UIRegistry.getResourceString("PasteMenu"), 86, UIRegistry.getResourceString("PasteMneu")));
        }
        return menuBar;
    }

    public static JMenuItem createLocalizedMenuItem(String key, String mnemonic, String accessibleDescription, boolean enabled, ActionListener al) {
        JMenuItem mi = new JMenuItem(UIRegistry.getResourceString(key));
        if (StringUtils.isNotEmpty((String)mnemonic)) {
            String mnu = UIRegistry.getResourceString(mnemonic);
            mi.setMnemonic(mnu.charAt(0));
        }
        if (StringUtils.isNotEmpty((String)accessibleDescription)) {
            String desc = UIRegistry.getResourceString(accessibleDescription);
            mi.getAccessibleContext().setAccessibleDescription(desc);
        }
        mi.addActionListener(al);
        mi.setEnabled(enabled);
        return mi;
    }

    public static JMenuItem createLocalizedMenuItem(JMenu menu, String key, String mnemonic, String accessibleDescription, boolean enabled, ActionListener al) {
        JMenuItem mi = UIHelper.createLocalizedMenuItem(key, mnemonic, accessibleDescription, enabled, al);
        if (menu != null) {
            menu.add(mi);
        }
        return mi;
    }

    public static JMenuItem createLocalizedMenuItem(JPopupMenu popupMenu, String key, String mnemonic, String accessibleDescription, boolean enabled, ActionListener al) {
        JMenuItem mi = UIHelper.createLocalizedMenuItem(key, mnemonic, accessibleDescription, enabled, al);
        if (popupMenu != null) {
            popupMenu.add(mi);
        }
        return mi;
    }

    public static JMenuItem createMenuItemWithAction(JMenu menu, String label, String mnemonic, String accessibleDescription, boolean enabled, Action action) {
        JMenuItem mi = new JMenuItem(action);
        mi.setText(label);
        if (menu != null) {
            menu.add(mi);
        }
        if (StringUtils.isNotEmpty((String)mnemonic)) {
            mi.setMnemonic(mnemonic.charAt(0));
        }
        if (StringUtils.isNotEmpty((String)accessibleDescription)) {
            mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
        }
        if (action != null) {
            action.addPropertyChangeListener(new MenuItemPropertyChangeListener(mi));
            action.setEnabled(enabled);
        }
        return mi;
    }

    public static JMenuItem createMenuItemWithAction(JPopupMenu menu, String label, String mnemonic, String accessibleDescription, boolean enabled, Action action) {
        JMenuItem mi = new JMenuItem(action);
        mi.setText(label);
        if (menu != null) {
            menu.add(mi);
        }
        if (StringUtils.isNotEmpty((String)mnemonic)) {
            mi.setMnemonic(mnemonic.charAt(0));
        }
        if (StringUtils.isNotEmpty((String)accessibleDescription)) {
            mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
        }
        if (action != null) {
            action.addPropertyChangeListener(new MenuItemPropertyChangeListener(mi));
            action.setEnabled(enabled);
        }
        return mi;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(JMenu menu, String label, String mnemonic, String accessibleDescription, boolean enabled, AbstractAction action) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(UIRegistry.getResourceString(label));
        if (menu != null) {
            menu.add(mi);
        }
        UIHelper.setLocalizedMnemonic(mi, mnemonic);
        if (StringUtils.isNotEmpty((String)accessibleDescription)) {
            mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
        }
        if (action != null) {
            mi.addActionListener(action);
            action.addPropertyChangeListener(new MenuItemPropertyChangeListener(mi));
            action.setEnabled(enabled);
        }
        return mi;
    }

    public static JCheckBoxMenuItem createLocalizedCheckBoxMenuItem(String labelKey, String mnemonicKey, String accessibleDescriptionKey, boolean enabled, AbstractAction action) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(UIRegistry.getResourceString(labelKey));
        UIHelper.setLocalizedMnemonic(mi, UIRegistry.getResourceString(mnemonicKey));
        if (StringUtils.isNotEmpty((String)accessibleDescriptionKey)) {
            mi.getAccessibleContext().setAccessibleDescription(UIRegistry.getResourceString(accessibleDescriptionKey));
        }
        if (action != null) {
            mi.addActionListener(action);
            action.addPropertyChangeListener(new MenuItemPropertyChangeListener(mi));
            action.setEnabled(enabled);
        }
        return mi;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(JMenu menu, String label, String mnemonic, String accessibleDescription, boolean enabled, AbstractAction action) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(UIRegistry.getResourceString(label));
        if (menu != null) {
            menu.add(mi);
        }
        UIHelper.setLocalizedMnemonic(mi, mnemonic);
        if (StringUtils.isNotEmpty((String)accessibleDescription)) {
            mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
        }
        if (action != null) {
            mi.addActionListener(action);
            action.addPropertyChangeListener(new MenuItemPropertyChangeListener(mi));
            action.setEnabled(enabled);
        }
        return mi;
    }

    public static JMenu createLocalizedMenu(JMenuBar menuBar, String labelKey, String mneuKey) {
        return menuBar.add(UIHelper.createLocalizedMenu(labelKey, mneuKey));
    }

    public static JMenu createLocalizedMenu(String labelKey, String mneuKey) {
        JMenu menu = null;
        try {
            menu = new JMenu(UIRegistry.getResourceString(labelKey));
            if (oSType != OSTYPE.MacOSX) {
                UIHelper.setLocalizedMnemonic(menu, mneuKey);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error((Object)("Couldn't create menu for " + labelKey + "  " + mneuKey));
        }
        return menu;
    }

    public static void setLocalizedMnemonic(AbstractButton btn, String mnemonicKey) {
        if (StringUtils.isNotEmpty((String)mnemonicKey)) {
            String mnemonic = UIRegistry.getResourceString(mnemonicKey);
            if (btn != null && StringUtils.isNotEmpty((String)mnemonic)) {
                btn.setMnemonic(UIRegistry.getResourceString(mnemonic).charAt(0));
            }
        }
    }

    public static Object[] getFieldValues(String[] fieldNames, Object dataObj, DataObjectGettable getter) {
        if (scrDateFormat == null) {
            scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
        }
        Object[] values = null;
        if (fieldNames.length > 5) {
            values = new Object[fieldNames.length];
        } else {
            values = valuesArray[fieldNames.length - 1];
            int i = fieldNames.length;
            while (i < values.length) {
                values[i] = null;
                ++i;
            }
        }
        boolean allFieldsNull = true;
        int cnt = 0;
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object dataValue;
            String fldName = stringArray[n2];
            if (getter.usesDotNotation()) {
                int inx = fldName.indexOf(".");
                if (inx > -1) {
                    FormDataObjIFace parentObj;
                    UIFieldFormatterIFace fmtr;
                    StringTokenizer st = new StringTokenizer(fldName, ".");
                    Object data = dataObj;
                    Object parentData = null;
                    String fieldName = null;
                    while (data != null && st.hasMoreTokens()) {
                        parentData = data;
                        fieldName = st.nextToken();
                        data = getter.getFieldValue(parentData, fieldName);
                    }
                    dataValue = data;
                    if (parentData instanceof FormDataObjIFace && dataValue != null && (fmtr = DBTableIdMgr.getFieldFormatterFor((parentObj = (FormDataObjIFace)parentData).getDataClass(), fieldName)) != null) {
                        dataValue = fmtr.formatToUI(dataValue);
                    }
                } else {
                    dataValue = getter.getFieldValue(dataObj, fldName);
                }
            } else {
                dataValue = getter.getFieldValue(dataObj, fldName);
            }
            if (dataValue instanceof Date) {
                dataValue = scrDateFormat.format((Date)dataValue);
            } else if (dataValue instanceof Calendar) {
                dataValue = scrDateFormat.format(((Calendar)dataValue).getTime());
            }
            if (allFieldsNull && dataValue != null) {
                allFieldsNull = false;
            }
            values[cnt++] = dataValue;
            ++n2;
        }
        return allFieldsNull ? null : values;
    }

    public static Object[] getFieldValues(FormCellIFace formCell, Object dataObj, DataObjectGettable getter) {
        String[] fieldNames = formCell.getFieldNames();
        if (fieldNames != null && fieldNames.length != 0) {
            return UIHelper.getFieldValues(fieldNames, dataObj, getter);
        }
        return null;
    }

    public static Object getFormattedValue(String format, Object ... valuesArg) {
        if (valuesArg == null || valuesArg.length == 0) {
            return "";
        }
        try {
            StringFormatHelper strFmtHelper = StringFormatHelper.getStringFormatHelper(format, true);
            if (strFmtHelper != null && !strFmtHelper.isInError()) {
                return strFmtHelper.format(valuesArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valuesArg[0] != null ? valuesArg[0].toString() : "";
    }

    public static Map<String, String> createMap() {
        return new Hashtable<String, String>();
    }

    public static List<String> createStringList() {
        return new ArrayList<String>();
    }

    public static boolean tryLogin(String dbDriver, String dbDialect, String dbName, String connectionStr, String dbUsername, String dbPassword) {
        log.debug((Object)"try login");
        FormHelper.setCurrentUserEditStr("");
        DBConnection dbConn = DBConnection.getInstance();
        dbConn.setDriver(dbDriver);
        dbConn.setDialect(dbDialect);
        dbConn.setDatabaseName(dbName);
        dbConn.setConnectionStr(connectionStr);
        dbConn.setUsernamePassword(dbUsername, dbPassword);
        Connection connection = dbConn.createConnection();
        if (connection != null) {
            try {
                connection.close();
                return true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    public static DatabaseLoginPanel doLogin(String userName, String password, boolean engageUPPrefs, boolean doAutoClose, boolean useDialog, DatabaseLoginListener listener, String iconName, String appIconName, String helpContext) {
        return UIHelper.doLogin(userName, password, engageUPPrefs, doAutoClose, useDialog, listener, iconName, null, null, appIconName, helpContext);
    }

    public static DatabaseLoginPanel doLogin(DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider, boolean engageUPPrefs, boolean doAutoClose, boolean useDialog, DatabaseLoginListener listener, String iconName, String title, String appName, String appIconName, String helpContext) {
        return UIHelper.doLogin(null, null, engageUPPrefs, usrPwdProvider, doAutoClose, useDialog, listener, iconName, title, appName, appIconName, helpContext);
    }

    public static DatabaseLoginPanel doLogin(String userName, String password, boolean engageUPPrefs, boolean doAutoClose, boolean useDialog, DatabaseLoginListener listener, String iconName, String title, String appName, String appIconName, String helpContext) {
        return UIHelper.doLogin(userName, password, engageUPPrefs, null, doAutoClose, useDialog, listener, iconName, title, appName, appIconName, helpContext);
    }

    public static DatabaseLoginPanel doLogin(String userName, String password, boolean engageUPPrefs, DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider, boolean doAutoClose, boolean useDialog, DatabaseLoginListener listener, String iconName, String title, String appName, String appIconName, String helpContext) {
        ImageIcon imgIcon;
        ImageIcon icon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std32);
        if (StringUtils.isNotEmpty((String)appIconName) && (imgIcon = IconManager.getIcon(appIconName)) != null) {
            icon = imgIcon;
        }
        if (useDialog) {
            JDialog.setDefaultLookAndFeelDecorated(false);
            DatabaseLoginDlg dlg = new DatabaseLoginDlg((Frame)UIRegistry.getTopWindow(), userName, password, engageUPPrefs, listener, iconName, helpContext);
            JDialog.setDefaultLookAndFeelDecorated(true);
            dlg.setDoAutoClose(doAutoClose);
            dlg.setModal(true);
            if (StringUtils.isNotEmpty((String)title)) {
                dlg.setTitle(title);
            }
            dlg.setIconImage(icon.getImage());
            UIHelper.centerAndShow(dlg);
            return dlg.getDatabaseLoginPanel();
        }
        JFrame.setDefaultLookAndFeelDecorated(false);
        JFrame frame = new JFrame(title);
        class DBListener
        implements DatabaseLoginListener {
            protected JFrame frame;
            protected DatabaseLoginListener frameDBListener;
            protected boolean doAutoCloseOfListener;

            public DBListener(JFrame frame, DatabaseLoginListener frameDBListener, boolean doAutoCloseOfListener) {
                this.frame = frame;
                this.frameDBListener = frameDBListener;
                this.doAutoCloseOfListener = doAutoCloseOfListener;
            }

            @Override
            public void loggedIn(Window window, String databaseName, String userNameArg) {
                log.debug((Object)"UIHelper.doLogin[DBListener]");
                if (this.doAutoCloseOfListener) {
                    this.frame.setVisible(false);
                }
                this.frameDBListener.loggedIn(window, databaseName, userNameArg);
            }

            @Override
            public void cancelled() {
                this.frame.setVisible(false);
                this.frameDBListener.cancelled();
            }
        }
        DatabaseLoginPanel panel = StringUtils.isNotEmpty((String)title) ? new DatabaseLoginPanel(userName, password, engageUPPrefs, usrPwdProvider, new DBListener(frame, listener, doAutoClose), false, true, title, appName, iconName, helpContext) : new DatabaseLoginPanel(userName, password, engageUPPrefs, usrPwdProvider, new DBListener(frame, listener, doAutoClose), false, true, null, null, iconName, helpContext);
        panel.setAutoClose(doAutoClose);
        panel.setWindow(frame);
        frame.setContentPane(panel);
        frame.setIconImage(icon.getImage());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        UIHelper.centerAndShow(frame);
        return panel;
    }

    public static CustomDBConverterDlg doSpecifyConvert() {
        log.debug((Object)"doSpecifyConvert");
        CustomDBConverter converter = new CustomDBConverter();
        converter.setUpSystemProperties();
        converter.setUpPreferrences();
        CustomDBConverter listener = converter;
        JDialog.setDefaultLookAndFeelDecorated(false);
        CustomDBConverterDlg dlg = new CustomDBConverterDlg((Frame)UIRegistry.getTopWindow(), listener);
        JDialog.setDefaultLookAndFeelDecorated(true);
        UIHelper.centerAndShow(dlg);
        return dlg;
    }

    protected static boolean doesContain(Throwable e, String className, String methodName) {
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            if (ste.getClassName().equals(className) && (methodName == null || ste.getMethodName().equals(methodName))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean isExceptionOKToThrow(Throwable e) {
        String msg;
        if (e instanceof ArrayIndexOutOfBoundsException) {
            String msg2 = e.getCause().toString();
            if (msg2 != null && UIHelper.doesContain(e, "apple.awt.CWindow", "displayChanged")) {
                return false;
            }
            if (msg2 != null && UIHelper.doesContain(e, "javax.swing.RepaintManager", "paint")) {
                return false;
            }
        } else if (e instanceof NullPointerException) {
            String msg3 = e.getMessage();
            if (msg3 != null && UIHelper.doesContain(e, "javax.help.WindowPresentation", null)) {
                return false;
            }
            if (msg3 != null && UIHelper.doesContain(e, "javax.swing.JComponent._paintImmediately", null)) {
                return false;
            }
        } else if (e instanceof IndexOutOfBoundsException && (msg = e.getMessage()) != null && UIHelper.doesContain(e, "javax.swing.JTabbedPane", "checkIndex")) {
            return false;
        }
        return true;
    }

    protected static void mailUnhandledException(Throwable throwable) {
    }

    public static void attachUnhandledException() {
        log.debug((Object)("attachUnhandledException " + Thread.currentThread().getName() + " " + Thread.currentThread().hashCode()));
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (UIHelper.isExceptionOKToThrow(e)) {
                    UIHelper.mailUnhandledException(e);
                    UIHelper.showUnhandledException(e);
                }
                UsageTracker.incrUsageCount("UncaughtException");
                e.printStackTrace();
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (UIHelper.isExceptionOKToThrow(e)) {
                    UIHelper.mailUnhandledException(e);
                    UIHelper.showUnhandledException(e);
                }
                UsageTracker.incrUsageCount("UncaughtException");
                e.printStackTrace();
            }
        });
    }

    public static void showUnhandledException(final Throwable throwable) {
        log.debug((Object)("showUnhandledException " + Thread.currentThread().getName() + " " + Thread.currentThread().hashCode()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnhandledExceptionDialog dlg = new UnhandledExceptionDialog(throwable);
                dlg.setVisible(true);
                UIHelper.attachUnhandledException();
            }
        });
    }

    public static Window getWindow(Component comp) {
        Container parent = comp.getParent();
        do {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public static Dialog getDialog(Component comp) {
        Container parent = comp.getParent();
        do {
            if (!(parent instanceof Dialog)) continue;
            return (Dialog)parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public static Frame getFrame(Component comp) {
        Window window = UIHelper.getWindow(comp);
        return window instanceof Frame ? (Frame)window : (Frame)UIRegistry.getTopWindow();
    }

    public static JButton createButton(String iconName, String toolTip, IconManager.IconSize size, boolean focusable) {
        JButton btn = new JButton(IconManager.getIcon(iconName, size));
        btn.setToolTipText(toolTip);
        btn.setFocusable(focusable);
        btn.setMargin(new Insets(1, 1, 1, 1));
        btn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return btn;
    }

    public static JButton createMiniI18NBtn(String key) {
        JButton btn;
        if (UIHelper.isMacOS()) {
            btn = UIHelper.createButton(UIRegistry.getResourceString(key));
            btn.putClientProperty("JComponent.sizeVariant", CONTROLSIZE.mini.toString());
        } else {
            btn = UIHelper.createButton(UIRegistry.getResourceString(key));
            Font defFont = UIRegistry.getDefaultFont();
            Font baseFont = UIRegistry.getDefaultFont();
            Font btnFont = baseFont.getSize() < defFont.getSize() ? baseFont : baseFont.deriveFont((float)defFont.getSize() - 2.0f);
            btn.setFont(btnFont);
        }
        return btn;
    }

    public static JButton createIconBtn(String iconName, String toolTipTextKey, ActionListener al) {
        return UIHelper.createIconBtn(iconName, null, toolTipTextKey, false, al);
    }

    public static JButton createIconBtn(String iconName, IconManager.IconSize size, String toolTipTextKey, ActionListener al) {
        return UIHelper.createIconBtn(iconName, size, toolTipTextKey, false, al);
    }

    public static JButton createIconBtn(String iconName, IconManager.IconSize size, String toolTipTextKey, boolean withEmptyBorder, ActionListener al) {
        String ttText = StringUtils.isNotEmpty((String)toolTipTextKey) ? UIRegistry.getResourceString(toolTipTextKey) : null;
        return UIHelper.createIconBtnTT(iconName, size, ttText, withEmptyBorder, false, al);
    }

    public static JButton createIconBtn(String iconName, IconManager.IconSize size, String toolTipTextKey, boolean withEmptyBorder, boolean enabled, ActionListener al) {
        String ttText = StringUtils.isNotEmpty((String)toolTipTextKey) ? UIRegistry.getResourceString(toolTipTextKey) : null;
        return UIHelper.createIconBtnTT(iconName, size, ttText, withEmptyBorder, enabled, al);
    }

    public static JButton createIconBtnTT(String iconName, IconManager.IconSize size, String toolTipText, boolean withEmptyBorder, ActionListener al) {
        return UIHelper.createIconBtnTT(iconName, size, toolTipText, withEmptyBorder, false, al);
    }

    public static JButton createIconBtnTT(String iconName, IconManager.IconSize size, String toolTipText, boolean withEmptyBorder, boolean enabled, ActionListener al) {
        IconButton btn = new IconButton(size != null ? IconManager.getIcon(iconName, size) : IconManager.getIcon(iconName), withEmptyBorder);
        if (StringUtils.isNotEmpty((String)toolTipText)) {
            btn.setToolTipText(toolTipText);
        }
        if (al != null) {
            btn.addActionListener(al);
        }
        btn.setEnabled(enabled);
        return btn;
    }

    public static JScrollPane createScrollPane(JComponent content) {
        return UIHelper.createScrollPane(content, false);
    }

    public static JScrollPane createScrollPane(JComponent content, boolean makeHorzAsNeeded) {
        return new JScrollPane(content, UIHelper.isMacOS() ? 22 : 20, makeHorzAsNeeded ? 30 : 31);
    }

    public static JButton createIconBtn(String iconName, String toolTipTextKey, Action action) {
        return UIHelper.createIconBtn(iconName, null, toolTipTextKey, false, action);
    }

    public static JButton createIconBtn(String iconName, String toolTipTextKey, boolean withEmptyBorder, Action action) {
        return UIHelper.createIconBtn(iconName, null, toolTipTextKey, withEmptyBorder, action);
    }

    public static JButton createIconBtn(String iconName, IconManager.IconSize size, String toolTipTextKey, Action action) {
        return UIHelper.createIconBtn(iconName, size, toolTipTextKey, false, action);
    }

    public static JButton createIconBtn(String iconName, IconManager.IconSize size, String toolTipTextKey, boolean withEmptyBorder, Action action) {
        JButton btn = new JButton(action){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.setBorder(emptyBorder);
            }
        };
        btn.setOpaque(false);
        if (!withEmptyBorder) {
            btn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (((JButton)e.getSource()).isEnabled()) {
                        ((JButton)e.getSource()).setBorder(focusBorder);
                    }
                    super.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (((JButton)e.getSource()).isEnabled()) {
                        ((JButton)e.getSource()).setBorder(emptyBorder);
                    }
                    super.mouseExited(e);
                }
            });
            btn.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (((JButton)e.getSource()).isEnabled()) {
                        ((JButton)e.getSource()).setBorder(focusBorder);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (((JButton)e.getSource()).isEnabled()) {
                        ((JButton)e.getSource()).setBorder(emptyBorder);
                    }
                }
            });
            btn.setBorder(emptyBorder);
        }
        btn.setIcon(size != null ? IconManager.getIcon(iconName, size) : IconManager.getIcon(iconName));
        btn.setText(null);
        if (StringUtils.isNotEmpty((String)toolTipTextKey)) {
            btn.setToolTipText(UIRegistry.getResourceString(toolTipTextKey));
        }
        btn.setEnabled(false);
        btn.setFocusable(true);
        btn.setMargin(new Insets(0, 0, 0, 0));
        UIHelper.setControlSize(btn);
        return btn;
    }

    public static void calcColumnWidths(JTable table) {
        UIHelper.calcColumnWidths(table, 10);
    }

    public static void calcColumnWidths(JTable table, Integer numRowsHeight) {
        UIHelper.calcColumnWidths(table, numRowsHeight, null);
    }

    public static void calcColumnWidths(JTable table, Integer numRowsHeight, Integer maxWidth) {
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            TableCellRenderer defaultHeaderRenderer = null;
            if (header != null) {
                defaultHeaderRenderer = header.getDefaultRenderer();
            }
            TableColumnModel columns = table.getColumnModel();
            TableModel data = table.getModel();
            int margin = columns.getColumnMargin();
            int rowCount = data.getRowCount();
            int totalWidth = 0;
            int i = columns.getColumnCount() - 1;
            while (i >= 0) {
                TableColumn column = columns.getColumn(i);
                int columnIndex = column.getModelIndex();
                int width = -1;
                TableCellRenderer h = column.getHeaderRenderer();
                if (h == null) {
                    h = defaultHeaderRenderer;
                }
                if (h != null) {
                    Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                    width = c.getPreferredSize().width;
                }
                int row = rowCount - 1;
                while (row >= 0) {
                    TableCellRenderer r = table.getCellRenderer(row, i);
                    Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                    width = Math.max(width, c.getPreferredSize().width + 10);
                    if (maxWidth != null) {
                        width = Math.min(width, maxWidth);
                    }
                    --row;
                }
                if (width >= 0) {
                    column.setPreferredWidth(width + margin);
                }
                totalWidth += column.getPreferredWidth();
                --i;
            }
            Dimension size = table.getPreferredScrollableViewportSize();
            if (numRowsHeight != null) {
                size.height = Math.min(size.height, table.getRowHeight() * numRowsHeight);
            }
            size.width = totalWidth;
            table.setPreferredScrollableViewportSize(size);
        }
    }

    public static JTable autoResizeColWidth(JTable table, DefaultTableModel model) {
        table.setAutoResizeMode(0);
        table.setModel(model);
        int margin = 5;
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        int preferredWidthTotal = 0;
        int renderedWidthTotal = 0;
        int[] colWidths = new int[table.getColumnCount()];
        int i = 0;
        while (i < table.getColumnCount()) {
            int vColIndex = i;
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            int r = 0;
            while (r < table.getRowCount()) {
                renderer = table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                width = Math.max(width, comp.getPreferredSize().width);
                ++r;
            }
            preferredWidthTotal += col.getPreferredWidth();
            colWidths[i] = width += 2 * margin;
            renderedWidthTotal += width;
            ++i;
        }
        if (renderedWidthTotal > preferredWidthTotal) {
            i = 0;
            while (i < table.getColumnCount()) {
                colModel.getColumn(i).setPreferredWidth(colWidths[i]);
                ++i;
            }
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    public static void makeTableHeadersCentered(JTable table, boolean dataColsAlso) {
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        if (dataColsAlso) {
            TableCellRenderer tcr = table.getDefaultRenderer(String.class);
            DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)tcr;
            dtcr.setHorizontalAlignment(0);
        }
    }

    public static Properties parseProperties(String nameValuePairs) {
        if (StringUtils.isNotEmpty((String)nameValuePairs)) {
            Properties props = new Properties();
            String[] stringArray = StringUtils.split((String)nameValuePairs, (String)";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                int firstEqualsSign = pair.indexOf(61);
                if (firstEqualsSign == -1 || firstEqualsSign == pair.length() - 1) {
                    log.error((Object)("Initialize string[" + nameValuePairs + "] must be a set of name/value pairs separated by ';'."));
                } else {
                    String name = pair.substring(0, firstEqualsSign);
                    String value = pair.substring(firstEqualsSign + 1);
                    props.put(name, value);
                }
                ++n2;
            }
            return props.size() > 0 ? props : null;
        }
        return null;
    }

    public String createNameValuePairs(Properties props) {
        StringBuilder str = new StringBuilder();
        for (Object key : props.keySet()) {
            if (str.length() > 0) {
                str.append(';');
            }
            str.append(key.toString());
            str.append('=');
            str.append(props.get(key).toString());
        }
        return str.toString();
    }

    public static int getProperty(Properties properties, String nameStr, int defVal) {
        if (properties != null) {
            String str = properties.getProperty(nameStr);
            if (StringUtils.isNotEmpty((String)str)) {
                return Integer.parseInt(str);
            }
        } else {
            return defVal;
        }
        return -1;
    }

    public static boolean getProperty(Properties properties, String nameStr, boolean defVal) {
        if (properties != null) {
            String str = properties.getProperty(nameStr);
            if (StringUtils.isNotEmpty((String)str)) {
                return str.equalsIgnoreCase("true");
            }
        } else {
            return defVal;
        }
        return false;
    }

    public static String makeNamePretty(String nameToFix) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < nameToFix.length()) {
            if (i == 0) {
                s.append(Character.toUpperCase(nameToFix.charAt(i)));
            } else {
                char c = nameToFix.charAt(i);
                if (Character.isUpperCase(c)) {
                    s.append(' ');
                }
                s.append(c);
            }
            ++i;
        }
        return s.toString();
    }

    public static String stripSubDirs(String path, int numToStrip) {
        String databasePath = path;
        int i = 0;
        while (i < numToStrip) {
            int endInx = databasePath.lastIndexOf("/");
            if (endInx > -1) {
                databasePath = databasePath.substring(0, endInx);
            } else {
                endInx = databasePath.lastIndexOf("\\");
                if (endInx > -1) {
                    databasePath = databasePath.substring(0, endInx);
                } else {
                    log.error((Object)("Couldn'f find / in [" + databasePath + "]"));
                }
            }
            ++i;
        }
        return databasePath;
    }

    public static RenderingHints createTextRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Object value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        try {
            Field declaredField = RenderingHints.class.getDeclaredField("VALUE_TEXT_ANTIALIAS_LCD_HRGB");
            value = declaredField.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, value);
        return renderingHints;
    }

    public static void removeFocusListeners(Component comp) {
        if (comp != null) {
            FocusListener[] focusListenerArray = comp.getFocusListeners();
            int n = focusListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                FocusListener l = focusListenerArray[n2];
                comp.removeFocusListener(l);
                ++n2;
            }
        }
    }

    public static void removeListSelectionListeners(JList comp) {
        if (comp != null) {
            ListSelectionListener[] listSelectionListenerArray = comp.getListSelectionListeners();
            int n = listSelectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListSelectionListener l = listSelectionListenerArray[n2];
                comp.removeListSelectionListener(l);
                ++n2;
            }
        }
    }

    public static void removeKeyListeners(Component comp) {
        if (comp != null) {
            KeyListener[] keyListenerArray = comp.getKeyListeners();
            int n = keyListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyListener l = keyListenerArray[n2];
                comp.removeKeyListener(l);
                ++n2;
            }
        }
    }

    public static void removeMouseListeners(Component c) {
        if (c != null) {
            EventListener l;
            EventListener[] eventListenerArray = c.getMouseListeners();
            int n = eventListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                l = eventListenerArray[n2];
                c.removeMouseListener((MouseListener)l);
                ++n2;
            }
            eventListenerArray = c.getMouseMotionListeners();
            n = eventListenerArray.length;
            n2 = 0;
            while (n2 < n) {
                l = eventListenerArray[n2];
                c.removeMouseMotionListener((MouseMotionListener)l);
                ++n2;
            }
        }
    }

    public static Color parseRGB(String rgb) {
        StringTokenizer st = new StringTokenizer(rgb, ",");
        if (st.countTokens() == 3) {
            String r = st.nextToken().trim();
            String g = st.nextToken().trim();
            String b = st.nextToken().trim();
            return new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
        }
        throw new ConfigurationException("R,G,B value is bad [" + rgb + "]");
    }

    protected static String getHexStr(int val) {
        String str = Integer.toHexString(val).toUpperCase();
        return str.length() == 1 ? "0" + str : str;
    }

    public static String getBGRHexFromColor(Color color) {
        return String.valueOf(UIHelper.getHexStr(color.getBlue())) + UIHelper.getHexStr(color.getGreen()) + UIHelper.getHexStr(color.getRed());
    }

    public static String getRGBHexFromColor(Color color) {
        return String.valueOf(UIHelper.getHexStr(color.getRed())) + UIHelper.getHexStr(color.getGreen()) + UIHelper.getHexStr(color.getBlue());
    }

    public static Color makeLighter(Color color, double percentage) {
        int r = Math.min(color.getRed() + (int)((double)color.getRed() * percentage), 255);
        int g = Math.min(color.getGreen() + (int)((double)color.getGreen() * percentage), 255);
        int b = Math.min(color.getBlue() + (int)((double)color.getBlue() * percentage), 255);
        return new Color(r, g, b);
    }

    public static Color makeDarker(Color color, double percentage) {
        int r = Math.max(color.getRed() - (int)((double)color.getRed() * percentage), 0);
        int g = Math.max(color.getGreen() - (int)((double)color.getGreen() * percentage), 0);
        int b = Math.max(color.getBlue() - (int)((double)color.getBlue() * percentage), 0);
        return new Color(r, g, b);
    }

    public static JPanel createAddRemoveEditBtnBar(ActionListener addAL, String addTT, ActionListener removeAL, String removeTT, ActionListener editAL, String editTT) {
        int numBtns = (addAL != null ? 1 : 0) + (removeAL != null ? 1 : 0) + (editAL != null ? 1 : 0);
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g," + UIHelper.createDuplicateJGoodiesDef("p", "2px", numBtns), "p"));
        CellConstraints cc = new CellConstraints();
        int x = 2;
        if (addAL != null) {
            pb.add((Component)UIHelper.createIconBtn("PlusSign", addTT, addAL), cc.xy(x, 1));
            x += 2;
        }
        if (removeAL != null) {
            pb.add((Component)UIHelper.createIconBtn("MinusSign", removeTT, removeAL), cc.xy(x, 1));
            x += 2;
        }
        if (editAL != null) {
            pb.add((Component)UIHelper.createIconBtn("EditIcon", editTT, editAL), cc.xy(x, 1));
            x += 2;
        }
        return pb.getPanel();
    }

    public static JLabel createI18NLabel(String key) {
        return UIHelper.createLabel(UIRegistry.getResourceString(key));
    }

    public static JLabel createI18NLabel(String key, int align) {
        return UIHelper.createLabel(UIRegistry.getResourceString(key), align);
    }

    public static Color changeColorBrightness(Color color, double delta) {
        int r = (int)Math.min((double)color.getRed() * delta, 255.0);
        int g = (int)Math.min((double)color.getGreen() * delta, 255.0);
        int b = (int)Math.min((double)color.getBlue() * delta, 255.0);
        return new Color(r, g, b);
    }

    public static void addSpecialKeyListenerForPopup(final JPopupMenu popupMenu) {
        if (!UIHelper.isMacOS()) {
            popupMenu.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    if (e.getKeyCode() == 10) {
                        int i = 0;
                        while (i < popupMenu.getComponentCount()) {
                            JMenuItem mi;
                            Component c = popupMenu.getComponent(i);
                            if (c instanceof JMenuItem && (mi = (JMenuItem)c).isArmed()) {
                                mi.doClick();
                                popupMenu.setVisible(false);
                            }
                            ++i;
                        }
                    }
                }
            });
        }
    }

    private static String getSysVersion(Element root, String nodeName) {
        for (Object obj : root.selectNodes("/config/" + nodeName)) {
            Element varObj = (Element)obj;
            String name = XMLHelper.getAttr(varObj, "name", null);
            if (!name.equals("sys.version")) continue;
            return XMLHelper.getAttr(varObj, "value", null);
        }
        return null;
    }

    public static String getInstall4JInstallString() {
        Element root = XMLHelper.readDOMFromConfigDir(".." + File.separator + ".install4j" + File.separator + "i4jparams.conf");
        if (root != null) {
            String sysVersion = UIHelper.getSysVersion(root, "variables/variable");
            if (StringUtils.isNotEmpty((String)sysVersion)) {
                return sysVersion;
            }
            sysVersion = UIHelper.getSysVersion(root, "compilerVariables/variable");
            if (StringUtils.isNotEmpty((String)sysVersion)) {
                return sysVersion;
            }
        }
        try {
            File parmsFile = new File(String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + "i4jparams.conf");
            if (parmsFile.exists() && (root = XMLHelper.readFileToDOM4J(parmsFile)) != null) {
                for (Object obj : root.selectNodes("/config/variables/variable")) {
                    Element varObj = (Element)obj;
                    String name = XMLHelper.getAttr(varObj, "name", null);
                    if (!name.equals("sys.version")) continue;
                    return XMLHelper.getAttr(varObj, "value", null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static JButton createButton() {
        JButton btn = new JButton();
        UIHelper.setControlSize(btn);
        return btn;
    }

    public static JButton createButton(ImageIcon icon) {
        JButton btn = new JButton(icon);
        UIHelper.setControlSize(btn);
        return btn;
    }

    public static JButton createI18NButton(String key) {
        JButton btn = new JButton(UIRegistry.getResourceString(key));
        UIHelper.setControlSize(btn);
        return btn;
    }

    public static JButton createButton(String text) {
        JButton btn = new JButton(text);
        UIHelper.setControlSize(btn);
        return btn;
    }

    public static JButton createButton(String text, ImageIcon icon) {
        JButton btn = new JButton(text, icon);
        UIHelper.setControlSize(btn);
        return btn;
    }

    public static JButton createButton(Action action) {
        JButton btn = new JButton(action);
        UIHelper.setControlSize(btn);
        return btn;
    }

    public static JButton[] adjustButtonArray(JButton[] buttonArray) {
        JButton[] jButtonArray = buttonArray;
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            JButton btn = jButtonArray[n2];
            UIHelper.setControlSize(btn);
            ++n2;
        }
        return buttonArray;
    }

    public static JTextField createTextField() {
        JTextField tf = new JTextField();
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static <T> T addAutoSelect(JTextField tf) {
        if (!UIHelper.isMacOS()) {
            tf.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getSource()).selectAll();
                }
            });
        }
        return (T)tf;
    }

    public static JTextField createTextField(String text) {
        JTextField tf = new JTextField(text);
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static JTextField createTextField(String text, int size) {
        JTextField tf = new JTextField(text, size);
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static JTextField createTextField(int size) {
        JTextField tf = new JTextField(size);
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static JPasswordField createPasswordField() {
        JPasswordField tf = new JPasswordField();
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static JPasswordField createPasswordField(String val) {
        JPasswordField tf = new JPasswordField(val);
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static JPasswordField createPasswordField(String val, int size) {
        JPasswordField tf = new JPasswordField(val, size);
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static JPasswordField createPasswordField(int size) {
        JPasswordField tf = new JPasswordField(size);
        UIHelper.setControlSize(tf);
        return tf;
    }

    public static JLabel createLabel(String text) {
        JLabel lbl = new JLabel(text);
        UIHelper.setControlSize(lbl);
        return lbl;
    }

    public static JLabel createLabel(String text, int horzAlignment) {
        JLabel lbl = new JLabel(text, horzAlignment);
        UIHelper.setControlSize(lbl);
        return lbl;
    }

    public static JLabel createI18NFormLabel(String key) {
        return UIHelper.createI18NFormLabel(key, 4);
    }

    public static JLabel createI18NFormLabel(String key, int horzAlignment) {
        return UIHelper.createFormLabel(UIRegistry.getResourceString(key), horzAlignment);
    }

    public static JLabel createFormLabel(String text) {
        return UIHelper.createFormLabel(text, 4);
    }

    public static JLabel createFormLabel(String text, int horzAlignment) {
        JLabel lbl = new JLabel(String.valueOf(text) + ":", horzAlignment);
        UIHelper.setControlSize(lbl);
        return lbl;
    }

    public static JLabel createLabel(String text, ImageIcon icon, int horzAlignment) {
        JLabel lbl = new JLabel(text, icon, horzAlignment);
        UIHelper.setControlSize(lbl);
        return lbl;
    }

    public static JLabel createLabel(String text, ImageIcon icon) {
        JLabel lbl = new JLabel(text, icon, 11);
        UIHelper.setControlSize(lbl);
        return lbl;
    }

    public static JRadioButton createRadioButton(String text) {
        JRadioButton rb = new JRadioButton(text);
        UIHelper.setControlSize(rb);
        return rb;
    }

    public static JCheckBox createCheckBox() {
        JCheckBox chkbx = new JCheckBox();
        UIHelper.setControlSize(chkbx);
        return chkbx;
    }

    public static JCheckBox createCheckBox(String text) {
        JCheckBox chkbx = new JCheckBox(text);
        UIHelper.setControlSize(chkbx);
        return chkbx;
    }

    public static JCheckBox createI18NCheckBox(String key) {
        JCheckBox chkbx = new JCheckBox(UIRegistry.getResourceString(key));
        UIHelper.setControlSize(chkbx);
        return chkbx;
    }

    public static JProgressBar createProgressBar(int start, int end) {
        JProgressBar pb = new JProgressBar(start, end);
        UIHelper.setControlSize(pb);
        return pb;
    }

    public static JProgressBar createProgressBar() {
        JProgressBar pb = new JProgressBar();
        UIHelper.setControlSize(pb);
        return pb;
    }

    public static JComboBox createComboBox() {
        JComboBox cbx = new JComboBox();
        UIHelper.setControlSize(cbx);
        if (isMacOS_10_5_X) {
            cbx.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        }
        return cbx;
    }

    public static JComboBox createComboBox(Object[] items) {
        JComboBox<Object> cbx = new JComboBox<Object>(items);
        UIHelper.setControlSize(cbx);
        if (isMacOS_10_5_X) {
            cbx.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        }
        return cbx;
    }

    public static JComboBox createComboBox(Vector<?> items) {
        JComboBox cbx = new JComboBox(items);
        UIHelper.setControlSize(cbx);
        if (isMacOS_10_5_X) {
            cbx.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        }
        return cbx;
    }

    public static JComboBox createComboBox(ComboBoxModel model) {
        JComboBox cbx = new JComboBox(model);
        UIHelper.setControlSize(cbx);
        if (isMacOS_10_5_X) {
            cbx.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        }
        return cbx;
    }

    public static JTextArea createTextArea() {
        final JTextArea text = new JTextArea();
        UIHelper.setControlSize(text);
        text.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "none");
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 9) {
                    if (event.isShiftDown()) {
                        text.transferFocusBackward();
                    } else {
                        text.transferFocus();
                    }
                }
            }
        });
        return text;
    }

    public static JTextArea createTextArea(int rows, int columns) {
        JTextArea text = new JTextArea(rows, columns);
        UIHelper.setControlSize(text);
        return text;
    }

    public static JList createList(ListModel model) {
        JList lst = new JList(model);
        if (isMacOS_10_5_X) {
            lst.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        }
        return lst;
    }

    public static JList createList(Vector<?> items) {
        JList lst = new JList(items);
        if (isMacOS_10_5_X) {
            lst.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        }
        return lst;
    }

    public static JFormattedTextField createFormattedTexField(String mask) {
        JFormattedTextField ftf = new JFormattedTextField(UIHelper.createFormatterMask(mask));
        UIHelper.setControlSize(ftf);
        return ftf;
    }

    public static MaskFormatter createFormatterMask(String mask) {
        MaskFormatter maskFormatter = null;
        try {
            maskFormatter = new MaskFormatter(mask);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return maskFormatter;
    }

    public static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        int i = 0;
        while (i < clr1.length) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
            ++i;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    public static void paintBorderGlow(Graphics2D g2, Shape shape, int glowWidth) {
        int gw;
        int i = gw = glowWidth * 2;
        while (i >= 2) {
            float pct = (float)(gw - i) / (float)(gw - 1);
            Color mixHi = UIHelper.getMixedColor(clrGlowInnerHi, pct, clrGlowOuterHi, 1.0f - pct);
            Color mixLo = UIHelper.getMixedColor(clrGlowInnerLo, pct, clrGlowOuterLo, 1.0f - pct);
            g2.setPaint(new GradientPaint(0.0f, 10.0f, mixHi, 0.0f, 40.0f, mixLo));
            g2.setColor(Color.WHITE);
            g2.setComposite(AlphaComposite.getInstance(10, pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(shape);
            i -= 2;
        }
    }

    public static BasicStroke getStdLineStroke() {
        return stdLineStroke;
    }

    public static void setStdLineStroke(BasicStroke stdLineStroke) {
        UIHelper.stdLineStroke = stdLineStroke;
    }

    public static void drawRoundedRect(Graphics2D g2d, Color color, Dimension size, int inset) {
        UIHelper.drawRoundedRect(g2d, color, size, inset, 5);
    }

    public static Triple<Border, Border, Color> getFocusBorders(Component comp) {
        Triple<Border, Border, Color> focusInfo = new Triple<Border, Border, Color>();
        if (focusInfo.first == null) {
            if (UIHelper.isMacOS()) {
                focusInfo.first = new MacBtnBorder();
                Insets fbInsets = ((Border)focusInfo.first).getBorderInsets(comp);
                focusInfo.second = new EmptyBorder(fbInsets);
            } else {
                focusInfo.third = UIManager.getLookAndFeel() instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getFocusColor() : UIManager.getColor("Button.focus");
                if (focusInfo.third == null) {
                    focusInfo.third = Color.YELLOW;
                }
                focusInfo.first = new LineBorder((Color)focusInfo.third, 1, true);
                focusInfo.second = new EmptyBorder(focusBorder.getBorderInsets(comp));
            }
        }
        return focusInfo;
    }

    public static void drawRoundedRect(Graphics2D g2d, Color color, Dimension size, int inset, int arcSize) {
        UIHelper.drawRoundedRect(g2d, color, inset, inset, size.width - inset * 2, size.height - inset * 2, arcSize, arcSize);
    }

    public static void drawRoundedRect(Graphics2D g2d, Color color, int x, int y, int w, int h, int arcSizeW, int arcSizeH) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(UIHelper.getStdLineStroke());
        g2d.setColor(color);
        g2d.drawRoundRect(x, y, w, h, arcSizeW, arcSizeH);
    }

    public static Color getHoverColor() {
        return hoverColor;
    }

    public static void setHoverColor(Color hoverColor) {
        UIHelper.hoverColor = hoverColor;
    }

    private static void buildKeyStrokeForCommandTypes(int[] keys, int[] mods) {
        int i = 0;
        CommandType[] commandTypeArray = CommandType.values();
        int n = commandTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandType cmdType = commandTypeArray[n2];
            cmdTypeKSHash.put(cmdType, KeyStroke.getKeyStroke(keys[i], mods[i]));
            ++i;
            ++n2;
        }
    }

    private static void buildKeyStrokeForCommandTypesMac() {
        int sc = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        int[] keys = new int[]{36, 34, 33, 35, 83, 78, 68};
        int[] mods = new int[]{sc, sc, sc, sc, sc, sc, sc};
        UIHelper.buildKeyStrokeForCommandTypes(keys, mods);
    }

    private static void buildKeyStrokeForCommandTypes() {
        int alt = 512;
        int[] keys = new int[]{38, 37, 39, 40, 83, 78, 68};
        int[] mods = new int[]{alt, alt, alt, alt, alt, alt, alt};
        UIHelper.buildKeyStrokeForCommandTypes(keys, mods);
    }

    public static KeyStroke getKeyStroke(CommandType cmdType) {
        return cmdTypeKSHash.get((Object)cmdType);
    }

    public static JButton createHelpIconButton(String helpContext) {
        JButton helpBtn;
        if (UIHelper.isMacOS()) {
            helpBtn = new JButton("");
            helpBtn.putClientProperty("JButton.buttonType", "help");
        } else {
            helpBtn = UIHelper.createButton(IconManager.getIcon("Help"));
            helpBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        helpBtn.setFocusable(false);
        HelpMgr.registerComponent((AbstractButton)helpBtn, helpContext);
        return helpBtn;
    }

    public static boolean isValidNameForDB(String name) {
        return name.matches("^(?:\\p{L}\\p{M}*|[0-9\\-. '`])*$");
    }

    public static String escapeName(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"`");
    }

    public static boolean isANumber(String str) {
        String separator = "\\" + DecimalFormatSymbols.getInstance().getDecimalSeparator();
        return StringUtils.isNumeric((String)str.replaceFirst("-", "").replaceFirst(separator, ""));
    }

    public static String fixColorForHTML(String textColorArg) {
        String textColor = textColorArg;
        if (textColorArg != null && !textColor.isEmpty()) {
            if (textColorArg.length() == 8) {
                textColor = "#" + textColorArg.substring(2);
            }
            if (textColor.charAt(0) != '#') {
                textColor = "#" + textColor;
            }
        } else {
            textColor = "#000000";
        }
        return textColor;
    }

    public static void addSaveKeyBinding(JComponent saveComp, Action saveAction) {
        UIHelper.addKeyBinding(saveComp, saveAction, "SAVE", 83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static void addKeyBinding(JComponent comp, Action action, String actionName, int keyCode, int modifier) {
        KeyStroke ctrlS = KeyStroke.getKeyStroke(keyCode, modifier);
        InputMap inputMap = comp.getInputMap(2);
        inputMap.put(ctrlS, actionName);
        ActionMap actionMap = comp.getActionMap();
        actionMap.put(actionName, action);
    }

    public static boolean checkForOpenGL() {
        AppPreferences localPrefs;
        block3: {
            localPrefs = AppPreferences.getLocalPrefs();
            String HAS_OPENGL_PREF = "SYSTEM.HasOpenGL";
            String USE_WORLDWIND = "USE.WORLDWIND";
            final Boolean initialUseWordWind = localPrefs.getBoolean("USE.WORLDWIND", null);
            final Boolean initialHasOpenGL = localPrefs.getBoolean("SYSTEM.HasOpenGL", null);
            if (UIHelper.isMacOS()) {
                localPrefs.putBoolean("SYSTEM.HasOpenGL", true);
                localPrefs.putBoolean("USE.WORLDWIND", true);
                return true;
            }
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        block15: {
                            Boolean hasOpenGL = localPrefs.getBoolean("SYSTEM.HasOpenGL", null);
                            if (hasOpenGL == null) {
                                JDialog frame;
                                block17: {
                                    frame = new JDialog();
                                    try {
                                        GLCanvas canvas = new GLCanvas();
                                        frame.getContentPane().add((Component)canvas);
                                        JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
                                        if (topFrame != null) {
                                            Rectangle screenRect = topFrame.getGraphicsConfiguration().getBounds();
                                            frame.setBounds(screenRect.width, screenRect.height + 50, 50, 50);
                                        } else {
                                            frame.setBounds(-100, -100, 50, 50);
                                        }
                                        frame.setVisible(true);
                                        hasOpenGL = true;
                                    }
                                    catch (GLException ex) {
                                        hasOpenGL = false;
                                        if (hasOpenGL == null) {
                                            hasOpenGL = UIHelper.isMacOS();
                                        }
                                        localPrefs.putBoolean("SYSTEM.HasOpenGL", hasOpenGL);
                                        if (initialUseWordWind == null || initialHasOpenGL != null && hasOpenGL != initialHasOpenGL) {
                                            localPrefs.putBoolean("USE.WORLDWIND", hasOpenGL);
                                        }
                                        SwingUtilities.invokeLater(new Runnable(frame){
                                            private final /* synthetic */ JDialog val$frame;
                                            {
                                                this.val$frame = jDialog;
                                            }

                                            @Override
                                            public void run() {
                                                if (this.val$frame != null) {
                                                    this.val$frame.setVisible(false);
                                                }
                                            }
                                        });
                                        break block15;
                                    }
                                    catch (Exception ex) {
                                        block16: {
                                            try {
                                                hasOpenGL = false;
                                                if (hasOpenGL != null) break block16;
                                            }
                                            catch (Throwable throwable) {
                                                if (hasOpenGL == null) {
                                                    hasOpenGL = UIHelper.isMacOS();
                                                }
                                                localPrefs.putBoolean("SYSTEM.HasOpenGL", hasOpenGL);
                                                if (initialUseWordWind == null || initialHasOpenGL != null && hasOpenGL != initialHasOpenGL) {
                                                    localPrefs.putBoolean("USE.WORLDWIND", hasOpenGL);
                                                }
                                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                                throw throwable;
                                            }
                                            hasOpenGL = UIHelper.isMacOS();
                                        }
                                        localPrefs.putBoolean("SYSTEM.HasOpenGL", hasOpenGL);
                                        if (initialUseWordWind == null || initialHasOpenGL != null && hasOpenGL != initialHasOpenGL) {
                                            localPrefs.putBoolean("USE.WORLDWIND", hasOpenGL);
                                        }
                                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                        break block15;
                                    }
                                    if (hasOpenGL != null) break block17;
                                    hasOpenGL = UIHelper.isMacOS();
                                }
                                localPrefs.putBoolean("SYSTEM.HasOpenGL", hasOpenGL);
                                if (initialUseWordWind == null || initialHasOpenGL != null && hasOpenGL != initialHasOpenGL) {
                                    localPrefs.putBoolean("USE.WORLDWIND", hasOpenGL);
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                    }
                });
            }
            catch (Error e) {
                e.printStackTrace();
                localPrefs.putBoolean("SYSTEM.HasOpenGL", false);
                if (initialUseWordWind != null && (initialHasOpenGL == null || !initialHasOpenGL.booleanValue())) break block3;
                localPrefs.putBoolean("USE.WORLDWIND", false);
            }
        }
        return localPrefs.getBoolean("SYSTEM.HasOpenGL", false);
    }

    public static boolean promptForAction(String yesLabelKey, String noLabelKey, String titleKey, String msg) {
        Object[] options = new Object[]{UIRegistry.getResourceString(yesLabelKey), UIRegistry.getResourceString(noLabelKey)};
        int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), msg, UIRegistry.getResourceString(titleKey), 0, 3, null, options, options[0]);
        return userChoice == 0;
    }

    public static void setTextToClipboard(String text) {
        StringSelection stsel = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stsel, stsel);
    }

    public static String getTextFromClipboard() {
        Clipboard sysClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        DataFlavor[] dataFlavorArray = sysClipboard.getAvailableDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor flavor = dataFlavorArray[n2];
            if (flavor.isMimeTypeEqual(DataFlavor.getTextPlainUnicodeFlavor())) {
                try {
                    StringBuilder sb = new StringBuilder();
                    Object dataObj = sysClipboard.getData(flavor);
                    if (dataObj instanceof String) {
                        sb.append((String)dataObj);
                    } else if (dataObj instanceof InputStreamReader) {
                        InputStreamReader reader = (InputStreamReader)sysClipboard.getData(flavor);
                        char[] buffer = new char[1024];
                        int len = reader.read(buffer);
                        sb.append(new String(buffer, 0, len));
                        while (len > -1) {
                            len = reader.read(buffer);
                            if (len <= 0) continue;
                            sb.append(buffer);
                        }
                    }
                    if (sb.length() <= 0) break;
                    return sb.toString();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            ++n2;
        }
        return null;
    }

    public static Double parseDouble(String value) {
        return doubleValidator.validate(value, Locale.getDefault());
    }

    public static BigDecimal parseDoubleToBigDecimal(String value) {
        return bigDecValidator.validate(value, Locale.getDefault());
    }

    public static boolean isAllCaps(String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isLetter(ch) && Character.isLowerCase(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void setVisibleRowCount(JTable table, int rows) {
        if (table != null) {
            table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredScrollableViewportSize().width, rows * table.getRowHeight()));
        }
    }

    public static void setVisibleRowCountForHeight(JTable table, int rows) {
        if (table != null) {
            int height = 0;
            int row = 0;
            while (row < rows) {
                height += table.getRowHeight(row);
                ++row;
            }
            table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredScrollableViewportSize().width, height));
        }
    }

    public static String createLocaleName(Locale locale, String fileName, String ext) {
        String fullPath;
        File file;
        String name = String.valueOf(fileName) + '_' + locale.getLanguage();
        if (StringUtils.isNotEmpty((String)locale.getCountry())) {
            name = String.valueOf(name) + '_' + locale.getCountry();
        }
        if ((file = new File(fullPath = String.valueOf(name) + '.' + ext)).exists()) {
            return name;
        }
        fullPath = String.valueOf(fileName) + '_' + locale.getLanguage() + '.' + ext;
        file = new File(name);
        if (!file.exists()) {
            fullPath = String.valueOf(fileName) + '.' + ext;
        }
        return fullPath;
    }

    public static boolean isValidEmailAddress(String emailAddress) {
        String expression = "^[\\w\\-]([\\.\\w])+[\\w]+@([\\w\\-]+\\.)+[A-Z]{2,4}$";
        String inputStr = emailAddress;
        Pattern pattern = Pattern.compile(expression, 2);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.matches();
    }

    public static enum CONTROLSIZE {
        regular,
        small,
        mini;

    }

    public static enum CommandType {
        First,
        Previous,
        Next,
        Last,
        Save,
        NewItem,
        DelItem;

    }

    public static enum OSTYPE {
        Unknown,
        Windows,
        MacOSX,
        Linux;

    }
}

