/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.UIHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class TristateCheckBox
extends JCheckBox {
    private RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State DONT_CARE = new State();
    private final TristateDecorator model;

    public TristateCheckBox(String text, Icon icon) {
        this(text, icon, NOT_SELECTED);
    }

    public TristateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setCheckState(initial);
    }

    public TristateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public TristateCheckBox(String text) {
        this(text, DONT_CARE);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener l) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.getCheckState() == DONT_CARE) {
            Graphics2D g2 = (Graphics2D)g;
            g2.addRenderingHints(this.hints);
            g2.setColor(Color.BLACK);
            Dimension s = this.getSize();
            if (UIHelper.isMacOS()) {
                Stroke origStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawLine(11, s.height / 2, 16, s.height / 2);
                g2.setStroke(origStroke);
            }
        }
    }

    public void setCheckState(State state) {
        this.model.setState(state);
    }

    public State getCheckState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setCheckState(SELECTED);
        } else {
            this.setCheckState(NOT_SELECTED);
        }
    }

    public static class State {
        private State() {
        }
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(false);
                this.setSelected(false);
            }
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return SELECTED;
            }
            if (!this.isSelected() && this.isArmed()) {
                return DONT_CARE;
            }
            return NOT_SELECTED;
        }

        private void nextState() {
            State current = this.getState();
            if (current == NOT_SELECTED) {
                this.setState(SELECTED);
            } else if (current == SELECTED) {
                this.setState(DONT_CARE);
            } else if (current == DONT_CARE) {
                this.setState(NOT_SELECTED);
            }
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setEnabled(boolean b) {
            TristateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        @Override
        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

