/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.GradiantButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;

public class TriangleButton
extends GradiantButton {
    protected static RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    protected boolean isDown = true;
    protected Polygon poly = new Polygon();
    protected Color triangleColor = Color.WHITE;

    static {
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public TriangleButton() {
        super("");
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(hints);
        if (this.pressed) {
            g.translate(1, 1);
        }
        this.poly.reset();
        Rectangle r = this.getBounds();
        int delta = (int)((double)r.width * 0.28);
        r.grow(-delta, -delta);
        if (this.isDown) {
            this.poly.addPoint(r.x, r.y);
            this.poly.addPoint(r.x + r.width, r.y);
            this.poly.addPoint(r.x + r.width / 2, r.y + r.height);
            this.poly.addPoint(r.x, r.y);
        } else {
            this.poly.addPoint(r.x, r.y);
            this.poly.addPoint(r.x, r.y + r.height);
            this.poly.addPoint(r.x + r.width, r.y + r.height / 2);
            this.poly.addPoint(r.x, r.y);
        }
        g.setColor(this.triangleColor);
        g.fillPolygon(this.poly);
    }

    public boolean isDown() {
        return this.isDown;
    }

    public void setDown(boolean isDown) {
        this.isDown = isDown;
        this.repaint();
    }

    public Color getTriangleColor() {
        return this.triangleColor;
    }

    public void setTriangleColor(Color triangleColor) {
        this.triangleColor = triangleColor;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.repaint();
    }
}

