/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.List;
import java.util.Vector;

public class ToolbarLayoutManager
implements LayoutManager,
LayoutManager2 {
    private Vector<Component> comps = new Vector();
    private Dimension preferredSize = new Dimension();
    private int borderPadding = 2;
    private int separation = 5;
    private int maxCompHeight = 0;
    private boolean adjustRightLastComp = false;

    public ToolbarLayoutManager(int borderPadding, int separation) {
        this(borderPadding, separation, false);
    }

    public ToolbarLayoutManager(int borderPadding, int separation, boolean adjustRightLastComp) {
        this.borderPadding = borderPadding;
        this.separation = separation;
        this.adjustRightLastComp = adjustRightLastComp;
    }

    public void setAdjustRightLastComp(boolean adjustRightLastComp) {
        this.adjustRightLastComp = adjustRightLastComp;
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
        if (arg1 == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        this.comps.addElement(arg1);
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Null component in removeLayoutComponent");
        }
        this.comps.removeElement(arg0);
    }

    @Override
    public Dimension preferredLayoutSize(Container arg0) {
        return new Dimension(this.preferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        return new Dimension(this.preferredSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this.comps.clear();
            int i = 0;
            while (i < target.getComponentCount()) {
                this.comps.add(target.getComponent(i));
                ++i;
            }
            Insets insets = target.getInsets();
            this.calcPreferredSize(target);
            int x = this.borderPadding + insets.left;
            int y = this.borderPadding + insets.top;
            Component lastComp = this.adjustRightLastComp ? (this.comps.size() > 0 ? this.comps.lastElement() : null) : null;
            for (Component comp : this.comps) {
                int lastCompX;
                Dimension size = comp.getPreferredSize();
                if (lastComp != null && comp == lastComp && (lastCompX = target.getWidth() - (this.borderPadding + size.width + insets.right)) > x) {
                    x = lastCompX;
                }
                int yc = y;
                if (size.height < this.preferredSize.height) {
                    yc = (this.preferredSize.height - size.height) / 2;
                }
                comp.setBounds(x, yc, size.width, size.height);
                x += size.width + this.separation;
            }
        }
    }

    protected void calcPreferredSize(Container target) {
        if (this.maxCompHeight == 0) {
            Insets insets = target.getInsets();
            this.preferredSize.setSize(this.borderPadding * 2 + insets.left + insets.right, this.borderPadding + insets.top + insets.bottom);
            for (Component comp : this.comps) {
                Dimension size = comp.getPreferredSize();
                this.maxCompHeight = Math.max(this.maxCompHeight, size.height);
                this.preferredSize.height = Math.max(this.preferredSize.height, size.height + 2 * this.borderPadding);
                this.preferredSize.width += size.width + this.separation;
            }
            this.preferredSize.width -= this.separation;
        }
    }

    public List<Component> getComponentList() {
        return this.comps;
    }

    public void removeAll() {
        this.comps.clear();
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        this.comps.addElement(comp);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.maxCompHeight = 0;
        this.preferredSize.setSize(0, 0);
        this.calcPreferredSize(target);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        this.calcPreferredSize(target);
        return new Dimension(this.preferredSize);
    }
}

