/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.DropDownButton;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Container;
import java.awt.Font;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class ToolBarDropDownBtn
extends DropDownButton
implements CommandListener {
    protected static final String PREFS = "Preferences";

    public ToolBarDropDownBtn(String label, ImageIcon icon, int textPosition, boolean addArrowBtn) {
        super(label, icon, null, textPosition, addArrowBtn);
        CommandDispatcher.register(PREFS, this);
    }

    public ToolBarDropDownBtn(String label, ImageIcon icon, String toolTip, int textPosition, boolean addArrowBtn) {
        super(label, icon, toolTip, textPosition, addArrowBtn);
        CommandDispatcher.register(PREFS, this);
    }

    public ToolBarDropDownBtn(String label, ImageIcon icon, int vertTextPosition, List<JComponent> menus) {
        super(label, icon, vertTextPosition, menus);
        CommandDispatcher.register(PREFS, this);
    }

    public ToolBarDropDownBtn(ImageIcon icon) {
        super(icon, false);
        CommandDispatcher.register(PREFS, this);
    }

    public void shutdown() {
        CommandDispatcher.unregister(PREFS, this);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    protected void prefsChanged(AppPreferences appPrefs) {
        if (appPrefs == AppPreferences.getRemote()) {
            AppPreferences ap = AppPreferences.getLocalPrefs();
            String key = "ui.formatting.controlSizes";
            String fontName = ap.get(String.valueOf(key) + ".FN", UIRegistry.getBaseFont().getFamily());
            int size = ap.getInt(String.valueOf(key) + ".SZ", UIRegistry.getBaseFont().getSize());
            this.mainBtn.setFont(UIRegistry.adjustPerDefaultFont(new Font(fontName, 0, size)));
            this.mainBtn.validate();
            this.mainBtn.repaint();
            Container parent = this.getParent();
            while (!(parent instanceof JToolBar) && parent != null) {
                parent = parent.getParent();
            }
            if (parent != null) {
                parent.invalidate();
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(PREFS)) {
            this.prefsChanged((AppPreferences)cmdAction.getData());
        }
    }
}

