/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.NavBoxLayoutManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToggleButtonChooserPanel<T>
extends JPanel
implements ActionListener {
    protected List<T> items = new Vector<T>();
    protected Vector<JToggleButton> buttons = new Vector();
    protected Vector<JToggleButton> unusedButtons = new Vector();
    protected JButton selectAllBtn;
    protected JButton deselectAllBtn;
    protected ButtonGroup group = null;
    protected JScrollPane listScroller = null;
    protected JPanel listPanel = null;
    protected Type uiType = null;
    protected String desc = null;
    protected int initialSelectedIndex = -1;
    protected boolean addSelectAll = false;
    protected List<T> selectedItems = null;
    protected boolean isBuilt = false;
    protected ChangeListener changeListener = null;
    protected ActionListener actionListener = null;
    protected boolean useScrollPane = false;
    protected JButton okBtn = null;
    protected int staticSize = -1;
    protected boolean wasCreated = false;
    protected boolean hasInitialSelection = false;

    public ToggleButtonChooserPanel(int staticSize, Type uiType) {
        this(null, null, uiType);
        this.staticSize = staticSize;
    }

    public ToggleButtonChooserPanel(List<T> listItems, Type uiType) {
        this(listItems, null, uiType);
    }

    public ToggleButtonChooserPanel(List<T> listItems, String desc, Type uiType) {
        if (listItems != null) {
            this.items.addAll(listItems);
        }
        this.desc = desc;
        this.uiType = uiType;
        this.setDoubleBuffered(true);
    }

    protected JToggleButton createBtn(String label) {
        JToggleButton togBtn;
        if (this.uiType == Type.Checkbox) {
            togBtn = UIHelper.createCheckBox(label);
        } else {
            togBtn = UIHelper.createRadioButton(label);
            this.group.add(togBtn);
        }
        if (this.changeListener != null) {
            togBtn.addChangeListener(this.changeListener);
        }
        if (this.actionListener != null) {
            togBtn.addActionListener(this.actionListener);
        }
        if (this.okBtn != null) {
            togBtn.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((JToggleButton)e.getSource()).isSelected()) {
                        ToggleButtonChooserPanel.this.okBtn.setEnabled(true);
                    }
                }
            });
        }
        togBtn.setOpaque(false);
        return togBtn;
    }

    public void createUI() {
        this.removeAll();
        this.buttons.clear();
        this.isBuilt = true;
        StringBuffer rowDef = new StringBuffer();
        if (this.desc != null) {
            rowDef.append("p,2px,");
        }
        rowDef.append("f:p:g");
        if (this.addSelectAll && this.uiType == Type.Checkbox) {
            rowDef.append(",2px,p");
        }
        rowDef.append(",10px");
        int y = 1;
        CellConstraints cc = new CellConstraints();
        PanelBuilder panelBlder = new PanelBuilder(new FormLayout("f:p:g", rowDef.toString()), (JPanel)this);
        JPanel panel = panelBlder.getPanel();
        panel.setDoubleBuffered(true);
        if (this.desc != null) {
            JLabel lbl = UIHelper.createLabel(UIRegistry.getResourceString(this.desc), 0);
            panelBlder.add((Component)lbl, cc.xy(1, y));
            y += 2;
        }
        boolean isStaticSize = this.staticSize > -1;
        int len = isStaticSize ? this.staticSize : this.items.size();
        this.listPanel = new JPanel(new NavBoxLayoutManager(2, 2));
        this.listPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.listPanel.setDoubleBuffered(true);
        if (this.useScrollPane) {
            this.listPanel.setBackground(Color.WHITE);
        }
        this.group = this.uiType == Type.Checkbox ? null : new ButtonGroup();
        int yy = 1;
        int i = 0;
        while (i < len) {
            Object obj = isStaticSize ? null : (Object)this.items.get(i);
            String label = isStaticSize ? "XXXXXXXXXXXXXXXXXXXXXXXXXX" : obj.toString();
            JToggleButton togBtn = this.createBtn(label);
            this.buttons.add(togBtn);
            this.listPanel.add(togBtn);
            yy += 2;
            ++i;
        }
        Dimension size = this.listPanel.getPreferredSize();
        this.listPanel.setSize(size);
        if (this.useScrollPane) {
            if (this.listScroller == null) {
                this.listScroller = new JScrollPane(this.listPanel, 20, 31);
                this.listScroller.setDoubleBuffered(true);
            }
            if (this.buttons.size() > 0) {
                Dimension btnPrefSize = this.buttons.get(0).getPreferredSize();
                Dimension scollerPrefSize = this.listScroller.getPreferredSize();
                scollerPrefSize.height = btnPrefSize.height * 11;
                this.listScroller.getViewport().setPreferredSize(scollerPrefSize);
            }
            panelBlder.add((Component)this.listScroller, cc.xy(1, y));
            y += 2;
        } else {
            panelBlder.add((Component)this.listPanel, cc.xy(1, y));
            y += 2;
        }
        panel.setDoubleBuffered(true);
        if (this.addSelectAll && this.uiType == Type.Checkbox) {
            this.selectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("SELECTALL"));
            this.deselectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("DeselectAll"));
            this.selectAllBtn.addActionListener(this);
            this.deselectAllBtn.addActionListener(this);
            PanelBuilder bb = new PanelBuilder(new FormLayout("f:p:g,p,10px,p,f:p:g", "p"));
            bb.add((Component)this.selectAllBtn, cc.xy(2, 1));
            bb.add((Component)this.deselectAllBtn, cc.xy(4, 1));
            panelBlder.add((Component)bb.getPanel(), cc.xy(1, y));
            y += 2;
        }
        if (this.initialSelectedIndex != -1) {
            this.setSelectedIndex(this.initialSelectedIndex);
        }
        if (isStaticSize) {
            this.setItems(null);
        }
        this.wasCreated = true;
        this.setSelectedObjects(this.selectedItems);
    }

    public JComponent getUIComponent() {
        return this;
    }

    public T getItemForBtn(JToggleButton btn) {
        int inx = this.buttons.indexOf(btn);
        if (inx > -1 && inx < this.items.size()) {
            return this.items.get(inx);
        }
        System.err.println("Mismatch between btn slected and items list!");
        return null;
    }

    public Vector<JToggleButton> getButtons() {
        return this.buttons;
    }

    public void setItems(List<T> itemsArg) {
        if (this.group != null) {
            this.group.clearSelection();
        }
        this.items.clear();
        this.listPanel.removeAll();
        this.unusedButtons.addAll(this.buttons);
        this.buttons.clear();
        if (itemsArg != null) {
            this.items.addAll(itemsArg);
            int i = 0;
            while (i < itemsArg.size()) {
                JToggleButton tb;
                if (this.unusedButtons.size() > 0) {
                    tb = this.unusedButtons.get(0);
                    this.unusedButtons.remove(0);
                } else {
                    tb = this.createBtn(" ");
                }
                this.buttons.add(tb);
                tb.setText(itemsArg.get(i).toString());
                tb.setSelected(false);
                tb.setEnabled(true);
                this.listPanel.add(tb);
                ++i;
            }
        }
        Dimension size = this.listPanel.getPreferredSize();
        this.listPanel.setSize(size);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.items.size()) {
            JToggleButton tb = this.buttons.elementAt(i);
            tb.setEnabled(enabled);
            ++i;
        }
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setAddSelectAll(boolean addSelectAll) {
        this.addSelectAll = addSelectAll;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean doSelect;
        boolean bl = doSelect = e.getSource() == this.selectAllBtn;
        if (!doSelect && this.hasInitialSelection) {
            this.okBtn.setEnabled(true);
        }
        for (JToggleButton tb : this.buttons) {
            if (!tb.isEnabled()) continue;
            tb.setSelected(doSelect);
        }
    }

    public void setUseScrollPane(boolean useScrollPane) {
        this.useScrollPane = useScrollPane;
    }

    public T getSelectedObject() {
        int inx = 0;
        for (JToggleButton tb : this.buttons) {
            if (tb.isSelected()) {
                return this.items.get(inx);
            }
            ++inx;
        }
        return null;
    }

    public void setSelectedIndex(int index) {
        if (this.wasCreated) {
            if (index > -1 && index < this.buttons.size()) {
                this.buttons.get(index).setSelected(true);
            }
        } else {
            this.hasInitialSelection = true;
            this.initialSelectedIndex = index;
        }
    }

    public void setSelectedObj(T item) {
        if (!this.wasCreated) {
            this.hasInitialSelection = true;
        }
        this.setSelectedIndex(this.items.indexOf(item));
    }

    public int getSelectedIndex() {
        int inx = 0;
        for (JToggleButton tb : this.buttons) {
            if (tb.isSelected()) {
                return inx;
            }
            ++inx;
        }
        return -1;
    }

    public void setSelectedObjects(List<T> selectedItems) {
        if (!this.wasCreated) {
            this.selectedItems = selectedItems;
            this.hasInitialSelection = true;
        } else if (selectedItems != null) {
            block0: for (T obj : selectedItems) {
                int inx = 0;
                for (JToggleButton tb : this.buttons) {
                    if (obj == this.items.get(inx)) {
                        tb.setSelected(true);
                        continue block0;
                    }
                    ++inx;
                }
            }
        }
    }

    public List<T> getSelectedObjects() {
        Vector<T> list = new Vector<T>();
        int inx = 0;
        for (JToggleButton tb : this.buttons) {
            if (tb.isSelected()) {
                list.add(this.items.get(inx));
            }
            ++inx;
        }
        return list;
    }

    public boolean hasSelection() {
        for (JToggleButton tb : this.buttons) {
            if (!tb.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setOkBtn(JButton okBtn) {
        this.okBtn = okBtn;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
        if (this.wasCreated) {
            for (JToggleButton tb : this.buttons) {
                tb.addChangeListener(changeListener);
            }
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
        if (this.wasCreated) {
            for (JToggleButton tb : this.buttons) {
                tb.addActionListener(actionListener);
            }
        }
    }

    public static enum Type {
        Checkbox,
        RadioButton;

    }
}

