/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.TableSearcherCell;
import edu.ku.brc.ui.tmanfe.SearchReplacePanel;
import edu.ku.brc.ui.tmanfe.SpreadSheet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TableSearcher {
    private static final boolean debugging = false;
    protected static final Logger log = Logger.getLogger(TableSearcher.class);
    protected int initialRow;
    protected int initialCol;
    protected boolean isFirstPassOnTable;
    protected int replacementCount;
    protected SpreadSheet table;
    protected SearchReplacePanel findPanel;

    public TableSearcher(SpreadSheet table, SearchReplacePanel findPanel) {
        this.table = table;
        this.findPanel = findPanel;
        this.initialRow = -1;
        this.initialCol = -1;
        this.reset();
    }

    protected void reset() {
        this.isFirstPassOnTable = true;
        this.replacementCount = 0;
    }

    public int getNextRow(int prevRow, int prevColumn, boolean isSearchDown, boolean isWrapOn) {
        return this.getNewCellValue(prevRow, prevColumn, isSearchDown, isWrapOn, true);
    }

    public int getNextColumn(int prevRow, int prevColumn, boolean isSearchDown, boolean isWrapOn) {
        return this.getNewCellValue(prevRow, prevColumn, isSearchDown, isWrapOn, false);
    }

    private int getNewCellValue(int prevRow, int prevColumn, boolean isSearchDown, boolean isWrapOn, boolean returnRow) {
        int curRow = prevRow;
        int curCol = prevColumn;
        if (isSearchDown) {
            if (curRow == -1) {
                curRow = 0;
            }
            if (curCol >= this.table.getColumnModel().getColumnCount() - 1) {
                ++curRow;
                curCol = -1;
            }
            if (isWrapOn && curRow >= this.table.getRowCount()) {
                curRow = 0;
            }
            ++curCol;
        } else {
            if (curRow == -1) {
                curRow = this.table.getRowCount() - 1;
            }
            if (curCol <= 0) {
                --curRow;
                curCol = this.table.getColumnModel().getColumnCount();
            }
            --curCol;
        }
        if (returnRow) {
            return curRow;
        }
        return curCol;
    }

    public TableSearcherCell findNext(String searchValue, int prevRow, int prevColumn, boolean isSearchDown, boolean isWrapOn, boolean isMatchCaseOn, boolean isSearchSelection) {
        if (!this.isTableValid()) {
            return null;
        }
        this.stopTableEditing();
        String findValue = searchValue;
        int curRow = prevRow;
        int curCol = prevColumn;
        curRow = this.getNextRow(curRow, curCol, isSearchDown, isWrapOn);
        curCol = this.getNextColumn(curRow, curCol, isSearchDown, isWrapOn);
        TableSearcherCell cell = this.searchTableForValue(findValue, curRow, curCol, isMatchCaseOn, isSearchDown, isWrapOn, isSearchSelection);
        return cell;
    }

    private boolean isTableValid() {
        if (this.table == null) {
            this.findPanel.setStatusLabelWithFailedFind();
            return false;
        }
        return true;
    }

    public boolean replace(TableSearcherCell cell, String findValue, String replaceValue, boolean isMtchCaseOn, boolean isSearchSelection) {
        if (!this.isTableValid()) {
            return false;
        }
        if (cell == null) {
            return false;
        }
        this.stopTableEditing();
        int row = cell.getRow();
        int col = cell.getColumn();
        Object o = this.table.getValueAt(row, col);
        if (!(o instanceof String)) {
            log.info((Object)("replace () The value  value=[ " + o.toString() + "] is not a String and cannot be replaced"));
            return false;
        }
        if (row == -1 || col == -1) {
            this.findPanel.setStatusLabelWithFailedFind();
            return false;
        }
        String newValue = "";
        String oldValue = o.toString();
        if (cell.isFound()) {
            newValue = isMtchCaseOn ? Pattern.compile(findValue).matcher(oldValue).replaceAll(replaceValue) : Pattern.compile(Pattern.quote(findValue), 2).matcher(oldValue).replaceAll(replaceValue);
            this.table.setValueAt(newValue, row, col);
            ++this.replacementCount;
            return true;
        }
        return false;
    }

    private void stopTableEditing() {
        if (this.table == null && this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
            return;
        }
    }

    public TableSearcherCell checkCellForMatch(String searchStringArg, int row, int column, boolean isMatchCaseOn) {
        String searchString = searchStringArg;
        Object cellValue = this.table.getValueAt(row, column);
        if (cellValue != null) {
            String valueInTable = cellValue.toString();
            if (!isMatchCaseOn) {
                valueInTable = valueInTable.toLowerCase();
                searchString = searchString.toLowerCase();
            }
            if (valueInTable.contains(searchString)) {
                this.isFirstPassOnTable = true;
                return new TableSearcherCell(row, column, true, cellValue.toString());
            }
        }
        return new TableSearcherCell(-1, -1, false, null);
    }

    private TableSearcherCell searchTableForValueBkwds(String searchStringArg, int row, int column, boolean isMatchCaseOn, boolean isWrapOn, boolean isSearchSelection) {
        String searchString = searchStringArg;
        int currentRow = row;
        int currentColumn = column;
        int numOfCols = this.table.getColumnCount();
        int numOfRows = this.table.getRowCount();
        boolean isStartOfRow = true;
        int i = currentRow;
        while (i > -1) {
            if (!isStartOfRow) {
                currentColumn = numOfCols - 1;
            }
            int j = currentColumn;
            while (j > -1) {
                TableSearcherCell cell = this.checkCell(searchString, i, j, isMatchCaseOn, isSearchSelection);
                if (cell.isFound()) {
                    return cell;
                }
                isStartOfRow = false;
                --j;
            }
            --i;
        }
        if (isWrapOn && this.isFirstPassOnTable) {
            this.isFirstPassOnTable = false;
            return this.searchTableForValueBkwds(searchString, --numOfRows, --numOfCols, isMatchCaseOn, isWrapOn, isSearchSelection);
        }
        this.reset();
        return new TableSearcherCell(-1, -1, false, null);
    }

    public TableSearcherCell checkCell(String searchString, int i, int j, boolean isMatchCaseOn, boolean isSearchSelection) {
        TableSearcherCell cell;
        if (!this.isFirstPassOnTable && this.initialRow == i && this.initialCol == j) {
            return new TableSearcherCell(-1, -1, false, null);
        }
        if ((!isSearchSelection || this.table.isCellSelected(i, j)) && (cell = this.checkCellForMatch(searchString, i, j, isMatchCaseOn)).isFound()) {
            return cell;
        }
        return new TableSearcherCell(-1, -1, false, null);
    }

    private TableSearcherCell searchTableForValue(String searchString, int row, int column, boolean isMatchCaseOn, boolean isForwardSearch, boolean isWrapOn, boolean isSearchSelection) {
        int currentRow = row;
        int currentColumn = column;
        int numOfCols = this.table.getColumnCount();
        int numOfRows = this.table.getRowCount();
        if (this.isFirstPassOnTable) {
            this.initialRow = currentRow;
            this.initialCol = currentColumn;
        }
        if (!isForwardSearch) {
            TableSearcherCell matchCell = this.searchTableForValueBkwds(searchString, currentRow, currentColumn, isMatchCaseOn, isWrapOn, isSearchSelection);
            return matchCell;
        }
        boolean isStartOfRow = true;
        int i = currentRow;
        while (i < numOfRows) {
            if (!isStartOfRow) {
                currentColumn = 0;
            }
            int j = currentColumn;
            while (j < numOfCols) {
                TableSearcherCell cell = this.checkCell(searchString, i, j, isMatchCaseOn, isSearchSelection);
                if (cell.isFound()) {
                    return cell;
                }
                isStartOfRow = false;
                ++j;
            }
            ++i;
        }
        if (isWrapOn && this.isFirstPassOnTable) {
            this.isFirstPassOnTable = false;
            TableSearcherCell matchCell = this.searchTableForValue(searchString, 0, 0, isMatchCaseOn, isForwardSearch, isWrapOn, isSearchSelection);
            return matchCell;
        }
        this.isFirstPassOnTable = true;
        return new TableSearcherCell(-1, -1, false, null);
    }

    public void replacementCleanup() {
        if (this.replacementCount > 0) {
            this.table.getModel().fireTableDataChanged();
        }
    }

    public int getReplacementCount() {
        return this.replacementCount;
    }
}

