/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class StringFormatHelper {
    private static final HashMap<String, StringFormatHelper> hashMap = new HashMap();
    private static final HashMap<Integer, Object[]> valueArrayHash = new HashMap();
    private static final ArrayList<Object> valueArrayList = new ArrayList();
    private boolean isInError = false;
    private String[] formats;
    private StringBuilder sb = new StringBuilder();

    public static StringFormatHelper getStringFormatHelper(String formatStr, boolean displayError) {
        StringFormatHelper sfh = hashMap.get(formatStr);
        if (sfh == null) {
            sfh = new StringFormatHelper();
            boolean bl = !sfh.createFormatter(formatStr, displayError);
            sfh.isInError = bl;
            hashMap.put(formatStr, sfh);
        }
        return sfh.isInError ? null : sfh;
    }

    private StringFormatHelper() {
    }

    public boolean isInError() {
        return this.isInError;
    }

    public boolean createFormatter(String formatStr, boolean displayError) {
        String[] fmts = StringUtils.splitPreserveAllTokens((String)formatStr, (char)'%');
        if (fmts != null && fmts.length > 0) {
            ArrayList<String> fmtList = new ArrayList<String>();
            String[] stringArray = fmts;
            int n = fmts.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (StringUtils.isNotEmpty((String)str)) {
                    fmtList.add("%" + str);
                }
                ++n2;
            }
            this.formats = new String[fmtList.size()];
            fmtList.toArray(this.formats);
            return true;
        }
        return false;
    }

    public synchronized String format(Object ... args) {
        this.sb.setLength(0);
        valueArrayList.clear();
        if (args.length == this.formats.length) {
            int i = 0;
            while (i < this.formats.length) {
                if (args[i] != null) {
                    this.sb.append(this.formats[i]);
                    valueArrayList.add(args[i]);
                }
                ++i;
            }
            Object[] vals = valueArrayHash.get(valueArrayList.size());
            if (vals == null) {
                vals = new Object[valueArrayList.size()];
                valueArrayHash.put(valueArrayList.size(), vals);
            }
            valueArrayList.toArray(vals);
            valueArrayList.clear();
            return String.format(this.sb.toString(), vals);
        }
        return null;
    }
}

