/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.GradiantLabel;
import edu.ku.brc.ui.IconManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SortableTableModel
implements TableModel,
TableModelListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected TableModel delegatedModel;
    protected int[] sortedIndicies;
    protected int sortColumn;
    protected Comparator<Object> comparator;
    protected Comparator[] comparators;
    protected boolean[] sortDirection;
    protected boolean isSorted = false;

    public SortableTableModel(TableModel tm) {
        this.delegatedModel = tm;
        this.comparators = new Comparator[tm.getColumnCount()];
        this.sortDirection = new boolean[tm.getColumnCount()];
        this.sortedIndicies = new int[0];
        int i = 0;
        while (i < this.sortDirection.length) {
            this.sortDirection[i] = false;
            ++i;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableModelEvent(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TableModelListener.class) {
                ((TableModelListener)listeners[i + 1]).tableChanged(e);
            }
            i -= 2;
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (this.delegatedModel.getRowCount() > 0) {
            return this.delegatedModel.getValueAt(0, column).getClass();
        }
        return Object.class;
    }

    public TableModel getDelegateModel() {
        return this.delegatedModel;
    }

    @Override
    public int getColumnCount() {
        return this.delegatedModel.getColumnCount();
    }

    @Override
    public String getColumnName(int index) {
        return this.delegatedModel.getColumnName(index);
    }

    @Override
    public int getRowCount() {
        return this.delegatedModel.getRowCount();
    }

    public int getDelegatedRow(int rowIndex) {
        return this.isSorted ? this.sortedIndicies[rowIndex] : rowIndex;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.delegatedModel.getValueAt(this.getDelegatedRow(rowIndex), columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.delegatedModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.delegatedModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    protected void setComparatorForColumn(Comparator<Object> c, int i) {
        if (i > this.comparators.length) {
            Comparator[] newComparators = new Comparator[i + 1];
            System.arraycopy(this.comparators, 0, newComparators, 0, this.comparators.length);
            this.comparators = newComparators;
        }
        this.comparators[i] = c;
    }

    public void setSortColumn(int i) {
        this.sortColumn = i;
        this.comparator = null;
        if (this.comparators != null && this.comparators.length > 0) {
            this.comparator = this.comparators[this.sortColumn];
        }
        this.sortDirection[this.sortColumn] = !this.sortDirection[this.sortColumn];
        this.resort();
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    protected void resort() {
        if (this.sortedIndicies.length != this.delegatedModel.getRowCount()) {
            this.sortedIndicies = new int[this.delegatedModel.getRowCount()];
        }
        ArrayList<SortingDelegate> sortMe = new ArrayList<SortingDelegate>();
        int i = 0;
        while (i < this.delegatedModel.getRowCount()) {
            SortingDelegate sd = new SortingDelegate(this.delegatedModel.getValueAt(i, this.getSortColumn()), i);
            sortMe.add(sd);
            ++i;
        }
        SortingDelegateComparator sdc = new SortingDelegateComparator(this.comparator, this.getSortColumn());
        Collections.sort(sortMe, sdc);
        int i2 = 0;
        while (i2 < sortMe.size()) {
            this.sortedIndicies[i2] = ((SortingDelegate)sortMe.get((int)i2)).row;
            ++i2;
        }
        this.isSorted = true;
        this.fireAllChanged();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        switch (e.getType()) {
            case -1: {
                this.resort();
                this.fireAllChanged();
                break;
            }
            case 1: {
                this.resort();
                this.fireAllChanged();
                break;
            }
            case 0: {
                this.resort();
                this.fireAllChanged();
            }
        }
    }

    protected void fireAllChanged() {
        TableModelEvent e = new TableModelEvent(this);
        this.fireTableModelEvent(e);
    }

    class SortableTableHeaderCellRenderer
    extends GradiantLabel
    implements TableCellRenderer {
        protected ImageIcon downIcon;
        protected ImageIcon upIcon;
        protected ImageIcon blankIcon;

        public SortableTableHeaderCellRenderer() {
            super("");
            this.downIcon = IconManager.getScaledIcon(IconManager.getIcon("DownArrow", IconManager.IconSize.Std16), IconManager.IconSize.Std16, IconManager.IconSize.Std8);
            this.upIcon = IconManager.getScaledIcon(IconManager.getIcon("UpArrow", IconManager.IconSize.Std16), IconManager.IconSize.Std16, IconManager.IconSize.Std8);
            this.blankIcon = IconManager.getScaledIcon(IconManager.getIcon("BlankIcon", IconManager.IconSize.Std16), IconManager.IconSize.Std16, IconManager.IconSize.Std8);
            this.setHorizontalTextPosition(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            this.setIcon(SortableTableModel.this.isSorted && vColIndex == SortableTableModel.this.sortColumn ? (SortableTableModel.this.sortDirection[vColIndex] ? this.downIcon : this.upIcon) : this.blankIcon);
            this.setText(value != null ? value.toString() : "");
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class SortingDelegate {
        public Object value;
        public int row;

        public SortingDelegate(Object v, int r) {
            this.value = v;
            this.row = r;
        }
    }

    class SortingDelegateComparator
    implements Comparator<Object> {
        protected Comparator<Object> comp;
        protected int columnIndex;

        public SortingDelegateComparator(Comparator<Object> c, int columnIndex) {
            this.comp = c;
            this.columnIndex = columnIndex;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object v1 = ((SortingDelegate)o1).value;
            Object v2 = ((SortingDelegate)o2).value;
            if (this.comp != null) {
                return SortableTableModel.this.sortDirection[this.columnIndex] ? this.comp.compare(v1, v2) : this.comp.compare(v2, v1);
            }
            if (v1 instanceof Comparable) {
                return SortableTableModel.this.sortDirection[this.columnIndex] ? ((Comparable)v1).compareTo(v2) : ((Comparable)v2).compareTo(v1);
            }
            throw new IllegalArgumentException("Can't compare objects for sorting");
        }
    }
}

