/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class ScrollablePopupMenu
extends JPopupMenu
implements ActionListener {
    public static final Icon EMPTY_IMAGE_ICON = new ImageIcon("menu_spacer.gif");
    private JPanel panelMenus = new JPanel();
    private JScrollPane scroll = null;

    public ScrollablePopupMenu() {
        this.setLayout(new BorderLayout());
        this.panelMenus.setLayout(new GridLayout(0, 1));
        this.panelMenus.setBackground(UIManager.getColor("MenuItem.background"));
    }

    private static Frame getFrame(Component c) {
        Component w = c;
        while (!(w instanceof Frame) && w != null) {
            w = w.getParent();
        }
        return (Frame)w;
    }

    private void init(Component invoker) {
        super.removeAll();
        Frame frame = ScrollablePopupMenu.getFrame(invoker);
        this.scroll = new JScrollPane();
        this.scroll.setViewportView(this.panelMenus);
        this.scroll.setBorder(null);
        this.scroll.setMinimumSize(new Dimension(240, 40));
        Dimension maxSize = new Dimension(this.scroll.getMaximumSize().width, this.getToolkit().getScreenSize().height - this.getToolkit().getScreenInsets((GraphicsConfiguration)frame.getGraphicsConfiguration()).top - this.getToolkit().getScreenInsets((GraphicsConfiguration)frame.getGraphicsConfiguration()).bottom - 4);
        this.scroll.setMaximumSize(maxSize);
        this.scroll.setFocusable(false);
        this.panelMenus.setFocusable(false);
        super.add((Component)this.scroll, "Center");
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this.init(invoker);
        this.panelMenus.validate();
        int maxsize = this.scroll.getMaximumSize().height;
        int realsize = this.panelMenus.getPreferredSize().height;
        int sizescroll = 0;
        if (maxsize < realsize) {
            sizescroll = this.scroll.getVerticalScrollBar().getPreferredSize().width;
        }
        this.scroll.setPreferredSize(new Dimension(this.scroll.getPreferredSize().width + sizescroll + 20, this.scroll.getPreferredSize().height));
        this.pack();
        this.setInvoker(invoker);
        if (sizescroll != 0) {
            this.setPopupSize(new Dimension(this.scroll.getPreferredSize().width + 20, this.scroll.getMaximumSize().height - 20));
        }
        Point invokerOrigin = invoker.getLocationOnScreen();
        this.setLocation((int)invokerOrigin.getX() + x, (int)invokerOrigin.getY() + y);
        this.panelMenus.getComponent(0).requestFocus();
        super.show(invoker, x, y);
    }

    public void hidemenu() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        if (menuItem != null) {
            this.panelMenus.add(menuItem);
        }
        return menuItem;
    }

    @Override
    public void addSeparator() {
        this.panelMenus.add(new JSeparator());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hidemenu();
    }

    @Override
    public Component[] getComponents() {
        return this.panelMenus.getComponents();
    }
}

