/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.DataActionEvent;
import edu.ku.brc.ui.dnd.DndDeletable;
import edu.ku.brc.ui.dnd.DragAndDropLock;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import edu.ku.brc.ui.dnd.ShadowFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class RolloverCommand
extends JPanel
implements GhostActionable,
DndDeletable {
    protected static Color transparentWhite = new Color(255, 255, 255, 180);
    protected static Color focusColor = Color.BLUE;
    protected static Color activeColor = new Color(0, 150, 0, 100);
    protected static Color hoverColor = new Color(0, 0, 150, 100);
    protected static Color dropColor = new Color(255, 140, 0, 100);
    protected static final int ICON_TEXT_GAP = 4;
    public static ImageIcon hoverImg = null;
    protected static Font defaultFont = null;
    protected static int vertGap = 0;
    protected static boolean useEmptyBorder = false;
    protected JTextField txtFld = null;
    protected JLabel iconLabel;
    protected boolean isEditing = false;
    protected PropertyChangeListener pcl = null;
    protected boolean isOver = false;
    protected Vector<ActionListener> actions = new Vector();
    protected ImageIcon imgIcon = null;
    protected String label = "";
    protected BufferedImage sizeBufImg = null;
    protected Dimension preferredSize = new Dimension(0, 0);
    protected Vector<ActionListener> listeners = new Vector();
    protected GhostMouseInputAdapter mouseDropAdapter = null;
    protected Object data = null;
    protected static final int SHADOW_SIZE = 10;
    protected RenderingHints hints = null;
    protected BufferedImage shadowBuffer = null;
    protected BufferedImage buffer = null;
    protected double ratio = 0.0;
    protected Dimension prefferedRenderSize = new Dimension(0, 0);
    protected boolean verticalLayout = false;
    protected JPopupMenu popupMenu = null;
    protected RolloverCommand itself = null;
    protected List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();
    protected List<DataFlavor> dragFlavors = new ArrayList<DataFlavor>();
    protected boolean isActive = false;
    protected CommandAction deleteCmdAction = null;

    protected RolloverCommand() {
    }

    public RolloverCommand(String label, ImageIcon imgIcon) {
        if (useEmptyBorder) {
            this.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        }
        this.setLayout(new BorderLayout());
        this.imgIcon = imgIcon;
        this.label = label;
        this.iconLabel = new JLabel(imgIcon);
        this.itself = this;
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            protected boolean wasPopUp = false;
            protected Point downME = null;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (RolloverCommand.this.isEnabled()) {
                    RolloverCommand.this.isOver = true;
                    RolloverCommand.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RolloverCommand.this.isOver = false;
                RolloverCommand.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.downME = e.getPoint();
                RolloverCommand.this.repaint();
                this.wasPopUp = e.isPopupTrigger();
                if (RolloverCommand.this.popupMenu != null && this.wasPopUp && RolloverCommand.this.itself.isEnabled()) {
                    RolloverCommand.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RolloverCommand.this.repaint();
                Point pnt = e.getPoint();
                boolean clicked = Math.abs(pnt.x - this.downME.x) < 4 && Math.abs(pnt.y - this.downME.y) < 4;
                Rectangle r = RolloverCommand.this.getBounds();
                r.x = 0;
                r.y = 0;
                if (!this.wasPopUp && clicked && RolloverCommand.this.isEnabled() && r.contains(e.getPoint())) {
                    if (!e.isPopupTrigger()) {
                        RolloverCommand.this.doAction(RolloverCommand.this);
                    } else if (RolloverCommand.this.popupMenu != null) {
                        RolloverCommand.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RolloverCommand.this.repaint();
            }
        });
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.iconLabel != null) {
            this.iconLabel.setBackground(bg);
        }
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public String getLabelText() {
        return this.label;
    }

    public void setLabelText(String label) {
        if (label != null && !label.equals(this.label)) {
            this.sizeBufImg = null;
        }
        this.label = label;
        this.invalidate();
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    protected void calcPreferredSize() {
        if (this.sizeBufImg == null) {
            Insets ins = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
            this.sizeBufImg = new BufferedImage(1, 1, 2);
            Graphics2D g = this.sizeBufImg.createGraphics();
            if (defaultFont != null) {
                g.setFont(defaultFont);
            } else {
                g.setFont(this.getFont());
            }
            FontMetrics fm = g.getFontMetrics();
            if (this.verticalLayout) {
                this.preferredSize.width = ins.left + ins.right + Math.max(this.label != null ? fm.stringWidth(this.label) : 0, this.imgIcon != null ? this.imgIcon.getIconWidth() + 2 : 0);
                this.preferredSize.height = ins.top + ins.bottom + (this.label != null ? fm.getHeight() + 4 : 0) + (this.imgIcon != null ? this.imgIcon.getIconHeight() + vertGap : 0);
            } else {
                this.preferredSize.width = ins.left + ins.right + 4 + ((this.label != null ? fm.stringWidth(this.label) : 0) + 2) + (this.imgIcon != null ? this.imgIcon.getIconWidth() : 0);
                this.preferredSize.height = ins.top + ins.bottom + Math.max(fm.getHeight(), this.imgIcon != null ? this.imgIcon.getIconHeight() + 2 : 0);
            }
            g.dispose();
        }
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font defaultFont) {
        RolloverCommand.defaultFont = defaultFont;
    }

    public static void setVertGap(int vertGap) {
        RolloverCommand.vertGap = vertGap;
    }

    public static void setUseEmptyBorder(boolean useEmptyBorder) {
        RolloverCommand.useEmptyBorder = useEmptyBorder;
    }

    @Override
    public Dimension getPreferredSize() {
        this.calcPreferredSize();
        return new Dimension(this.preferredSize);
    }

    protected void stopEditting() {
        if (this.txtFld != null || this.isEditing) {
            String oldLabel = this.label;
            this.label = this.txtFld.getText();
            this.txtFld.setVisible(false);
            this.remove(this.txtFld);
            this.remove(this.iconLabel);
            if (this.pcl != null) {
                this.pcl.propertyChange(new PropertyChangeEvent(this, "label", oldLabel, this.label));
                this.pcl = null;
            }
            this.txtFld = null;
            this.buffer = null;
            this.sizeBufImg = null;
            this.invalidate();
            this.getParent().doLayout();
            this.getParent().repaint();
            this.isEditing = false;
        }
    }

    public void startEditting(PropertyChangeListener pclArg) {
        this.pcl = pclArg;
        this.txtFld = new JTextField(this.label);
        this.add((Component)this.iconLabel, "West");
        this.add((Component)this.txtFld, "Center");
        this.txtFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RolloverCommand.this.txtFld.getText().length() > 0) {
                    RolloverCommand.this.stopEditting();
                }
            }
        });
        this.txtFld.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                RolloverCommand.this.stopEditting();
            }
        });
        this.isEditing = true;
        this.invalidate();
        this.doLayout();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setEnabled(enabled);
            ++i;
        }
    }

    protected void paintComp(Graphics g) {
        super.paint(g);
        if (!this.isEditing) {
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            if (this.verticalLayout) {
                int y = insets.top;
                if (this.imgIcon != null && this.imgIcon.getImage() != null) {
                    g.drawImage(this.imgIcon.getImage(), (size.width - this.imgIcon.getIconWidth()) / 2, y, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
                    y += this.imgIcon.getIconHeight() + 1;
                }
                if (this.label != null) {
                    if (defaultFont != null) {
                        g.setFont(defaultFont);
                    }
                    FontMetrics fm = g.getFontMetrics();
                    g.setColor(this.getForeground());
                    ((Graphics2D)g).setRenderingHints(UIHelper.createTextRenderingHints());
                    g.drawString(this.label, (size.width - fm.stringWidth(this.label)) / 2, y + fm.getHeight());
                }
            } else {
                int x = insets.left + 1;
                int y = insets.top;
                int xOffset = 0;
                if (this.imgIcon != null && this.imgIcon.getImage() != null) {
                    if (this.label == null) {
                        x = (size.width - this.imgIcon.getIconWidth()) / 2;
                    }
                    g.drawImage(this.imgIcon.getImage(), x, y + (size.height - this.imgIcon.getIconHeight()) / 2, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
                    xOffset = this.imgIcon.getIconWidth() + 4;
                }
                if (this.label != null) {
                    if (defaultFont != null) {
                        g.setFont(defaultFont);
                    }
                    FontMetrics fm = g.getFontMetrics();
                    g.setColor(this.getForeground());
                    ((Graphics2D)g).setRenderingHints(UIHelper.createTextRenderingHints());
                    g.drawString(this.label, x + xOffset + 1, y + (size.height - fm.getHeight()) / 2 + fm.getAscent());
                }
            }
            if ((this.isActive || !DragAndDropLock.isDragAndDropStarted() && this.isOver) && !this.hasFocus()) {
                Color color;
                if (this.isActive) {
                    color = DragAndDropLock.isDragAndDropStarted() && this.isOver ? dropColor : activeColor;
                } else {
                    Color mouseOverColor = this.dragFlavors.size() > 0 ? activeColor : hoverColor;
                    color = this.hasFocus() && UIManager.getLookAndFeel() instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getFocusColor() : mouseOverColor;
                }
                g.setColor(color);
                if (!useEmptyBorder) {
                    insets.set(1, 1, 1, 1);
                }
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                RoundRectangle2D.Double rr = new RoundRectangle2D.Double(insets.left, insets.top, size.width - insets.right - insets.left, size.height - insets.bottom - insets.top, 10.0, 10.0);
                g2d.draw(rr);
                rr = new RoundRectangle2D.Double(insets.left + 1, insets.top + 1, size.width - insets.right - insets.left - 2, size.height - insets.bottom - insets.top - 2, 10.0, 10.0);
                g2d.draw(rr);
            }
            if (this.isOver && hoverImg != null && this.isActive && DragAndDropLock.isDragAndDropStarted()) {
                int x = size.width - hoverImg.getIconWidth() - 1;
                int y = (size.height - hoverImg.getIconHeight()) / 2;
                g.drawImage(hoverImg.getImage(), x, y, null);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        this.paintComp(g);
        if (!this.isEnabled()) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = this.getSize();
            g2d.setPaint(transparentWhite);
            g2d.fillRect(0, 0, size.width, size.height);
        }
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void addDragDataFlavor(DataFlavor dataFlavor) {
        this.dragFlavors.add(dataFlavor);
    }

    public void addDropDataFlavor(DataFlavor dataFlavor) {
        this.dropFlavors.add(dataFlavor);
    }

    public static ImageIcon getHoverImg() {
        return hoverImg;
    }

    public static void setHoverImg(ImageIcon hoverImgArg) {
        hoverImg = hoverImgArg;
    }

    public static Color getActiveColor() {
        return activeColor;
    }

    public static void setActiveColor(Color activeColor) {
        RolloverCommand.activeColor = activeColor;
    }

    public static Color getDropColor() {
        return dropColor;
    }

    public static void setDropColor(Color dropColor) {
        RolloverCommand.dropColor = dropColor;
    }

    public static Color getFocusColor() {
        return focusColor;
    }

    public static void setFocusColor(Color focusColor) {
        RolloverCommand.focusColor = focusColor;
    }

    public static Color getHoverColor() {
        return hoverColor;
    }

    public static void setHoverColor(Color hoverColor) {
        RolloverCommand.hoverColor = hoverColor;
    }

    public JComponent getUIComponent() {
        return this;
    }

    public String getTitle() {
        return this.label;
    }

    public void setToolTip(String toolTip) {
        super.setToolTipText(toolTip);
    }

    public void setIcon(ImageIcon icon) {
        if (icon != null) {
            this.imgIcon = icon;
            if (this.iconLabel != null) {
                this.iconLabel.setIcon(this.imgIcon);
            }
            this.repaint();
        }
    }

    @Override
    public void doAction(GhostActionable src) {
        DataActionEvent ae = new DataActionEvent(src, this, src != null ? src.getData() : null);
        for (ActionListener al : this.listeners) {
            al.actionPerformed(ae);
        }
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return UIHelper.getDataForClass(this.data, classObj);
    }

    @Override
    public void createMouseInputAdapter() {
        this.mouseDropAdapter = new GhostMouseInputAdapter(UIRegistry.getGlassPane(), "action", this);
        this.addMouseListener(this.mouseDropAdapter);
        this.addMouseMotionListener(this.mouseDropAdapter);
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return this.mouseDropAdapter;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
        this.repaint();
    }

    public int getItemWidth() {
        return this.getPreferredSize().width + 10;
    }

    public int getItemHeight() {
        return this.getPreferredSize().height;
    }

    private void createRenderingHints() {
        if (this.hints == null) {
            this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            Object value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            try {
                Field declaredField = RenderingHints.class.getDeclaredField("VALUE_TEXT_ANTIALIAS_LCD_HRGB");
                value = declaredField.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, value);
        }
    }

    private void renderOffscreen() {
        this.createRenderingHints();
        BufferedImage bgBufImg = this.getBackgroundImageBuffer();
        this.buffer = new BufferedImage(bgBufImg.getWidth(), bgBufImg.getHeight(), 2);
        int shadowWidth = bgBufImg.getWidth() - this.getItemWidth();
        int shadowHeight = bgBufImg.getHeight() - this.getItemHeight();
        int left = (int)((double)shadowWidth * 0.5);
        int top = (int)((double)shadowHeight * 0.4);
        int width = this.getItemWidth() - 2;
        int height = this.getItemHeight() - 2;
        Graphics2D g2 = this.buffer.createGraphics();
        g2.setRenderingHints(this.hints);
        g2.drawImage(bgBufImg, 0, 0, bgBufImg.getWidth(), bgBufImg.getHeight(), null);
        g2.fillRect(left, top, width, height);
        g2.setClip(left, top, width, height);
        if (this.imgIcon != null) {
            g2.drawImage(this.imgIcon.getImage(), left + 1, top + (height - this.imgIcon.getIconHeight()) / 2, this.imgIcon.getIconWidth(), this.imgIcon.getIconHeight(), null);
        }
        g2.setFont(this.getFont());
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(Color.BLACK);
        if (this.label != null) {
            if (this.imgIcon != null) {
                g2.drawString(this.label, left + 1 + this.imgIcon.getIconWidth() + 1 + 4, top + (height - fm.getHeight()) / 2 + fm.getAscent());
            } else {
                g2.drawString(this.label, left + 1, top + (height - fm.getHeight()) / 2 + fm.getAscent());
            }
        }
        g2.dispose();
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.buffer == null) {
            this.renderOffscreen();
        }
        return this.buffer;
    }

    private BufferedImage getBackgroundImageBuffer() {
        if (this.shadowBuffer == null) {
            this.createRenderingHints();
            ShadowFactory factory = new ShadowFactory(10, 0.17f, Color.BLACK);
            BufferedImage image = new BufferedImage(this.getItemWidth(), this.getItemHeight(), 2);
            Graphics2D g2 = image.createGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.dispose();
            this.shadowBuffer = factory.createShadow(image);
        }
        return this.shadowBuffer;
    }

    public boolean isVerticalLayout() {
        return this.verticalLayout;
    }

    public void setVerticalLayout(boolean verticalLayout) {
        this.verticalLayout = verticalLayout;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return this.dragFlavors;
    }

    @Override
    public boolean deleteRequest() {
        if (this.deleteCmdAction != null) {
            CommandDispatcher.dispatch(this.deleteCmdAction);
        }
        return true;
    }

    @Override
    public String toXML() {
        return null;
    }

    @Override
    public void setDeleteCommandAction(CommandAction deleteCmdAction) {
        if (deleteCmdAction.getSrcObj() == null) {
            deleteCmdAction.setSrcObj(this);
        }
        this.deleteCmdAction = deleteCmdAction;
    }

    @Override
    public String getName() {
        return this.label;
    }

    @Override
    public Icon getIcon() {
        return this.imgIcon;
    }
}

