/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.ModifiableListModel;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class ReorderableTrayListModel<T>
extends AbstractListModel
implements ModifiableListModel<T> {
    protected Vector<T> data = new Vector();

    @Override
    public T getElementAt(int index) {
        return this.data.get(index);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public synchronized void add(T t) {
        this.data.add(t);
        this.fireIntervalAdded(this, this.data.indexOf(t), this.data.indexOf(t));
    }

    @Override
    public synchronized T remove(int index) {
        T t = this.data.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return t;
    }

    @Override
    public synchronized boolean remove(T element) {
        int index = this.data.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.data.remove(element);
        return true;
    }

    public synchronized void shiftLeft(int index) {
        T moving = this.data.get(index);
        int newIndex = index - 1 < 0 ? 0 : index - 1;
        this.data.remove(index);
        this.data.insertElementAt(moving, newIndex);
        this.fireContentsChanged(this, newIndex, index);
    }

    public synchronized void shiftRight(int index) {
        T moving = this.data.get(index);
        int newIndex = index + 1 > this.data.size() - 1 ? this.data.size() - 1 : index + 1;
        this.data.remove(index);
        this.data.insertElementAt(moving, newIndex);
        this.fireContentsChanged(this, newIndex, index);
    }

    public synchronized void moveToStart(int index) {
        T moving = this.data.get(index);
        this.data.remove(index);
        this.data.insertElementAt(moving, 0);
        this.fireContentsChanged(this, 0, index);
    }

    public synchronized void moveToEnd(int index) {
        T moving = this.data.get(index);
        this.data.remove(index);
        this.data.add(moving);
        this.fireContentsChanged(this, index, this.data.size() - 1);
    }

    @Override
    public synchronized void clear() {
        if (this.data.isEmpty()) {
            return;
        }
        int index1 = this.data.size() - 1;
        this.data.clear();
        this.fireIntervalRemoved(this, 0, index1);
    }
}

